/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinTree;
import nl.mpi.kinnate.ui.TableCellDragHandler;

public class MetadataPanel
extends JPanel {
    private KinTree kinTree;
    private ArbilTableModel kinTableModel;
    private ArbilTableModel archiveTableModel;
    private JScrollPane kinTableScrollPane;
    private HidePane editorHidePane;
    private ArrayList<ArbilDataNode> archiveNodes = new ArrayList();

    public MetadataPanel(GraphPanel graphPanel, HidePane editorHidePane, TableCellDragHandler tableCellDragHandler) {
        this.kinTree = new KinTree(graphPanel);
        this.kinTableModel = new ArbilTableModel();
        this.archiveTableModel = new ArbilTableModel();
        ArbilTable kinTable = new ArbilTable(this.kinTableModel, "Selected Nodes");
        ArbilTable archiveTable = new ArbilTable(this.archiveTableModel, "Selected Nodes");
        kinTable.setTransferHandler((TransferHandler)tableCellDragHandler);
        kinTable.setDragEnabled(true);
        this.editorHidePane = editorHidePane;
        this.setLayout(new BorderLayout());
        this.kinTableScrollPane = new JScrollPane((Component)kinTable);
        JScrollPane archiveTableScrollPane = new JScrollPane((Component)archiveTable);
        this.add((Component)archiveTableScrollPane, "Center");
        this.add((Component)((Object)this.kinTree), "Before");
    }

    public void removeAllArbilDataNodeRows() {
        this.kinTableModel.removeAllArbilDataNodeRows();
        this.archiveTableModel.removeAllArbilDataNodeRows();
        this.archiveNodes.clear();
    }

    public void addSingleArbilDataNode(ArbilDataNode arbilDataNode) {
        this.kinTableModel.addSingleArbilDataNode(arbilDataNode);
        this.archiveTableModel.addSingleArbilDataNode(arbilDataNode);
        this.archiveNodes.add(arbilDataNode);
    }

    public void addTab(String labelString, Component elementEditor) {
        this.editorHidePane.addTab(labelString, elementEditor);
    }

    public void removeTab(Component elementEditor) {
        this.editorHidePane.remove(elementEditor);
    }

    public void updateEditorPane() {
        if (this.archiveTableModel.getArbilDataNodeCount() > 0) {
            this.addTab("Archive Links", this);
        } else {
            this.removeTab(this);
        }
        if (this.kinTableModel.getArbilDataNodeCount() > 0) {
            this.addTab("Metadata", this.kinTableScrollPane);
        } else {
            this.removeTab(this.kinTableScrollPane);
        }
        boolean showEditor = this.editorHidePane.getComponentCount() > 0;
        this.kinTree.rootNodeChildren = (ArbilNode[])this.archiveNodes.toArray(new ArbilDataNode[0]);
        this.kinTree.requestResort();
        if (showEditor && this.editorHidePane.isHidden()) {
            this.editorHidePane.toggleHiddenState();
        }
        this.editorHidePane.setVisible(showEditor);
    }
}

