/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import nl.mpi.arbil.util.BugCatcher;
import org.apache.commons.digester.Digester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiComponentLinkReader {
    private static BugCatcher bugCatcher;
    public ArrayList<CmdiResourceLink> cmdiResourceLinkArray = null;
    public ArrayList<ResourceRelation> cmdiResourceRelationArray = null;

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void main(String[] args) {
        System.out.println("CmdiComponentLinkReader");
        CmdiComponentLinkReader cmdiComponentLinkReader = new CmdiComponentLinkReader();
        try {
            cmdiComponentLinkReader.readLinks(new URI("http://www.clarin.eu/cmd/example/example-md-instance.cmdi"));
        }
        catch (URISyntaxException exception) {
            System.err.println(exception.getMessage());
        }
    }

    public URI getLinkUrlString(String resourceId) {
        CmdiResourceLink cmdiResourceLink = this.getResourceLink(resourceId);
        if (cmdiResourceLink != null) {
            try {
                return cmdiResourceLink.getLinkUri();
            }
            catch (URISyntaxException urise) {
                bugCatcher.logError(urise);
            }
        }
        return null;
    }

    public CmdiResourceLink getResourceLink(String resourceId) {
        for (CmdiResourceLink cmdiResourceLink : this.cmdiResourceLinkArray) {
            if (!cmdiResourceLink.resourceProxyId.equals(resourceId)) continue;
            return cmdiResourceLink;
        }
        return null;
    }

    public String getProxyId(String resourceRef) {
        for (CmdiResourceLink resourceLink : this.cmdiResourceLinkArray) {
            if (!resourceLink.resourceRef.equals(resourceRef)) continue;
            return resourceLink.resourceProxyId;
        }
        return null;
    }

    public ArrayList<CmdiResourceLink> readLinks(URI targetCmdiNode) {
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addCallMethod("CMD/Resources/ResourceProxyList/ResourceProxy", "addResourceProxy", 3);
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy", 0, "id");
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy/ResourceType", 1);
            digester.addCallParam("CMD/Resources/ResourceProxyList/ResourceProxy/ResourceRef", 2);
            digester.addCallMethod("CMD/Resources/ResourceRelationList/ResourceRelation", "addResourceRelation", 3);
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/RelationType", 0);
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/Res1", 1, "ref");
            digester.addCallParam("CMD/Resources/ResourceRelationList/ResourceRelation/Res2", 2, "ref");
            this.cmdiResourceLinkArray = new ArrayList();
            this.cmdiResourceRelationArray = new ArrayList();
            digester.parse(targetCmdiNode.toURL());
        }
        catch (Exception e) {
            bugCatcher.logError(e);
        }
        return this.cmdiResourceLinkArray;
    }

    public void addResourceProxy(String resourceProxyId, String resourceType, String resourceRef) {
        System.out.println("addResourceProxy: " + resourceProxyId + " : " + resourceType + " : " + resourceRef);
        CmdiResourceLink cmdiProfile = new CmdiResourceLink(resourceProxyId, resourceType, resourceRef);
        this.cmdiResourceLinkArray.add(cmdiProfile);
    }

    public void addResourceRelation(String RelationType, String Res1, String Res2) {
        System.out.println("addResourceRelation: " + RelationType + " : " + Res1 + " : " + Res2);
        ResourceRelation resourceRelation = new ResourceRelation(RelationType, Res1, Res2);
        this.cmdiResourceRelationArray.add(resourceRelation);
    }

    public static class ResourceRelation {
        public final String relationType;
        public final String res1;
        public final String res2;

        public ResourceRelation(String type, String resource1, String resource2) {
            this.relationType = type;
            this.res1 = resource1;
            this.res2 = resource2;
        }
    }

    public static class CmdiResourceLink {
        public final String resourceProxyId;
        public final String resourceType;
        public final String resourceRef;
        private int referencingNodes;

        public CmdiResourceLink(String proxyId, String type, String ref) {
            this.resourceProxyId = proxyId;
            this.resourceType = type;
            this.resourceRef = ref;
        }

        public synchronized void addReferencingNode() {
            ++this.referencingNodes;
        }

        public synchronized void removeReferencingNode() {
            --this.referencingNodes;
        }

        public synchronized int getReferencingNodesCount() {
            return this.referencingNodes;
        }

        public URI getLinkUri() throws URISyntaxException {
            if (this.resourceRef != null && this.resourceRef.length() > 0) {
                if (this.resourceRef.startsWith("hdl://")) {
                    return new URI(this.resourceRef.replace("hdl://", "http://hdl.handle.net/"));
                }
                return new URI(this.resourceRef);
            }
            return null;
        }
    }
}

