/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilEntityResolver;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiTemplate
extends ArbilTemplate {
    public static final String RESOURCE_REFERENCE_ATTRIBUTE = "ref";
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private String nameSpaceString;
    private String[] filterString = new String[]{".CMD.Resources.", ".CMD.Header."};
    private Document schemaDocument;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public void loadTemplate(String nameSpaceStringLocal) {
        this.vocabularyHashTable = new Hashtable();
        this.nameSpaceString = nameSpaceStringLocal;
        try {
            CmdiProfileReader.CmdiProfile cmdiProfile = CmdiProfileReader.getSingleInstance().getProfile(this.nameSpaceString);
            this.loadedTemplateName = cmdiProfile != null ? cmdiProfile.name : this.nameSpaceString.substring(this.nameSpaceString.lastIndexOf("/") + 1);
            ArrayListGroup arrayListGroup = new ArrayListGroup();
            URI xsdUri = new URI(this.nameSpaceString);
            this.readSchema(xsdUri, arrayListGroup);
            this.childNodePaths = (String[][])arrayListGroup.childNodePathsList.toArray((T[])new String[0][]);
            this.templatesArray = (String[][])arrayListGroup.addableComponentPathsList.toArray((T[])new String[0][]);
            this.resourceNodePaths = (String[][])arrayListGroup.resourceNodePathsList.toArray((T[])new String[0][]);
            this.fieldConstraints = (String[][])arrayListGroup.fieldConstraintList.toArray((T[])new String[0][]);
            this.fieldUsageArray = (String[][])arrayListGroup.fieldUsageDescriptionList.toArray((T[])new String[0][]);
            this.makeGuiNamesUnique();
            String[][] tempSortableArray = (String[][])arrayListGroup.displayNamePreferenceList.toArray((T[])new String[0][]);
            Arrays.sort(tempSortableArray, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return Integer.valueOf(o1[1]) - Integer.valueOf(o2[1]);
                }
            });
            this.preferredNameFields = new String[tempSortableArray.length];
            for (int nameFieldCounter = 0; nameFieldCounter < this.preferredNameFields.length; ++nameFieldCounter) {
                this.preferredNameFields[nameFieldCounter] = tempSortableArray[nameFieldCounter][0];
            }
        }
        catch (URISyntaxException urise) {
            bugCatcher.logError(urise);
        }
        this.requiredFields = new String[0];
        this.fieldTriggersArray = new String[0][];
        this.autoFieldsArray = new String[0][];
        this.genreSubgenreArray = new String[0][];
    }

    private void makeGuiNamesUnique() {
        boolean allGuiNamesUnique = false;
        while (!allGuiNamesUnique) {
            allGuiNamesUnique = true;
            for (String[] currentTemplate : this.templatesArray) {
                String currentTemplateGuiName = currentTemplate[1];
                String currentTemplatePath = currentTemplate[0];
                for (String[] secondTemplate : this.templatesArray) {
                    String[] templateToChangePathParts;
                    int pathCount;
                    String templateToChangePath;
                    String templateToChangeGuiName;
                    String secondTemplateGuiName = secondTemplate[1];
                    String secondTemplatePath = secondTemplate[0];
                    if (currentTemplatePath.equals(secondTemplatePath) || !currentTemplateGuiName.equals(secondTemplateGuiName)) continue;
                    allGuiNamesUnique = false;
                    for (String[] templateToChange : this.templatesArray) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                    for (String[] templateToChange : this.childNodePaths) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                }
            }
        }
    }

    @Override
    public Enumeration listTypesFor(Object targetNodeUserObject) {
        String targetNodeXpath = ((ArbilDataNode)targetNodeUserObject).getURI().getFragment();
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        boolean isComponentPath = false;
        if (targetNodeXpath != null) {
            isComponentPath = targetNodeXpath.endsWith(")");
            targetNodeXpath = targetNodeXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        Vector<String[]> childTypes = new Vector<String[]>();
        if (targetNodeUserObject instanceof ArbilDataNode) {
            for (String[] childPathString : this.templatesArray) {
                boolean allowEntry = false;
                if (targetNodeXpath == null) {
                    allowEntry = true;
                } else if (childPathString[0].startsWith(targetNodeXpath)) {
                    allowEntry = true;
                }
                if (childPathString[0].equals(targetNodeXpath) && isComponentPath) {
                    allowEntry = false;
                }
                for (String currentFilter : this.filterString) {
                    if (!childPathString[0].startsWith(currentFilter)) continue;
                    allowEntry = false;
                }
                if (!allowEntry) continue;
                childTypes.add(new String[]{childPathString[1], childPathString[0]});
            }
            String[][] childTypesArray = (String[][])childTypes.toArray((T[])new String[0][]);
            childTypes.removeAllElements();
            for (String[] currentChildType : childTypesArray) {
                boolean keepChildType = true;
                for (String[] subChildType : childTypesArray) {
                    String remainderString;
                    if (!currentChildType[1].startsWith(subChildType[1]) || !(remainderString = currentChildType[1].substring(subChildType[1].length())).contains(".")) continue;
                    keepChildType = false;
                }
                if (!keepChildType) continue;
                childTypes.add(currentChildType);
            }
            Collections.sort(childTypes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = ((String[])o1)[0];
                    String value2 = ((String[])o2)[0];
                    return value1.compareTo(value2);
                }
            });
        }
        return childTypes.elements();
    }

    private void readSchema(URI xsdFile, ArrayListGroup arrayListGroup) {
        File schemaFile = xsdFile.getScheme().equals("file") ? new File(xsdFile) : sessionStorage.updateCache(xsdFile.toString(), 100);
        this.templateFile = schemaFile;
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setCharacterEncoding("UTF-8");
            xmlOptions.setEntityResolver(new ArbilEntityResolver(xsdFile));
            SchemaTypeSystem sts = XmlBeans.compileXsd(new XmlObject[]{XmlObject.Factory.parse(inputStream, xmlOptions)}, XmlBeans.getBuiltinTypeSystem(), xmlOptions);
            SchemaType schemaType = sts.documentTypes()[0];
            this.constructXml(schemaType, arrayListGroup, "");
        }
        catch (IOException e) {
            bugCatcher.logError(this.templateFile.getName(), e);
            messageDialogHandler.addMessageDialogToQueue("Could not open the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
        catch (XmlException e) {
            bugCatcher.logError(this.templateFile.getName(), e);
            messageDialogHandler.addMessageDialogToQueue("Could not read the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
    }

    private int constructXml(SchemaType schemaType, ArrayListGroup arrayListGroup, String pathString) {
        int childCount = 0;
        int subNodeCount = 0;
        this.readControlledVocabularies(schemaType, pathString);
        this.readFieldConstrains(schemaType, pathString, arrayListGroup.fieldConstraintList);
        SchemaParticle topParticle = schemaType.getContentModel();
        this.searchForAnnotations(topParticle, pathString, arrayListGroup);
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        int currentNodeChildCount = 0;
        for (SchemaProperty schemaProperty : schemaPropertyArray) {
            int maxOccurs;
            ++childCount;
            String localName = schemaProperty.getName().getLocalPart();
            String currentPathString = pathString + "." + localName;
            if (localName == null) continue;
            ++currentNodeChildCount;
            boolean canHaveMultiple = true;
            if (schemaProperty.getMaxOccurs() == null) {
                maxOccurs = -1;
                canHaveMultiple = true;
            } else if (schemaProperty.getMaxOccurs().toString().equals("unbounded")) {
                maxOccurs = -1;
                canHaveMultiple = true;
            } else {
                maxOccurs = schemaProperty.getMaxOccurs().intValue();
                boolean bl = canHaveMultiple = schemaProperty.getMaxOccurs().intValue() > 1;
            }
            if (!canHaveMultiple) {
                canHaveMultiple = schemaProperty.getMinOccurs().intValue() != schemaProperty.getMaxOccurs().intValue();
            }
            SchemaType currentSchemaType = schemaProperty.getType();
            String currentNodeMenuName = localName;
            subNodeCount = this.constructXml(currentSchemaType, arrayListGroup, currentPathString);
            if (canHaveMultiple && subNodeCount > 0) {
                arrayListGroup.childNodePathsList.add(new String[]{currentPathString, pathString.substring(pathString.lastIndexOf(".") + 1)});
            }
            if (canHaveMultiple) {
                String insertBefore = "";
                arrayListGroup.addableComponentPathsList.add(new String[]{currentPathString, currentNodeMenuName, insertBefore, Integer.toString(maxOccurs)});
            }
            boolean hasResourceAttribute = false;
            for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
                if (!attributesProperty.getName().getLocalPart().equals(RESOURCE_REFERENCE_ATTRIBUTE)) continue;
                hasResourceAttribute = true;
                break;
            }
            if (!hasResourceAttribute) continue;
            arrayListGroup.resourceNodePathsList.add(new String[]{currentPathString, localName});
        }
        return subNodeCount += currentNodeChildCount;
    }

    private void searchForAnnotations(SchemaParticle schemaParticle, String nodePathBase, ArrayListGroup arrayListGroup) {
        if (schemaParticle != null) {
            switch (schemaParticle.getParticleType()) {
                case 3: {
                    for (SchemaParticle schemaParticleChild : schemaParticle.getParticleChildren()) {
                        String nodePath;
                        if (schemaParticleChild.getName() != null) {
                            nodePath = nodePathBase + "." + schemaParticleChild.getName().getLocalPart();
                        } else {
                            nodePath = nodePathBase + ".unnamed";
                            bugCatcher.logError(new Exception("unnamed node at: " + nodePath));
                        }
                        this.searchForAnnotations(schemaParticleChild, nodePath, arrayListGroup);
                    }
                    break;
                }
                case 4: {
                    SchemaLocalElement schemaLocalElement = (SchemaLocalElement)((Object)schemaParticle);
                    this.saveAnnotationData(schemaLocalElement, nodePathBase, arrayListGroup);
                }
            }
        }
    }

    private void saveAnnotationData(SchemaLocalElement schemaLocalElement, String nodePath, ArrayListGroup arrayListGroup) {
        SchemaAnnotation schemaAnnotation = schemaLocalElement.getAnnotation();
        if (schemaAnnotation != null) {
            for (SchemaAnnotation.Attribute annotationAttribute : schemaAnnotation.getAttributes()) {
                System.out.println("  Annotation: " + annotationAttribute.getName() + " : " + annotationAttribute.getValue());
                if ("{http://www.clarin.eu}displaypriority".equals(annotationAttribute.getName().toString())) {
                    arrayListGroup.displayNamePreferenceList.add(new String[]{nodePath, annotationAttribute.getValue()});
                }
                if (!"{http://www.clarin.eu}documentation".equals(annotationAttribute.getName().toString())) continue;
                arrayListGroup.fieldUsageDescriptionList.add(new String[]{nodePath, annotationAttribute.getValue()});
            }
        }
    }

    private void readFieldConstrains(SchemaType schemaType, String nodePath, ArrayList<String[]> fieldConstraintList) {
        switch (schemaType.getBuiltinTypeCode()) {
            case 12: {
                break;
            }
            case 16: {
                fieldConstraintList.add(new String[]{nodePath, "([0-9][0-9][0-9][0-9])((-[0-1][0-9])(-[0-3][0-9])?)?"});
                break;
            }
            case 3: {
                fieldConstraintList.add(new String[]{nodePath, "true|false"});
                break;
            }
            case 6: {
                fieldConstraintList.add(new String[]{nodePath, "[^\\d]+://.*"});
                break;
            }
            case 0: {
                break;
            }
        }
    }

    private synchronized Document getSchemaDocument() {
        if (this.schemaDocument == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.schemaDocument = documentBuilder.parse(this.templateFile);
            }
            catch (IOException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
            catch (ParserConfigurationException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
            catch (SAXException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
        }
        return this.schemaDocument;
    }

    private HashMap<String, String> getDescriptionsForVocabulary(String vocabularyName) throws TransformerException {
        Document schemaDoc = this.getSchemaDocument();
        if (schemaDoc == null) {
            return null;
        }
        NodeList enumNodes = XPathAPI.selectNodeList((Node)this.getSchemaDocument(), (String)("//*[@name='" + vocabularyName + "']//xs:restriction/xs:enumeration"));
        HashMap<String, String> descriptions = new HashMap<String, String>(enumNodes.getLength());
        for (int i = 0; i < enumNodes.getLength(); ++i) {
            Node valueNode;
            NamedNodeMap attMap = enumNodes.item(i).getAttributes();
            Node labelNode = attMap.getNamedItem("ann:label");
            if (labelNode == null || (valueNode = attMap.getNamedItem("value")) == null) continue;
            descriptions.put(valueNode.getTextContent(), labelNode.getTextContent());
        }
        return descriptions;
    }

    private void readControlledVocabularies(SchemaType schemaType, String nodePath) {
        XmlAnySimpleType[] enumerationValues = schemaType.getEnumerationValues();
        if (enumerationValues != null && enumerationValues.length > 0) {
            ArbilVocabulary vocabulary = ArbilVocabularies.getSingleInstance().getEmptyVocabulary(this.nameSpaceString + "#" + schemaType.getName());
            HashMap<String, String> descriptions = null;
            try {
                descriptions = this.getDescriptionsForVocabulary(schemaType.getBaseType().getName().getLocalPart());
            }
            catch (Exception ex) {
                bugCatcher.logError(ex);
            }
            for (XmlAnySimpleType anySimpleType : schemaType.getEnumerationValues()) {
                String description;
                String entryCode = anySimpleType.getStringValue();
                String string = description = descriptions == null ? null : descriptions.get(entryCode);
                if (description == null) {
                    vocabulary.addEntry(entryCode, null);
                    continue;
                }
                vocabulary.addEntry(description, entryCode);
            }
            System.out.println("vocabularyHashTable.put: " + nodePath);
            this.vocabularyHashTable.put(nodePath, vocabulary);
        }
    }

    public static void main(String[] args) {
        ArbilDesktopInjector.injectHandlers();
        new CmdiTemplate().loadTemplate("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1271859438164/xsd");
    }

    private static class ArrayListGroup {
        public ArrayList<String[]> childNodePathsList = new ArrayList();
        public ArrayList<String[]> addableComponentPathsList = new ArrayList();
        public ArrayList<String[]> resourceNodePathsList = new ArrayList();
        public ArrayList<String[]> fieldConstraintList = new ArrayList();
        public ArrayList<String[]> displayNamePreferenceList = new ArrayList();
        public ArrayList<String[]> fieldUsageDescriptionList = new ArrayList();

        private ArrayListGroup() {
        }
    }
}

