/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.ArbilVocabularyFilter;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationLanguages
implements ArbilVocabularyFilter {
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private static final String LANGUAGE_VOCABULARY_URL_KEY = "LanguageVocabularyUrl";
    private static final String SELECTED_LANGUAGES_KEY = "selectedLanguages";
    private static final String OLD_MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/ISO639-2Languages.xml";
    private static final String MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/MPI-Languages.xml";
    private static String languageVocabularyUrl;
    private static DocumentationLanguages singleInstance;

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized String getLanguageVocabularyUrl() {
        if (languageVocabularyUrl == null && ((languageVocabularyUrl = sessionStorage.loadString(LANGUAGE_VOCABULARY_URL_KEY)) == null || languageVocabularyUrl.equals(OLD_MPI_LANGUAGE_VOCABULARY_URL))) {
            languageVocabularyUrl = MPI_LANGUAGE_VOCABULARY_URL;
            sessionStorage.saveString(LANGUAGE_VOCABULARY_URL_KEY, languageVocabularyUrl);
        }
        return languageVocabularyUrl;
    }

    public static synchronized DocumentationLanguages getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new DocumentationLanguages();
        }
        return singleInstance;
    }

    private DocumentationLanguages() {
    }

    public synchronized List<ArbilVocabularyItem> getallLanguages() {
        return ArbilVocabularies.getSingleInstance().getVocabulary(null, DocumentationLanguages.getLanguageVocabularyUrl()).getVocabularyItemsUnfiltered();
    }

    public synchronized ArrayList<String> getSelectedLanguagesArrayList() {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
        }
        catch (Exception e) {
            bugCatcher.logError("No selectedLanguages file, will create one now.", e);
            this.addDefaultTemplates();
        }
        return selectedLanguages;
    }

    public synchronized List<ArbilVocabularyItem> getLanguageListSubset() {
        ArrayList<ArbilVocabularyItem> languageListSubset = new ArrayList<ArbilVocabularyItem>();
        ArrayList<String> selectedLanguages = this.getSelectedLanguagesArrayList();
        for (ArbilVocabularyItem currentVocabItem : this.getallLanguages()) {
            if (!selectedLanguages.contains(currentVocabItem.itemDisplayName)) continue;
            languageListSubset.add(currentVocabItem);
        }
        return languageListSubset;
    }

    private void addDefaultTemplates() {
        for (ArbilVocabularyItem currentTemplate : this.getallLanguages()) {
            this.addselectedLanguages(currentTemplate.itemDisplayName);
        }
    }

    public synchronized void addselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
        }
        catch (Exception e) {
            bugCatcher.logError("No selectedLanguages file, will create one now.", e);
        }
        selectedLanguages.add(templateString);
        this.saveSelectedLanguages(selectedLanguages);
    }

    public synchronized void removeselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
            while (selectedLanguages.contains(templateString)) {
                selectedLanguages.remove(templateString);
            }
        }
        catch (IOException ex) {
            bugCatcher.logError(ex);
        }
        this.saveSelectedLanguages(selectedLanguages);
    }

    private void saveSelectedLanguages(ArrayList<String> selectedLanguages) {
        try {
            sessionStorage.saveStringArray(SELECTED_LANGUAGES_KEY, selectedLanguages.toArray(new String[0]));
        }
        catch (IOException ex) {
            bugCatcher.logError(ex);
        }
    }

    @Override
    public List<ArbilVocabularyItem> filterVocabularyItems(List<ArbilVocabularyItem> items) {
        ArrayList<ArbilVocabularyItem> vocabClone = new ArrayList<ArbilVocabularyItem>(items);
        vocabClone.retainAll(this.getLanguageListSubset());
        return vocabClone;
    }

    static {
        languageVocabularyUrl = null;
        singleInstance = null;
    }
}

