/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;

public class ArbilHyperlinkListener
implements HyperlinkListener {
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)evt.getSource();
            if (evt.getDescription().startsWith("arbilscript:")) {
                try {
                    String[] commandsArray;
                    ArbilDataNode currentImdiObject = null;
                    String arbilscriptString = evt.getDescription().substring("arbilscript:".length());
                    System.out.println("acting on arbilscript: " + arbilscriptString);
                    for (String commandString : commandsArray = arbilscriptString.split("&")) {
                        System.out.println("commandString: " + commandString);
                        if (commandString.startsWith("add=")) {
                            String nodeTypeString = commandString.substring("add=".length());
                            System.out.println("nodeTypeString: " + nodeTypeString);
                            currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, "Wizard Corpus", null, null, null);
                        }
                        if (!commandString.startsWith("set=")) continue;
                        String[] fieldCommand = commandString.substring("set=".length()).split(":");
                        System.out.println("set: " + fieldCommand[0] + " = " + fieldCommand[1]);
                        this.setField(currentImdiObject, fieldCommand[0], fieldCommand[1]);
                    }
                    for (int i = 0; i < pane.getComponentCount(); ++i) {
                        Container c = (Container)pane.getComponent(i);
                        System.out.println(c.getComponentCount());
                        Component swingComponentOfHTMLInputType = c.getComponent(0);
                        System.out.println(swingComponentOfHTMLInputType.getClass().getName());
                        if (swingComponentOfHTMLInputType instanceof JTextField) {
                            JTextField tf = (JTextField)swingComponentOfHTMLInputType;
                            System.out.println(tf.getName());
                            System.out.println(tf.getText());
                            System.out.println(tf.getAction());
                            System.out.println(swingComponentOfHTMLInputType.getName());
                            System.out.println(swingComponentOfHTMLInputType.getName());
                            System.out.println(swingComponentOfHTMLInputType.getName());
                            String formCommandString = swingComponentOfHTMLInputType.getName();
                            System.out.println("formCommandString: " + formCommandString);
                            if (formCommandString == null || !formCommandString.startsWith("arbilscript:set=")) continue;
                            String nodeTypeString = formCommandString.substring("arbilscript:set=".length());
                            System.out.println("nodeTypeString: " + nodeTypeString);
                            currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, tf.getText(), null, null, null);
                            continue;
                        }
                        if (!(swingComponentOfHTMLInputType instanceof JButton)) continue;
                    }
                }
                catch (ArbilMetadataException exception) {
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                }
            } else if (evt.getURL() != null) {
                ArbilWindowManager.getSingleInstance().openUrlWindowOnce(evt.getURL().toString(), evt.getURL());
            }
        }
    }

    private void setField(ArbilDataNode currentImdiObject, String fieldPath, String FieldValue) {
        for (ArbilField[] currentField : currentImdiObject.getFields().values()) {
            if (!currentField[0].getFullXmlPath().endsWith(fieldPath)) continue;
            currentField[0].setFieldValue(FieldValue, true, true);
        }
    }

    private ArbilDataNode addNode(ArbilDataNode parentNode, String nodeType, String nodeTypeDisplayName, String targetXmlPath, URI resourceUri, String mimeType) throws ArbilMetadataException {
        ArbilDataNode addedImdiObject;
        System.out.println("wizard add node: " + nodeType);
        System.out.println("adding into: " + parentNode);
        if (parentNode == null) {
            URI targetFileURI = ArbilSessionStorage.getSingleInstance().getNewArbilFileName(ArbilSessionStorage.getSingleInstance().getCacheDirectory(), nodeType);
            targetFileURI = MetadataReader.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
            addedImdiObject = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, targetFileURI);
            ArbilTreeHelper.getSingleInstance().addLocation(targetFileURI);
            ArbilTreeHelper.getSingleInstance().applyRootLocations();
        } else {
            parentNode.saveChangesToCache(true);
            addedImdiObject = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, new MetadataBuilder().addChildNode(parentNode, nodeType, targetXmlPath, resourceUri, mimeType));
        }
        addedImdiObject.waitTillLoaded();
        ArbilWindowManager.getSingleInstance().openFloatingTableOnce(new ArbilDataNode[]{addedImdiObject}, nodeTypeDisplayName);
        return addedImdiObject;
    }
}

