/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.fieldeditors;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.ui.GuiHelper;

public class LanguageIdBox
extends JComboBox {
    public static final int languageSelectWidth = 100;
    static String defaultLanguageDropDownValue = "<select>";

    public LanguageIdBox(final ArbilField cellField, Rectangle parentCellRect) {
        String fieldLanguageId = cellField.getLanguageId();
        System.out.println("Has LanguageId");
        ArbilVocabularyItem selectedItem = null;
        this.setEditable(false);
        List<ArbilVocabularyItem> languageItemArray = DocumentationLanguages.getSingleInstance().getLanguageListSubset();
        Collections.sort(languageItemArray);
        for (ArbilVocabularyItem currentItem : languageItemArray) {
            this.addItem(currentItem);
            if (!fieldLanguageId.equals(currentItem.itemCode) && !fieldLanguageId.equals(currentItem.descriptionString)) continue;
            selectedItem = currentItem;
        }
        if (selectedItem != null) {
            System.out.println("selectedItem: " + selectedItem);
            this.setSelectedItem(selectedItem);
        } else {
            this.addItem(defaultLanguageDropDownValue);
            this.setSelectedItem(defaultLanguageDropDownValue);
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (LanguageIdBox.this.getSelectedItem() instanceof ArbilVocabularyItem) {
                        ArbilVocabularyItem selectedLanguage = (ArbilVocabularyItem)LanguageIdBox.this.getSelectedItem();
                        String languageCode = selectedLanguage.itemCode;
                        if (languageCode == null) {
                            languageCode = selectedLanguage.descriptionString;
                        }
                        cellField.setLanguageId(languageCode, true, false);
                    }
                    LanguageIdBox.this.removeItem(defaultLanguageDropDownValue);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        if (parentCellRect != null) {
            this.setPreferredSize(new Dimension(100, parentCellRect.height));
        }
    }
}

