/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.net.URI;
import java.net.URISyntaxException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;

public class GraphUserAgent
extends SVGUserAgentGUIAdapter {
    GraphPanel graphPanel;

    public GraphUserAgent(GraphPanel parentComponent) {
        super(parentComponent);
        this.graphPanel = parentComponent;
    }

    public void displayError(String message) {
        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(message, "SVG Error");
    }

    public void displayError(Exception exception) {
        GuiHelper.linorgBugCatcher.logError(exception);
    }

    public void displayMessage(String message) {
        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(message, "SVG Error");
    }

    public void showAlert(String message) {
        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue(message, "SVG Notification");
    }

    public void openLink(String targetUri, boolean newc) {
        this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
        try {
            ArbilDataNode arbilDataNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, new URI(targetUri));
            this.graphPanel.metadataPanel.addSingleArbilDataNode(arbilDataNode);
        }
        catch (URISyntaxException urise) {
            GuiHelper.linorgBugCatcher.logError((Exception)urise);
        }
        this.graphPanel.setSelectedIds(new UniqueIdentifier[0]);
        this.graphPanel.metadataPanel.updateEditorPane();
    }
}

