/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityService;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.QueryParser;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.ArchiveEntityLinkerPanel;
import nl.mpi.kinnate.ui.DocumentNewMenu;
import nl.mpi.kinnate.ui.EgoSelectionPanel;
import nl.mpi.kinnate.ui.EntitySearchPanel;
import nl.mpi.kinnate.ui.FieldSelectionList;
import nl.mpi.kinnate.ui.HidePane;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTermPanel;
import nl.mpi.kinnate.ui.KinTypeStringInput;
import nl.mpi.kinnate.ui.MetadataPanel;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.kintypeeditor.KinTypeDefinitions;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinDiagramPanel
extends JPanel
implements SavePanel,
KinTermSavePanel,
ArbilDataNodeContainer {
    private EntityCollection entityCollection;
    private KinTypeStringInput kinTypeStringInput;
    private GraphPanel graphPanel;
    private GraphSorter graphSorter;
    private EgoSelectionPanel egoSelectionPanel;
    private HidePane kinTermHidePane;
    private HidePane kinTypeHidePane;
    private EntityService entityIndex;
    private JProgressBar progressBar;
    private static File defaultDiagramTemplate;
    private HashMap<ArbilDataNode, UniqueIdentifier> registeredArbilDataNode;
    private HashSet<ArbilNode> arbilDataNodesFirstLoadDone;
    private String defaultString = "# The kin type strings entered here will determine how the entities show on the graph below\n";
    public static String defaultGraphString;
    boolean graphThreadRunning = false;
    boolean graphUpdateRequired = false;

    public KinDiagramPanel(URI existingFile, boolean savableType) {
        this.initKinDiagramPanel(existingFile, null, savableType);
    }

    public KinDiagramPanel(DocumentNewMenu.DocumentType documentType) {
        this.initKinDiagramPanel(null, documentType, false);
    }

    private void initKinDiagramPanel(URI existingFile, DocumentNewMenu.DocumentType documentType, boolean savableType) {
        this.entityCollection = new EntityCollection();
        this.progressBar = new JProgressBar();
        EntityData[] svgStoredEntities = null;
        this.graphPanel = new GraphPanel(this);
        this.kinTypeStringInput = new KinTypeStringInput(this.defaultString);
        boolean showKinTerms = false;
        boolean showArchiveLinker = false;
        boolean showDiagramTree = false;
        boolean showEntitySearch = false;
        boolean showIndexerSettings = false;
        boolean showKinTypeStrings = false;
        boolean showMetaData = false;
        if (existingFile != null) {
            svgStoredEntities = this.graphPanel.readSvg(existingFile, savableType);
            String kinTermContents = null;
            for (String currentKinTypeString : this.graphPanel.getKinTypeStrigs()) {
                if (currentKinTypeString.trim().length() <= 0) continue;
                kinTermContents = kinTermContents == null ? "" : kinTermContents + "\n";
                kinTermContents = kinTermContents + currentKinTypeString.trim();
            }
            this.kinTypeStringInput.setText(kinTermContents);
        } else {
            if (documentType == null) {
                documentType = DocumentNewMenu.DocumentType.Simple;
            }
            switch (documentType) {
                case ArchiveLinker: {
                    showMetaData = true;
                    showDiagramTree = true;
                    showArchiveLinker = true;
                    break;
                }
                case CustomQuery: {
                    showMetaData = true;
                    showKinTypeStrings = true;
                    showDiagramTree = true;
                    showIndexerSettings = true;
                    break;
                }
                case EntitySearch: {
                    showMetaData = true;
                    showEntitySearch = true;
                    showDiagramTree = true;
                    break;
                }
                case KinTerms: {
                    showKinTerms = true;
                    this.graphPanel.addKinTermGroup();
                    break;
                }
                case Freeform: {
                    showKinTypeStrings = true;
                    break;
                }
                case Simple: {
                    showMetaData = true;
                    showDiagramTree = true;
                    break;
                }
                case Query: {
                    showMetaData = true;
                    showDiagramTree = true;
                    showKinTypeStrings = true;
                }
            }
            this.graphPanel.generateDefaultSvg();
        }
        this.setLayout(new BorderLayout());
        this.progressBar.setVisible(false);
        this.graphPanel.add((Component)this.progressBar, "First");
        this.registeredArbilDataNode = new HashMap();
        this.arbilDataNodesFirstLoadDone = new HashSet();
        this.egoSelectionPanel = new EgoSelectionPanel(this.graphPanel);
        JPanel kinGraphPanel = new JPanel(new BorderLayout());
        this.kinTypeHidePane = new HidePane(HidePane.HidePanePosition.top, 0);
        HidePane tableHidePane = new HidePane(HidePane.HidePanePosition.bottom, 150);
        KinDragTransferHandler dragTransferHandler = new KinDragTransferHandler(this);
        this.graphPanel.setTransferHandler(dragTransferHandler);
        this.egoSelectionPanel.setTransferHandler(dragTransferHandler);
        EntitySearchPanel entitySearchPanel = new EntitySearchPanel(this.entityCollection, this.graphPanel);
        entitySearchPanel.setTransferHandler(dragTransferHandler);
        HidePane egoSelectionHidePane = new HidePane(HidePane.HidePanePosition.left, 0);
        this.kinTermHidePane = new HidePane(HidePane.HidePanePosition.right, 0);
        TableCellDragHandler tableCellDragHandler = new TableCellDragHandler();
        this.graphPanel.setArbilTableModel(new MetadataPanel(this.graphPanel, tableHidePane, tableCellDragHandler));
        if (this.graphPanel.dataStoreSvg.getVisiblePanels() == null) {
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.KinTerms, 150, showKinTerms);
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.ArchiveLinker, 150, showArchiveLinker);
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.DiagramTree, 150, showDiagramTree);
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.EntitySearch, 150, showEntitySearch);
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.IndexerSettings, 150, showIndexerSettings);
            this.graphPanel.dataStoreSvg.setPanelState(VisiblePanelSetting.PanelType.KinTypeStrings, 150, showKinTypeStrings);
        }
        block18: for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() == null) continue;
            switch (panelSetting.getPanelType()) {
                case ArchiveLinker: {
                    panelSetting.setHidePane(this.kinTermHidePane, "Archive Linker");
                    panelSetting.addTargetPanel(new ArchiveEntityLinkerPanel(this.graphPanel, dragTransferHandler));
                    continue block18;
                }
                case DiagramTree: {
                    panelSetting.setHidePane(egoSelectionHidePane, "Diagram Tree");
                    panelSetting.addTargetPanel(this.egoSelectionPanel);
                    continue block18;
                }
                case EntitySearch: {
                    panelSetting.setHidePane(this.kinTermHidePane, "Search Entities");
                    panelSetting.addTargetPanel(entitySearchPanel);
                    continue block18;
                }
                case IndexerSettings: {
                    panelSetting.setHidePane(this.kinTypeHidePane, "Diagram Settings");
                    this.graphPanel.getIndexParameters().symbolFieldsFields.setParent(this.graphPanel.getIndexParameters());
                    this.graphPanel.getIndexParameters().labelFields.setParent(this.graphPanel.getIndexParameters());
                    JScrollPane symbolFieldsPanel = new JScrollPane(new FieldSelectionList(this, this.graphPanel.getIndexParameters().symbolFieldsFields, tableCellDragHandler));
                    JScrollPane labelFieldsPanel = new JScrollPane(new FieldSelectionList(this, this.graphPanel.getIndexParameters().labelFields, tableCellDragHandler));
                    symbolFieldsPanel.setName("Symbol Fields");
                    labelFieldsPanel.setName("Label Fields");
                    panelSetting.addTargetPanel(symbolFieldsPanel);
                    panelSetting.addTargetPanel(labelFieldsPanel);
                    panelSetting.addTargetPanel(new KinTypeDefinitions("Kin Type Definitions", this, this.graphPanel.dataStoreSvg));
                    continue block18;
                }
                case KinTerms: {
                    panelSetting.setHidePane(this.kinTermHidePane, "Kin Terms");
                    for (KinTermGroup kinTerms : this.graphPanel.getkinTermGroups()) {
                        panelSetting.addTargetPanel(new KinTermPanel(this, kinTerms));
                    }
                    continue block18;
                }
                case KinTypeStrings: {
                    panelSetting.setHidePane(this.kinTypeHidePane, "Kin Type Strings");
                    panelSetting.addTargetPanel(new JScrollPane(this.kinTypeStringInput));
                }
            }
        }
        tableHidePane.setVisible(false);
        kinGraphPanel.add((Component)this.kinTypeHidePane, "First");
        kinGraphPanel.add((Component)egoSelectionHidePane, "Before");
        kinGraphPanel.add((Component)this.graphPanel, "Center");
        kinGraphPanel.add((Component)this.kinTermHidePane, "After");
        kinGraphPanel.add((Component)tableHidePane, "Last");
        this.add(kinGraphPanel);
        this.entityIndex = new QueryParser(svgStoredEntities);
        this.graphSorter = new GraphSorter();
        this.kinTypeStringInput.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                KeyEvent keyEvent = e;
                synchronized (keyEvent) {
                    KinDiagramPanel.this.redrawIfKinTermsChanged();
                }
            }
        });
    }

    public static File getDefaultDiagramFile() {
        if (defaultDiagramTemplate == null) {
            defaultDiagramTemplate = new File(ArbilSessionStorage.getSingleInstance().getStorageDirectory(), "DefaultKinDiagram.svg");
        }
        return defaultDiagramTemplate;
    }

    public void redrawIfKinTermsChanged() {
        if (this.kinTypeStringInput.hasChanges()) {
            this.graphPanel.setKinTypeStrigs(this.kinTypeStringInput.getCurrentStrings());
            this.drawGraph();
        }
    }

    public synchronized void drawGraph() {
        this.graphUpdateRequired = true;
        if (!this.graphThreadRunning) {
            this.graphThreadRunning = true;
            new Thread(){

                public void run() {
                    while (KinDiagramPanel.this.graphUpdateRequired) {
                        KinDiagramPanel.this.graphUpdateRequired = false;
                        try {
                            String[] kinTypeStrings = KinDiagramPanel.this.graphPanel.getKinTypeStrigs();
                            ParserHighlight[] parserHighlight = new ParserHighlight[kinTypeStrings.length];
                            KinDiagramPanel.this.progressBar.setValue(0);
                            KinDiagramPanel.this.progressBar.setVisible(true);
                            boolean isQuery = false;
                            if (!((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.egoEntities.isEmpty() || !((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.requiredEntities.isEmpty()) {
                                isQuery = true;
                            } else {
                                for (String currentLine : kinTypeStrings) {
                                    if (!currentLine.contains("=")) continue;
                                    isQuery = true;
                                    break;
                                }
                            }
                            if (isQuery) {
                                EntityData[] graphNodes = KinDiagramPanel.this.entityIndex.processKinTypeStrings(null, kinTypeStrings, parserHighlight, KinDiagramPanel.this.graphPanel.getIndexParameters(), ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg, KinDiagramPanel.this.progressBar);
                                KinDiagramPanel.this.graphSorter.setEntitys(graphNodes);
                                KinDiagramPanel.this.graphPanel.drawNodes(KinDiagramPanel.this.graphSorter);
                                KinDiagramPanel.this.egoSelectionPanel.setTreeNodes(((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.egoEntities, ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg.requiredEntities, KinDiagramPanel.this.graphSorter.getDataNodes(), KinDiagramPanel.this.graphPanel.getIndexParameters());
                            } else {
                                KinTypeStringConverter graphData = new KinTypeStringConverter(((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg);
                                graphData.readKinTypes(kinTypeStrings, KinDiagramPanel.this.graphPanel.getkinTermGroups(), ((KinDiagramPanel)KinDiagramPanel.this).graphPanel.dataStoreSvg, parserHighlight);
                                KinDiagramPanel.this.graphPanel.drawNodes(graphData);
                                KinDiagramPanel.this.egoSelectionPanel.setTransientNodes(graphData.getDataNodes());
                            }
                            KinDiagramPanel.this.kinTypeStringInput.highlightKinTerms(parserHighlight, kinTypeStrings);
                        }
                        catch (EntityServiceException exception) {
                            GuiHelper.linorgBugCatcher.logError((Exception)exception);
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to load all entities required", "Draw Graph");
                        }
                        KinDiagramPanel.this.progressBar.setVisible(false);
                    }
                    KinDiagramPanel.this.graphThreadRunning = false;
                }
            }.start();
        }
    }

    public void setEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities = new HashSet<UniqueIdentifier>(Arrays.asList(egoIdentifierArray));
        this.drawGraph();
    }

    public void addEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities.addAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph();
    }

    public void removeEgoNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.egoEntities.removeAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph();
    }

    public void addRequiredNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.requiredEntities.addAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph();
    }

    public void removeRequiredNodes(UniqueIdentifier[] egoIdentifierArray) {
        this.graphPanel.dataStoreSvg.requiredEntities.removeAll(Arrays.asList(egoIdentifierArray));
        this.drawGraph();
    }

    public boolean hasSaveFileName() {
        return this.graphPanel.hasSaveFileName();
    }

    public File getFileName() {
        return this.graphPanel.getFileName();
    }

    public boolean requiresSave() {
        return this.graphPanel.requiresSave();
    }

    public void setRequiresSave() {
        this.graphPanel.setRequiresSave();
    }

    public void saveToFile() {
        this.graphPanel.saveToFile();
    }

    public void saveToFile(File saveFile) {
        this.graphPanel.saveToFile(saveFile);
    }

    public void updateGraph() {
        this.drawGraph();
    }

    public void exportKinTerms() {
        Component tabComponent = this.kinTermHidePane.getSelectedComponent();
        if (tabComponent instanceof KinTermPanel) {
            ((KinTermPanel)tabComponent).exportKinTerms();
        }
    }

    public void importKinTerms() {
        Component tabComponent = this.kinTermHidePane.getSelectedComponent();
        if (tabComponent instanceof KinTermPanel) {
            ((KinTermPanel)tabComponent).importKinTerms();
        }
    }

    public void addKinTermGroup() {
        KinTermGroup kinTermGroup = this.graphPanel.addKinTermGroup();
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != VisiblePanelSetting.PanelType.KinTerms) continue;
            panelSetting.addTargetPanel(new KinTermPanel(this, kinTermGroup));
        }
    }

    public VisiblePanelSetting[] getVisiblePanels() {
        return this.graphPanel.dataStoreSvg.getVisiblePanels();
    }

    public void setPanelState(VisiblePanelSetting.PanelType panelType, boolean panelVisible) {
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != panelType) continue;
            panelSetting.setPanelShown(panelVisible);
        }
    }

    public boolean getPanelState(VisiblePanelSetting.PanelType panelType) {
        for (VisiblePanelSetting panelSetting : this.graphPanel.dataStoreSvg.getVisiblePanels()) {
            if (panelSetting.getPanelType() != panelType) continue;
            return panelSetting.isPanelShown();
        }
        return false;
    }

    public void setSelectedKinTypeSting(String kinTypeStrings) {
        for (Component tabComponent : this.kinTermHidePane.getComponents()) {
            if (!(tabComponent instanceof KinTermPanel)) continue;
            KinTermPanel kinTermPanel = (KinTermPanel)tabComponent;
            kinTermPanel.setDefaultKinType(kinTypeStrings);
        }
    }

    public EntityData[] getGraphEntities() {
        return this.graphSorter.getDataNodes();
    }

    public void registerArbilNode(UniqueIdentifier uniqueIdentifier, ArbilDataNode arbilDataNode) {
        if (!this.registeredArbilDataNode.containsKey(arbilDataNode)) {
            arbilDataNode.registerContainer((ArbilDataNodeContainer)this);
            this.registeredArbilDataNode.put(arbilDataNode, uniqueIdentifier);
        }
    }

    public void entityRelationsChanged(UniqueIdentifier[] selectedIdentifiers) {
        this.graphPanel.clearEntityLocations(selectedIdentifiers);
        this.graphPanel.getIndexParameters().valuesChanged = true;
        this.drawGraph();
    }

    public void dataNodeIconCleared(ArbilNode arbilNode) {
        if (this.arbilDataNodesFirstLoadDone.contains(arbilNode)) {
            boolean dataBaseRequiresUpdate = false;
            boolean redrawRequired = false;
            if (arbilNode instanceof ArbilDataNode) {
                ArbilDataNode arbilDataNode = (ArbilDataNode)arbilNode;
                UniqueIdentifier uniqueIdentifier = this.registeredArbilDataNode.get(arbilDataNode);
                for (EntityData entityData : this.graphSorter.getDataNodes()) {
                    if (!entityData.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
                    if (entityData.metadataRequiresSave && !arbilDataNode.getNeedsSaveToDisk(false)) {
                        dataBaseRequiresUpdate = true;
                        redrawRequired = true;
                    }
                    entityData.metadataRequiresSave = arbilDataNode.getNeedsSaveToDisk(false);
                    if (!entityData.metadataRequiresSave) continue;
                    redrawRequired = true;
                }
                if (dataBaseRequiresUpdate) {
                    this.entityCollection.updateDatabase(arbilDataNode.getURI());
                    this.graphPanel.getIndexParameters().valuesChanged = true;
                }
            }
            if (redrawRequired) {
                this.drawGraph();
            }
        }
        if (!arbilNode.isLoading()) {
            this.arbilDataNodesFirstLoadDone.add(arbilNode);
        }
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newChildNode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dataNodeRemoved(ArbilNode adn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        defaultGraphString = "# The kin type strings entered here will determine how the entities show on the graph below\n# Enter one string per line.\n# for example:\nEm:Charles II of Spain:W:Marie Louise d'Orl\ufffdans\nEm:Charles II of Spain:F:Philip IV of Spain:F:Philip III of Spain:F:Philip II of Spain:F:Charles V, Holy Roman Emperor:F:Philip I of Castile\nEm:Charles II of Spain:M:Mariana of Austria:M:Maria Anna of Spain:M:Margaret of Austria:M:Maria Anna of Bavaria\nM:Mariana of Austria:F:Ferdinand III, Holy Roman Emperor:\nF:Philip IV of Spain:M:Margaret of Austria\nF:Ferdinand III, Holy Roman Emperor:\nM:Maria Anna of Spain:\nF:Philip III of Spain\nM:Margaret of Austria\n\n";
    }
}

