/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.KinnateArbilInjector;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.export.ExportToR;
import nl.mpi.kinnate.transcoder.DiagramTranscoder;
import nl.mpi.kinnate.ui.ArchiveMenu;
import nl.mpi.kinnate.ui.DiagramPanelsMenu;
import nl.mpi.kinnate.ui.DocumentNewMenu;
import nl.mpi.kinnate.ui.EditMenu;
import nl.mpi.kinnate.ui.EntityUploadPanel;
import nl.mpi.kinnate.ui.GedcomImportPanel;
import nl.mpi.kinnate.ui.ImportSamplesFileMenu;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinTermsMenu;
import nl.mpi.kinnate.ui.RecentFileMenu;
import nl.mpi.kinnate.ui.SamplesFileMenu;

public class MainFrame
extends JFrame {
    private RecentFileMenu recentFileMenu = new RecentFileMenu(this);
    private EntityUploadPanel entityUploadPanel;
    private JMenuItem ImportGedcomUrl;
    private JMenuItem closeTabMenuItem;
    private JMenu editMenu;
    private JMenuItem entityUploadMenuItem;
    private JMenuItem exitApplication;
    private JMenuItem exportToR;
    private JMenu fileMenu;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JMenuItem newDiagramMenuItem;
    private JMenuItem openDiagram;
    private JMenu openRecentMenu;
    private JMenuItem saveAsDefaultMenuItem;
    private JMenuItem saveDiagram;
    private JMenuItem saveDiagramAs;
    private JMenuItem savePdfMenuItem;

    public MainFrame() {
        this.initComponents();
        ((EditMenu)this.editMenu).enableMenuKeys();
        ApplicationVersionManager versionManager = new ApplicationVersionManager((ApplicationVersion)new KinOathVersion());
        KinnateArbilInjector.injectHandlers(versionManager);
        this.add((Component)this.jTabbedPane1, "Center");
        this.newDiagramMenuItemActionPerformed(null);
        this.jMenuBar1.add(new DiagramPanelsMenu(this));
        this.jMenuBar1.add(new KinTermsMenu(this));
        this.jMenuBar1.add(new ArchiveMenu(this));
        this.doLayout();
        this.pack();
        ArbilWindowManager.getSingleInstance().setMessagesCanBeShown(true);
        this.setTitle(versionManager.getApplicationVersion().applicationTitle + " " + versionManager.getApplicationVersion().compileDate);
        this.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
        versionManager.checkForUpdate();
    }

    private SavePanel getSavePanel(int tabIndex) {
        Component selectedComponent = this.jTabbedPane1.getComponentAt(tabIndex);
        SavePanel savePanel = null;
        if (selectedComponent instanceof SavePanel) {
            savePanel = (SavePanel)((Object)selectedComponent);
        }
        return savePanel;
    }

    public KinTermSavePanel getKinTermPanel() {
        Component selectedComponent = this.jTabbedPane1.getComponentAt(this.jTabbedPane1.getSelectedIndex());
        KinTermSavePanel kinTermSavePanel = null;
        if (selectedComponent instanceof KinTermSavePanel) {
            kinTermSavePanel = (KinTermSavePanel)((Object)selectedComponent);
        }
        return kinTermSavePanel;
    }

    public void openDiagram(String diagramTitle, URI selectedUri, boolean saveToRecentMenu) {
        if (saveToRecentMenu) {
            this.recentFileMenu.addRecentFile(new File(selectedUri));
        }
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(selectedUri, saveToRecentMenu);
        this.jTabbedPane1.add(diagramTitle, egoSelectionTestPanel);
        this.jTabbedPane1.setSelectedComponent(egoSelectionTestPanel);
    }

    public void importEntities(String importPath) {
        new GedcomImportPanel(this.jTabbedPane1).startImportJar(importPath);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.ImportGedcomUrl = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.newDiagramMenuItem = new JMenuItem();
        this.jMenu3 = new DocumentNewMenu(this.jTabbedPane1);
        this.openDiagram = new JMenuItem();
        this.openRecentMenu = this.recentFileMenu;
        this.jMenu1 = new SamplesFileMenu(this);
        this.jMenu2 = new ImportSamplesFileMenu(this);
        this.jSeparator2 = new JPopupMenu.Separator();
        this.entityUploadMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.saveDiagram = new JMenuItem();
        this.saveDiagramAs = new JMenuItem();
        this.savePdfMenuItem = new JMenuItem();
        this.exportToR = new JMenuItem();
        this.closeTabMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.saveAsDefaultMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.exitApplication = new JMenuItem();
        this.editMenu = new EditMenu();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.jTabbedPane1, "First");
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                MainFrame.this.fileMenuMenuSelected(evt);
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileMenuActionPerformed(evt);
            }
        });
        this.ImportGedcomUrl.setText("Import Gedcom Samples (from internet)");
        this.ImportGedcomUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ImportGedcomUrlActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.ImportGedcomUrl);
        this.fileMenu.add(this.jSeparator1);
        this.newDiagramMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newDiagramMenuItem.setText("New (default diagram)");
        this.newDiagramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.newDiagramMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newDiagramMenuItem);
        this.jMenu3.setText("New Diagram of Type");
        this.fileMenu.add(this.jMenu3);
        this.openDiagram.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openDiagram.setText("Open");
        this.openDiagram.setActionCommand("open");
        this.openDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openDiagramActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openDiagram);
        this.openRecentMenu.setText("Open Recent Diagram");
        this.openRecentMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openRecentMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openRecentMenu);
        this.jMenu1.setText("Open Sample Diagram");
        this.fileMenu.add(this.jMenu1);
        this.jMenu2.setText("Import Sample Data");
        this.fileMenu.add(this.jMenu2);
        this.fileMenu.add(this.jSeparator2);
        this.entityUploadMenuItem.setText("Entity Upload");
        this.entityUploadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.entityUploadMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.entityUploadMenuItem);
        this.fileMenu.add(this.jSeparator4);
        this.saveDiagram.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveDiagram.setText("Save");
        this.saveDiagram.setActionCommand("save");
        this.saveDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveDiagramActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveDiagram);
        this.saveDiagramAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveDiagramAs.setText("Save As");
        this.saveDiagramAs.setActionCommand("saveas");
        this.saveDiagramAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveDiagramAsActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveDiagramAs);
        this.savePdfMenuItem.setText("Export as PDF");
        this.savePdfMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.savePdfMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.savePdfMenuItem);
        this.exportToR.setText("Export to R / SPSS");
        this.exportToR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exportToRActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportToR);
        this.closeTabMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeTabMenuItem.setText("Close");
        this.closeTabMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.closeTabMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeTabMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.saveAsDefaultMenuItem.setText("Save as Default Diagram");
        this.saveAsDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveAsDefaultMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsDefaultMenuItem);
        this.fileMenu.add(this.jSeparator5);
        this.exitApplication.setText("Exit");
        this.exitApplication.setActionCommand("exit");
        this.exitApplication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitApplicationActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitApplication);
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                MainFrame.this.editMenuMenuSelected(evt);
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.editMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.editMenuActionPerformed(evt);
            }
        });
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void openDiagramActionPerformed(ActionEvent evt) {
        File[] selectedFilesArray = ArbilWindowManager.getSingleInstance().showFileSelectBox("Open Kin Diagram", false, true, false);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                this.openDiagram(selectedFile.getName(), selectedFile.toURI(), true);
            }
        }
    }

    private void openRecentMenuActionPerformed(ActionEvent evt) {
    }

    private void saveDiagramActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.getSavePanel(tabIndex);
        savePanel.saveToFile();
    }

    private void saveDiagramAsActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".svg");
            }

            public String getDescription() {
                return "Scalable Vector Graphics (SVG)";
            }
        });
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File svgFile = fc.getSelectedFile();
            if (!svgFile.getName().toLowerCase().endsWith(".svg")) {
                svgFile = new File(svgFile.getParentFile(), svgFile.getName() + ".svg");
            }
            int tabIndex = Integer.valueOf(evt.getActionCommand());
            SavePanel savePanel = this.getSavePanel(tabIndex);
            savePanel.saveToFile(svgFile);
            this.recentFileMenu.addRecentFile(svgFile);
            this.jTabbedPane1.setTitleAt(tabIndex, svgFile.getName());
        }
    }

    private void exitApplicationActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        int selectedIndex = this.jTabbedPane1.getSelectedIndex();
        String currentTabText = this.jTabbedPane1.getTitleAt(selectedIndex);
        SavePanel savePanel = this.getSavePanel(selectedIndex);
        this.saveDiagramAs.setText("Save As (" + currentTabText + ")");
        this.saveDiagramAs.setActionCommand(Integer.toString(selectedIndex));
        this.saveDiagram.setText("Save (" + currentTabText + ")");
        this.saveDiagram.setActionCommand(Integer.toString(selectedIndex));
        this.closeTabMenuItem.setText("Close (" + currentTabText + ")");
        this.closeTabMenuItem.setActionCommand(Integer.toString(selectedIndex));
        this.saveAsDefaultMenuItem.setText("Set Default Diagram as (" + currentTabText + ")");
        this.saveAsDefaultMenuItem.setActionCommand(Integer.toString(selectedIndex));
        if (savePanel != null) {
            this.saveDiagram.setEnabled(savePanel.hasSaveFileName() && savePanel.requiresSave());
            this.saveDiagramAs.setEnabled(true);
            this.exportToR.setEnabled(true);
            this.closeTabMenuItem.setEnabled(true);
            this.saveAsDefaultMenuItem.setEnabled(true);
            this.savePdfMenuItem.setEnabled(true);
        } else {
            this.saveDiagramAs.setEnabled(false);
            this.saveDiagram.setEnabled(false);
            this.exportToR.setEnabled(false);
            this.closeTabMenuItem.setEnabled(false);
            this.saveAsDefaultMenuItem.setEnabled(false);
            this.savePdfMenuItem.setEnabled(false);
        }
    }

    private void closeTabMenuItemActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.getSavePanel(tabIndex);
        if (savePanel.requiresSave()) {
            // empty if block
        }
        this.jTabbedPane1.remove(tabIndex);
    }

    private void newDiagramMenuItemActionPerformed(ActionEvent evt) {
        URI defaultDiagramUri = null;
        if (KinDiagramPanel.getDefaultDiagramFile().exists()) {
            defaultDiagramUri = KinDiagramPanel.getDefaultDiagramFile().toURI();
        }
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(defaultDiagramUri, false);
        this.jTabbedPane1.add("Unsaved Default Diagram", egoSelectionTestPanel);
        this.jTabbedPane1.setSelectedComponent(egoSelectionTestPanel);
    }

    private void ImportGedcomUrlActionPerformed(ActionEvent evt) {
        String[] importList;
        for (String importUrlString : importList = new String[]{"http://gedcomlibrary.com/gedcoms.html", "http://GedcomLibrary.com/gedcoms/gl120365.ged", "http://GedcomLibrary.com/gedcoms/gl120366.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120369.ged", "http://GedcomLibrary.com/gedcoms/gl120370.ged", "http://GedcomLibrary.com/gedcoms/gl120371.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/myline.ged", "http://gedcomlibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged"}) {
            new GedcomImportPanel(this.jTabbedPane1).startImport(importUrlString);
        }
    }

    private void savePdfMenuItemActionPerformed(ActionEvent evt) {
        new DiagramTranscoder().saveAsPdf((SavePanel)((Object)this.jTabbedPane1.getSelectedComponent()));
        new DiagramTranscoder().saveAsJpg((SavePanel)((Object)this.jTabbedPane1.getSelectedComponent()));
    }

    private void editMenuActionPerformed(ActionEvent evt) {
    }

    private void editMenuMenuSelected(MenuEvent evt) {
    }

    private void exportToRActionPerformed(ActionEvent evt) {
        new ExportToR().doExport(this, this.getKinTermPanel());
    }

    private void entityUploadMenuItemActionPerformed(ActionEvent evt) {
        if (this.entityUploadPanel == null) {
            this.entityUploadPanel = new EntityUploadPanel();
            this.jTabbedPane1.add("Entity Upload", this.entityUploadPanel);
        }
        this.jTabbedPane1.setSelectedComponent(this.entityUploadPanel);
    }

    private void saveAsDefaultMenuItemActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.getSavePanel(tabIndex);
        savePanel.saveToFile(KinDiagramPanel.getDefaultDiagramFile());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

