/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.mpi.arbil.ui.GuiHelper;
import org.apache.batik.bridge.UpdateManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SvgElementEditor
extends JPanel {
    UpdateManager updateManager;

    public SvgElementEditor(UpdateManager updateManager, final Element svgElement) {
        this.updateManager = updateManager;
        this.setLayout(new BorderLayout());
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel pickerPanel = new JPanel(new BorderLayout());
        JPanel pickerWrapperPanel = new JPanel(new BorderLayout());
        JPanel sidePanel = new JPanel(new GridLayout(0, 2));
        JPanel sideWrapperPanel = new JPanel(new BorderLayout());
        sideWrapperPanel.add((Component)sidePanel, "First");
        pickerWrapperPanel.add((Component)pickerPanel, "Center");
        pickerWrapperPanel.add((Component)sideWrapperPanel, "After");
        String editorMode = svgElement.getTagName();
        if (editorMode.equals("text")) {
            final JTextArea textArea = new JTextArea(svgElement.getTextContent());
            textArea.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    SvgElementEditor.this.updateValue(svgElement, textArea.getText());
                }
            });
            this.addColourInput(svgElement, sidePanel, pickerPanel, "fill");
            this.addNumberSpinner(svgElement, sidePanel, "font size", "font-size", 1, 100);
            outerPanel.add((Component)textArea, "Center");
            outerPanel.add((Component)pickerWrapperPanel, "After");
        } else {
            this.addColourInput(svgElement, sidePanel, pickerPanel, "fill");
            this.addColourInput(svgElement, sidePanel, pickerPanel, "stroke");
            this.addNumberSpinner(svgElement, sidePanel, "stroke width", "stroke-width", 1, 100);
            if (editorMode.equals("rect")) {
                this.addNumberSpinner(svgElement, sidePanel, "corner radius", "rx", 0, 100);
            }
            outerPanel.add((Component)pickerWrapperPanel, "After");
        }
        this.addDeleteButton(svgElement, sidePanel);
        this.add(new JScrollPane(outerPanel));
    }

    private void addDeleteButton(final Element svgElement, JPanel sidePanel) {
        final Node parentElement = svgElement.getParentNode();
        final JButton unDeleteButton = new JButton("Undelete");
        final JButton deleteButton = new JButton("Delete");
        sidePanel.add(unDeleteButton);
        unDeleteButton.setEnabled(false);
        unDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SvgElementEditor.this.reAddElement(parentElement, svgElement);
                unDeleteButton.setEnabled(false);
                deleteButton.setEnabled(true);
            }
        });
        sidePanel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SvgElementEditor.this.removeElement(parentElement, svgElement);
                unDeleteButton.setEnabled(true);
                deleteButton.setEnabled(false);
            }
        });
    }

    private void addNumberSpinner(final Element svgElement, JPanel sidePanel, String labelString, final String attributeString, int minValue, int maxValue) {
        int initialValue = 0;
        try {
            String initialValueString = svgElement.getAttribute(attributeString).trim();
            if (initialValueString.length() > 0) {
                initialValue = Integer.decode(initialValueString);
            }
        }
        catch (NumberFormatException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
        sidePanel.add(new JLabel(labelString));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(initialValue, minValue, maxValue, 1);
        final JSpinner numberSpinner = new JSpinner(spinnerModel);
        numberSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SvgElementEditor.this.updateValue(svgElement, attributeString, numberSpinner.getValue().toString());
            }
        });
        sidePanel.add(numberSpinner);
    }

    private void addColourInput(final Element svgElement, JPanel sidePanel, final JPanel pickerPanel, final String attributeString) {
        Color initialColour = Color.white;
        try {
            String attributeValue = svgElement.getAttribute(attributeString).trim();
            if (!attributeValue.equals("none")) {
                initialColour = Color.decode(attributeValue);
            }
        }
        catch (NumberFormatException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
        sidePanel.add(new JLabel(attributeString));
        final JPanel colourSquare = new JPanel();
        colourSquare.setBackground(initialColour);
        colourSquare.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                pickerPanel.removeAll();
                final JColorChooser colourChooser = new JColorChooser(colourSquare.getBackground());
                final Color revertColour = colourSquare.getBackground();
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
                JButton cancelButton = new JButton("Cancel");
                buttonPanel.add(cancelButton);
                JButton revertButton = new JButton("Revert");
                buttonPanel.add(revertButton);
                JButton noneButton = new JButton("None (Transparent)");
                buttonPanel.add(noneButton);
                JButton okButton = new JButton("OK");
                buttonPanel.add(okButton);
                cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        pickerPanel.removeAll();
                        SvgElementEditor.this.revalidate();
                        SvgElementEditor.this.repaint();
                    }
                });
                revertButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        SvgElementEditor.this.updateValue(svgElement, attributeString, "#" + Integer.toHexString(colourChooser.getColor().getRGB()).substring(2));
                    }
                });
                noneButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SvgElementEditor.this.updateValue(svgElement, attributeString, "none");
                        colourSquare.setBackground(Color.WHITE);
                    }
                });
                okButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        pickerPanel.removeAll();
                        SvgElementEditor.this.revalidate();
                        SvgElementEditor.this.repaint();
                    }
                });
                colourChooser.setPreviewPanel(new JPanel());
                colourChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        colourSquare.setBackground(colourChooser.getColor());
                        SvgElementEditor.this.updateValue(svgElement, attributeString, "#" + Integer.toHexString(colourChooser.getColor().getRGB()).substring(2));
                    }
                });
                pickerPanel.add((Component)colourChooser.getChooserPanels()[0], "Center");
                pickerPanel.add((Component)buttonPanel, "After");
                SvgElementEditor.this.revalidate();
                SvgElementEditor.this.repaint();
            }
        });
        sidePanel.add(colourSquare);
    }

    protected void updateValue(final Element changeTarget, final String attributeName, final String changeValue) {
        if (this.updateManager != null) {
            this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    changeTarget.setAttribute(attributeName, changeValue);
                }
            });
        }
    }

    protected void updateValue(final Element changeTarget, final String changeValue) {
        if (this.updateManager != null) {
            this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    changeTarget.setTextContent(changeValue);
                }
            });
        }
    }

    protected void removeElement(final Node parentTarget, final Element changeTarget) {
        if (this.updateManager != null) {
            this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    parentTarget.removeChild(changeTarget);
                }
            });
        }
    }

    protected void reAddElement(final Node parentTarget, final Element changeTarget) {
        if (this.updateManager != null) {
            this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    parentTarget.appendChild(changeTarget);
                }
            });
        }
    }
}

