/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.kintypeeditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.svg.DataStoreSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTypeTableModel
extends AbstractTableModel
implements ActionListener {
    SavePanel savePanel;
    DataStoreSvg dataStoreSvg;
    HashSet<KinType> checkBoxSet = new HashSet();
    JButton deleteSelectedButton;

    public KinTypeTableModel(SavePanel savePanel, DataStoreSvg dataStoreSvg, JButton deleteSelectedButton) {
        this.savePanel = savePanel;
        this.dataStoreSvg = dataStoreSvg;
        this.deleteSelectedButton = deleteSelectedButton;
        deleteSelectedButton.setEnabled(false);
        deleteSelectedButton.addActionListener(this);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Kin Type String";
            }
            case 1: {
                return "Relation Type";
            }
            case 2: {
                return "Symbol Type";
            }
            case 3: {
                return "Display Name";
            }
            case 4: {
                return "";
            }
        }
        throw new UnsupportedOperationException("Too many columns");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.dataStoreSvg.getKinTypeDefinitions().length + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            KinType kinType = this.dataStoreSvg.getKinTypeDefinitions()[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return kinType.getCodeString();
                }
                case 1: {
                    return kinType.getRelationType();
                }
                case 2: {
                    return kinType.getSymbolType();
                }
                case 3: {
                    return kinType.getDisplayString();
                }
                case 4: {
                    return this.checkBoxSet.contains(kinType);
                }
            }
            throw new UnsupportedOperationException("Too many columns");
        }
        switch (columnIndex) {
            case 4: {
                return false;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String stringValue = aValue.toString();
        KinType[] kinTypeDefinitions = this.dataStoreSvg.getKinTypeDefinitions();
        if (rowIndex >= this.dataStoreSvg.getKinTypeDefinitions().length && columnIndex == 4) {
            if (this.checkBoxSet.isEmpty()) {
                this.checkBoxSet.addAll(Arrays.asList(kinTypeDefinitions));
            } else {
                this.checkBoxSet.clear();
            }
            this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
            this.fireTableDataChanged();
            return;
        }
        String codeString = "undefined";
        DataTypes.RelationType relationType = DataTypes.RelationType.ancestor;
        EntityData.SymbolType symbolType = EntityData.SymbolType.square;
        String displayString = "";
        KinType kinType = null;
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            kinType = kinTypeDefinitions[rowIndex];
            codeString = kinType.getCodeString();
            relationType = kinType.getRelationType();
            symbolType = kinType.getSymbolType();
            displayString = kinType.getDisplayString();
        }
        switch (columnIndex) {
            case 0: {
                codeString = stringValue;
                break;
            }
            case 1: {
                relationType = DataTypes.RelationType.valueOf(stringValue);
                break;
            }
            case 2: {
                symbolType = EntityData.SymbolType.valueOf(stringValue);
                break;
            }
            case 3: {
                displayString = stringValue;
                break;
            }
            case 4: {
                if (((Boolean)aValue).booleanValue()) {
                    this.checkBoxSet.add(kinType);
                } else {
                    this.checkBoxSet.remove(kinType);
                }
                this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
                this.fireTableDataChanged();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Too many columns");
            }
        }
        if (rowIndex < this.dataStoreSvg.getKinTypeDefinitions().length) {
            kinTypeDefinitions[rowIndex] = new KinType(codeString, relationType, symbolType, displayString);
            this.dataStoreSvg.setKinTypeDefinitions(kinTypeDefinitions);
        } else {
            if ("".equals(aValue)) {
                return;
            }
            ArrayList<KinType> kinTypesList = new ArrayList<KinType>(Arrays.asList(kinTypeDefinitions));
            kinTypesList.add(new KinType(codeString, relationType, symbolType, displayString));
            this.dataStoreSvg.setKinTypeDefinitions(kinTypesList.toArray(new KinType[0]));
        }
        this.savePanel.updateGraph();
        this.savePanel.requiresSave();
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<KinType> kinTypesList = new ArrayList<KinType>(Arrays.asList(this.dataStoreSvg.getKinTypeDefinitions()));
        for (KinType kinType : this.checkBoxSet) {
            kinTypesList.remove(kinType);
        }
        this.dataStoreSvg.setKinTypeDefinitions(kinTypesList.toArray(new KinType[0]));
        this.checkBoxSet.clear();
        this.fireTableDataChanged();
        this.savePanel.updateGraph();
    }
}

