/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class QuickTimeCheck {
    byte[] buf = new byte[4096];
    boolean extraVerbose = false;
    boolean verbose = false;

    public void setVerbose(boolean v) {
        this.extraVerbose = v;
    }

    String readTag(int offset) {
        if (offset + 3 >= this.buf.length || offset < 0) {
            return new String("evil");
        }
        String result = new String(this.buf, offset, 4);
        return result.replaceAll("\\p{Punct}", ".").replaceAll("\\s", "_").replaceAll("[^\\w.]", "?");
    }

    long readLong(int offset) {
        if (offset + 3 >= this.buf.length || offset < 0) {
            return -1L;
        }
        long n1 = 0xFF & this.buf[offset + 0];
        long n2 = 0xFF & this.buf[offset + 1];
        long n3 = 0xFF & this.buf[offset + 2];
        long n4 = 0xFF & this.buf[offset + 3];
        return n4 | n3 << 8 | n2 << 16 | n1 << 24;
    }

    int readShort(int offset) {
        if (offset + 1 >= this.buf.length || offset < 0) {
            return -1;
        }
        int n1 = 0xFF & this.buf[offset + 0];
        int n2 = 0xFF & this.buf[offset + 1];
        return n2 | n1 << 8;
    }

    String doStbl(int offset, int size, String family) {
        int atomSize;
        String result = "";
        String fourcc = "none";
        int eof = offset + size;
        for (int pos = offset + 8; pos <= eof; pos += atomSize) {
            if (pos == eof) {
                if (result.length() == 0) {
                    return "evil/emptystbl";
                }
                return result.trim();
            }
            if (pos + 8 > eof) {
                return result + "evil/truncatedstbl";
            }
            long longAtomSize = this.readLong(pos);
            if (longAtomSize + (long)pos > (long)eof) {
                return result + "evil/badstblseek=" + (longAtomSize + (long)pos) + ">" + eof;
            }
            atomSize = (int)longAtomSize;
            String tag = this.readTag(pos + 4);
            System.err.println("          " + atomSize + " stbl:" + tag + " +" + pos);
            if (atomSize < 8) {
                return result + "evil/badstblsize=" + atomSize;
            }
            if ("stsd".equals(tag)) {
                if (atomSize < 32) {
                    result = result + "evil/smallsmhdstsd=" + atomSize + " ";
                    continue;
                }
                long entries = this.readLong(pos + 12);
                long configSize = 0L;
                if (entries != 1L) {
                    result = result + "evil/ncodecs=" + entries + " ";
                }
                if (entries > 0L) {
                    configSize = this.readLong(pos + 16);
                    fourcc = this.readTag(pos + 16 + 4);
                    result = result + family + "/" + fourcc + " ";
                    if (this.extraVerbose || fourcc.equals("twos") && configSize != 52L && configSize != 36L || fourcc.equals("cvid") && configSize != 86L || fourcc.equals("mp4a") && configSize != 87L || fourcc.equals("avc1") && configSize != 129L) {
                        result = result + "info/config=" + configSize + " ";
                    }
                }
                if (entries <= 1L) continue;
                if (configSize + (long)pos + 16L + 8L > (long)eof) {
                    result = result + "evil/2ndcodec=???*??? ";
                    continue;
                }
                result = result + "evil/2ndcodec=" + this.readTag(pos + 16 + (int)configSize + 4) + "*" + this.readLong(pos + 16 + (int)configSize) + " ";
                continue;
            }
            if ("stts".equals(tag) || "stsc".equals(tag) || "stss".equals(tag) || "stsz".equals(tag) || "stco".equals(tag) || "co64".equals(tag)) continue;
            if ("ctts".equals(tag)) {
                if (this.extraVerbose) {
                    result = result + "info/AACctts=" + atomSize + "@+" + pos + " ";
                    continue;
                }
                if (fourcc.equals("mp4a") || fourcc.equals("avc1")) continue;
                result = result + "info/aacctts ";
                continue;
            }
            if ("sdtp".equals(tag) || "udta".equals(tag)) continue;
            result = result + "evil/badstbltag=" + tag + "*" + atomSize + "@+" + pos + " ";
        }
        return result + "evil/stbleof";
    }

    String doMinf(int offset, int size) {
        int atomSize;
        String result = "";
        int eof = offset + size;
        String family = "unknown";
        for (int pos = offset + 8; pos <= eof; pos += atomSize) {
            if (pos == eof) {
                if (result.length() == 0) {
                    return "evil/emptyminf";
                }
                return result.trim();
            }
            if (pos + 8 > eof) {
                return result + "evil/truncatedminf";
            }
            long longAtomSize = this.readLong(pos);
            if (longAtomSize + (long)pos > (long)eof) {
                return result + "evil/badminfseek=" + (longAtomSize + (long)pos) + ">" + eof;
            }
            atomSize = (int)longAtomSize;
            String tag = this.readTag(pos + 4);
            System.err.println("        " + atomSize + " minf:" + tag + " +" + pos);
            if (atomSize < 8) {
                return result + "evil/badminfsize=" + atomSize;
            }
            if ("vmhd".equals(tag)) {
                if (atomSize < 20) {
                    result = result + "evil/smallminfvmhd=" + atomSize + " ";
                }
                family = "video";
                continue;
            }
            if ("smhd".equals(tag)) {
                if (atomSize < 16) {
                    result = result + "evil/smallminfsmhd=" + atomSize + " ";
                }
                family = "audio";
                continue;
            }
            if ("gmhd".equals(tag)) {
                result = result + "evil/generic ";
                family = "generic";
                continue;
            }
            if ("hdlr".equals(tag) || "dinf".equals(tag)) continue;
            if ("stbl".equals(tag)) {
                result = result + this.doStbl(pos, atomSize, family) + " ";
                continue;
            }
            if ("nmhd".equals(tag)) {
                if (atomSize > 12) {
                    result = result + "info/mpeg4nmhd=" + atomSize + "@+" + pos + " ";
                    continue;
                }
                if (!this.extraVerbose) continue;
                result = result + "info/mpeg4nmhd ";
                continue;
            }
            if ("hmhd".equals(tag)) {
                if (size != 28) {
                    result = result + "info/mpeg4hmhd=" + atomSize + "@+" + pos + " ";
                    continue;
                }
                result = result + "info/mpeg4hmhd ";
                continue;
            }
            if ("udta".equals(tag)) continue;
            result = result + "evil/badminftag=" + tag + "*" + atomSize + "@+" + pos + " ";
        }
        return result + "evil/minfeof";
    }

    String doMdia(int offset, int size) {
        int atomSize;
        String result = "";
        int eof = offset + size;
        for (int pos = offset + 8; pos <= eof; pos += atomSize) {
            if (pos == eof) {
                if (result.length() == 0) {
                    return "evil/emptymdia";
                }
                return result.trim();
            }
            if (pos + 8 > eof) {
                return result + "evil/truncatedmdia";
            }
            long longAtomSize = this.readLong(pos);
            if (longAtomSize + (long)pos > (long)eof) {
                return result + "evil/badmdiaseek=" + (longAtomSize + (long)pos) + ">" + eof;
            }
            atomSize = (int)longAtomSize;
            String tag = this.readTag(pos + 4);
            System.err.println("      " + atomSize + " mdia:" + tag + " +" + pos);
            if (atomSize < 8) {
                return result + "evil/badmdiasize=" + atomSize;
            }
            if ("mdhd".equals(tag)) {
                if (atomSize < 32) {
                    result = result + "evil/smallmdiamdhd=" + atomSize + " ";
                    continue;
                }
                DecimalFormat form = new DecimalFormat("######0.###");
                long timeScale = this.readLong(pos + 20);
                long duration = this.readLong(pos + 24);
                double seconds = 1.0 * (double)duration / ((double)timeScale + 0.01);
                if (!this.verbose) continue;
                result = result + "info/mtime=" + form.format(seconds) + " ";
                continue;
            }
            if ("hdlr".equals(tag)) continue;
            if ("minf".equals(tag)) {
                result = result + this.doMinf(pos, atomSize) + " ";
                continue;
            }
            if ("udta".equals(tag)) continue;
            result = result + "evil/badmdiatag=" + tag + "*" + atomSize + "@+" + pos + " ";
        }
        return result + "evil/mdiaeof";
    }

    String doTrak(int offset, int size) {
        int atomSize;
        String result = "";
        int eof = offset + size;
        for (int pos = offset + 8; pos <= eof; pos += atomSize) {
            if (pos == eof) {
                if (result.length() == 0) {
                    return "evil/emptytrak";
                }
                return result.trim();
            }
            if (pos + 8 > eof) {
                return result + "evil/truncatedtrak";
            }
            long longAtomSize = this.readLong(pos);
            if (longAtomSize + (long)pos > (long)eof) {
                return result + "evil/badtrakseek=" + (longAtomSize + (long)pos) + ">" + eof;
            }
            atomSize = (int)longAtomSize;
            String tag = this.readTag(pos + 4);
            System.err.println("    " + atomSize + " trak:" + tag + " +" + pos);
            if (atomSize < 8) {
                return result + "evil/badtraksize=" + atomSize;
            }
            if ("tkhd".equals(tag)) {
                if (atomSize < 92) {
                    result = result + "evil/smalltraktkhd=" + atomSize + " ";
                    continue;
                }
                if ((this.readLong(pos + 8) & 1L) == 1L) {
                    int volume = this.readShort(pos + 44) * 100 / 256;
                    result = result + "info/track=" + this.readLong(pos + 20);
                    if (this.readLong(pos + 84) != 0L) {
                        result = result + ":" + this.readShort(pos + 84) + "x" + this.readShort(pos + 88);
                        if (volume != 0) {
                            result = result + "@" + volume + "%";
                        }
                    } else {
                        result = result + ":" + volume + "%";
                    }
                    result = result + " ";
                    continue;
                }
                return result + "info/offtrack=" + this.readLong(pos + 20);
            }
            if ("mdia".equals(tag)) {
                result = result + this.doMdia(pos, atomSize) + " ";
                continue;
            }
            if ("edts".equals(tag)) continue;
            if ("tapt".equals(tag)) {
                if (atomSize == 68) {
                    result = result + "info/tapt=" + this.readTag(pos + 12) + ":" + this.readShort(pos + 20) + "x" + this.readShort(pos + 24) + ":" + this.readTag(pos + 32) + ":" + this.readShort(pos + 40) + "x" + this.readShort(pos + 44) + ":" + this.readTag(pos + 52) + ":" + this.readShort(pos + 60) + "x" + this.readShort(pos + 64) + " ";
                    continue;
                }
                result = result + "evil/badsizedtag=tapt*" + atomSize + "@" + pos + " ";
                continue;
            }
            if ("load".equals(tag) || "imap".equals(tag) || "clip".equals(tag) || "matt".equals(tag) || "udta".equals(tag)) continue;
            result = "tref".equals(tag) ? result + "info/traktref=" + atomSize + " " : result + "evil/badtraktag=" + tag + "*" + atomSize + "@+" + pos + " ";
        }
        return result + "evil/trakeof";
    }

    String doMoov(int size) {
        int atomSize;
        String result = "";
        for (int pos = 8; pos <= size; pos += atomSize) {
            if (pos == size) {
                if (result.length() == 0) {
                    return "evil/emptymoov";
                }
                return result.trim();
            }
            if (pos + 8 > size) {
                return result + "evil/truncatedmoov";
            }
            long longAtomSize = this.readLong(pos);
            if (longAtomSize + (long)pos > (long)size) {
                return result + "evil/badmoovseek=" + (longAtomSize + (long)pos) + ">" + size;
            }
            atomSize = (int)longAtomSize;
            String tag = this.readTag(pos + 4);
            System.err.println("  " + atomSize + " moov:" + tag + " +" + pos);
            if (atomSize < 8) {
                return result + "evil/badmoovsize=" + atomSize;
            }
            if ("mvhd".equals(tag)) {
                if (atomSize < 108) {
                    result = result + "evil/smallmoovmvhd=" + atomSize + " ";
                    continue;
                }
                DecimalFormat form = new DecimalFormat("######0.###");
                long timeScale = this.readLong(pos + 20);
                long duration = this.readLong(pos + 24);
                long nextFreeTrack = this.readLong(pos + 104);
                double seconds = 1.0 * (double)duration / ((double)timeScale + 0.01);
                if (this.verbose) {
                    result = result + "info/time=" + form.format(seconds);
                }
                result = result + " info/tracks=" + (nextFreeTrack - 1L) + " ";
                continue;
            }
            if ("trak".equals(tag)) {
                result = result + this.doTrak(pos, atomSize) + " ";
                continue;
            }
            if ("udta".equals(tag)) continue;
            if ("iods".equals(tag)) {
                if (this.extraVerbose || atomSize != 33) {
                    result = result + "info/mpeg4iods=" + atomSize + " ";
                    continue;
                }
                result = result + "info/mpeg4iods ";
                continue;
            }
            if ("rmra".equals(tag)) {
                result = result + "evil/externalmoov=" + tag + "*" + atomSize + "@+" + pos + " ";
                continue;
            }
            if ("cmov".equals(tag)) {
                result = this.extraVerbose ? result + "info/cmov=" + atomSize + "@+" + pos + " " : result + "info/cmov ";
                if (atomSize < 33 || this.readLong(pos + 8) != 12L || !"dcom".equals(this.readTag(pos + 8 + 4)) || !"zlib".equals(this.readTag(pos + 8 + 8))) {
                    result = result + "evil/badcmov=" + atomSize + (atomSize < 20 ? "" : ":" + this.readTag(pos + 8 + 4) + ":" + this.readTag(pos + 8 + 8)) + " ";
                    continue;
                }
                long comprSize = this.readLong(pos + 8 + 12) - 12L;
                if (!"cmvd".equals(this.readTag(pos + 8 + 16)) || comprSize < 1L || comprSize > 0x400000L) {
                    result = result + "evil/badcmvd=" + this.readLong(pos + 8 + 12) + ":" + this.readTag(pos + 8 + 16) + ":" + comprSize + " ";
                    continue;
                }
                long decomSize = this.readLong(pos + 8 + 20);
                if (decomSize > 0x800000L) {
                    return result + "evil/hugecmov=" + decomSize;
                }
                byte[] decomSrc = new byte[(int)comprSize];
                if (decomSrc == null) {
                    result = result + "evil/outofmemory=cmvd ";
                    return result;
                }
                if (pos + atomSize != size) {
                    result = result + "evil/skipaftercmov=" + (size - (pos + atomSize)) + " ";
                }
                try {
                    System.arraycopy(this.buf, pos + 8 + 24, decomSrc, 0, (int)comprSize);
                    if (decomSize > (long)this.buf.length) {
                        this.buf = new byte[(int)decomSize];
                    }
                    if (this.buf == null) {
                        result = result + "evil/outofmemory=cmvd ";
                        return result;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    result = result + "evil/arraycopyfail-bounds ";
                    return result;
                }
                catch (ArrayStoreException e) {
                    result = result + "evil/arraycopyfail-type ";
                    return result;
                }
                catch (NullPointerException e) {
                    result = result + "evil/arraycopyfail-null ";
                    return result;
                }
                Inflater inflate = new Inflater();
                inflate.setInput(decomSrc, 0, (int)comprSize);
                int foundSize = 0;
                try {
                    foundSize = inflate.inflate(this.buf, 0, (int)decomSize);
                }
                catch (DataFormatException e) {
                    System.err.println(e);
                    result = result + "evil/badcmvdata ";
                    return result;
                }
                if ((long)foundSize < decomSize) {
                    result = result + "evil/shortcmvd=" + foundSize + "<" + decomSize + " ";
                    if (foundSize < 16) {
                        return result;
                    }
                }
                inflate.end();
                if (!"moov".equals(this.readTag(4))) {
                    result = result + "evil/badcmvdcontents ";
                    return result;
                }
                result = result + this.doMoov(foundSize);
                return result;
            }
            result = result + "evil/badmoovtag=" + tag + "*" + atomSize + "@+" + pos + " ";
        }
        return result + "evil/mooveof";
    }

    public synchronized String checkQuickTime(RandomAccessFile qt) throws IOException {
        long size;
        int bufPos = 4096;
        int len = 4096;
        String result = "";
        if (qt == null || qt.length() <= 0L) {
            return "evil/empty";
        }
        for (long filePos = 0L; filePos <= qt.length(); filePos += size) {
            len = 4096;
            if (qt.length() - filePos < 4096L) {
                len = (int)(qt.length() - filePos);
            }
            if (len < 8) {
                if (len == 0) {
                    return result.trim();
                }
                return result + "evil/truncated";
            }
            if (bufPos >= 3072) {
                qt.seek(filePos);
                bufPos = 0;
                qt.readFully(this.buf, bufPos, len);
            }
            if ((size = this.readLong(bufPos + 0)) + filePos > qt.length() || size > Integer.MAX_VALUE) {
                return result + "evil/badseek=" + (size + filePos) + ">" + qt.length();
            }
            String tag = this.readTag(bufPos + 4);
            System.err.println("" + size + " tag=" + tag + " @" + filePos + "/" + bufPos);
            if (size < 8L) {
                if (this.readLong(bufPos + 4) == 0L && size == 0L) {
                    return result + "evil/zerohole=8@" + filePos;
                }
                return result + "evil/badsize=" + size + "@" + filePos + ":" + tag;
            }
            if ((size == 442L || size == 435L) && filePos == 0L) {
                return "evil/barempeg";
            }
            if ("moov".equals(tag)) {
                if (this.verbose) {
                    result = result + "info/movie=" + size + " ";
                }
                if (size > 0x800000L) {
                    return result + "evil/hugemoov=" + size;
                }
                len = (int)size;
                if (size > (long)this.buf.length) {
                    this.buf = new byte[len];
                }
                if (this.buf == null) {
                    result = result + "evil/outofmemory=moov ";
                    return result;
                }
                System.err.println("Load: " + len + " @" + filePos);
                qt.seek(filePos);
                bufPos = 0;
                qt.readFully(this.buf, bufPos, len);
                result = result + this.doMoov((int)size) + " ";
                len = 4096;
                qt.seek(filePos);
                if (filePos + 4096L >= qt.length()) {
                    len = (int)(qt.length() - filePos);
                }
                bufPos = 0;
                qt.readFully(this.buf, bufPos, len);
            } else if ("mdat".equals(tag)) {
                if (this.verbose) {
                    result = result + "info/mdat=" + size + " ";
                }
            } else if ("ftyp".equals(tag)) {
                result = result + "info/ftyp=" + this.readTag(bufPos + 8);
                if (size > 19L) {
                    int i = 16;
                    while ((long)(i + 3) < size) {
                        if (this.readLong(bufPos + i) != 0L) {
                            result = result + ":" + this.readTag(bufPos + i);
                        }
                        i += 4;
                    }
                }
                result = result + " ";
            } else if (!("pnot".equals(tag) || "udta".equals(tag) || "free".equals(tag) || "junk".equals(tag) || "wide".equals(tag))) {
                if ("pict".equals(tag) || "PICT".equals(tag)) {
                    result = result + "info/picture=" + size + " ";
                } else {
                    if ("evil".equals(tag)) {
                        return result + "evil/overflow";
                    }
                    result = result + " evil/badtoptag=" + tag + "*" + size + "@" + filePos + " ";
                }
            }
            bufPos = (int)((long)bufPos + size);
        }
        return result + "evil/eof";
    }

    public static void main(String[] args) {
        QuickTimeCheck me = new QuickTimeCheck();
        me.setVerbose(false);
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            RandomAccessFile what = null;
            try {
                what = new RandomAccessFile(args[i], "r");
                String result = me.checkQuickTime(what);
                what.close();
                System.out.println("" + result + " file: " + args[i]);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + fnfe);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check input file: " + args[i]);
                System.out.println("I/O Error: " + ioe);
                ioe.printStackTrace();
                if (what == null) continue;
                try {
                    what.close();
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

