/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.export.PedigreePackageExport;
import nl.mpi.kinnate.ui.MainFrame;

public class ExportToR {
    public void doExport(MainFrame mainFrame, KinTermSavePanel savePanel) {
        JFileChooser fc = new JFileChooser();
        String lastSavedFileString = ArbilSessionStorage.getSingleInstance().loadString("kinoath.ExportToR");
        if (lastSavedFileString != null) {
            fc.setSelectedFile(new File(lastSavedFileString));
        }
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".csv");
            }

            public String getDescription() {
                return "Data Frame (CSV)";
            }
        });
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            PedigreePackageExport packageExport = new PedigreePackageExport();
            ArbilSessionStorage.getSingleInstance().saveString("kinoath.ExportToR", file.getPath());
            try {
                FileWriter fileWriter = new FileWriter(file, false);
                fileWriter.write(packageExport.createCsvContents(savePanel.getGraphEntities()));
                fileWriter.close();
            }
            catch (IOException exception) {
                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Error, could not save file", "Export");
                GuiHelper.linorgBugCatcher.logError((Exception)exception);
            }
        }
    }
}

