/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import nl.mpi.kinnate.kintypestrings.KinTerm;

public class KinTermGroup {
    @XmlAttribute(name="GroupName", namespace="http://mpi.nl/tla/kin")
    public String titleString = "Kin Term Group (unnamed)";
    @XmlAttribute(name="GroupDescription", namespace="http://mpi.nl/tla/kin")
    public String descriptionString;
    @XmlAttribute(name="GroupColour", namespace="http://mpi.nl/tla/kin")
    public String graphColour = "#0000FF";
    @XmlAttribute(name="Show", namespace="http://mpi.nl/tla/kin")
    public boolean graphShow = true;
    @XmlAttribute(name="Generate", namespace="http://mpi.nl/tla/kin")
    public boolean graphGenerate = true;
    @XmlElement(name="KinTerm", namespace="http://mpi.nl/tla/kin")
    private ArrayList<KinTerm> kinTermArray;

    public KinTermGroup() {
        this.kinTermArray = new ArrayList();
    }

    @Deprecated
    public KinTermGroup(int type) {
        switch (type) {
            case 0: {
                this.titleString = "English terms";
                this.graphColour = "blue";
                this.kinTermArray = new ArrayList();
                this.kinTermArray.add(new KinTerm("Grand Mother", null, null, "MM", null, null));
                this.kinTermArray.add(new KinTerm("Aunt", null, null, "MZ|FZ", null, null));
                this.kinTermArray.add(new KinTerm("Uncle", null, null, "MB|FB", null, null));
                this.kinTermArray.add(new KinTerm("Grand Father", null, null, "FF", null, null));
                break;
            }
            case 1: {
                this.titleString = "Hawaiian Kin Terms";
                this.descriptionString = "http://umanitoba.ca/faculties/arts/anthropology/tutor/kinterms/hawaiian.html";
                this.graphColour = "cyan";
                this.kinTermArray = new ArrayList();
                this.kinTermArray.add(new KinTerm("Makuakane", "Father, Uncle", null, "F|FB|MB", null, null));
                this.kinTermArray.add(new KinTerm("Makuahini", "Mother, Aunt", null, "M|MZ|FZ", null, null));
                this.kinTermArray.add(new KinTerm("Kaikua'ana", "", null, "E(male)B|E(male)FBS|E(male)FZS|E(male)MBS|E(male)MZS", null, null));
                this.kinTermArray.add(new KinTerm("Kaikua'ana", "Brother/Sister, Cousin", null, "E(female)Z|E(female)FBD|E(female)FZD|E(female)MBD|E(female)MZD", null, null));
                this.kinTermArray.add(new KinTerm("Kaikuane", "Brother, Cousin", null, "E(female)B|E(female)FBS|E(female)FZS|E(female)MBS|E(female)MZS", null, null));
                this.kinTermArray.add(new KinTerm("Kaikuane", "Sister, Cousin", null, "E(male)Z|E(male)FBD|E(male)FZD|E(male)MBD|E(male)MZD", null, null));
                this.kinTermArray.add(new KinTerm("Keikikane", "Son, Nephew", null, "S|BS|ZS", null, null));
                this.kinTermArray.add(new KinTerm("Keikamahini", "Daughter, Niece", null, "D|BD|ZD", null, null));
                break;
            }
            default: {
                this.kinTermArray = new ArrayList();
            }
        }
    }

    public void addKinTerm(String kinTypeStrings, String kinTerm) {
        this.kinTermArray.add(new KinTerm(kinTerm, null, null, kinTypeStrings, null, null));
    }

    public void addKinTerm(KinTerm kinTerm) {
        this.kinTermArray.add(kinTerm);
    }

    public void updateKinTerm(String kinTypeStrings, String kinTerm) {
        for (KinTerm kinTermItem : this.kinTermArray) {
            if (!kinTermItem.kinTerm.equals(kinTerm)) continue;
            kinTermItem.alterKinTypeStrings = kinTypeStrings;
        }
    }

    public void removeKinTerm(String kinTerm) {
        for (KinTerm kinTermItem : this.getKinTerms()) {
            if (!kinTermItem.kinTerm.equals(kinTerm)) continue;
            this.kinTermArray.remove(kinTermItem);
        }
    }

    public void removeKinTerm(KinTerm kinTerm) {
        this.kinTermArray.remove(kinTerm);
    }

    public KinTerm[] getKinTerms() {
        return this.kinTermArray.toArray(new KinTerm[0]);
    }

    public String[] getTermLabel(String kinTypeString) {
        ArrayList<String> foundKinTerms = new ArrayList<String>();
        for (KinTerm kinTermItem : this.kinTermArray) {
            for (String kinType : kinTermItem.alterKinTypeStrings.split("\\|")) {
                if (!kinTypeString.trim().equals(kinType.trim())) continue;
                foundKinTerms.add(kinTermItem.kinTerm);
            }
        }
        return foundKinTerms.toArray(new String[0]);
    }
}

