/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class RelationDragHandle {
    protected DataTypes.RelationType relationType;
    protected float elementStartX;
    protected float elementStartY;
    protected float mouseStartX;
    protected float mouseStartY;
    protected float diagramScaleFactor;
    protected UniqueIdentifier targetIdentifier = null;

    public RelationDragHandle(DataTypes.RelationType relationType, float elementStartX, float elementStartY, float mouseStartX, float mouseStartY, double diagramScaleFactor) {
        this.relationType = relationType;
        this.elementStartX = elementStartX;
        this.elementStartY = elementStartY;
        this.mouseStartX = mouseStartX;
        this.mouseStartY = mouseStartY;
        this.diagramScaleFactor = (float)diagramScaleFactor;
    }

    protected float getTranslatedX(float localDragNodeX) {
        return this.elementStartX + (localDragNodeX - this.mouseStartX) / this.diagramScaleFactor;
    }

    protected float getTranslatedY(float localDragNodeY) {
        return this.elementStartY + (localDragNodeY - this.mouseStartY) / this.diagramScaleFactor;
    }
}

