/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.export.EntityUploader;

public class EntityUploadPanel
extends JPanel
implements ActionListener {
    private JTextArea uploadText;
    private JButton searchNewButton;
    private JButton searchModifiedButton;
    private JButton uploadButton;
    private JButton viewUploadButton;
    private JButton createWorkspaceButton;
    private JTextField workspaceName;
    private JPasswordField passwordText;
    private JProgressBar uploadProgress;
    private EntityUploader entityUploader = new EntityUploader();
    private JPanel workspacePanel;
    private JPanel passwordPanel;

    public EntityUploadPanel() {
        this.uploadText = new JTextArea();
        this.searchNewButton = new JButton("Search New Entities");
        this.searchModifiedButton = new JButton("Search Modified Entities");
        this.uploadButton = new JButton("Upload Selected");
        this.viewUploadButton = new JButton("View Uploaded");
        this.createWorkspaceButton = new JButton("Create Workspace");
        this.workspaceName = new JTextField();
        this.workspaceName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char keyChar = keyEvent.getKeyChar();
                if (!Character.isLetterOrDigit(keyChar)) {
                    keyEvent.consume();
                }
            }
        });
        this.passwordText = new JPasswordField();
        this.uploadProgress = new JProgressBar();
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.searchNewButton);
        controlPanel.add(this.searchModifiedButton);
        controlPanel.add(this.uploadButton);
        controlPanel.add(this.viewUploadButton);
        this.workspacePanel = new JPanel();
        this.workspacePanel.setLayout(new BorderLayout());
        this.workspacePanel.add((Component)new JLabel("Target Workspace Name"), "Before");
        this.workspacePanel.add((Component)this.workspaceName, "Center");
        this.workspacePanel.add((Component)this.createWorkspaceButton, "After");
        this.passwordPanel = new JPanel();
        this.passwordPanel.setLayout(new BorderLayout());
        this.passwordPanel.add((Component)new JLabel("Workspace Password"), "Before");
        this.passwordPanel.add((Component)this.passwordText, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.add(controlPanel);
        topPanel.add(this.workspacePanel);
        topPanel.add(this.passwordPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "First");
        this.add((Component)new JScrollPane(this.uploadText), "Center");
        this.add((Component)this.uploadProgress, "Last");
        this.uploadButton.setEnabled(false);
        this.viewUploadButton.setEnabled(false);
        this.workspacePanel.setVisible(false);
        this.passwordPanel.setVisible(false);
        this.searchNewButton.addActionListener(this);
        this.searchModifiedButton.addActionListener(this);
        this.uploadButton.addActionListener(this);
        this.viewUploadButton.addActionListener(this);
        this.createWorkspaceButton.addActionListener(this);
        this.searchNewButton.setActionCommand("searchnew");
        this.searchModifiedButton.setActionCommand("searchmodified");
        this.uploadButton.setActionCommand("upload");
        this.viewUploadButton.setActionCommand("view");
        this.createWorkspaceButton.setActionCommand("create");
    }

    public void actionPerformed(ActionEvent e) {
        this.searchNewButton.setEnabled(false);
        this.searchModifiedButton.setEnabled(false);
        this.uploadButton.setEnabled(false);
        this.viewUploadButton.setEnabled(false);
        if (e.getActionCommand().equals("searchnew")) {
            this.uploadText.setText("Searching for local entities that do not exist on the server\n");
            this.uploadProgress.setIndeterminate(true);
            this.entityUploader.findLocalEntities(this);
        } else if (e.getActionCommand().equals("searchmodified")) {
            this.uploadText.setText("Searching for modified entities that require upload to the server\n");
            this.uploadProgress.setIndeterminate(true);
            this.entityUploader.findModifiedEntities(this);
        } else if (e.getActionCommand().equals("upload")) {
            if (!this.workspaceName.getText().isEmpty()) {
                this.uploadText.append("Uploading entities to the server\n");
                this.entityUploader.uploadLocalEntites(this, this.uploadProgress, this.uploadText, this.workspaceName.getText(), this.passwordText.getPassword());
            } else {
                this.uploadText.append("Please enter a workspace name\n");
            }
        } else if (e.getActionCommand().equals("seachcomplete")) {
            this.uploadText.append(this.entityUploader.getFoundMessage());
            this.uploadProgress.setIndeterminate(false);
            this.uploadText.append("Done\n");
            this.searchNewButton.setEnabled(true);
            this.searchModifiedButton.setEnabled(true);
        } else if (e.getActionCommand().equals("uploadaborted")) {
            this.uploadProgress.setIndeterminate(false);
            this.uploadText.append("Error on upload, does the specified workspace exist?\n");
        } else if (e.getActionCommand().equals("view")) {
            GuiHelper.getSingleInstance().openFileInExternalApplication(this.entityUploader.getWorkspaceUri());
        } else if (e.getActionCommand().equals("create")) {
            URI createUri = this.entityUploader.getCreateUrl(this.workspaceName.getText());
            GuiHelper.getSingleInstance().openFileInExternalApplication(createUri);
        }
        this.workspacePanel.setVisible(this.entityUploader.canUpload());
        this.passwordPanel.setVisible(this.entityUploader.canUpload());
        this.uploadButton.setEnabled(this.entityUploader.canUpload());
        this.viewUploadButton.setEnabled(this.entityUploader.isUploadComplete());
    }
}

