/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.ui.MainFrame;

public class SamplesFileMenu
extends JMenu
implements ActionListener {
    MainFrame mainFrame;

    public SamplesFileMenu(MainFrame mainFrameLocal) {
        this.mainFrame = mainFrameLocal;
        this.addSampleToMenu("Application Overview", "ApplicationOverview.svg");
        this.addSampleToMenu("Hawaiian Kin Terms", "HawaiianKinTerms.svg");
        this.addSampleToMenu("Named Transient Entities", "NamedTransientEntities.svg");
        this.addSampleToMenu("Charles II of Spain", "Charles_II_of_Spain.svg");
        this.addSampleToMenu("Imported Data Query Example (ANTONIO DE PAULA PESSOA DE /FIGUEIREDO/)", "QueryExample.svg");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        String currentFilePath = SamplesFileMenu.class.getResource("/svgsamples/" + sampleFileString).toString();
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(currentFilePath);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            URI sampleFile = new URI(e.getActionCommand());
            if (e.getSource() instanceof JMenuItem) {
                String sampleName = ((JMenuItem)e.getSource()).getText();
                this.mainFrame.openDiagram(sampleName, sampleFile, false);
            }
        }
        catch (URISyntaxException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to load sample", "Sample Diagram");
        }
    }
}

