/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilEntityResolver;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.FieldUpdateRequest;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilComponentBuilder {
    public static final String RESOURCE_ID_PREFIX = "res_";
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private static DataNodeLoader dataNodeLoader;
    private HashMap<ArbilDataNode, SchemaType> nodeSchemaTypeMap = new HashMap();

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static Document getDocument(URI inputUri) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (inputUri == null) {
            document = documentBuilder.newDocument();
        } else {
            String decodeUrlString = URLDecoder.decode(inputUri.toString(), "UTF-8");
            document = documentBuilder.parse(decodeUrlString);
        }
        return document;
    }

    public static void savePrettyFormatting(Document document, File outputFile) {
        try {
            if (outputFile.getPath().endsWith(".imdi")) {
                ArbilComponentBuilder.removeImdiDomIds(document);
            }
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            StreamResult xmlOutput = new StreamResult(fileOutputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(dOMSource, xmlOutput);
            xmlOutput.getOutputStream().close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bugCatcher.logError(illegalArgumentException);
        }
        catch (TransformerException transformerException) {
            bugCatcher.logError(transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.out.println(transformerFactoryConfigurationError.getMessage());
        }
        catch (FileNotFoundException notFoundException) {
            bugCatcher.logError(notFoundException);
        }
        catch (IOException iOException) {
            bugCatcher.logError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertResourceProxy(ArbilDataNode arbilDataNode, ArbilDataNode resourceNode) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            boolean newResourceProxy;
            String targetXmlPath = this.getTargetXmlPath(arbilDataNode);
            System.out.println("insertResourceProxy: " + targetXmlPath);
            String resourceProxyId = null;
            CmdiComponentLinkReader linkReader = arbilDataNode.getParentDomNode().cmdiComponentLinkReader;
            if (linkReader != null) {
                resourceProxyId = linkReader.getProxyId(resourceNode.getUrlString());
            }
            boolean bl = newResourceProxy = resourceProxyId == null;
            if (newResourceProxy) {
                resourceProxyId = RESOURCE_ID_PREFIX + UUID.randomUUID().toString();
            }
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    try {
                        this.insertResourceProxyReference(targetDocument, targetXmlPath, resourceProxyId);
                    }
                    catch (TransformerException exception) {
                        bugCatcher.logError(exception);
                        return null;
                    }
                    if (newResourceProxy) {
                        SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().templateFile);
                        this.addNewResourceProxy(targetDocument, schemaType, resourceProxyId, resourceNode);
                    } else {
                        linkReader.getResourceLink(resourceProxyId).addReferencingNode();
                    }
                }
                catch (Exception exception) {
                    bugCatcher.logError(exception);
                    return null;
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, arbilDataNode.getFile());
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            return arbilDataNode.getURI();
        }
    }

    private String[] convertImdiPathToXPathOptions(String targetXpath) {
        if (targetXpath == null) {
            return null;
        }
        return new String[]{targetXpath.replaceAll("\\.", "/"), targetXpath.replaceAll("\\.", "/:")};
    }

    private String getTargetXmlPath(ArbilDataNode arbilDataNode) {
        String targetXmlPath = arbilDataNode.getURI().getFragment();
        if (targetXmlPath == null) {
            targetXmlPath = ".CMD.Components.*[1]";
        }
        return targetXmlPath;
    }

    private void insertResourceProxyReference(Document targetDocument, String targetXmlPath, String resourceProxyId) throws TransformerException, DOMException {
        Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
        Node previousRefNode = documentNode.getAttributes().getNamedItem("ref");
        if (previousRefNode != null) {
            String previousRefValue = documentNode.getAttributes().getNamedItem("ref").getNodeValue();
            ((Element)documentNode).setAttribute("ref", previousRefValue + " " + resourceProxyId);
        } else {
            ((Element)documentNode).setAttribute("ref", resourceProxyId);
        }
    }

    private void addNewResourceProxy(Document targetDocument, SchemaType schemaType, String resourceProxyId, ArbilDataNode resourceNode) throws ArbilMetadataException, DOMException {
        Node addedResourceNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, ".CMD.Resources.ResourceProxyList", ".CMD.Resources.ResourceProxyList.ResourceProxy");
        addedResourceNode.getAttributes().getNamedItem("id").setNodeValue(resourceProxyId);
        for (Node childNode = addedResourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            String localName = childNode.getNodeName();
            if ("ResourceType".equals(localName)) {
                if (resourceNode.isCmdiMetaDataNode()) {
                    childNode.setTextContent("Metadata");
                } else {
                    ((Element)childNode).setAttribute("mimetype", resourceNode.mpiMimeType);
                    childNode.setTextContent("Resource");
                }
            }
            if (!"ResourceRef".equals(localName)) continue;
            childNode.setTextContent(resourceNode.getUrlString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceProxyReferences(ArbilDataNode parent, Collection<String> resourceProxyReferences) {
        Object object = parent.getParentDomLockObject();
        synchronized (object) {
            CmdiComponentLinkReader linkReader = parent.getCmdiComponentLinkReader();
            if (linkReader == null) {
                return false;
            }
            HashSet<String> resourceProxyIds = new HashSet<String>(resourceProxyReferences.size());
            for (String reference : resourceProxyReferences) {
                resourceProxyIds.add(linkReader.getProxyId(reference));
            }
            String targetXmlPath = this.getTargetXmlPath(parent);
            System.out.println("removeResourceProxyReferences: " + targetXmlPath);
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(parent.getURI());
                try {
                    Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
                    Node previousRefNode = documentNode.getAttributes().getNamedItem("ref");
                    if (previousRefNode != null) {
                        String previousRefsValue = documentNode.getAttributes().getNamedItem("ref").getNodeValue();
                        StringBuilder newRefsValueSB = new StringBuilder();
                        for (String ref : previousRefsValue.split(" ")) {
                            if ((ref = ref.trim()).length() <= 0 || resourceProxyIds.contains(ref)) continue;
                            newRefsValueSB.append(ref).append(" ");
                        }
                        String newRefsValue = newRefsValueSB.toString().trim();
                        if (newRefsValue.length() == 0) {
                            ((Element)documentNode).removeAttribute("ref");
                        } else {
                            ((Element)documentNode).setAttribute("ref", newRefsValue);
                        }
                    }
                }
                catch (TransformerException exception) {
                    bugCatcher.logError(exception);
                    return false;
                }
                for (String id : resourceProxyIds) {
                    CmdiComponentLinkReader.CmdiResourceLink link = linkReader.getResourceLink(id);
                    link.removeReferencingNode();
                    if (link.getReferencingNodesCount() != 0 || this.removeResourceProxy(targetDocument, id)) continue;
                    messageDialogHandler.addMessageDialogToQueue("Failed to remove ", "Warning");
                }
                parent.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, parent.getFile());
                return true;
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
            }
        }
        return false;
    }

    private boolean removeResourceProxy(Document document, String resourceProxyId) {
        String[] xpaths;
        for (String xpath : xpaths = this.convertImdiPathToXPathOptions(".CMD.Resources.ResourceProxyList.ResourceProxy[@id='" + resourceProxyId + "']")) {
            try {
                Node proxyNode = XPathAPI.selectSingleNode((Node)document, (String)xpath);
                if (proxyNode == null) continue;
                proxyNode.getParentNode().removeChild(proxyNode);
                return true;
            }
            catch (TransformerException ex) {
                bugCatcher.logError("Exception while finding for removel resource proxy with id " + resourceProxyId, ex);
            }
            catch (DOMException ex) {
                bugCatcher.logError("Exception while trying to remove resource proxy with id " + resourceProxyId, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChildNodes(ArbilDataNode arbilDataNode, String[] nodePaths) {
        if (arbilDataNode.getNeedsSaveToDisk(false)) {
            arbilDataNode.saveChangesToCache(true);
        }
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("remove from parent nodes: " + arbilDataNode);
            File cmdiNodeFile = arbilDataNode.getFile();
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                ArrayList<Node> selectedNodes = new ArrayList<Node>();
                for (String currentNodePath : nodePaths) {
                    System.out.println("removeChildNodes: " + currentNodePath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentNodePath);
                    if (documentNode == null) continue;
                    System.out.println("documentNodeName: " + documentNode != null ? documentNode.getNodeName() : "<null>");
                    selectedNodes.add(documentNode);
                }
                System.out.println(selectedNodes.size());
                for (Node currentNode : selectedNodes) {
                    Node parentNode = currentNode.getParentNode();
                    if (parentNode == null) continue;
                    parentNode.removeChild(currentNode);
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (String currentNodePath : nodePaths) {
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
            }
            catch (TransformerException exception) {
                bugCatcher.logError(exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFieldValues(ArbilDataNode arbilDataNode, FieldUpdateRequest[] fieldUpdates) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("setFieldValues: " + arbilDataNode);
            File cmdiNodeFile = arbilDataNode.getFile();
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    Node languageNode;
                    System.out.println("currentFieldUpdate: " + currentFieldUpdate.fieldPath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentFieldUpdate.fieldPath);
                    NamedNodeMap attributesMap = documentNode.getAttributes();
                    if (!currentFieldUpdate.fieldOldValue.equals(documentNode.getTextContent())) {
                        bugCatcher.logError(new Exception("expecting '" + currentFieldUpdate.fieldOldValue + "' not '" + documentNode.getTextContent() + "' in " + currentFieldUpdate.fieldPath));
                        return false;
                    }
                    documentNode.setTextContent(currentFieldUpdate.fieldNewValue);
                    Node keyNameNode = attributesMap.getNamedItem("Name");
                    if (keyNameNode != null && currentFieldUpdate.keyNameValue != null) {
                        keyNameNode.setNodeValue(currentFieldUpdate.keyNameValue);
                    }
                    if ((languageNode = attributesMap.getNamedItem("LanguageId")) == null) {
                        languageNode = attributesMap.getNamedItem("xml:lang");
                    }
                    if (languageNode == null || currentFieldUpdate.fieldLanguageId == null) continue;
                    languageNode.setNodeValue(currentFieldUpdate.fieldLanguageId);
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath, currentFieldUpdate.fieldOldValue, currentFieldUpdate.fieldNewValue, "save");
                    if (currentFieldUpdate.fieldLanguageId != null) {
                        ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath + ":LanguageId", currentFieldUpdate.fieldLanguageId, "", "save");
                    }
                    if (currentFieldUpdate.keyNameValue == null) continue;
                    ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath + ":Name", currentFieldUpdate.keyNameValue, "", "save");
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
            }
            catch (TransformerException exception) {
                bugCatcher.logError(exception);
            }
            return false;
        }
    }

    public void testInsertFavouriteComponent() {
        try {
            ArbilDataNode favouriteArbilDataNode1 = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor"));
            ArbilDataNode favouriteArbilDataNode2 = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor(2)"));
            ArbilDataNode destinationArbilDataNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/imdicache/20100527141926/20100527141926.imdi"));
            this.insertFavouriteComponent(destinationArbilDataNode, favouriteArbilDataNode1);
            this.insertFavouriteComponent(destinationArbilDataNode, favouriteArbilDataNode2);
        }
        catch (URISyntaxException exception) {
            bugCatcher.logError(exception);
        }
        catch (ArbilMetadataException exception) {
            bugCatcher.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertFavouriteComponent(ArbilDataNode destinationArbilDataNode, ArbilDataNode favouriteArbilDataNode) throws ArbilMetadataException {
        URI returnUri = null;
        String elementName = favouriteArbilDataNode.getURI().getFragment();
        String insertBefore = destinationArbilDataNode.getNodeTemplate().getInsertBeforeOfTemplate(elementName);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = destinationArbilDataNode.getNodeTemplate().getMaxOccursForTemplate(elementName);
        System.out.println("maxOccurs: " + maxOccurs);
        if (destinationArbilDataNode.getNeedsSaveToDisk(false)) {
            destinationArbilDataNode.saveChangesToCache(true);
        }
        try {
            Document favouriteDocument;
            Object object = favouriteArbilDataNode.getParentDomLockObject();
            synchronized (object) {
                favouriteDocument = ArbilComponentBuilder.getDocument(favouriteArbilDataNode.getURI());
            }
            object = destinationArbilDataNode.getParentDomLockObject();
            synchronized (object) {
                Node[] favouriteNodes;
                Document destinationDocument = ArbilComponentBuilder.getDocument(destinationArbilDataNode.getURI());
                String favouriteXpath = favouriteArbilDataNode.getURI().getFragment();
                String favouriteXpathTrimmed = favouriteXpath.replaceFirst("\\.[^(^.]+$", "");
                boolean onlySubNodes = !favouriteXpathTrimmed.equals(favouriteXpath);
                System.out.println("favouriteXpath: " + favouriteXpathTrimmed);
                String destinationXpath = onlySubNodes ? favouriteXpathTrimmed : favouriteXpathTrimmed.replaceFirst("\\.[^.]+$", "");
                System.out.println("destinationXpath: " + destinationXpath);
                Node destinationNode = this.selectSingleNode(destinationDocument, destinationXpath);
                Node selectedNode = this.selectSingleNode(favouriteDocument, favouriteXpathTrimmed);
                Node importedNode = destinationDocument.importNode(selectedNode, true);
                if (onlySubNodes) {
                    NodeList selectedNodeList = importedNode.getChildNodes();
                    favouriteNodes = new Node[selectedNodeList.getLength()];
                    for (int nodeCounter = 0; nodeCounter < selectedNodeList.getLength(); ++nodeCounter) {
                        favouriteNodes[nodeCounter] = selectedNodeList.item(nodeCounter);
                    }
                } else {
                    favouriteNodes = new Node[]{importedNode};
                }
                for (Node singleFavouriteNode : favouriteNodes) {
                    if (singleFavouriteNode.getNodeType() == 3) continue;
                    ArbilComponentBuilder.insertNodeInOrder(destinationNode, singleFavouriteNode, insertBefore, maxOccurs);
                    System.out.println("inserting favouriteNode: " + singleFavouriteNode.getLocalName());
                }
                ArbilComponentBuilder.savePrettyFormatting(destinationDocument, destinationArbilDataNode.getFile());
                try {
                    String nodeFragment = favouriteNodes.length != 1 ? destinationXpath : ArbilComponentBuilder.convertNodeToNodePath(destinationDocument, favouriteNodes[0], destinationXpath);
                    System.out.println("nodeFragment: " + nodeFragment);
                    returnUri = new URI(destinationArbilDataNode.getURI().toString().split("#")[0] + "#" + nodeFragment);
                }
                catch (URISyntaxException exception) {
                    bugCatcher.logError(exception);
                }
            }
        }
        catch (IOException exception) {
            bugCatcher.logError(exception);
        }
        catch (ParserConfigurationException exception) {
            bugCatcher.logError(exception);
        }
        catch (SAXException exception) {
            bugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            bugCatcher.logError(exception);
        }
        return returnUri;
    }

    public static boolean canInsertNode(Node destinationNode, Node addableNode, int maxOccurs) {
        if (maxOccurs > 0) {
            String addableName = addableNode.getLocalName();
            if (addableName == null) {
                addableName = addableNode.getNodeName();
            }
            NodeList childNodes = destinationNode.getChildNodes();
            int duplicateNodeCounter = 0;
            for (int childCounter = 0; childCounter < childNodes.getLength(); ++childCounter) {
                String childsName = childNodes.item(childCounter).getLocalName();
                if (!addableName.equals(childsName) || ++duplicateNodeCounter < maxOccurs) continue;
                return false;
            }
        }
        return true;
    }

    public static Node insertNodeInOrder(Node destinationNode, Node addableNode, String insertBefore, int maxOccurs) throws TransformerException, ArbilMetadataException {
        Node addedNode;
        if (!ArbilComponentBuilder.canInsertNode(destinationNode, addableNode, maxOccurs)) {
            throw new ArbilMetadataException("The maximum nodes of this type have already been added.\n");
        }
        Node insertBeforeNode = null;
        if (insertBefore != null && insertBefore.length() > 0) {
            String[] insertBeforeArray = insertBefore.split(",");
            NodeList childNodes = destinationNode.getChildNodes();
            block0: for (int childCounter = 0; childCounter < childNodes.getLength(); ++childCounter) {
                String childsName = childNodes.item(childCounter).getLocalName();
                for (String currentInsertBefore : insertBeforeArray) {
                    if (!currentInsertBefore.equals(childsName)) continue;
                    System.out.println("insertbefore: " + childsName);
                    insertBeforeNode = childNodes.item(childCounter);
                    break block0;
                }
            }
        }
        if (insertBeforeNode != null) {
            System.out.println("inserting before: " + insertBeforeNode.getNodeName());
            addedNode = destinationNode.insertBefore(addableNode, insertBeforeNode);
        } else {
            System.out.println("inserting");
            addedNode = destinationNode.appendChild(addableNode);
        }
        return addedNode;
    }

    private String checkTargetXmlPath(String targetXmlPath, String cmdiComponentId) {
        if (targetXmlPath == null) {
            targetXmlPath = cmdiComponentId.replaceAll("\\.[^.]+$", "");
        } else if (targetXmlPath.replaceAll("\\(\\d+\\)", "").length() == cmdiComponentId.length()) {
            targetXmlPath = targetXmlPath.replaceAll("\\.[^.]+$", "");
        }
        String[] cmdiComponentArray = cmdiComponentId.split("\\.");
        String[] targetXmlPathArray = targetXmlPath.replaceAll("\\(\\d+\\)", "").split("\\.");
        StringBuilder arrayPathParts = new StringBuilder();
        for (int pathPartCounter = targetXmlPathArray.length; pathPartCounter < cmdiComponentArray.length - 1; ++pathPartCounter) {
            System.out.println("adding missing path component: " + cmdiComponentArray[pathPartCounter]);
            arrayPathParts.append('.');
            arrayPathParts.append(cmdiComponentArray[pathPartCounter]);
        }
        return targetXmlPath + arrayPathParts.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertChildComponent(ArbilDataNode arbilDataNode, String targetXmlPath, String cmdiComponentId) {
        if (arbilDataNode.getNeedsSaveToDisk(false)) {
            arbilDataNode.saveChangesToCache(true);
        }
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("insertChildComponent: " + cmdiComponentId);
            System.out.println("targetXmlPath: " + targetXmlPath);
            targetXmlPath = this.checkTargetXmlPath(targetXmlPath, cmdiComponentId);
            System.out.println("trimmed targetXmlPath: " + targetXmlPath);
            String nodeFragment = "";
            try {
                SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().templateFile);
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    Node AddedNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                    nodeFragment = ArbilComponentBuilder.convertNodeToNodePath(targetDocument, AddedNode, targetXmlPath);
                }
                catch (ArbilMetadataException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                    return null;
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, arbilDataNode.getFile());
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            try {
                System.out.println("nodeFragment: " + nodeFragment);
                return new URI(arbilDataNode.getURI().toString().split("#")[0] + "#" + nodeFragment);
            }
            catch (URISyntaxException exception) {
                bugCatcher.logError(exception);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canInsertChildComponent(ArbilDataNode arbilDataNode, String targetXmlPath, String cmdiComponentId) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            targetXmlPath = this.checkTargetXmlPath(targetXmlPath, cmdiComponentId);
            try {
                SchemaType schemaType = this.getFirstSchemaType(arbilDataNode);
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    return this.canInsertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                }
                catch (ArbilMetadataException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                    return false;
                }
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
                return false;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
                return false;
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
                return false;
            }
        }
    }

    public void testRemoveArchiveHandles() {
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(new URI("http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/MPI.imdi"));
            this.removeArchiveHandles(workingDocument);
            this.printoutDocument(workingDocument);
        }
        catch (Exception exception) {
            bugCatcher.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArchiveHandles(ArbilDataNode arbilDataNode) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            try {
                Document workingDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                this.removeArchiveHandles(workingDocument);
                ArbilComponentBuilder.savePrettyFormatting(workingDocument, arbilDataNode.getFile());
            }
            catch (Exception exception) {
                bugCatcher.logError(exception);
            }
        }
    }

    private static void removeImdiDomIds(Document targetDocument) {
        String handleXpath = "/:METATRANSCRIPT[@id]|/:METATRANSCRIPT//*[@id]";
        try {
            NodeList domIdNodeList = XPathAPI.selectNodeList((Node)targetDocument, (String)handleXpath);
            for (int nodeCounter = 0; nodeCounter < domIdNodeList.getLength(); ++nodeCounter) {
                Node domIdNode = domIdNodeList.item(nodeCounter);
                if (domIdNode == null) continue;
                domIdNode.getAttributes().removeNamedItem("id");
            }
        }
        catch (TransformerException exception) {
            bugCatcher.logError(exception);
        }
    }

    private void removeArchiveHandles(Document targetDocument) {
        String handleXpath = "/:METATRANSCRIPT[@ArchiveHandle]|/:METATRANSCRIPT//*[@ArchiveHandle]";
        try {
            NodeList archiveHandleNodeList = XPathAPI.selectNodeList((Node)targetDocument, (String)handleXpath);
            for (int nodeCounter = 0; nodeCounter < archiveHandleNodeList.getLength(); ++nodeCounter) {
                Node archiveHandleNode = archiveHandleNodeList.item(nodeCounter);
                if (archiveHandleNode == null) continue;
                archiveHandleNode.getAttributes().removeNamedItem("ArchiveHandle");
            }
        }
        catch (TransformerException exception) {
            bugCatcher.logError(exception);
        }
    }

    private Node selectSingleNode(Document targetDocument, String targetXpath) throws TransformerException {
        String[] tempXpathArray = this.convertImdiPathToXPathOptions(targetXpath);
        if (tempXpathArray != null) {
            for (String tempXpath : tempXpathArray) {
                tempXpath = tempXpath.replaceAll("\\(", "[");
                tempXpath = tempXpath.replaceAll("\\)", "]");
                System.out.println("tempXpath: " + tempXpath);
                Node returnNode = XPathAPI.selectSingleNode((Node)targetDocument, (String)tempXpath);
                if (returnNode == null) continue;
                return returnNode;
            }
        }
        bugCatcher.logError(new Exception("Xpath issue, no node found for: " + targetXpath));
        return null;
    }

    private Node insertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws ArbilMetadataException {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String insertBefore = "";
        String strippedXpath = null;
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            strippedXpath = targetXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("strippedXpath: " + strippedXpath);
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            System.out.println("currentPathComponent: " + currentPathComponent);
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.getName().getLocalPart();
                if (foundProperty == null) {
                    if (!currentPathComponent.equals(currentName)) continue;
                    foundProperty = schemaProperty;
                    insertBefore = "";
                    continue;
                }
                if (schemaProperty.isAttribute()) continue;
                insertBefore = insertBefore.length() < 1 ? currentName : insertBefore + "," + currentName;
                System.out.println("insertBefore: " + insertBefore);
            }
            if (foundProperty == null) {
                throw new ArbilMetadataException("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
            System.out.println("foundProperty: " + foundProperty.getName().getLocalPart());
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        Node addedNode = this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode, false);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = foundProperty.getMaxOccurs() != null ? foundProperty.getMaxOccurs().intValue() : -1;
        System.out.println("maxOccurs: " + maxOccurs);
        if (insertBefore.length() > 0 || maxOccurs != -1) {
            try {
                documentNode.removeChild(addedNode);
                ArbilComponentBuilder.insertNodeInOrder(documentNode, addedNode, insertBefore, maxOccurs);
            }
            catch (TransformerException exception) {
                throw new ArbilMetadataException(exception.getMessage());
            }
        }
        return addedNode;
    }

    private boolean canInsertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws ArbilMetadataException {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String insertBefore = "";
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                bugCatcher.logError(exception);
                return false;
            }
        }
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.getName().getLocalPart();
                if (foundProperty == null) {
                    if (!currentPathComponent.equals(currentName)) continue;
                    foundProperty = schemaProperty;
                    insertBefore = "";
                    continue;
                }
                if (schemaProperty.isAttribute()) continue;
                insertBefore = insertBefore.length() < 1 ? currentName : insertBefore + "," + currentName;
            }
            if (foundProperty == null) {
                throw new ArbilMetadataException("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        Node addedNode = this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode, false);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = foundProperty.getMaxOccurs() != null ? foundProperty.getMaxOccurs().intValue() : -1;
        System.out.println("maxOccurs: " + maxOccurs);
        if (insertBefore.length() > 0 || maxOccurs != -1) {
            documentNode.removeChild(addedNode);
            return ArbilComponentBuilder.canInsertNode(documentNode, addedNode, maxOccurs);
        }
        return true;
    }

    public static String convertNodeToNodePath(Document targetDocument, Node documentNode, String targetXmlPath) {
        System.out.println("Calculating the added fragment");
        int siblingCouter = 1;
        for (Node siblingNode = documentNode.getPreviousSibling(); siblingNode != null; siblingNode = siblingNode.getPreviousSibling()) {
            if (!documentNode.getNodeName().equals(siblingNode.getNodeName())) continue;
            ++siblingCouter;
        }
        String nodeFragment = documentNode.getNodeName();
        String nodePathString = targetXmlPath + "." + nodeFragment + "(" + siblingCouter + ")";
        System.out.println("nodeFragment: " + nodePathString);
        System.out.println("targetXmlPath: " + targetXmlPath);
        return nodePathString;
    }

    public URI createComponentFile(URI cmdiNodeFile, URI xsdFile, boolean addDummyData) {
        System.out.println("createComponentFile: " + cmdiNodeFile + " : " + xsdFile);
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(null);
            this.readSchema(workingDocument, xsdFile, addDummyData);
            ArbilComponentBuilder.savePrettyFormatting(workingDocument, new File(cmdiNodeFile));
        }
        catch (IOException e) {
            bugCatcher.logError(e);
        }
        catch (ParserConfigurationException e) {
            bugCatcher.logError(e);
        }
        catch (SAXException e) {
            bugCatcher.logError(e);
        }
        return cmdiNodeFile;
    }

    private SchemaType getFirstSchemaType(ArbilDataNode arbilDataNode) {
        if (this.nodeSchemaTypeMap.containsKey(arbilDataNode)) {
            return this.nodeSchemaTypeMap.get(arbilDataNode);
        }
        SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().templateFile);
        this.nodeSchemaTypeMap.put(arbilDataNode, schemaType);
        return schemaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaType getFirstSchemaType(File schemaFile) {
        block9: {
            SchemaType schemaType;
            FileInputStream inputStream = new FileInputStream(schemaFile);
            try {
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.setCharacterEncoding("UTF-8");
                xmlOptions.setEntityResolver(new ArbilEntityResolver(sessionStorage.getOriginatingUri(schemaFile.toURI())));
                SchemaTypeSystem sts = XmlBeans.compileXsd(new XmlObject[]{XmlObject.Factory.parse(inputStream, xmlOptions)}, XmlBeans.getBuiltinTypeSystem(), xmlOptions);
                schemaType = sts.documentTypes()[0];
            }
            catch (IOException e) {
                try {
                    try {
                        bugCatcher.logError(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e2) {
                    bugCatcher.logError(e2);
                    break block9;
                }
                catch (XmlException e3) {
                    messageDialogHandler.addMessageDialogToQueue("Could not read the XML Schema", "Error inserting node");
                    bugCatcher.logError(e3);
                }
            }
            ((InputStream)inputStream).close();
            return schemaType;
        }
        return null;
    }

    private void readSchema(Document workingDocument, URI xsdFile, boolean addDummyData) {
        File schemaFile = xsdFile.getScheme() == null || xsdFile.getScheme().length() == 0 || xsdFile.getScheme().toLowerCase().equals("file") ? new File(xsdFile) : sessionStorage.updateCache(xsdFile.toString(), 5);
        SchemaType schemaType = this.getFirstSchemaType(schemaFile);
        this.constructXml(schemaType.getElementProperties()[0], "documentTypes", workingDocument, xsdFile.toString(), null, addDummyData);
    }

    private Element appendNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty, boolean addDummyData) {
        Element currentElement = workingDocument.createElementNS("http://www.clarin.eu/cmd/", schemaProperty.getName().getLocalPart());
        SchemaType currentSchemaType = schemaProperty.getType();
        for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
            if (attributesProperty.getMinOccurs() == null || attributesProperty.getMinOccurs().equals(BigInteger.ZERO)) continue;
            currentElement.setAttribute(attributesProperty.getName().getLocalPart(), attributesProperty.getDefaultText());
        }
        if (parentElement == null) {
            currentElement.setAttribute("CMDVersion", "1.1");
            currentElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            currentElement.setAttribute("xsi:schemaLocation", "http://www.clarin.eu/cmd/ " + nameSpaceUri);
            workingDocument.appendChild(currentElement);
        } else {
            parentElement.appendChild(currentElement);
        }
        return currentElement;
    }

    private Node constructXml(SchemaProperty currentSchemaProperty, String pathString, Document workingDocument, String nameSpaceUri, Node parentElement, boolean addDummyData) {
        Element currentElement;
        Element returnNode = null;
        String currentPathString = pathString + "." + currentSchemaProperty.getName().getLocalPart();
        System.out.println("Found Element: " + currentPathString);
        SchemaType currentSchemaType = currentSchemaProperty.getType();
        returnNode = currentElement = this.appendNode(workingDocument, nameSpaceUri, parentElement, currentSchemaProperty, addDummyData);
        for (SchemaProperty schemaProperty : currentSchemaType.getElementProperties()) {
            BigInteger maxNumberToAdd;
            if (addDummyData) {
                maxNumberToAdd = schemaProperty.getMaxOccurs();
                BigInteger dummyNumberToAdd = BigInteger.ONE.add(BigInteger.ONE).add(BigInteger.ONE);
                if (maxNumberToAdd == null) {
                    maxNumberToAdd = dummyNumberToAdd;
                } else if (dummyNumberToAdd.compareTo(maxNumberToAdd) == -1) {
                    maxNumberToAdd = dummyNumberToAdd;
                }
            } else {
                maxNumberToAdd = schemaProperty.getMinOccurs();
                if (maxNumberToAdd == null) {
                    maxNumberToAdd = BigInteger.ZERO;
                }
            }
            BigInteger addNodeCounter = BigInteger.ZERO;
            while (addNodeCounter.compareTo(maxNumberToAdd) < 0) {
                this.constructXml(schemaProperty, currentPathString, workingDocument, nameSpaceUri, currentElement, addDummyData);
                addNodeCounter = addNodeCounter.add(BigInteger.ONE);
            }
        }
        return returnNode;
    }

    private void printoutDocument(Document workingDocument) {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer transformer = tranFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(workingDocument);
            StreamResult dest = new StreamResult(System.out);
            transformer.transform(src, dest);
        }
        catch (Exception e) {
            bugCatcher.logError(e);
        }
    }

    public void testWalk() {
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(null);
            this.readSchema(workingDocument, new URI("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1264769926773/xsd"), true);
            this.printoutDocument(workingDocument);
        }
        catch (Exception e) {
            bugCatcher.logError(e);
        }
    }
}

