/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

public abstract class ArbilActionBuffer {
    private final Object actionLock;
    private String title;
    private int delay;
    private int maxDelay;
    private boolean actionRequested;
    private Thread workerThread;

    public ArbilActionBuffer(String title, int delay, int maxDelay) {
        this(title, delay, maxDelay, new Object());
    }

    public ArbilActionBuffer(String title, int delay) {
        this(title, delay, 0, new Object());
    }

    public ArbilActionBuffer(String title, int delay, int maxDelay, Object lock) {
        this.actionLock = lock;
        this.delay = delay;
        this.title = title;
        this.maxDelay = maxDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAction() {
        Object object = this.actionLock;
        synchronized (object) {
            this.actionRequested = true;
            if (this.workerThread == null || !this.workerThread.isAlive()) {
                this.workerThread = new Thread((Runnable)new ArbilBufferedWorkerRunnable(), this.title);
                this.workerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestActionAndNotify() {
        Object object = this.actionLock;
        synchronized (object) {
            this.requestAction();
            this.actionLock.notifyAll();
        }
    }

    protected abstract void executeAction();

    private class ArbilBufferedWorkerRunnable
    implements Runnable {
        private ArbilBufferedWorkerRunnable() {
        }

        public void run() {
            while (ArbilActionBuffer.this.actionRequested) {
                try {
                    this.waitForIncomingRequests();
                    ArbilActionBuffer.this.executeAction();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForIncomingRequests() throws InterruptedException {
            long waitStartTime = System.currentTimeMillis();
            Object object = ArbilActionBuffer.this.actionLock;
            synchronized (object) {
                if (!ArbilActionBuffer.this.actionRequested) {
                    ArbilActionBuffer.this.actionLock.wait();
                }
                while (ArbilActionBuffer.this.actionRequested) {
                    ArbilActionBuffer.this.actionRequested = false;
                    if (ArbilActionBuffer.this.maxDelay > 0 && System.currentTimeMillis() - waitStartTime > (long)ArbilActionBuffer.this.maxDelay) {
                        return;
                    }
                    ArbilActionBuffer.this.actionLock.wait(ArbilActionBuffer.this.delay);
                }
            }
        }
    }
}

