/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class LabelStringsParser {
    protected boolean userDefinedIdentifierFound = false;
    public UniqueIdentifier uniqueIdentifier;
    public boolean dateError = false;
    public int dateLocation = -1;
    public int dateEndLocation = -1;
    public int uidStartLocation = -1;
    public int uidEndLocation = -1;
    public String[] labelsStrings = new String[0];
    public Date dateOfBirth = null;
    public Date dateOfDeath = null;
    protected String remainingInputString;

    protected LabelStringsParser(String inputString, EntityData parentData, String currentKinTypeString) {
        if (inputString.startsWith(":")) {
            String[] inputStringParts = inputString.split(":", 3);
            this.remainingInputString = inputStringParts.length > 2 ? inputStringParts[2] : "";
            if (inputStringParts.length > 0) {
                String remainingString = inputStringParts[1].replaceFirst(";[0-9]{4}(/[0-9]{2}){0,2}(-[0-9]{4}(/[0-9]{2}){0,2})?$", "");
                if (remainingString.length() != inputStringParts[1].length()) {
                    String dateString = inputStringParts[1].substring(remainingString.length());
                    dateString = dateString.replaceFirst("^;", "");
                    this.dateLocation = dateString.length() + this.remainingInputString.length() + 1;
                    this.dateEndLocation = this.remainingInputString.length() + 1;
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
                    String[] dateStringArray = dateString.split("-");
                    try {
                        while (dateStringArray[0].length() < "yyyy/MM/dd".length()) {
                            dateStringArray[0] = dateStringArray[0] + "/01";
                        }
                        this.dateOfBirth = formatter.parse(dateStringArray[0]);
                        if (dateStringArray.length > 1) {
                            while (dateStringArray[1].length() < "yyyy/MM/dd".length()) {
                                dateStringArray[1] = dateStringArray[1] + "/01";
                            }
                            this.dateOfDeath = formatter.parse(dateStringArray[1]);
                        }
                        inputStringParts[1] = remainingString;
                    }
                    catch (ParseException exception) {
                        System.out.println(exception.getMessage());
                        this.dateError = true;
                    }
                }
                this.labelsStrings = inputStringParts[1].split(";");
                if (this.labelsStrings[0].matches("^#[0-9]*")) {
                    this.uniqueIdentifier = new UniqueIdentifier("id:" + this.labelsStrings[0], UniqueIdentifier.IdentifierType.tid);
                    this.userDefinedIdentifierFound = true;
                    this.uidStartLocation = inputString.length() - 1;
                    this.uidEndLocation = inputString.length() - this.labelsStrings[0].length() - 1;
                }
                if (this.uniqueIdentifier == null) {
                    this.uniqueIdentifier = new UniqueIdentifier("label:" + inputStringParts[1], UniqueIdentifier.IdentifierType.tid);
                    this.userDefinedIdentifierFound = true;
                }
            }
        }
        if (this.uniqueIdentifier == null) {
            this.uniqueIdentifier = parentData != null ? new UniqueIdentifier(parentData.getUniqueIdentifier().getAttributeIdentifier() + currentKinTypeString, UniqueIdentifier.IdentifierType.tid) : new UniqueIdentifier("label:kintype:" + currentKinTypeString, UniqueIdentifier.IdentifierType.tid);
        }
    }
}

