/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.util.XsdChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNodeLoaderThreadManager {
    private static final int MAX_REMOTE_THREADS = 6;
    private static final int MAX_LOCAL_THREADS = 6;
    private boolean continueThread = true;
    private int arbilFilesLoaded = 0;
    private int remoteArbilFilesLoaded = 0;
    private int threadStartCounter = 0;
    private ThreadGroup remoteLoaderThreadGroup;
    private ThreadGroup localLoaderThreadGroup;
    private final Vector<ArbilDataNode> arbilRemoteNodesToInit = new Vector();
    private final Vector<ArbilDataNode> arbilLocalNodesToInit = new Vector();
    private boolean schemaCheckLocalFiles = false;
    private ScheduledThreadPoolExecutor remoteExecutor = new ScheduledThreadPoolExecutor(DataNodeLoaderThreadManager.MAX_REMOTE_THREADS()){

        protected void beforeExecute(Thread t, Runnable r) {
            DataNodeLoaderThreadManager.this.beforeExecuteLoaderThread(t, r, false);
        }

        protected void afterExecute(Runnable r, Throwable t) {
            DataNodeLoaderThreadManager.this.afterExecuteLoaderThread(r, t, false);
        }

        public ThreadFactory getThreadFactory() {
            return new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    String threadName = "ArbilDataNodeLoader-remote-" + DataNodeLoaderThreadManager.this.threadStartCounter++;
                    Thread thread = new Thread(DataNodeLoaderThreadManager.this.remoteLoaderThreadGroup, r, threadName);
                    thread.setPriority(4);
                    return thread;
                }
            };
        }
    };
    private ScheduledThreadPoolExecutor localExecutor = new ScheduledThreadPoolExecutor(DataNodeLoaderThreadManager.MAX_LOCAL_THREADS()){

        protected void beforeExecute(Thread t, Runnable r) {
            DataNodeLoaderThreadManager.this.beforeExecuteLoaderThread(t, r, true);
        }

        protected void afterExecute(Runnable r, Throwable t) {
            DataNodeLoaderThreadManager.this.afterExecuteLoaderThread(r, t, true);
        }

        public ThreadFactory getThreadFactory() {
            return new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    String threadName = "ArbilDataNodeLoader-local-" + DataNodeLoaderThreadManager.this.threadStartCounter++;
                    Thread thread = new Thread(DataNodeLoaderThreadManager.this.localLoaderThreadGroup, r, threadName);
                    thread.setPriority(4);
                    return thread;
                }
            };
        }
    };

    public DataNodeLoaderThreadManager() {
        this.remoteLoaderThreadGroup = new ThreadGroup("RemoteLoaderThreads");
        this.localLoaderThreadGroup = new ThreadGroup("LocalLoaderThreads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeToQueue(ArbilDataNode nodeToAdd) {
        this.startLoaderThreads();
        if (ArbilDataNode.isStringLocal(nodeToAdd.getUrlString())) {
            Vector<ArbilDataNode> vector = this.arbilLocalNodesToInit;
            synchronized (vector) {
                if (!this.arbilLocalNodesToInit.contains(nodeToAdd)) {
                    this.arbilLocalNodesToInit.addElement(nodeToAdd);
                    this.arbilLocalNodesToInit.notifyAll();
                }
            }
        }
        Vector<ArbilDataNode> vector = this.arbilRemoteNodesToInit;
        synchronized (vector) {
            if (!this.arbilRemoteNodesToInit.contains(nodeToAdd)) {
                this.arbilRemoteNodesToInit.addElement(nodeToAdd);
                this.arbilRemoteNodesToInit.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArbilDataNode getNodeFromQueue(Vector<ArbilDataNode> dataNodesQueue) {
        Vector<ArbilDataNode> vector = dataNodesQueue;
        synchronized (vector) {
            if (dataNodesQueue.size() > 0) {
                ArbilDataNode tempDataNode = dataNodesQueue.remove(0);
                if (tempDataNode.lockedByLoadingThread) {
                    dataNodesQueue.add(tempDataNode);
                    return null;
                }
                tempDataNode.lockedByLoadingThread = true;
                dataNodesQueue.notifyAll();
                return tempDataNode;
            }
            return null;
        }
    }

    public synchronized void startLoaderThreads() {
        while (this.isContinueThread() && this.remoteExecutor.getActiveCount() < DataNodeLoaderThreadManager.MAX_REMOTE_THREADS()) {
            this.remoteExecutor.submit(new RemoteLoader());
        }
        while (this.isContinueThread() && this.localExecutor.getActiveCount() < DataNodeLoaderThreadManager.MAX_LOCAL_THREADS()) {
            this.localExecutor.submit(new LocalLoader());
        }
    }

    synchronized void stopLoaderThreads() {
        this.remoteExecutor.shutdownNow();
        this.localExecutor.shutdownNow();
    }

    public boolean isSchemaCheckLocalFiles() {
        return this.schemaCheckLocalFiles;
    }

    public void setSchemaCheckLocalFiles(boolean schemaCheckLocalFiles) {
        this.schemaCheckLocalFiles = schemaCheckLocalFiles;
    }

    public boolean isContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(boolean continueThread) {
        this.continueThread = continueThread;
    }

    public static int MAX_REMOTE_THREADS() {
        return 6;
    }

    public static int MAX_LOCAL_THREADS() {
        return 6;
    }

    protected void beforeExecuteLoaderThread(Thread t, Runnable r, boolean local) {
    }

    protected void afterExecuteLoaderThread(Runnable r, Throwable t, boolean local) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArbilDataNode waitForNodes(Vector<ArbilDataNode> queue) throws InterruptedException {
        Vector<ArbilDataNode> vector = queue;
        synchronized (vector) {
            while (queue.isEmpty()) {
                queue.wait();
            }
            return this.getNodeFromQueue(queue);
        }
    }

    private class LocalLoader
    implements Runnable {
        private ArbilDataNode currentArbilDataNode;

        private LocalLoader() {
        }

        public void run() {
            while (DataNodeLoaderThreadManager.this.isContinueThread() && !Thread.currentThread().isInterrupted()) {
                try {
                    this.currentArbilDataNode = DataNodeLoaderThreadManager.this.waitForNodes(DataNodeLoaderThreadManager.this.arbilLocalNodesToInit);
                }
                catch (InterruptedException ex) {
                    System.out.println(Thread.currentThread().getName() + " interrupted. " + ex.getMessage());
                    return;
                }
                if (this.currentArbilDataNode == null) continue;
                System.out.println("run LocalArbilLoader processing: " + this.currentArbilDataNode.getUrlString());
                if (this.currentArbilDataNode.getNeedsSaveToDisk(false)) {
                    this.currentArbilDataNode.saveChangesToCache(false);
                }
                this.currentArbilDataNode.loadArbilDom();
                if (DataNodeLoaderThreadManager.this.isSchemaCheckLocalFiles()) {
                    if (this.currentArbilDataNode.isMetaDataNode()) {
                        XsdChecker xsdChecker = new XsdChecker();
                        String checkerResult = xsdChecker.simpleCheck(this.currentArbilDataNode.getFile(), this.currentArbilDataNode.getURI());
                        this.currentArbilDataNode.hasSchemaError = checkerResult != null;
                    }
                } else {
                    this.currentArbilDataNode.hasSchemaError = false;
                }
                this.currentArbilDataNode.updateLoadingState(-1);
                this.currentArbilDataNode.clearIcon();
                this.currentArbilDataNode.clearChildIcons();
                DataNodeLoaderThreadManager.this.arbilFilesLoaded++;
                System.out.println("remoteArbilFilesLoaded: " + DataNodeLoaderThreadManager.this.remoteArbilFilesLoaded + " arbilFilesLoaded: " + DataNodeLoaderThreadManager.this.arbilFilesLoaded);
                this.currentArbilDataNode.lockedByLoadingThread = false;
                this.currentArbilDataNode.notifyLoaded();
            }
        }
    }

    private class RemoteLoader
    implements Runnable {
        ArbilDataNode currentArbilDataNode = null;

        private RemoteLoader() {
        }

        public void run() {
            while (DataNodeLoaderThreadManager.this.isContinueThread() && !Thread.currentThread().isInterrupted()) {
                try {
                    this.currentArbilDataNode = DataNodeLoaderThreadManager.this.waitForNodes(DataNodeLoaderThreadManager.this.arbilRemoteNodesToInit);
                }
                catch (InterruptedException ex) {
                    System.out.println(Thread.currentThread().getName() + " interrupted. " + ex.getMessage());
                    return;
                }
                if (this.currentArbilDataNode == null) continue;
                System.out.println("run RemoteArbilLoader processing: " + this.currentArbilDataNode.getUrlString());
                this.currentArbilDataNode.loadArbilDom();
                this.currentArbilDataNode.updateLoadingState(-1);
                this.currentArbilDataNode.clearIcon();
                this.currentArbilDataNode.clearChildIcons();
                DataNodeLoaderThreadManager.this.remoteArbilFilesLoaded++;
                this.currentArbilDataNode.notifyLoaded();
                this.currentArbilDataNode.lockedByLoadingThread = false;
            }
        }
    }
}

