/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.importexport.ArbilToHtmlConverter;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;

public abstract class ArbilContextMenu
extends JPopupMenu {
    protected ArbilDataNode[] selectedTreeNodes = null;
    protected ArbilDataNode leadSelectedTreeNode = null;
    private JMenuItem browseForResourceFileMenuItem = new JMenuItem();
    private JMenuItem viewXmlMenuItem = new JMenuItem();
    private JMenuItem viewXmlMenuItemFormatted = new JMenuItem();
    private JMenuItem openInExternalApplicationMenuItem = new JMenuItem();
    private JMenuItem openXmlMenuItemFormatted = new JMenuItem();
    private JMenuItem exportHtmlMenuItemFormatted = new JMenuItem();
    private JMenuItem overrideTypeCheckerDecision = new JMenuItem();
    private JMenuItem saveMenuItem = new JMenuItem();
    private LinkedHashMap<String, List<OrderedMenuItem>> itemsMap = new LinkedHashMap();
    protected static final String CATEGORY_NODE = "node";
    protected static final String CATEGORY_EDIT = "edit";
    protected static final String CATEGORY_ADD_FAVOURITES = "add+favourites";
    protected static final String CATEGORY_XML = "xml";
    protected static final String CATEGORY_DISK = "disk";
    protected static final String CATEGORY_REMOTE_CORPUS = "remote corpus";
    protected static final String CATEGORY_WORKING_DIR = "working dir";
    protected static final String CATEGORY_TABLE_CELL = "table cell";
    protected static final String CATEGORY_TABLE_ROW = "table row";
    protected static final String CATEGORY_IMPORT = "import";
    protected static final int PRIORITY_TOP = 0;
    protected static final int PRIORITY_MIDDLE = 50;
    protected static final int PRIORITY_BOTTOM = 100;

    private void applyMenuItems() {
        boolean first = true;
        for (List<OrderedMenuItem> category : this.itemsMap.values()) {
            if (category.isEmpty()) continue;
            Collections.sort(category);
            if (!first) {
                this.add(new JSeparator());
            } else {
                first = false;
            }
            for (OrderedMenuItem item : category) {
                this.add(item.menuItem);
            }
        }
    }

    public void show(int posX, int posY) {
        this.setCommonInvisible();
        this.setAllInvisible();
        this.prepareItemCategories();
        this.setUpMenu();
        this.setUpCommonMenuItems();
        this.setUpCommonActions();
        this.applyMenuItems();
        this.configureMenuSeparators();
        super.show(this.getInvoker(), posX, posY);
        this.requestFocusInWindow();
    }

    protected abstract void setUpMenu();

    protected abstract void setAllInvisible();

    private void setUpCommonActions() {
        this.browseForResourceFileMenuItem.setText("Browse For Resource File");
        this.browseForResourceFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    File[] selectedFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Select Resource File", false, false, false);
                    if (selectedFiles != null && selectedFiles.length > 0) {
                        ArbilContextMenu.this.leadSelectedTreeNode.resourceUrlField.setFieldValue(selectedFiles[0].toURL().toExternalForm(), true, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_NODE, 100, this.browseForResourceFileMenuItem);
        this.saveMenuItem.setText("Save Changes to Disk");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : ArbilContextMenu.this.selectedTreeNodes) {
                        System.out.println("userObject: " + selectedNode);
                        ArbilDataNodeLoader.getSingleInstance().requestReload(selectedNode.getParentDomNode());
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_DISK, 0, this.saveMenuItem);
        this.overrideTypeCheckerDecision.setText("Override Type Checker Decision");
        this.overrideTypeCheckerDecision.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String titleString = "Override Type Checker Decision";
                    String messageString = "The type checker does not recognise the selected file/s, which means that they\nare not an archivable type. This action will override that decision and allow you\nto add the file/s to a session, as either media or written resources,\nhowever it might not be possible to import the result to the copus server.";
                    Object[] optionStrings = new String[]{"WrittenResource", "MediaFile", "Cancel"};
                    int userSelection = JOptionPane.showOptionDialog(ArbilWindowManager.getSingleInstance().linorgFrame.getContentPane(), messageString, titleString, -1, -1, null, optionStrings, optionStrings[2]);
                    if (((String)optionStrings[userSelection]).equals("WrittenResource") || ((String)optionStrings[userSelection]).equals("MediaFile")) {
                        for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                            if (currentNode.mpiMimeType != null) continue;
                            currentNode.mpiMimeType = "Manual/" + (String)optionStrings[userSelection];
                            currentNode.typeCheckerMessage = "Manually overridden (might not be compatible with the archive)";
                            currentNode.clearIcon();
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_WORKING_DIR, 0, this.overrideTypeCheckerDecision);
        this.openInExternalApplicationMenuItem.setText("Open in External Application");
        this.openInExternalApplicationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilContextMenu.this.openFileInExternalApplication(ArbilContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_DISK, 100, this.openInExternalApplicationMenuItem);
        this.viewXmlMenuItem.setText("View XML");
        this.viewXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, false, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 0, this.viewXmlMenuItem);
        this.viewXmlMenuItemFormatted.setText("View IMDI Formatted");
        this.viewXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, true, false);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 5, this.viewXmlMenuItemFormatted);
        this.openXmlMenuItemFormatted.setText("Open IMDI Formatted");
        this.openXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        GuiHelper.getSingleInstance().openImdiXmlWindow(currentNode, true, true);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 10, this.openXmlMenuItemFormatted);
        this.exportHtmlMenuItemFormatted.setText("Export IMDI to HTML");
        this.exportHtmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    URI uri = new ArbilToHtmlConverter().exportImdiToHtml(ArbilContextMenu.this.selectedTreeNodes);
                    if (uri != null) {
                        System.out.println("Converted to html in " + uri.toString());
                        GuiHelper.getSingleInstance().openFileInExternalApplication(uri);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Export to HTML failed. Check the error log for details.", "Export failed");
                }
            }
        });
        this.addItem(CATEGORY_XML, 15, this.exportHtmlMenuItemFormatted);
    }

    protected void setUpCommonMenuItems() {
        if (this.leadSelectedTreeNode != null) {
            this.saveMenuItem.setVisible(this.leadSelectedTreeNode.getNeedsSaveToDisk(false));
            if (this.leadSelectedTreeNode.hasResource()) {
                this.browseForResourceFileMenuItem.setVisible(true);
            }
            if (!this.leadSelectedTreeNode.isChildNode() && this.leadSelectedTreeNode.isMetaDataNode()) {
                this.viewXmlMenuItem.setVisible(true);
                if (!this.leadSelectedTreeNode.isCmdiMetaDataNode()) {
                    this.viewXmlMenuItemFormatted.setVisible(true);
                    this.openXmlMenuItemFormatted.setVisible(true);
                    this.exportHtmlMenuItemFormatted.setVisible(true);
                }
            }
            this.openInExternalApplicationMenuItem.setVisible(true);
            this.overrideTypeCheckerDecision.setVisible(!this.leadSelectedTreeNode.isMetaDataNode() && this.leadSelectedTreeNode.mpiMimeType == null);
        }
    }

    private void configureMenuSeparators() {
        boolean lastWasSeparator = true;
        Component lastVisibleComponent = null;
        for (Component currentComponent : this.getComponents()) {
            if (currentComponent instanceof JSeparator) {
                currentComponent.setVisible(!lastWasSeparator);
                lastWasSeparator = true;
            } else if (currentComponent.isVisible()) {
                lastWasSeparator = false;
            }
            if (!currentComponent.isVisible()) continue;
            lastVisibleComponent = currentComponent;
        }
        if (lastVisibleComponent != null && lastVisibleComponent instanceof JSeparator) {
            lastVisibleComponent.setVisible(false);
        }
    }

    private void openFileInExternalApplication(ArbilDataNode[] selectedNodes) {
        for (ArbilDataNode currentNode : selectedNodes) {
            URI targetUri = null;
            targetUri = currentNode.hasResource() ? currentNode.getFullResourceURI() : currentNode.getURI();
            GuiHelper.getSingleInstance().openFileInExternalApplication(targetUri);
        }
    }

    protected void setCommonInvisible() {
        this.viewXmlMenuItem.setVisible(false);
        this.viewXmlMenuItemFormatted.setVisible(false);
        this.openXmlMenuItemFormatted.setVisible(false);
        this.exportHtmlMenuItemFormatted.setVisible(false);
        this.overrideTypeCheckerDecision.setVisible(false);
        this.openInExternalApplicationMenuItem.setVisible(false);
        this.browseForResourceFileMenuItem.setVisible(false);
        this.saveMenuItem.setVisible(false);
    }

    protected void prepareItemCategories() {
        this.addItemCategory(CATEGORY_NODE);
        this.addItemCategory(CATEGORY_EDIT);
        this.addItemCategory(CATEGORY_REMOTE_CORPUS);
        this.addItemCategory(CATEGORY_WORKING_DIR);
        this.addItemCategory(CATEGORY_TABLE_CELL);
        this.addItemCategory(CATEGORY_TABLE_ROW);
        this.addItemCategory(CATEGORY_ADD_FAVOURITES);
        this.addItemCategory(CATEGORY_DISK);
        this.addItemCategory(CATEGORY_IMPORT);
        this.addItemCategory(CATEGORY_XML);
    }

    protected final void addItemCategory(String category) {
        if (!this.itemsMap.containsKey(category)) {
            this.itemsMap.put(category, new ArrayList());
        }
    }

    protected final void addItem(String category, int priority, JMenuItem item) {
        this.addItemCategory(category);
        this.itemsMap.get(category).add(new OrderedMenuItem(priority, item));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderedMenuItem
    implements Comparable<OrderedMenuItem> {
        private final JMenuItem menuItem;
        private final Integer itemPriority;

        private OrderedMenuItem(int priority, JMenuItem item) {
            this.menuItem = item;
            this.itemPriority = priority;
        }

        public int hashCode() {
            return this.itemPriority.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof OrderedMenuItem) {
                return this.itemPriority.equals(((OrderedMenuItem)o).itemPriority);
            }
            return false;
        }

        @Override
        public int compareTo(OrderedMenuItem o) {
            return this.itemPriority.compareTo(o.itemPriority);
        }
    }
}

