/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinTree
extends ArbilTree {
    GraphPanel graphPanel;

    public KinTree(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    protected void putSelectionIntoPreviewTable() {
        ArbilNode[] arbilNodeArray = this.getAllSelectedNodes();
        ArrayList<UniqueIdentifier> identifierList = new ArrayList<UniqueIdentifier>();
        this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
        for (ArbilNode arbilNode : arbilNodeArray) {
            if (arbilNode instanceof ArbilDataNode) {
                this.graphPanel.metadataPanel.addSingleArbilDataNode((ArbilDataNode)arbilNode);
                continue;
            }
            if (!(arbilNode instanceof KinTreeNode)) continue;
            KinTreeNode kinTreeNode = (KinTreeNode)arbilNode;
            if (kinTreeNode.entityData == null) continue;
            identifierList.add(kinTreeNode.entityData.getUniqueIdentifier());
            try {
                ArbilDataNode arbilDataNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, new URI(((KinTreeNode)arbilNode).entityData.getEntityPath()));
                this.graphPanel.metadataPanel.addSingleArbilDataNode(arbilDataNode);
            }
            catch (URISyntaxException urise) {
                GuiHelper.linorgBugCatcher.logError((Exception)urise);
            }
        }
        this.graphPanel.setSelectedIds(identifierList.toArray(new UniqueIdentifier[0]));
        this.graphPanel.metadataPanel.updateEditorPane();
    }
}

