/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.io.in.BufferInput;
import org.basex.io.out.PrintOutput;
import org.basex.server.ClientQuery;
import org.basex.server.EventNotifier;
import org.basex.server.LoginException;
import org.basex.server.ServerCmd;
import org.basex.server.Session;
import org.basex.util.Token;

public final class ClientSession
extends Session {
    final Map<String, EventNotifier> notifiers = Collections.synchronizedMap(new HashMap());
    final PrintOutput sout;
    final InputStream sin;
    private final Socket socket;
    private final String ehost;
    private Socket esocket;

    public ClientSession(Context context, String user, String pw) throws IOException {
        this(context, user, pw, null);
    }

    public ClientSession(Context context, String user, String pw, OutputStream output) throws IOException {
        this(context.mprop.get(MainProp.HOST), context.mprop.num(MainProp.PORT), user, pw, output);
    }

    public ClientSession(String host, int port, String user, String pw) throws IOException {
        this(host, port, user, pw, null);
    }

    public ClientSession(String host, int port, String user, String pw, OutputStream output) throws IOException {
        super(output);
        this.ehost = host;
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.sin = this.socket.getInputStream();
        BufferInput bi = new BufferInput(this.sin);
        String ts = bi.readString();
        this.sout = PrintOutput.get(this.socket.getOutputStream());
        this.send(user);
        this.send(Token.md5(String.valueOf(Token.md5(pw)) + ts));
        this.sout.flush();
        if (!this.ok(bi)) {
            throw new LoginException();
        }
    }

    @Override
    public void create(String name, InputStream input) throws BaseXException {
        try {
            this.sout.write(ServerCmd.CREATE.code);
            this.send(name);
            this.send(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BaseXException(ex);
        }
    }

    @Override
    public void add(String name, String target, InputStream input) throws BaseXException {
        try {
            this.sout.write(ServerCmd.ADD.code);
            this.send(name);
            this.send(target);
            this.send(input);
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    public void replace(String path, InputStream input) throws BaseXException {
        try {
            this.sout.write(ServerCmd.REPLACE.code);
            this.send(path);
            this.send(input);
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    public void watch(String name, EventNotifier notifier) throws BaseXException {
        try {
            this.sout.write(ServerCmd.WATCH.code);
            this.send(name);
            BufferInput bi = new BufferInput(this.sin);
            if (this.esocket == null) {
                int eport = Integer.parseInt(bi.readString());
                this.esocket = new Socket();
                this.esocket.connect(new InetSocketAddress(this.ehost, eport), 5000);
                PrintOutput po = PrintOutput.get(this.esocket.getOutputStream());
                po.print(bi.readString());
                po.write(0);
                po.flush();
                this.listen(this.esocket.getInputStream());
            }
            this.info = bi.readString();
            if (!this.ok(bi)) {
                throw new IOException(this.info);
            }
            this.notifiers.put(name, notifier);
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    private void listen(final InputStream in) {
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        BufferInput bi = new BufferInput(in);
                        ClientSession.this.notifiers.get(bi.readString()).notify(bi.readString());
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }.start();
    }

    public void unwatch(String name) throws BaseXException {
        try {
            this.sout.write(ServerCmd.UNWATCH.code);
            this.send(name);
            BufferInput bi = new BufferInput(this.sin);
            this.info = bi.readString();
            if (!this.ok(bi)) {
                throw new IOException(this.info);
            }
            this.notifiers.remove(name);
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    private void send(InputStream input) throws IOException {
        int b;
        while ((b = input.read()) != -1) {
            this.sout.write(b);
        }
        this.sout.write(0);
        this.sout.flush();
        BufferInput bi = new BufferInput(this.sin);
        this.info = bi.readString();
        if (!this.ok(bi)) {
            throw new IOException(this.info);
        }
    }

    @Override
    public ClientQuery query(String query) throws BaseXException {
        return new ClientQuery(query, this);
    }

    @Override
    public void close() throws IOException {
        this.send(Commands.Cmd.EXIT.toString());
        if (this.esocket != null) {
            this.esocket.close();
        }
        this.socket.close();
    }

    void send(String s) throws IOException {
        this.sout.print(s);
        this.sout.write(0);
        this.sout.flush();
    }

    boolean ok(BufferInput bi) throws IOException {
        return bi.read() == 0;
    }

    @Override
    protected void execute(String cmd, OutputStream os) throws BaseXException {
        try {
            int b;
            this.send(cmd);
            BufferInput bi = new BufferInput(this.sin);
            while ((b = bi.read()) != 0) {
                os.write(b);
            }
            this.info = bi.readString();
            if (!this.ok(bi)) {
                throw new BaseXException(this.info, new Object[0]);
            }
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    protected void execute(Command cmd, OutputStream os) throws BaseXException {
        this.execute(cmd.toString(), os);
    }
}

