/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.QNm;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class FNIndex
extends TokenSet {
    private static final FNIndex INSTANCE = new FNIndex();
    private Function[] funcs = new Function[8];

    public static FNIndex get() {
        return INSTANCE;
    }

    private FNIndex() {
        Function[] functionArray = Function.values();
        int n = functionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Function def = functionArray[n2];
            String dsc = def.desc;
            byte[] ln = Token.token(dsc.substring(0, dsc.indexOf("(")));
            int i = this.add(this.full(def.uri(), ln));
            if (i < 0) {
                Util.notexpected("Function defined twice:" + (Object)((Object)def));
            }
            this.funcs[i] = def;
            ++n2;
        }
    }

    public FuncCall get(byte[] name, byte[] uri, Expr[] args, QueryParser qp) throws QueryException {
        int id = this.id(this.full(uri, name));
        if (id == 0) {
            return null;
        }
        Function fl = this.funcs[id];
        if (!Token.eq(fl.uri(), uri)) {
            return null;
        }
        FuncCall f = fl.get(qp.input(), args);
        if (!qp.ctx.xquery3 && f.uses(Expr.Use.X30)) {
            qp.error(Err.FEATURE11, new Object[0]);
        }
        if (args.length < fl.min || args.length > fl.max) {
            qp.error(Err.XPARGS, new Object[]{fl});
        }
        return f;
    }

    public void error(QNm name, QueryParser qp) throws QueryException {
        byte[] ln = name.ln();
        Levenshtein ls = new Levenshtein();
        int k = 1;
        while (k < this.size) {
            int i = Token.indexOf(this.keys[k], 125);
            byte[] u = Token.substring(this.keys[k], 1, i);
            byte[] l = Token.substring(this.keys[k], i + 1);
            if (Token.eq(ln, l)) {
                byte[] ur = name.uri().atom();
                qp.error(Err.FUNSIMILAR, new TokenBuilder(NSGlobal.prefix(ur)).add(58).add(l), new TokenBuilder(NSGlobal.prefix(u)).add(58).add(l));
            } else if (ls.similar(ln, l, 0)) {
                qp.error(Err.FUNSIMILAR, name.atom(), l);
            }
            ++k;
        }
    }

    private byte[] full(byte[] uri, byte[] ln) {
        return new TokenBuilder().add(123).add(uri).add(125).add(ln).finish();
    }

    @Override
    protected void rehash() {
        super.rehash();
        this.funcs = Arrays.copyOf(this.funcs, this.size << 1);
    }
}

