/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import nl.mpi.arbil.data.ArbilVocabularyFilter;
import nl.mpi.arbil.data.ArbilVocabularyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilVocabulary
implements Serializable {
    private Vector<ArbilVocabularyItem> vocabularyItems = new Vector();
    private String vocabularyUrl = null;
    private transient ArbilVocabularyFilter filter = null;

    public ArbilVocabulary(String locationUrl) {
        this.vocabularyUrl = locationUrl;
    }

    public void addEntry(String entryString, String entryCode) {
        boolean itemExistsInVocab = false;
        for (ArbilVocabularyItem currentVocabularyItem : this.vocabularyItems.toArray(new ArbilVocabularyItem[0])) {
            if (!currentVocabularyItem.itemDisplayName.equals(entryString)) continue;
            itemExistsInVocab = true;
        }
        if (!itemExistsInVocab) {
            this.vocabularyItems.add(new ArbilVocabularyItem(entryString, entryCode, null));
        }
    }

    public ArbilVocabularyItem findVocabularyItem(String itemDisplayName) {
        if (itemDisplayName != null) {
            for (ArbilVocabularyItem currentVocabularyItem : this.vocabularyItems.toArray(new ArbilVocabularyItem[0])) {
                if (!itemDisplayName.equals(currentVocabularyItem.itemDisplayName)) continue;
                return currentVocabularyItem;
            }
        }
        return null;
    }

    public ArbilVocabularyItem getVocabularyItemByCode(String itemCode) {
        if (itemCode != null) {
            for (ArbilVocabularyItem currentVocabularyItem : this.vocabularyItems.toArray(new ArbilVocabularyItem[0])) {
                if (!itemCode.equals(currentVocabularyItem.itemCode)) continue;
                return currentVocabularyItem;
            }
        }
        return null;
    }

    public String resolveFollowUpUrl(String folowUpString) {
        String vocabUrlDirectory = this.vocabularyUrl.substring(0, this.vocabularyUrl.lastIndexOf("/") + 1);
        System.out.println("vocabUrlDirectory: " + vocabUrlDirectory);
        return vocabUrlDirectory + folowUpString;
    }

    public List<ArbilVocabularyItem> getVocabularyItems() {
        if (this.filter == null) {
            return this.vocabularyItems;
        }
        return this.filter.filterVocabularyItems(this.vocabularyItems);
    }

    public List<ArbilVocabularyItem> getVocabularyItemsUnfiltered() {
        return this.vocabularyItems;
    }

    public String getVocabularyUrl() {
        return this.vocabularyUrl;
    }

    public void setFilter(ArbilVocabularyFilter filter) {
        this.filter = filter;
    }
}

