/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ArbilFieldView
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3L;
    private Vector hiddenColumns = new Vector();
    private Vector showOnlyColumns = new Vector();
    private Vector knownColumns = new Vector();
    private Vector alwaysShowColumns = new Vector();
    private HashMap<String, Integer> columnWidths = new HashMap();

    public void showState() {
        System.out.println("knownColumns: " + this.knownColumns);
        System.out.println("hiddenColumns: " + this.hiddenColumns);
        System.out.println("showOnlyColumns: " + this.showOnlyColumns);
        System.out.println("alwaysShowColumns: " + this.alwaysShowColumns);
        System.out.println("columnWidths: " + this.columnWidths);
    }

    public void setAlwaysShowColumns(Vector alwaysShowColumns) {
        this.alwaysShowColumns = alwaysShowColumns;
    }

    public Enumeration getAlwaysShowColumns() {
        return this.alwaysShowColumns.elements();
    }

    public void setHiddenColumns(Vector hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    private void setKnownColumns(Vector knownColumns) {
        this.knownColumns = knownColumns;
    }

    public void setShowOnlyColumns(Vector showOnlyColumns) {
        this.showOnlyColumns = showOnlyColumns;
    }

    public ArbilFieldView clone() {
        ArbilFieldView returnFieldView = new ArbilFieldView();
        returnFieldView.setAlwaysShowColumns((Vector)this.alwaysShowColumns.clone());
        returnFieldView.setHiddenColumns((Vector)this.hiddenColumns.clone());
        returnFieldView.setKnownColumns((Vector)this.knownColumns.clone());
        returnFieldView.setShowOnlyColumns((Vector)this.showOnlyColumns.clone());
        returnFieldView.columnWidths = (HashMap)this.columnWidths.clone();
        return returnFieldView;
    }

    public void addKnownColumn(String columnName) {
        if (!this.knownColumns.contains(columnName)) {
            this.knownColumns.add(columnName);
        }
    }

    public void setShowOnlyColumns(String[] columnsToShow) {
        this.showOnlyColumns.clear();
        for (int columnCounter = 0; columnCounter < columnsToShow.length; ++columnCounter) {
            this.showOnlyColumns.add(columnsToShow[columnCounter]);
        }
    }

    public void addAlwaysShowColumn(String columnName) {
        System.out.println("addAlwaysShowColumn");
        this.alwaysShowColumns.add(columnName);
        this.showState();
    }

    public void removeAlwaysShowColumn(String columnName) {
        System.out.println("removeAlwaysShowColumn");
        this.alwaysShowColumns.remove(columnName);
        this.showState();
    }

    public void addShowOnlyColumn(String columnName) {
        System.out.println("addShowOnlyColumn");
        this.showOnlyColumns.add(columnName);
        this.showState();
    }

    public void removeShowOnlyColumn(String columnName) {
        System.out.println("removeShowOnlyColumn");
        this.showOnlyColumns.remove(columnName);
        this.showState();
    }

    public void addHiddenColumn(String columnName) {
        System.out.println("addHiddenColumn");
        this.hiddenColumns.add(columnName);
        this.showOnlyColumns.remove(columnName);
        this.showState();
    }

    public void removeHiddenColumn(String columnName) {
        System.out.println("removeHiddenColumn");
        this.hiddenColumns.remove(columnName);
        this.showState();
    }

    public boolean viewShowsColumn(String currentColumnString) {
        boolean showColumn = true;
        if (this.showOnlyColumns.size() > 0) {
            showColumn = this.showOnlyColumns.contains(currentColumnString);
        } else {
            boolean bl = showColumn = !this.hiddenColumns.contains(currentColumnString);
        }
        if (!showColumn) {
            showColumn = this.alwaysShowColumns.contains(currentColumnString);
        }
        return showColumn;
    }

    public Enumeration getKnownColumns() {
        Collections.sort(this.knownColumns);
        return this.knownColumns.elements();
    }

    public boolean isShowOnlyColumn(String columnString) {
        return this.showOnlyColumns.contains(columnString);
    }

    public boolean isHiddenColumn(String columnString) {
        return this.hiddenColumns.contains(columnString);
    }

    public boolean isAlwaysShowColumn(String columnString) {
        return this.alwaysShowColumns.contains(columnString);
    }

    public void setColumnWidth(String columnString, Integer width) {
        if (width != null) {
            this.columnWidths.put(columnString, width);
        } else if (this.hasColumnWidthForColumn(columnString)) {
            this.columnWidths.remove(columnString);
        }
    }

    public boolean hasColumnWidthForColumn(String columnString) {
        return this.columnWidths.containsKey(columnString);
    }

    public Integer getColumnWidth(String columnString) {
        if (this.columnWidths.containsKey(columnString)) {
            return this.columnWidths.get(columnString);
        }
        return null;
    }

    public void resetColumnWidths() {
        this.columnWidths.clear();
    }

    public void storeColumnWidths(TableColumnModel columnModel) {
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            if (!(column.getHeaderValue() instanceof String)) continue;
            this.setColumnWidth((String)column.getHeaderValue(), column.getWidth());
        }
    }
}

