/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.importexport.ArbilCsvImporter;
import nl.mpi.arbil.templates.ArbilFavourites;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.ArbilContextMenu;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.XsdChecker;

public class TreeContextMenu
extends ArbilContextMenu {
    private ArbilTree tree;
    private JMenu addFromFavouritesMenu = new JMenu();
    private JMenuItem addLocalDirectoryMenuItem = new JMenuItem();
    private JCheckBoxMenuItem showHiddenFilesMenuItem = new JCheckBoxMenuItem();
    private JMenuItem addDefaultLocationsMenuItem = new JMenuItem();
    private JMenu addMenu = new JMenu();
    private JMenuItem addRemoteCorpusMenuItem = new JMenuItem();
    private JMenuItem addToFavouritesMenuItem = new JMenuItem();
    private JMenuItem removeFromFavouritesMenuItem = new JMenuItem();
    private JMenuItem copyBranchMenuItem = new JMenuItem();
    private JMenuItem searchRemoteBranchMenuItem = new JMenuItem();
    private JMenuItem copyNodeUrlMenuItem = new JMenuItem();
    private JMenuItem deleteMenuItem = new JMenuItem();
    private JMenuItem exportMenuItem = new JMenuItem();
    private JMenuItem importCsvMenuItem = new JMenuItem();
    private JMenuItem importBranchMenuItem = new JMenuItem();
    private JMenuItem reImportBranchMenuItem = new JMenuItem();
    private JMenuItem pasteMenuItem1 = new JMenuItem();
    private JMenuItem reloadSubnodesMenuItem = new JMenuItem();
    private JMenuItem removeCachedCopyMenuItem = new JMenuItem();
    private JMenuItem removeLocalDirectoryMenuItem = new JMenuItem();
    private JMenuItem removeRemoteCorpusMenuItem = new JMenuItem();
    private JMenuItem searchSubnodesMenuItem = new JMenuItem();
    private JMenuItem sendToServerMenuItem = new JMenuItem();
    private JMenuItem validateMenuItem = new JMenuItem();
    private JMenu historyMenu = new JMenu();
    private JMenuItem viewChangesMenuItem = new JMenuItem();
    private JMenuItem viewSelectedNodesMenuItem = new JMenuItem();
    private JMenuItem viewSelectedSubnodesMenuItem = new JMenuItem();
    private JMenuItem editInLongFieldEditor = new JMenuItem();

    public TreeContextMenu(ArbilTree tree) {
        this.tree = tree;
        this.setInvoker(tree);
        this.selectedTreeNodes = tree.getSelectedNodes();
        this.leadSelectedTreeNode = tree.getLeadSelectionDataNode();
    }

    protected void setUpMenu() {
        this.setUpItems();
        this.setUpActions();
    }

    private void setUpItems() {
        int nodeLevel = -1;
        int selectionCount = 0;
        boolean showRemoveLocationsTasks = false;
        boolean showAddLocationsTasks = false;
        selectionCount = this.tree.getSelectionCount();
        if (selectionCount > 0) {
            nodeLevel = this.tree.getSelectionPath().getPathCount();
        }
        showRemoveLocationsTasks = selectionCount == 1 && nodeLevel == 2 || selectionCount > 1;
        showAddLocationsTasks = selectionCount == 1 && nodeLevel == 1;
        this.viewSelectedNodesMenuItem.setText("View Selected");
        this.viewSelectedSubnodesMenuItem.setText(this.leadSelectedTreeNode != null && this.leadSelectedTreeNode.isEditable() ? "Edit all Metadata" : "View all Metadata");
        this.editInLongFieldEditor.setText(this.leadSelectedTreeNode != null && this.leadSelectedTreeNode.getParentDomNode().isEditable() ? "Edit in Long Field Editor" : "View in Long Field Editor");
        this.deleteMenuItem.setEnabled(true);
        if (ArbilTreeHelper.getSingleInstance().getArbilTreePanel() != null) {
            if (this.tree == ArbilTreeHelper.getSingleInstance().getArbilTreePanel().remoteCorpusTree) {
                this.removeRemoteCorpusMenuItem.setVisible(showRemoveLocationsTasks);
                this.addRemoteCorpusMenuItem.setVisible(showAddLocationsTasks);
                this.copyBranchMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
                this.searchRemoteBranchMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
                this.addDefaultLocationsMenuItem.setVisible(showAddLocationsTasks);
            }
            if (this.tree == ArbilTreeHelper.getSingleInstance().getArbilTreePanel().localCorpusTree) {
                this.viewSelectedNodesMenuItem.setText("View/Edit Selected");
                this.pasteMenuItem1.setVisible(selectionCount > 0 && nodeLevel > 1);
                this.searchSubnodesMenuItem.setVisible(selectionCount > 0);
                this.addMenu.setVisible(selectionCount == 1);
                this.deleteMenuItem.setVisible(nodeLevel > 1);
                boolean nodeIsChild = false;
                if (this.leadSelectedTreeNode != null) {
                    nodeIsChild = this.leadSelectedTreeNode.isChildNode();
                    this.validateMenuItem.setVisible(!nodeIsChild);
                    this.historyMenu.setVisible(this.leadSelectedTreeNode.hasHistory());
                    this.exportMenuItem.setVisible(!nodeIsChild);
                    this.importCsvMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus());
                    this.importBranchMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus());
                    this.reImportBranchMenuItem.setVisible(this.leadSelectedTreeNode.archiveHandle != null && !this.leadSelectedTreeNode.isChildNode());
                    this.addFromFavouritesMenu.setVisible(true);
                }
            }
            if (this.tree == ArbilTreeHelper.getSingleInstance().getArbilTreePanel().localDirectoryTree) {
                this.removeLocalDirectoryMenuItem.setVisible(showRemoveLocationsTasks);
                if (showAddLocationsTasks) {
                    this.showHiddenFilesMenuItem.setState(ArbilTreeHelper.getSingleInstance().isShowHiddenFilesInTree());
                    this.showHiddenFilesMenuItem.setVisible(true);
                }
                this.addLocalDirectoryMenuItem.setVisible(showAddLocationsTasks);
                if (this.leadSelectedTreeNode != null) {
                    this.copyBranchMenuItem.setVisible(this.leadSelectedTreeNode.isCorpus() || this.leadSelectedTreeNode.isSession());
                }
            }
        }
        if (this.leadSelectedTreeNode != null) {
            if (this.leadSelectedTreeNode.isFavorite()) {
                boolean isFavouriteTopLevel = ArbilTreeHelper.getSingleInstance().isInFavouritesNodes(this.leadSelectedTreeNode);
                this.addToFavouritesMenuItem.setVisible(false);
                this.removeFromFavouritesMenuItem.setVisible(isFavouriteTopLevel);
                this.removeFromFavouritesMenuItem.setEnabled(isFavouriteTopLevel);
                this.addMenu.setVisible(this.selectedTreeNodes.length == 1);
                this.viewSelectedNodesMenuItem.setText("View/Edit Selected");
                this.deleteMenuItem.setVisible(!isFavouriteTopLevel && this.selectedTreeNodes.length == 1);
                this.deleteMenuItem.setEnabled(!isFavouriteTopLevel && this.selectedTreeNodes.length == 1);
            } else {
                this.removeFromFavouritesMenuItem.setVisible(false);
                this.addToFavouritesMenuItem.setVisible(this.leadSelectedTreeNode.isMetaDataNode());
                this.addToFavouritesMenuItem.setEnabled(!this.leadSelectedTreeNode.isCorpus() && this.leadSelectedTreeNode.isMetaDataNode());
            }
        } else {
            this.addToFavouritesMenuItem.setVisible(false);
        }
        ArbilDataNode[] selectedNodes = this.tree.getSelectedNodes();
        this.copyNodeUrlMenuItem.setVisible(selectionCount == 1 && nodeLevel > 1 || selectionCount > 1);
        this.viewSelectedNodesMenuItem.setVisible(selectionCount >= 1 && nodeLevel > 1);
        this.reloadSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1);
        this.viewSelectedSubnodesMenuItem.setVisible(selectionCount > 0 && nodeLevel > 1 && selectedNodes[0].isMetaDataNode() && !this.tree.getSelectedNodes()[0].isCorpus());
        this.editInLongFieldEditor.setVisible(selectionCount > 0 && nodeLevel > 1 && !selectedNodes[0].isEmptyMetaNode());
    }

    private void setUpActions() {
        this.viewSelectedNodesMenuItem.setText("View Selected");
        this.viewSelectedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeContextMenu.this.viewSelectedNodes();
            }
        });
        this.addItem("node", 0, this.viewSelectedNodesMenuItem);
        this.editInLongFieldEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.startLongFieldEditor();
            }
        });
        this.addItem("node", 1, this.editInLongFieldEditor);
        this.viewSelectedSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeContextMenu.this.viewSelectedSubnodes();
            }
        });
        this.addItem("node", 2, this.viewSelectedSubnodesMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilTreeHelper.getSingleInstance().deleteNodes(TreeContextMenu.this.getInvoker());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 10, this.deleteMenuItem);
        this.copyNodeUrlMenuItem.setText("Copy");
        this.copyNodeUrlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TreeContextMenu.this.selectedTreeNodes == null) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No node selected", "Copy");
                    } else {
                        ArbilTree sourceTree = (ArbilTree)TreeContextMenu.this.getInvoker();
                        sourceTree.copyNodeUrlToClipboard(TreeContextMenu.this.selectedTreeNodes);
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 15, this.copyNodeUrlMenuItem);
        this.pasteMenuItem1.setText("Paste");
        this.pasteMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : TreeContextMenu.this.selectedTreeNodes) {
                        currentNode.pasteIntoNode();
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 20, this.pasteMenuItem1);
        this.searchRemoteBranchMenuItem.setText("Search Remote Corpus");
        this.searchRemoteBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.searchRemoteSubnodesMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("node", 50, this.searchRemoteBranchMenuItem);
        this.copyBranchMenuItem.setText("Import to Local Corpus");
        this.copyBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.copyBranchMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 50, this.copyBranchMenuItem);
        this.searchSubnodesMenuItem.setText("Search");
        this.searchSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.searchSubnodesMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("node", 50, this.searchSubnodesMenuItem);
        this.reloadSubnodesMenuItem.setText("Reload");
        this.reloadSubnodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : TreeContextMenu.this.selectedTreeNodes) {
                        currentNode.reloadNode();
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("node", 55, this.reloadSubnodesMenuItem);
        this.addMenu.setText("Add");
        this.addMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    TreeContextMenu.this.initAddMenu(TreeContextMenu.this.addMenu, TreeContextMenu.this.leadSelectedTreeNode);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 0, this.addMenu);
        this.addFromFavouritesMenu.setText("Add From Favourites");
        this.addFromFavouritesMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                TreeContextMenu.this.initAddFromFavouritesMenu();
            }
        });
        this.addItem("add+favourites", 50, this.addFromFavouritesMenu);
        if (this.leadSelectedTreeNode != null && this.leadSelectedTreeNode.isEmptyMetaNode()) {
            this.addToFavouritesMenuItem.setText("Add Children To Favourites List");
        } else {
            this.addToFavouritesMenuItem.setText("Add To Favourites List");
        }
        this.addToFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilFavourites.getSingleInstance().toggleFavouritesList(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes(), true);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 55, this.addToFavouritesMenuItem);
        this.removeFromFavouritesMenuItem.setText("Remove from Favourites List");
        this.removeFromFavouritesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilFavourites.getSingleInstance().toggleFavouritesList(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes(), false);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("add+favourites", 55, this.removeFromFavouritesMenuItem);
        this.validateMenuItem.setText("Check XML Conformance");
        this.validateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.validateMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("xml", 50, this.validateMenuItem);
        this.historyMenu.setText("History");
        this.historyMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                try {
                    TreeContextMenu.this.initHistoryMenu();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 100, this.historyMenu);
        this.addRemoteCorpusMenuItem.setText("Add Remote Location");
        this.addRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.addRemoteCorpusMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 50, this.addRemoteCorpusMenuItem);
        this.addDefaultLocationsMenuItem.setText("Add Default Remote Locations");
        this.addDefaultLocationsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.addDefaultLocationsMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 55, this.addDefaultLocationsMenuItem);
        this.removeRemoteCorpusMenuItem.setText("Remove Remote Location");
        this.removeRemoteCorpusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : TreeContextMenu.this.selectedTreeNodes) {
                        ArbilTreeHelper.getSingleInstance().removeLocation(selectedNode);
                    }
                    ArbilTreeHelper.getSingleInstance().applyRootLocations();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 60, this.removeRemoteCorpusMenuItem);
        this.removeCachedCopyMenuItem.setText("Remove Cache Link");
        this.removeCachedCopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.removeCachedCopyMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("disk", 105, this.removeCachedCopyMenuItem);
        this.addLocalDirectoryMenuItem.setText("Add Working Directory");
        this.addLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TreeContextMenu.this.addLocalDirectoryMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("working dir", 0, this.addLocalDirectoryMenuItem);
        this.showHiddenFilesMenuItem.setText("Show Hidden Files");
        this.showHiddenFilesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilTreeHelper.getSingleInstance().setShowHiddenFilesInTree(TreeContextMenu.this.showHiddenFilesMenuItem.getState());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("working dir", 50, this.showHiddenFilesMenuItem);
        this.removeLocalDirectoryMenuItem.setText("Remove Link to Directory");
        this.removeLocalDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : TreeContextMenu.this.selectedTreeNodes) {
                        ArbilTreeHelper.getSingleInstance().removeLocation(selectedNode);
                    }
                    ArbilTreeHelper.getSingleInstance().applyRootLocations();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("remote corpus", 100, this.removeLocalDirectoryMenuItem);
        this.exportMenuItem.setText("Export");
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().remoteCorpusTree);
                    importExportDialog.selectExportDirectoryAndExport(((ArbilTree)TreeContextMenu.this.getInvoker()).getSelectedNodes());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("disk", 5, this.exportMenuItem);
        this.importCsvMenuItem.setText("Import CSV");
        this.importCsvMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilCsvImporter csvImporter = new ArbilCsvImporter(TreeContextMenu.this.leadSelectedTreeNode);
                    csvImporter.doImport();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("import", 0, this.importCsvMenuItem);
        this.importBranchMenuItem.setText("Import Branch");
        this.importBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImportExportDialog importExportDialog = new ImportExportDialog(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().localCorpusTree);
                    importExportDialog.setDestinationNode(TreeContextMenu.this.leadSelectedTreeNode);
                    importExportDialog.importArbilBranch();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("import", 5, this.importBranchMenuItem);
        this.reImportBranchMenuItem.setText("Re-Import this Branch");
        this.reImportBranchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeContextMenu.this.reImportBranch();
            }
        });
        this.addItem("import", 50, this.reImportBranchMenuItem);
    }

    private void copyBranchMenuItemActionPerformed(ActionEvent evt) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(this.tree);
            importExportDialog.copyToCache(this.tree.getSelectedNodes());
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private void addLocalDirectoryMenuItemActionPerformed(ActionEvent evt) {
        File[] selectedFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Add Working Directory", true, true, false);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentDirectory : selectedFiles) {
                ArbilTreeHelper.getSingleInstance().addLocationGui(currentDirectory.toURI());
            }
        }
    }

    private void addRemoteCorpusMenuItemActionPerformed(ActionEvent evt) {
        String addableLocation = JOptionPane.showInputDialog(ArbilWindowManager.getSingleInstance().linorgFrame, "Enter the URL", "Add Location", -1);
        if (addableLocation != null && addableLocation.length() > 0) {
            ArbilTreeHelper.getSingleInstance().addLocationGui(ArbilDataNode.conformStringToUrl(addableLocation));
        }
    }

    private void addDefaultLocationsMenuItemActionPerformed(ActionEvent evt) {
        if (0 < ArbilTreeHelper.getSingleInstance().addDefaultCorpusLocations()) {
            ArbilTreeHelper.getSingleInstance().applyRootLocations();
        } else {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("The default locations already exists and will not be added again", "Add Default Locations");
        }
    }

    private void removeCachedCopyMenuItemActionPerformed(ActionEvent evt) {
        Object selectedTreeNode = null;
    }

    private void searchSubnodesMenuItemActionPerformed(ActionEvent evt) {
        ArbilWindowManager.getSingleInstance().openSearchTable(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().localCorpusTree.getAllSelectedNodes(), "Search");
    }

    private void searchRemoteSubnodesMenuItemActionPerformed(ActionEvent evt) {
        ArbilWindowManager.getSingleInstance().openSearchTable(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().remoteCorpusTree.getSelectedNodes(), "Search Remote Corpus");
    }

    private void sendToServerMenuItemActionPerformed(ActionEvent evt) {
    }

    private void validateMenuItemActionPerformed(ActionEvent evt) {
        for (ArbilDataNode currentNode : this.selectedTreeNodes) {
            XsdChecker xsdChecker = new XsdChecker();
            ArbilWindowManager.getSingleInstance().createWindow("XsdChecker", xsdChecker);
            xsdChecker.checkXML(currentNode);
            xsdChecker.setDividerLocation(0.5);
        }
    }

    public void initAddMenu(JMenu addMenu, Object targetNodeUserObject) {
        addMenu.removeAll();
        if (!(targetNodeUserObject instanceof ArbilDataNode) || ((ArbilDataNode)targetNodeUserObject).isCorpus()) {
            for (ArbilTemplateManager.MenuItemData currentAddable : ArbilTemplateManager.getSingleInstance().getSelectedTemplatesMenuItems()) {
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(currentAddable.menuText);
                addMenuItem.setName(currentAddable.menuText);
                addMenuItem.setActionCommand(currentAddable.menuAction);
                addMenuItem.setToolTipText(currentAddable.menuToolTip);
                addMenuItem.setIcon(currentAddable.menuIcon);
                addMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            if (TreeContextMenu.this.leadSelectedTreeNode != null) {
                                new MetadataBuilder().requestAddNode(TreeContextMenu.this.leadSelectedTreeNode, evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            } else {
                                new MetadataBuilder().requestRootAddNode(evt.getActionCommand(), ((JMenuItem)evt.getSource()).getText());
                            }
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                addMenu.add(addMenuItem);
            }
        }
        if (targetNodeUserObject instanceof ArbilDataNode) {
            ArbilTemplate currentTemplate = ((ArbilDataNode)targetNodeUserObject).getNodeTemplate();
            MetadataBuilder mdBuilder = new MetadataBuilder();
            Enumeration menuItemName = currentTemplate.listTypesFor(targetNodeUserObject);
            while (menuItemName.hasMoreElements()) {
                String[] currentField = (String[])menuItemName.nextElement();
                final String nodeText = currentField[0];
                final String nodeType = currentField[1];
                JMenuItem addMenuItem = new JMenuItem();
                addMenuItem.setText(nodeText);
                addMenuItem.setName(nodeText);
                addMenuItem.setToolTipText(nodeType);
                if (null != currentTemplate.pathIsChildNode(nodeType)) {
                    addMenuItem.setIcon(ArbilIcons.getSingleInstance().dataIcon);
                } else {
                    addMenuItem.setIcon(ArbilIcons.getSingleInstance().fieldIcon);
                }
                if (mdBuilder.canAddChildNode((ArbilDataNode)targetNodeUserObject, nodeType)) {
                    addMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                if (TreeContextMenu.this.leadSelectedTreeNode != null) {
                                    if (!TreeContextMenu.this.leadSelectedTreeNode.getParentDomNode().hasChangedFieldsInSubtree() || ArbilWindowManager.getSingleInstance().showConfirmDialogBox("Adding a node will save pending changes to \"" + TreeContextMenu.this.leadSelectedTreeNode.getParentDomNode().toString() + "\" to disk. Do you want to proceed?", "Save pending changes?")) {
                                        new MetadataBuilder().requestAddNode(TreeContextMenu.this.leadSelectedTreeNode, nodeType, nodeText);
                                    }
                                } else {
                                    new MetadataBuilder().requestRootAddNode(nodeType, ((JMenuItem)evt.getSource()).getText());
                                }
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(ex);
                            }
                        }
                    });
                } else {
                    addMenuItem.setEnabled(false);
                }
                addMenu.add(addMenuItem);
            }
        }
    }

    public void initHistoryMenu() {
        this.historyMenu.removeAll();
        for (String[] currentHistory : this.leadSelectedTreeNode.getHistoryList()) {
            JMenuItem revertHistoryMenuItem = new JMenuItem();
            revertHistoryMenuItem.setText(currentHistory[0]);
            revertHistoryMenuItem.setName(currentHistory[0]);
            revertHistoryMenuItem.setActionCommand(currentHistory[1]);
            revertHistoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (!TreeContextMenu.this.leadSelectedTreeNode.resurrectHistory(evt.getActionCommand())) {
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Could not revert version, no changes made", "History");
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            this.historyMenu.add(revertHistoryMenuItem);
        }
    }

    public void initAddFromFavouritesMenu() {
        this.addFromFavouritesMenu.removeAll();
        Enumeration menuItemName = ArbilFavourites.getSingleInstance().listFavouritesFor(this.leadSelectedTreeNode);
        while (menuItemName.hasMoreElements()) {
            String[] currentField = (String[])menuItemName.nextElement();
            JMenuItem addFavouriteMenuItem = new JMenuItem();
            addFavouriteMenuItem.setText(currentField[0]);
            addFavouriteMenuItem.setName(currentField[0]);
            addFavouriteMenuItem.setActionCommand(currentField[1]);
            addFavouriteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        String favouriteUrlString = evt.getActionCommand();
                        ArbilDataNode templateDataNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNode(null, ArbilDataNode.conformStringToUrl(favouriteUrlString));
                        if (TreeContextMenu.this.leadSelectedTreeNode != null) {
                            new MetadataBuilder().requestAddNode(TreeContextMenu.this.leadSelectedTreeNode, ((JMenuItem)evt.getSource()).getText(), templateDataNode);
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            this.addFromFavouritesMenu.add(addFavouriteMenuItem);
        }
    }

    private void viewSelectedNodes() {
        try {
            ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>();
            for (ArbilDataNode currentItem : ((ArbilTree)this.getInvoker()).getSelectedNodes()) {
                if (currentItem.isMetaDataNode() || currentItem.getFields().size() > 0) {
                    filteredNodes.add(currentItem);
                    continue;
                }
                try {
                    ArbilWindowManager.getSingleInstance().openUrlWindowOnce(currentItem.toString(), currentItem.getURI().toURL());
                }
                catch (MalformedURLException murle) {
                    GuiHelper.linorgBugCatcher.logError(murle);
                }
            }
            if (filteredNodes.size() > 0) {
                ArbilWindowManager.getSingleInstance().openFloatingTableOnce(filteredNodes.toArray(new ArbilDataNode[0]), null);
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private void viewSelectedSubnodes() {
        ArbilDataNode[] selectedNodes = ((ArbilTree)this.getInvoker()).getSelectedNodes();
        ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>(selectedNodes.length);
        for (ArbilDataNode dataNode : selectedNodes) {
            if (!dataNode.isSession() && !dataNode.isMetaDataNode()) continue;
            filteredNodes.add(dataNode);
        }
        if (!filteredNodes.isEmpty()) {
            ArbilWindowManager.getSingleInstance().openFloatingSubnodesWindows(filteredNodes.toArray(new ArbilDataNode[0]));
        }
    }

    private void reImportBranch() {
        try {
            URI remoteDataFile = ArbilSessionStorage.getSingleInstance().getOriginatingUri(this.leadSelectedTreeNode.getURI());
            if (remoteDataFile != null) {
                ArbilDataNode originatingNode = ArbilDataNodeLoader.getSingleInstance().getArbilDataNodeWithoutLoading(remoteDataFile);
                if (originatingNode.isLocal() && !originatingNode.getFile().exists()) {
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("The origional file location cannot be found", "Re Import Branch");
                } else if (originatingNode.isMetaDataNode()) {
                    ImportExportDialog importExportDialog = new ImportExportDialog(ArbilTreeHelper.getSingleInstance().getArbilTreePanel().localCorpusTree);
                    importExportDialog.setDestinationNode(this.leadSelectedTreeNode);
                    importExportDialog.copyToCache(new ArbilDataNode[]{originatingNode});
                } else {
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Could not determine the origional node type", "Re Import Branch");
                }
            } else {
                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Could not determine the origional location", "Re Import Branch");
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private void startLongFieldEditor() {
        ArbilDataNode[] selectedNodes;
        for (ArbilDataNode node : selectedNodes = ((ArbilTree)this.getInvoker()).getSelectedNodes()) {
            if (node.getFields().size() <= 0) continue;
            List<ArbilField[]> fieldArrays = node.getFieldsSorted();
            new ArbilLongFieldEditor().showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
        }
    }

    protected void setAllInvisible() {
        this.removeCachedCopyMenuItem.setVisible(false);
        this.removeLocalDirectoryMenuItem.setVisible(false);
        this.addLocalDirectoryMenuItem.setVisible(false);
        this.showHiddenFilesMenuItem.setVisible(false);
        this.removeRemoteCorpusMenuItem.setVisible(false);
        this.addRemoteCorpusMenuItem.setVisible(false);
        this.copyBranchMenuItem.setVisible(false);
        this.searchRemoteBranchMenuItem.setVisible(false);
        this.copyNodeUrlMenuItem.setVisible(false);
        this.pasteMenuItem1.setVisible(false);
        this.searchSubnodesMenuItem.setVisible(false);
        this.reloadSubnodesMenuItem.setVisible(false);
        this.addDefaultLocationsMenuItem.setVisible(false);
        this.addMenu.setVisible(false);
        this.deleteMenuItem.setVisible(false);
        this.viewSelectedNodesMenuItem.setVisible(false);
        this.addFromFavouritesMenu.setVisible(false);
        this.validateMenuItem.setVisible(false);
        this.historyMenu.setVisible(false);
        this.exportMenuItem.setVisible(false);
        this.importCsvMenuItem.setVisible(false);
        this.importBranchMenuItem.setVisible(false);
        this.reImportBranchMenuItem.setVisible(false);
        this.addToFavouritesMenuItem.setVisible(false);
        this.removeFromFavouritesMenuItem.setVisible(false);
        this.viewSelectedSubnodesMenuItem.setVisible(false);
        this.editInLongFieldEditor.setVisible(false);
    }
}

