/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.util.BugCatcher;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMetadataReader {
    private static BugCatcher bugCatcher;

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public ArbilField[] getExifMetadata(ArbilDataNode resourceNode, int currentFieldId) {
        Vector<ArbilField> exifTagFields = new Vector<ArbilField>();
        System.out.println("tempGetExif: " + resourceNode.getFile());
        try {
            URI uri = resourceNode.getURI();
            if (resourceNode.getFile().getName().contains(".")) {
                String fileSuffix = resourceNode.getFile().getName().substring(resourceNode.getFile().getName().lastIndexOf(".") + 1);
                System.out.println("tempGetExifSuffix: " + fileSuffix);
                Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(fileSuffix);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    reader.setInput(ImageIO.createImageInputStream(uri.toURL().openStream()));
                    IIOMetadata metadata = reader.getImageMetadata(0);
                    if (metadata != null) {
                        String[] names = metadata.getMetadataFormatNames();
                        for (int i = 0; i < names.length; ++i) {
                            System.out.println();
                            System.out.println("METADATA FOR FORMAT: " + names[i]);
                            this.decendExifTree(resourceNode, metadata.getAsTree(names[i]), null, exifTagFields, currentFieldId);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
        System.out.println("end tempGetExif");
        return exifTagFields.toArray(new ArbilField[0]);
    }

    public void decendExifTree(ArbilDataNode resourceNode, Node node, String prefixString, Vector<ArbilField> exifTagFields, int currentFieldId) {
        prefixString = prefixString == null ? "EXIF" : prefixString + "." + node.getNodeName();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int attributeCounter = 0; attributeCounter < namedNodeMap.getLength(); ++attributeCounter) {
                String attributeName = namedNodeMap.item(attributeCounter).getNodeName();
                String attributeValue = namedNodeMap.item(attributeCounter).getNodeValue();
                exifTagFields.add(new ArbilField(currentFieldId++, resourceNode, prefixString + "." + attributeName, attributeValue, 0));
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int ub = children.getLength();
            for (int i = 0; i < ub; ++i) {
                this.decendExifTree(resourceNode, children.item(i), prefixString, exifTagFields, currentFieldId);
            }
        }
    }
}

