/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLCheck {
    static XMLCheck self = null;
    MyEntityResolver myER = new MyEntityResolver(false);
    MyEntityResolver myERany = new MyEntityResolver(true);
    static final int MAXSIZE = 0xA00000;
    static DocumentBuilder docBuilder = null;
    static DocumentBuilder valDocBuilder = null;
    static DocumentBuilder imdiDocBuilder = null;
    static DocumentBuilder eaf20DocBuilder = null;
    static DocumentBuilder eaf21DocBuilder = null;
    static DocumentBuilder eaf22DocBuilder = null;
    static DocumentBuilder eaf23DocBuilder = null;
    static DocumentBuilder eaf24DocBuilder = null;
    static DocumentBuilder eaf25DocBuilder = null;
    static DocumentBuilder eaf26DocBuilder = null;
    static DocumentBuilder eafAnyDocBuilder = null;
    static HashSet cgnNames = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLCheck() {
        if (self == null) {
            try {
                cgnNames = new HashSet();
                cgnNames.add("bpt");
                cgnNames.add("pri");
                cgnNames.add("prx");
                cgnNames.add("skp");
                cgnNames.add("tag");
                cgnNames.add("tig");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                docBuilder = factory.newDocumentBuilder();
                factory.setValidating(true);
                valDocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/IMDI_3.0.xsd").openStream());
                imdiDocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.0.xsd").openStream());
                eaf20DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.1.xsd").openStream());
                eaf21DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.2.xsd").openStream());
                eaf22DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.3.xsd").openStream());
                eaf23DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.4.xsd").openStream());
                eaf24DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.5.xsd").openStream());
                eaf25DocBuilder = factory.newDocumentBuilder();
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XMLCheck.class.getResource("resources/eaf-EAFv2.6.xsd").openStream());
                eaf26DocBuilder = factory.newDocumentBuilder();
                eafAnyDocBuilder = factory.newDocumentBuilder();
            }
            catch (IllegalArgumentException iae) {
                System.out.println("XML Parser Attribute set error: " + iae.getMessage());
            }
            catch (ParserConfigurationException pce) {
                System.out.println("XML ParserConfigException when creating DocBuilder: " + pce.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("XML resource IMDI_*.xsd or eaf-EAFv2.?.xsd read error, using dummy validators: " + ioe);
                imdiDocBuilder = docBuilder;
                eaf20DocBuilder = docBuilder;
                eaf21DocBuilder = docBuilder;
                eaf22DocBuilder = docBuilder;
                eaf23DocBuilder = docBuilder;
                eaf24DocBuilder = docBuilder;
                eaf25DocBuilder = docBuilder;
                eaf26DocBuilder = docBuilder;
                eafAnyDocBuilder = docBuilder;
            }
            catch (NullPointerException npe) {
                System.out.println("XML resource IMDI_*.xsd or eaf-EAFv2.?.xsd missing, using dummy validators: " + npe);
                npe.printStackTrace();
                imdiDocBuilder = docBuilder;
                eaf20DocBuilder = docBuilder;
                eaf21DocBuilder = docBuilder;
                eaf22DocBuilder = docBuilder;
                eaf23DocBuilder = docBuilder;
                eaf24DocBuilder = docBuilder;
                eaf25DocBuilder = docBuilder;
                eaf26DocBuilder = docBuilder;
                eafAnyDocBuilder = docBuilder;
                self = this;
            }
            finally {
                self = this;
            }
        }
    }

    public synchronized String checkStream(InputStream is, String name) throws IOException {
        if (name == null) {
            return "false [BAD] No name given";
        }
        int version = -1;
        String what = "Generic XML";
        boolean crlfAdded = false;
        byte[] buf = new byte[0xA00000];
        int used = 0;
        try {
            int read = 1;
            while (read != -1 && used < 0x9FFFFE) {
                read = is.read(buf, used, 0x9FFFFE - used);
                if (read == -1) continue;
                used += read;
            }
            if (used == 0) {
                return "false [BAD] empty file";
            }
            if (buf[used - 1] != 10 && buf[used - 1] != 13) {
                buf[used] = 13;
                buf[used + 1] = 10;
                used += 2;
                crlfAdded = true;
            }
        }
        catch (IOException ioe) {
            return "false [BAD] I/O error: " + ioe.getMessage();
        }
        ByteArrayInputStream bytes = new ByteArrayInputStream(buf, 0, used);
        bytes.mark(0xA00000);
        MyErrorHandler errorHandler = new MyErrorHandler();
        Document parsed = null;
        String systemId = name;
        String extension = name.substring(name.lastIndexOf(46) + 1);
        systemId = name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("ftp:") || name.indexOf(58) < 3 || name.indexOf(58) > 6 ? name : new File(name).toURL().toString();
        try {
            if (extension.equals("imdi")) {
                what = "XML IMDI 3";
                imdiDocBuilder.setEntityResolver(this.myER);
                imdiDocBuilder.setErrorHandler(errorHandler);
                parsed = imdiDocBuilder.parse(bytes, systemId);
            } else if (extension.equals("eaf")) {
                what = "XML EAF";
                int end = 4095;
                if (end > used) {
                    end = used;
                }
                while ((buf[end] & 0x80) != 0) {
                    --end;
                }
                String header = null;
                try {
                    header = new String(buf, 0, end + 1, "UTF8");
                    int where = header.indexOf("VERSION=\"");
                    if (where == -1) {
                        version = 26;
                        what = "XML EAF 2.6/unspecified";
                    } else if (header.startsWith("2.0", where + "VERSION=\"".length())) {
                        version = 20;
                        what = "XML EAF 2.0";
                    } else if (header.startsWith("2.1", where + "VERSION=\"".length())) {
                        version = 21;
                        what = "XML EAF 2.1";
                    } else if (header.startsWith("2.2", where + "VERSION=\"".length())) {
                        version = 22;
                        what = "XML EAF 2.2";
                    } else if (header.startsWith("2.3", where + "VERSION=\"".length())) {
                        version = 23;
                        what = "XML EAF 2.3";
                    } else if (header.startsWith("2.4", where + "VERSION=\"".length())) {
                        version = 24;
                        what = "XML EAF 2.4";
                    } else if (header.startsWith("2.5", where + "VERSION=\"".length())) {
                        version = 25;
                        what = "XML EAF 2.5";
                    } else if (header.startsWith("2.6", where + "VERSION=\"".length())) {
                        version = 26;
                        what = "XML EAF 2.6";
                    } else {
                        String verString = header.substring(where + "VERSION=\"".length());
                        verString = (where = verString.indexOf(34)) < 1 ? "unknown" : verString.substring(0, where);
                        version = 0;
                        what = "Generic XML EAF version " + verString + " (no XSD available)";
                    }
                }
                catch (UnsupportedEncodingException e) {
                    return "false [BAD] XML EAF header parse error: unsupported encoding";
                }
                catch (IndexOutOfBoundsException e) {
                    return "false [BAD] XML EAF header parse error: index out of bounds";
                }
                eaf20DocBuilder.setEntityResolver(this.myER);
                eaf21DocBuilder.setEntityResolver(this.myER);
                eaf22DocBuilder.setEntityResolver(this.myER);
                eaf23DocBuilder.setEntityResolver(this.myER);
                eaf24DocBuilder.setEntityResolver(this.myER);
                eaf25DocBuilder.setEntityResolver(this.myER);
                eaf26DocBuilder.setEntityResolver(this.myER);
                eafAnyDocBuilder.setEntityResolver(this.myERany);
                if (version == 20) {
                    eaf20DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf20DocBuilder.parse(bytes, systemId);
                } else if (version == 21) {
                    eaf21DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf21DocBuilder.parse(bytes, systemId);
                } else if (version == 22) {
                    eaf22DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf22DocBuilder.parse(bytes, systemId);
                } else if (version == 23) {
                    eaf23DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf23DocBuilder.parse(bytes, systemId);
                } else if (version == 24) {
                    eaf24DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf24DocBuilder.parse(bytes, systemId);
                } else if (version == 25) {
                    eaf25DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf25DocBuilder.parse(bytes, systemId);
                } else if (version == 26) {
                    eaf26DocBuilder.setErrorHandler(errorHandler);
                    parsed = eaf26DocBuilder.parse(bytes, systemId);
                } else {
                    docBuilder.setEntityResolver(this.myER);
                    docBuilder.setErrorHandler(errorHandler);
                    parsed = docBuilder.parse(bytes, systemId);
                }
            } else if (cgnNames.contains(extension)) {
                what = "XML CGN " + extension.toUpperCase();
                valDocBuilder.setEntityResolver(this.myER);
                valDocBuilder.setErrorHandler(errorHandler);
                parsed = valDocBuilder.parse(bytes, systemId);
            } else {
                docBuilder.setEntityResolver(this.myER);
                docBuilder.setErrorHandler(errorHandler);
                parsed = docBuilder.parse(bytes, systemId);
            }
            if (crlfAdded) {
                what = what + " [no trailing CRLF]";
            }
        }
        catch (SAXException se) {
            this.myER.getExternals();
            return "false [BAD] " + what + " [SAX error] " + se.getMessage();
        }
        catch (NullPointerException npe) {
            this.myER.getExternals();
            npe.printStackTrace();
            return "false [BAD] " + what + " [SAX null pointer] " + npe.getMessage();
        }
        if (parsed == null) {
            return "false [BAD] " + what + " [null parse] " + this.myER.getExternals();
        }
        if (errorHandler.getErrors().length() > 0) {
            if (version < 20 || version == 26) {
                return "false [BAD] " + what + " " + errorHandler.getErrors() + " " + this.myER.getExternals();
            }
            what = "XML EAF 2.6/any";
            this.myER.getExternals();
            errorHandler = new MyErrorHandler();
            try {
                eafAnyDocBuilder.setEntityResolver(this.myERany);
                eafAnyDocBuilder.setErrorHandler(errorHandler);
                bytes.reset();
                parsed = eafAnyDocBuilder.parse(bytes, systemId);
            }
            catch (SAXException se) {
                this.myERany.getExternals();
                return "false [BAD] " + what + " [SAX error] " + se.getMessage();
            }
            if (parsed == null) {
                return "false [BAD] " + what + " [null parse] " + this.myERany.getExternals();
            }
            if (errorHandler.getErrors().length() > 0) {
                return "false [BAD] " + what + " " + errorHandler.getErrors() + " " + this.myERany.getExternals();
            }
            return "true [okay] Validated Generic " + what + " " + this.myERany.getExternals();
        }
        if (!what.startsWith("Generic XML")) {
            return "true [okay] Validated " + what + " " + this.myER.getExternals();
        }
        return "true [okay] Parsed " + what + " " + this.myER.getExternals();
    }

    public static void main(String[] args) {
        XMLCheck me = new XMLCheck();
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            FileInputStream what = null;
            try {
                what = new FileInputStream(args[i]);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + fnfe);
                continue;
            }
            try {
                String result = me.checkStream(what, args[i]);
                what.close();
                System.out.println(result + " file: " + args[i]);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check, I/O error: " + ioe + " file: " + args[i]);
                try {
                    what.close();
                    continue;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
    }

    class MyEntityResolver
    implements EntityResolver {
        String externals = new String();
        String[] resNormalNames = new String[]{"imdi_3.0.xsd", "eafv2.0.xsd", "eafv2.1.xsd", "eafv2.2.xsd", "eafv2.3.xsd", "eafv2.4.xsd", "eafv2.5.xsd", "eafv2.6.xsd", "ftext.dtd", "prtext.dtd", "stext.dtd", "ttext.dtd", "text.dtd", "ptext.dtd", "trans-13.dtd"};
        String[] resId = new String[]{"IMDI3", "EAF2.0", "EAF2.1", "EAF2.2", "EAF2.3", "EAF2.4", "EAF2.5", "EAF2.6", "BPT", "PRX", "TIG", "SKP", "PRI", "TAG", "TRS"};
        String[] resNames = new String[]{"IMDI_3.0.xsd", "eaf-EAFv2.0.xsd", "eaf-EAFv2.1.xsd", "eaf-EAFv2.2.xsd", "eaf-EAFv2.3.xsd", "eaf-EAFv2.4.xsd", "eaf-EAFv2.5.xsd", "eaf-EAFv2.6.xsd", "bpt-ftext.dtd", "prx-prtext.dtd", "tig-stext.dtd", "skp-ttext.dtd", "pri-text.dtd", "tag-ptext.dtd", "trs-trans-13.dtd"};
        boolean cheatEAF = false;

        public MyEntityResolver(boolean anyEAF) {
            this.cheatEAF = anyEAF;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            int baseOff2;
            int baseOffset;
            int baseOff1 = systemId.lastIndexOf(47);
            int n = baseOffset = baseOff1 > (baseOff2 = systemId.lastIndexOf(92)) ? baseOff1 : baseOff2;
            if (baseOffset == -1) {
                baseOffset = -1;
            }
            String baseName = systemId.substring(baseOffset + 1).toLowerCase();
            String realBase = null;
            if (this.cheatEAF && baseName.startsWith("eafv2.") && baseName.endsWith(".xsd")) {
                realBase = "EAF2.6/2." + baseName.substring(6, 7);
                baseName = "eafv2.6.xsd";
            }
            for (int x = 0; x < this.resNormalNames.length; ++x) {
                if (!baseName.equals(this.resNormalNames[x])) continue;
                this.externals = realBase != null ? this.externals + "[" + realBase + "]" : this.externals + "[" + this.resId[x] + "]";
                return new InputSource(XMLCheck.class.getResource("resources/" + this.resNames[x]).openStream());
            }
            this.externals = this.externals + "LOAD[" + publicId + ", " + systemId + "]";
            return null;
        }

        public String getExternals() {
            String retVal = this.externals;
            this.externals = new String();
            return retVal;
        }
    }

    class MyErrorHandler
    implements ErrorHandler {
        String errors = new String();

        MyErrorHandler() {
        }

        public void warning(SAXParseException e) {
            this.errors = this.errors + " WARN[ " + e.getMessage() + " ]";
        }

        public void error(SAXParseException e) {
            this.errors = this.errors + " ERROR[ " + e.getMessage() + " ]";
        }

        public void fatalError(SAXParseException e) {
            this.errors = this.errors + " FATAL[ " + e.getMessage() + " ]";
        }

        public String getErrors() {
            return this.errors;
        }
    }
}

