/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import javax.xml.bind.annotation.XmlAttribute;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;

public class KinType {
    @XmlAttribute(name="code", namespace="http://mpi.nl/tla/kin")
    protected String codeString = null;
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    protected DataTypes.RelationType relationType = null;
    @XmlAttribute(name="symbol", namespace="http://mpi.nl/tla/kin")
    protected EntityData.SymbolType symbolType = null;
    @XmlAttribute(name="name", namespace="http://mpi.nl/tla/kin")
    protected String displayString = null;
    private static KinType[] referenceKinTypes = new KinType[]{new KinType("Ef", DataTypes.RelationType.none, EntityData.SymbolType.circle, "Ego Female"), new KinType("Em", DataTypes.RelationType.none, EntityData.SymbolType.triangle, "Ego Male"), new KinType("Fa", DataTypes.RelationType.ancestor, EntityData.SymbolType.triangle, "Father"), new KinType("Mo", DataTypes.RelationType.ancestor, EntityData.SymbolType.circle, "Mother"), new KinType("Br", DataTypes.RelationType.sibling, EntityData.SymbolType.triangle, "Brother"), new KinType("Si", DataTypes.RelationType.sibling, EntityData.SymbolType.circle, "Sister"), new KinType("So", DataTypes.RelationType.descendant, EntityData.SymbolType.triangle, "Son"), new KinType("Da", DataTypes.RelationType.descendant, EntityData.SymbolType.circle, "Daughter"), new KinType("Hu", DataTypes.RelationType.union, EntityData.SymbolType.triangle, "Husband"), new KinType("Wi", DataTypes.RelationType.union, EntityData.SymbolType.circle, "Wife"), new KinType("Pa", DataTypes.RelationType.ancestor, EntityData.SymbolType.square, "Parent"), new KinType("Sb", DataTypes.RelationType.sibling, EntityData.SymbolType.square, "Sibling"), new KinType("Sp", DataTypes.RelationType.union, EntityData.SymbolType.square, "Spouse"), new KinType("Ch", DataTypes.RelationType.descendant, EntityData.SymbolType.square, "Child"), new KinType("F", DataTypes.RelationType.ancestor, EntityData.SymbolType.triangle, "Father"), new KinType("M", DataTypes.RelationType.ancestor, EntityData.SymbolType.circle, "Mother"), new KinType("B", DataTypes.RelationType.sibling, EntityData.SymbolType.triangle, "Brother"), new KinType("Z", DataTypes.RelationType.sibling, EntityData.SymbolType.circle, "Sister"), new KinType("S", DataTypes.RelationType.descendant, EntityData.SymbolType.triangle, "Son"), new KinType("D", DataTypes.RelationType.descendant, EntityData.SymbolType.circle, "Daughter"), new KinType("H", DataTypes.RelationType.union, EntityData.SymbolType.triangle, "Husband"), new KinType("W", DataTypes.RelationType.union, EntityData.SymbolType.circle, "Wife"), new KinType("P", DataTypes.RelationType.ancestor, EntityData.SymbolType.square, "Parent"), new KinType("G", DataTypes.RelationType.sibling, EntityData.SymbolType.square, "Sibling"), new KinType("E", DataTypes.RelationType.none, EntityData.SymbolType.square, "Ego"), new KinType("C", DataTypes.RelationType.descendant, EntityData.SymbolType.square, "Child"), new KinType("m", DataTypes.RelationType.none, EntityData.SymbolType.triangle, "Male"), new KinType("f", DataTypes.RelationType.none, EntityData.SymbolType.circle, "Female"), new KinType("x", DataTypes.RelationType.none, EntityData.SymbolType.square, "Undefined"), new KinType("*", null, null, "Any Relation")};

    private KinType() {
    }

    public KinType(String codeStringLocal, DataTypes.RelationType relationTypeLocal, EntityData.SymbolType symbolTypeLocal, String displayStringLocal) {
        this.codeString = codeStringLocal;
        this.relationType = relationTypeLocal;
        this.symbolType = symbolTypeLocal;
        this.displayString = displayStringLocal;
    }

    public String getCodeString() {
        return this.codeString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public DataTypes.RelationType getRelationType() {
        return this.relationType;
    }

    public EntityData.SymbolType getSymbolType() {
        return this.symbolType;
    }

    public boolean isEgoType() {
        return this.codeString.contains("E");
    }

    public boolean matchesRelation(EntityRelation entityRelation, String kinTypeModifier) {
        if (entityRelation.getAlterNode().isEgo != this.isEgoType()) {
            return false;
        }
        if (this.relationType != null && !this.relationType.equals((Object)entityRelation.relationType)) {
            return false;
        }
        if (this.symbolType != null && this.symbolType != EntityData.SymbolType.square && !this.symbolType.name().equals(entityRelation.getAlterNode().getSymbolType())) {
            return false;
        }
        if (kinTypeModifier != null && !kinTypeModifier.isEmpty()) {
            int relationOrder = entityRelation.getRelationOrder();
            if (kinTypeModifier.equals("-")) {
                if (relationOrder >= 0) {
                    return false;
                }
            } else if (kinTypeModifier.equals("+")) {
                if (relationOrder <= 0) {
                    return false;
                }
            } else {
                int requiredOrder = Integer.parseInt(kinTypeModifier.replaceFirst("^\\+", ""));
                return relationOrder == requiredOrder;
            }
        }
        return true;
    }

    public boolean matchesEgoEntity(EntityData entityData, String kinTypeModifier) {
        if (!entityData.isEgo || !this.isEgoType()) {
            return false;
        }
        if (this.symbolType == EntityData.SymbolType.square) {
            return true;
        }
        return this.symbolType.name().equals(entityData.getSymbolType());
    }

    public static KinType[] getReferenceKinTypes() {
        return referenceKinTypes;
    }
}

