/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.kinnate.ui.MainFrame;

public class RecentFileMenu
extends JMenu
implements ActionListener {
    MainFrame mainFrame;

    public RecentFileMenu(MainFrame mainFrameLocal) {
        this.mainFrame = mainFrameLocal;
        this.setupMenu();
    }

    public void addRecentFile(File recentFile) {
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            String[] tempArray = ArbilSessionStorage.getSingleInstance().loadStringArray("RecentKinFiles");
            if (tempArray != null) {
                tempList.addAll(Arrays.asList(tempArray));
            }
            while (tempList.size() > 10) {
                tempList.remove(0);
            }
            tempList.remove(recentFile.toString());
            tempList.add(recentFile.toString());
        }
        catch (IOException exception) {
            String[] tempArray = new String[]{recentFile.toString()};
        }
        try {
            ArbilSessionStorage.getSingleInstance().saveStringArray("RecentKinFiles", tempList.toArray(new String[0]));
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
        this.setupMenu();
    }

    private void setupMenu() {
        this.removeAll();
        try {
            String[] recentFileArray = ArbilSessionStorage.getSingleInstance().loadStringArray("RecentKinFiles");
            if (recentFileArray != null) {
                for (int currentIndex = recentFileArray.length - 1; currentIndex >= 0; --currentIndex) {
                    String currentFilePath = recentFileArray[currentIndex];
                    JMenuItem currentMenuItem = new JMenuItem(currentFilePath);
                    currentMenuItem.setActionCommand(currentFilePath);
                    currentMenuItem.addActionListener(this);
                    this.add(currentMenuItem);
                }
            }
            this.add(new JSeparator());
            JMenuItem clearMenuItem = new JMenuItem("Clear List");
            clearMenuItem.setActionCommand("Clear List");
            clearMenuItem.addActionListener(this);
            this.add(clearMenuItem);
        }
        catch (IOException exception) {
            JMenuItem currentMenuItem = new JMenuItem("no recent files");
            currentMenuItem.setEnabled(false);
            this.add(currentMenuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("Clear List".equals(e.getActionCommand())) {
            try {
                ArbilSessionStorage.getSingleInstance().saveStringArray("RecentKinFiles", new String[0]);
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError((Exception)exception);
            }
            this.setupMenu();
        } else {
            String actionString = e.getActionCommand();
            File recentFile = new File(actionString);
            String recentName = recentFile.getName();
            this.mainFrame.openDiagram(recentName, recentFile.toURI(), true);
        }
    }
}

