/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import nl.nikhef.slcshttps.crypto.CSR;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoStore {
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private CSR csr = null;
    private KeyStore keyStore = null;
    private char[] password = null;
    private static final String CERT_ALIAS = "CERTIFICATE";
    private static final int PASSWORD_LENGTH = 16;
    protected static final int KEYLENGTH = 1024;

    public CryptoStore(int n) throws NoSuchProviderException, KeyStoreException {
        if (Security.getProvider("BC") == null) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            catch (Exception exception) {
                throw new NoSuchProviderException("Cannot add BouncyCastle security provider");
            }
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            throw new KeyStoreException("Failed to create keypair in CryptoStore", exception);
        }
        try {
            this.keyStore = KeyStore.getInstance("PKCS12", "BC");
            this.keyStore.load(null, null);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Failed to created keystore in CryptoStore", exception);
        }
        try {
            this.password = this.getPassword(16);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("Failed to create in CryptoStore");
        }
    }

    public CryptoStore() throws NoSuchProviderException, KeyStoreException {
        this(1024);
    }

    public void CSRinit(String string) throws SignatureException {
        try {
            this.csr = new CSR(string, this.publicKey, this.privateKey);
        }
        catch (Exception exception) {
            throw new SignatureException("Cannot create a Certificate Signing Request", exception);
        }
    }

    public void CSRinit() throws SignatureException {
        try {
            this.csr = new CSR(this.publicKey, this.privateKey);
        }
        catch (Exception exception) {
            throw new SignatureException("Cannot create a Certificate Signing Request", exception);
        }
    }

    public CSR getCSR() {
        return this.csr;
    }

    public void storeCertificate(X509Certificate x509Certificate) throws KeyStoreException {
        try {
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            this.keyStore.setKeyEntry(CERT_ALIAS, this.privateKey, this.password, certificateArray);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot store certificate in keystore", exception);
        }
    }

    public X509Certificate importPKCS12(KeyStore keyStore, char[] cArray) throws CertificateException, KeyStoreException {
        if (keyStore.getType() != "PKCS12") {
            throw new KeyStoreException("Specified KeyStore is not a PKCS12 KeyStore");
        }
        Enumeration<String> enumeration = keyStore.aliases();
        if (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) {
                throw new CertificateException("First entry in KeyStore should be a X509Certificate/PrivateKey pair");
            }
            try {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                this.publicKey = x509Certificate.getPublicKey();
                this.privateKey = (PrivateKey)keyStore.getKey(string, cArray);
                this.storeCertificate(x509Certificate);
                return x509Certificate;
            }
            catch (Exception exception) {
                throw new CertificateException("Cannot get certificate or keys from PKCS12 KeyStore");
            }
        }
        throw new KeyStoreException("KeyStore is empty");
    }

    public X509Certificate getCertificate(String string) throws KeyStoreException {
        return (X509Certificate)this.keyStore.getCertificate(string);
    }

    public X509Certificate getCertificate() throws KeyStoreException {
        return this.getCertificate(CERT_ALIAS);
    }

    public void deleteCertificate(String string) throws KeyStoreException {
        this.keyStore.deleteEntry(string);
    }

    public void deleteCertificate() throws KeyStoreException {
        this.deleteCertificate(CERT_ALIAS);
    }

    KeyManager[] getKeyManagers() throws KeyStoreException {
        KeyManager[] keyManagerArray;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(this.keyStore, this.password);
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot get KeyManager[]", exception);
        }
        return keyManagerArray;
    }

    private char[] getPassword(int n) throws KeyStoreException {
        try {
            int n2 = "abcdefghijklmnopqrstuvxwyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
            char[] cArray = new char[n];
            Date date = new Date();
            Random random = new Random(date.getTime());
            for (int i = 0; i < n; ++i) {
                cArray[i] = "abcdefghijklmnopqrstuvxwyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(random.nextInt(n2));
            }
            date = null;
            random = null;
        }
        catch (Exception exception) {
            throw new KeyStoreException("Could not create random password", exception);
        }
        return this.password;
    }
}

