/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.crypto;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import nl.nikhef.slcshttps.crypto.CryptoStore;

public class CryptoSSL {
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;

    public CryptoSSL(CryptoStore cryptoStore) throws KeyStoreException {
        this.init(cryptoStore, null);
    }

    public CryptoSSL(CryptoStore cryptoStore, TrustManager trustManager) throws KeyStoreException {
        this.init(cryptoStore, trustManager);
    }

    public void init(CryptoStore cryptoStore) throws KeyStoreException {
        this.init(cryptoStore, null);
    }

    public void init(CryptoStore cryptoStore, TrustManager trustManager) throws KeyStoreException {
        try {
            this.keyManagers = cryptoStore.getKeyManagers();
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot get KeyManager[] from cryptoStore", exception);
        }
        if (trustManager != null) {
            this.trustManagers = new TrustManager[]{trustManager};
        }
    }

    public void addCryptoStore(CryptoStore cryptoStore) throws KeyStoreException {
        KeyManager[] keyManagerArray;
        KeyManager[] keyManagerArray2 = this.keyManagers;
        try {
            keyManagerArray = cryptoStore.getKeyManagers();
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot get KeyManager[] from cryptoStore", exception);
        }
        int n = keyManagerArray2.length;
        int n2 = keyManagerArray.length;
        this.keyManagers = new KeyManager[n + n2];
        System.arraycopy(keyManagerArray2, 0, this.keyManagers, 0, n);
        System.arraycopy(keyManagerArray, 0, this.keyManagers, n, n2);
    }

    public SSLSocketFactory getSSLSocketFactory() throws KeyManagementException {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(this.keyManagers, this.trustManagers, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new KeyManagementException("Cannot get a SocketFactory for given managers", exception);
        }
        return sSLSocketFactory;
    }
}

