/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.math.BigDecimal;
import java.util.Calendar;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.DTd;
import org.basex.query.item.Dat;
import org.basex.query.item.Date;
import org.basex.query.item.Dec;
import org.basex.query.item.Dtm;
import org.basex.query.item.Dur;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Tim;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class FNDate
extends FuncCall {
    public FNDate(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.input);
        if (it == null) {
            return null;
        }
        boolean d = this.expr.length == 2;
        Item zon = d ? this.expr[1].item(ctx, this.input) : null;
        switch (this.def) {
            case YEADUR: {
                return this.yea(this.checkDur(it));
            }
            case YEADTM: {
                return this.yea(this.checkDate(it, AtomType.DTM, ctx));
            }
            case YEADAT: {
                return this.yea(this.checkDate(it, AtomType.DAT, ctx));
            }
            case MONDUR: {
                return this.mon(this.checkDur(it));
            }
            case MONDTM: {
                return this.mon(this.checkDate(it, AtomType.DTM, ctx));
            }
            case MONDAT: {
                return this.mon(this.checkDate(it, AtomType.DAT, ctx));
            }
            case DAYDUR: {
                return this.day(this.checkDur(it));
            }
            case DAYDTM: {
                return this.day(this.checkDate(it, AtomType.DTM, ctx));
            }
            case DAYDAT: {
                return this.day(this.checkDate(it, AtomType.DAT, ctx));
            }
            case HOUDUR: {
                return this.hou(this.checkDur(it));
            }
            case HOUDTM: {
                return this.hou(this.checkDate(it, AtomType.DTM, ctx));
            }
            case HOUTIM: {
                return this.hou(this.checkDate(it, AtomType.TIM, ctx));
            }
            case MINDUR: {
                return this.min(this.checkDur(it));
            }
            case MINDTM: {
                return this.min(this.checkDate(it, AtomType.DTM, ctx));
            }
            case MINTIM: {
                return this.min(this.checkDate(it, AtomType.TIM, ctx));
            }
            case SECDUR: {
                return this.sec(this.checkDur(it));
            }
            case SECDTM: {
                return this.sec(this.checkDate(it, AtomType.DTM, ctx));
            }
            case SECTIM: {
                return this.sec(this.checkDate(it, AtomType.TIM, ctx));
            }
            case ZONDTM: {
                return this.zon(this.checkDate(it, AtomType.DTM, ctx));
            }
            case ZONDAT: {
                return this.zon(this.checkDate(it, AtomType.DAT, ctx));
            }
            case ZONTIM: {
                return this.zon(this.checkDate(it, AtomType.TIM, ctx));
            }
            case DATZON: {
                return this.datzon(it, zon, d);
            }
            case DTMZON: {
                return this.dtmzon(it, zon, d);
            }
            case TIMZON: {
                return this.timzon(it, zon, d);
            }
            case DATETIME: {
                return this.dattim(it, zon);
            }
        }
        return super.item(ctx, ii);
    }

    private Item yea(Item it) {
        return Itr.get(it instanceof Dur ? ((Dur)it).yea() : ((Date)it).xc.getYear());
    }

    private Item mon(Item it) {
        return Itr.get(it instanceof Dur ? ((Dur)it).mon() : ((Date)it).xc.getMonth());
    }

    private Item day(Item it) {
        return Itr.get(it instanceof Dur ? (int)((Dur)it).day() : ((Date)it).xc.getDay());
    }

    private Item hou(Item it) {
        return Itr.get(it instanceof Dur ? (int)((Dur)it).hou() : ((Date)it).xc.getHour());
    }

    private Item min(Item it) {
        return Itr.get(it instanceof Dur ? ((Dur)it).min() : (long)((Date)it).xc.getMinute());
    }

    private Item sec(Item it) {
        if (it instanceof Dur) {
            return Dec.get(((Dur)it).sec().doubleValue());
        }
        int s = ((Date)it).xc.getSecond();
        BigDecimal d = ((Date)it).xc.getFractionalSecond();
        return Dec.get((double)s + (d != null ? d.doubleValue() : 0.0));
    }

    private Item zon(Item it) {
        int z = ((Date)it).xc.getTimezone();
        return z == Integer.MIN_VALUE ? null : new DTd(z);
    }

    private Item checkDate(Item it, Type t, QueryContext ctx) throws QueryException {
        return it.unt() ? t.e(it, ctx, this.input) : this.checkType(it, t);
    }

    private Item checkDur(Item it) throws QueryException {
        if (it.unt()) {
            return new Dur(it.atom(this.input), this.input);
        }
        if (!it.dur()) {
            Err.type(this, AtomType.DUR, it);
        }
        return it;
    }

    private Item datzon(Item it, Item zon, boolean d) throws QueryException {
        Item i = it.unt() ? new Dat(it.atom(this.input), this.input) : this.checkType(it, AtomType.DAT);
        return this.adjust((Date)i, zon, d);
    }

    private Item dtmzon(Item it, Item zon, boolean d) throws QueryException {
        Item i = it.unt() ? new Dtm(it.atom(this.input), this.input) : this.checkType(it, AtomType.DTM);
        return this.adjust((Date)i, zon, d);
    }

    private Item timzon(Item it, Item zon, boolean d) throws QueryException {
        Item i = it.unt() ? new Tim(it.atom(this.input), this.input) : this.checkType(it, AtomType.TIM);
        return this.adjust((Date)i, zon, d);
    }

    private Item dattim(Item date, Item tm) throws QueryException {
        if (tm == null) {
            return null;
        }
        Item d = date.unt() ? new Dat(date.atom(this.input), this.input) : date;
        Item t = tm.unt() ? new Tim(tm.atom(this.input), this.input) : tm;
        Dtm dtm = new Dtm((Dat)this.checkType(d, AtomType.DAT));
        Tim tim = (Tim)this.checkType(t, AtomType.TIM);
        dtm.xc.setTime(tim.xc.getHour(), tim.xc.getMinute(), tim.xc.getSecond(), tim.xc.getMillisecond());
        int zone = tim.xc.getTimezone();
        if (dtm.xc.getTimezone() == Integer.MIN_VALUE) {
            dtm.xc.setTimezone(zone);
        } else if (dtm.xc.getTimezone() != zone && zone != Integer.MIN_VALUE) {
            Err.FUNZONE.thrw(this.input, dtm, tim);
        }
        return dtm;
    }

    private Date adjust(Date date, Item zon, boolean d) throws QueryException {
        if (d && zon == null) {
            date.xc.setTimezone(Integer.MIN_VALUE);
            return date;
        }
        int zn = date.xc.getTimezone();
        int tz = 0;
        if (zon == null) {
            Calendar c = Calendar.getInstance();
            tz = (c.get(15) + c.get(16)) / 60000;
        } else {
            DTd dtd = (DTd)this.checkType(zon, AtomType.DTD);
            tz = (int)(dtd.min() + dtd.hou() * 60L);
            if (dtd.sec().signum() != 0 || Math.abs(tz) > 840) {
                Err.INVALZONE.thrw(this.input, zon);
            }
        }
        if (zn != Integer.MIN_VALUE) {
            date.xc.add(Date.df.newDuration(-60000L * (long)(zn - tz)));
        }
        date.xc.setTimezone(tz);
        return date;
    }
}

