/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.kindocument.KinXsdException;
import nl.mpi.kinnate.userstorage.KinSessionStorage;

public class CmdiTransformer {
    private URL component2SchemaXsl = this.getClass().getResource("/xsd/comp2schema.xsl");
    private URL component2SchemaXslHeader = this.getClass().getResource("/xsd/comp2schema-header.xsl");
    private URL component2SchemaXslCleanup = this.getClass().getResource("/xsd/cleanup-xsd.xsl");

    public URI getXsdUrlString(String entityType) throws KinXsdException {
        String profileId = "clarin.eu:cr1:p_1320657629627";
        File xsdFile = new File(KinSessionStorage.getSingleInstance().getCacheDirectory(), entityType + "-" + profileId + ".xsd");
        try {
            if (!xsdFile.exists()) {
                this.transformProfileXmlToXsd(xsdFile, profileId);
            }
            return xsdFile.toURI();
        }
        catch (IOException exception) {
            System.out.println("exception: " + exception.getMessage());
            throw new KinXsdException();
        }
        catch (TransformerException exception) {
            System.out.println("exception: " + exception.getMessage());
            throw new KinXsdException();
        }
    }

    public File transformProfileXmlToXsd(File outputFile, String profileId) throws IOException, TransformerException {
        String cmdiProfileXmlUrl = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/" + profileId + "/xml";
        System.out.println("outputFile: " + outputFile.getAbsolutePath());
        File xlsFile = KinSessionStorage.getSingleInstance().updateCache(this.component2SchemaXsl.toExternalForm(), 1, false);
        System.out.println(KinSessionStorage.getSingleInstance().updateCache(this.component2SchemaXslHeader.toExternalForm(), 1, false));
        System.out.println(KinSessionStorage.getSingleInstance().updateCache(this.component2SchemaXslCleanup.toExternalForm(), 1, false));
        this.generateXsd(xlsFile, cmdiProfileXmlUrl, outputFile);
        return outputFile;
    }

    private void generateXsd(File xlsFile, String cmdiProfileXmlUrl, File outputFile) {
        Templates componentToSchemaTemplates;
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", TransformerFactoryImpl.class.getName());
            componentToSchemaTemplates = TransformerFactory.newInstance().newTemplates(new StreamSource(xlsFile));
        }
        catch (TransformerConfigurationException e) {
            new ArbilBugCatcher().logError("Cannot create Template", (Exception)e);
            return;
        }
        try {
            Transformer transformer = componentToSchemaTemplates.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://saxon.sf.net/}indent-spaces", "1");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(cmdiProfileXmlUrl), new StreamResult(new FileOutputStream(outputFile)));
        }
        catch (TransformerConfigurationException e) {
            new ArbilBugCatcher().logError("Cannot create Transformer", (Exception)e);
        }
        catch (TransformerException e) {
            new ArbilBugCatcher().logError("Cannot transform xml file: ", (Exception)e);
        }
        catch (FileNotFoundException e) {
            new ArbilBugCatcher().logError((Exception)e);
        }
    }

    public static void main(String[] args) {
        try {
            String profileId = "clarin.eu:cr1:p_1320657629627";
            File xsdFile = new File(KinSessionStorage.getSingleInstance().getCacheDirectory(), "individual-" + profileId + ".xsd");
            new CmdiTransformer().transformProfileXmlToXsd(xsdFile, profileId);
        }
        catch (IOException exception) {
            System.out.println("exception: " + exception.getMessage());
        }
        catch (TransformerException exception) {
            System.out.println("exception: " + exception.getMessage());
        }
    }
}

