/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.userstorage.KinSessionStorage;

public class RecentFileMenu
extends JMenu
implements ActionListener {
    AbstractDiagramManager diagramWindowManager;

    public RecentFileMenu(AbstractDiagramManager diagramWindowManager) {
        this.diagramWindowManager = diagramWindowManager;
        this.setText("Open Recent Diagram");
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                RecentFileMenu.this.setupMenu();
            }
        });
    }

    public static void addRecentFile(File recentFile) {
        ArrayList<String> tempList = new ArrayList<String>();
        try {
            String[] tempArray = KinSessionStorage.getSingleInstance().loadStringArray("RecentKinFiles");
            if (tempArray != null) {
                tempList.addAll(Arrays.asList(tempArray));
            }
            while (tempList.size() > 10) {
                tempList.remove(0);
            }
            tempList.remove(recentFile.toString());
            tempList.add(recentFile.toString());
        }
        catch (IOException exception) {
            String[] tempArray = new String[]{recentFile.toString()};
        }
        try {
            KinSessionStorage.getSingleInstance().saveStringArray("RecentKinFiles", tempList.toArray(new String[0]));
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError((Exception)exception);
        }
    }

    private void setupMenu() {
        this.removeAll();
        try {
            String[] recentFileArray = KinSessionStorage.getSingleInstance().loadStringArray("RecentKinFiles");
            if (recentFileArray != null) {
                for (int currentIndex = recentFileArray.length - 1; currentIndex >= 0; --currentIndex) {
                    String currentFilePath = recentFileArray[currentIndex];
                    JMenuItem currentMenuItem = new JMenuItem(currentFilePath);
                    currentMenuItem.setActionCommand(currentFilePath);
                    currentMenuItem.addActionListener(this);
                    this.add(currentMenuItem);
                }
            }
            this.add(new JSeparator());
            JMenuItem clearMenuItem = new JMenuItem("Clear List");
            clearMenuItem.setActionCommand("Clear List");
            clearMenuItem.addActionListener(this);
            this.add(clearMenuItem);
        }
        catch (IOException exception) {
            JMenuItem currentMenuItem = new JMenuItem("no recent files");
            currentMenuItem.setEnabled(false);
            this.add(currentMenuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("Clear List".equals(e.getActionCommand())) {
            try {
                KinSessionStorage.getSingleInstance().saveStringArray("RecentKinFiles", new String[0]);
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError((Exception)exception);
            }
        } else {
            String actionString = e.getActionCommand();
            File recentFile = new File(actionString);
            String recentName = recentFile.getName();
            this.diagramWindowManager.openDiagram(recentName, recentFile.toURI(), true);
        }
    }
}

