/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class LayeredDiagramManager
extends AbstractDiagramManager {
    private JPanel mainPanel;
    private HashMap<Component, String> titleMap = new HashMap();
    private ArrayList<Component> diagramArray = new ArrayList();
    private JFrame mainFrame;

    public LayeredDiagramManager(ApplicationVersionManager versionManager) {
        super(versionManager);
        this.mainPanel = new JPanel(new BorderLayout());
    }

    public void createApplicationWindow() {
        this.mainFrame = this.createDiagramWindow(this.getSavePanelTitle(this.getSavePanelIndex()), this.mainPanel);
    }

    public void createDiagramContainer(String diagramTitle, Component diagramComponent) {
        this.titleMap.put(diagramComponent, diagramTitle);
        this.diagramArray.add(diagramComponent);
        this.setSelectedDiagram(diagramComponent);
    }

    public void createDiagramSubPanel(String diagramTitle, Component diagramComponent) {
        JTabbedPane tabbedPane;
        int currentDiagramIndex = this.getSavePanelIndex();
        Component currentComponent = this.getDiagramAt(currentDiagramIndex);
        if (!(currentComponent instanceof JTabbedPane)) {
            tabbedPane = new JTabbedPane();
            String savePanelTitle = this.getSavePanelTitle(currentDiagramIndex);
            tabbedPane.addTab(savePanelTitle, currentComponent);
            this.titleMap.remove(currentComponent);
            this.titleMap.put(tabbedPane, savePanelTitle);
            this.diagramArray.set(currentDiagramIndex, tabbedPane);
            this.setSelectedDiagram(currentDiagramIndex);
        } else {
            tabbedPane = (JTabbedPane)currentComponent;
        }
        tabbedPane.addTab(diagramTitle, diagramComponent);
    }

    Component getSelectedDiagram() {
        if (this.mainPanel.getComponents().length > 0) {
            return this.mainPanel.getComponent(0);
        }
        return null;
    }

    public void setSelectedDiagram(Component diagramComponent) {
        this.mainPanel.removeAll();
        String diagramTitle = null;
        if (diagramComponent != null) {
            this.mainPanel.add(diagramComponent, "Center");
            diagramTitle = this.titleMap.get(diagramComponent);
        }
        if (this.mainFrame != null) {
            this.setWindowTitle(this.mainFrame, diagramTitle);
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public void setSelectedDiagram(int diagramIndex) {
        if (this.diagramArray.size() > diagramIndex) {
            this.setSelectedDiagram(this.diagramArray.get(diagramIndex));
        } else {
            this.setSelectedDiagram(null);
        }
    }

    public int getSavePanelIndex() {
        return this.diagramArray.indexOf(this.getSelectedDiagram());
    }

    public String getSavePanelTitle(int selectedIndex) {
        return this.titleMap.get(this.diagramArray.get(selectedIndex));
    }

    Component getDiagramAt(int diagramIndex) {
        return this.diagramArray.get(diagramIndex);
    }

    public void closeSavePanel(int selectedIndex) {
        this.titleMap.remove(this.diagramArray.get(selectedIndex));
        this.diagramArray.remove(selectedIndex);
        while (this.diagramArray.size() <= selectedIndex && selectedIndex > 0) {
            --selectedIndex;
        }
        this.setSelectedDiagram(selectedIndex);
    }

    public void setDiagramTitle(int diagramIndex, String diagramTitle) {
        this.titleMap.put(this.getSelectedDiagram(), diagramTitle);
        if (this.mainFrame != null) {
            this.setWindowTitle(this.mainFrame, diagramTitle);
        }
    }

    public Component[] getAllDiagrams() {
        return this.diagramArray.toArray(new Component[0]);
    }
}

