/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.TemplateDialogue;

public class CmdiProfilesPanel
extends JPanel {
    private JPanel clarinPanel;
    private JPanel profileReloadPanel;
    private JProgressBar profileReloadProgressBar;
    protected JCheckBox profileSelectionCheckBox;
    private JScrollPane clarinScrollPane;
    private JButton reloadButton;
    private JDialog parentFrame;

    public CmdiProfilesPanel(JDialog parentFrameLocal) {
        this.parentFrame = parentFrameLocal;
        this.profileReloadPanel = new JPanel();
        this.profileReloadProgressBar = new JProgressBar();
        this.clarinScrollPane = new JScrollPane();
        this.profileSelectionCheckBox = new JCheckBox();
        this.reloadButton = new JButton();
        this.clarinPanel = new JPanel();
        JPanel profileReloadTopPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.profileReloadPanel.setLayout(new BorderLayout());
        this.profileReloadPanel.setAlignmentX(2.0f);
        profileReloadTopPanel.setLayout(new BoxLayout(profileReloadTopPanel, 2));
        this.reloadButton.setText("Reload Clarin Profiles");
        this.reloadButton.setToolTipText("Download the latest clarin profiles");
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadButtonActionPerformed(evt);
            }
        });
        this.profileSelectionCheckBox.setText("Only load profiles selected for manual editing");
        this.profileSelectionCheckBox.setSelected(CmdiProfileReader.getSingleInstance().getSelection() == CmdiProfileReader.ProfileSelection.SELECTED);
        profileReloadTopPanel.add(this.reloadButton);
        profileReloadTopPanel.add(this.profileReloadProgressBar);
        this.profileReloadPanel.add((Component)profileReloadTopPanel, "Center");
        this.profileReloadPanel.add((Component)this.profileSelectionCheckBox, "South");
        this.add((Component)this.profileReloadPanel, "Last");
        this.clarinScrollPane.setViewportView(this.clarinPanel);
        this.add((Component)this.clarinScrollPane, "Center");
        JPanel profilesTopPanel = new JPanel();
        profilesTopPanel.setLayout(new BoxLayout(profilesTopPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("Add URL");
        addButton.setToolTipText("Add a profile URL to the list");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newDirectoryName = JOptionPane.showInputDialog(ArbilWindowManager.getSingleInstance().linorgFrame, "Enter the profile URL", "Add Profile", -1, null, null, null).toString();
                ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + newDirectoryName);
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopPanel.add(addButton);
        JButton browseButton = new JButton();
        browseButton.setText("Add File");
        browseButton.setToolTipText("Browse for local profiles");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (File selectedFile : ArbilWindowManager.getSingleInstance().showFileSelectBox("Select Profile", false, true, false)) {
                    ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + selectedFile.toURI().toString());
                }
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopPanel.add(browseButton);
        this.add((Component)profilesTopPanel, "First");
    }

    public void loadProfiles(final boolean forceUpdate) {
        CmdiProfileReader.getSingleInstance().setSelection(this.profileSelectionCheckBox.isSelected() ? CmdiProfileReader.ProfileSelection.SELECTED : CmdiProfileReader.ProfileSelection.ALL);
        this.clarinPanel.removeAll();
        this.clarinPanel.add(new JTextField("Loading, please wait..."));
        this.reloadButton.setVisible(false);
        this.profileSelectionCheckBox.setEnabled(false);
        this.profileReloadProgressBar.setVisible(true);
        this.doLayout();
        new Thread("loadProfiles"){

            public void run() {
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                cmdiProfileReader.refreshProfiles(CmdiProfilesPanel.this.profileReloadProgressBar, forceUpdate);
                CmdiProfilesPanel.this.profileReloadProgressBar.setVisible(false);
                CmdiProfilesPanel.this.reloadButton.setVisible(true);
                CmdiProfilesPanel.this.profileSelectionCheckBox.setEnabled(true);
                CmdiProfilesPanel.this.populateList();
                CmdiProfilesPanel.this.doLayout();
            }
        }.start();
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        this.loadProfiles(true);
    }

    public void populateList() {
        this.populateProfilesList();
        this.parentFrame.pack();
    }

    protected void populateProfilesList() {
        ArrayList<String> selectedTamplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplateArrayList();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
        for (CmdiProfileReader.CmdiProfile currentCmdiProfile : cmdiProfileReader.cmdiProfileArray) {
            String templateId = "clarin:" + currentCmdiProfile.getXsdHref();
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(currentCmdiProfile.name);
            clarinProfileCheckBox.setName(currentCmdiProfile.name);
            clarinProfileCheckBox.setActionCommand(templateId);
            clarinProfileCheckBox.setSelected(selectedTamplates.contains(templateId));
            clarinProfileCheckBox.setToolTipText(currentCmdiProfile.description);
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            checkBoxArray.add(clarinProfileCheckBox);
        }
        for (String currentSepectedProfile : selectedTamplates) {
            if (!currentSepectedProfile.startsWith("custom:")) continue;
            String customUrlString = currentSepectedProfile.substring("custom:".length());
            String customName = currentSepectedProfile.substring(currentSepectedProfile.lastIndexOf("/") + 1);
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(customName);
            clarinProfileCheckBox.setName(customName);
            clarinProfileCheckBox.setActionCommand(currentSepectedProfile);
            clarinProfileCheckBox.setSelected(true);
            clarinProfileCheckBox.setToolTipText("custom profile, uncheck to remove");
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            checkBoxArray.add(clarinProfileCheckBox);
        }
        TemplateDialogue.addSorted(this.clarinPanel, checkBoxArray);
    }
}

