/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.importexport.ShibbolethNegotiator;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.SaveCurrentSettingsPanel;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.DownloadAbortFlag;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.XsdChecker;

public class ImportExportDialog {
    private JDialog searchDialog;
    private JPanel searchPanel;
    private JPanel inputNodePanel;
    private JPanel outputNodePanel;
    protected JCheckBox copyFilesCheckBox;
    protected JCheckBox renameFileToNodeName;
    protected JCheckBox renameFileToLamusFriendlyName;
    protected JCheckBox detailsCheckBox;
    protected JCheckBox overwriteCheckBox;
    protected JCheckBox shibbolethCheckBox;
    private JPanel shibbolethPanel;
    private JLabel resourceProgressLabel;
    private JProgressBar progressBar;
    private JLabel diskSpaceLabel;
    JPanel detailsPanel;
    JPanel bottomPanel;
    private JLabel progressFoundLabel;
    private JLabel progressProcessedLabel;
    private JLabel progressAlreadyInCacheLabel;
    private JLabel progressFailedLabel;
    private JLabel progressXmlErrorsLabel;
    private JLabel resourceCopyErrorsLabel;
    private JButton showInTableButton;
    String progressFoundLabelText = "Total Metadata Files Found: ";
    String progressProcessedLabelText = "Total Metadata Files Processed: ";
    String progressAlreadyInCacheLabelText = "Metadata Files already in Local Corpus: ";
    String progressFailedLabelText = "Metadata File Copy Errors: ";
    String progressXmlErrorsLabelText = "Metadata File Validation Errors: ";
    String resourceCopyErrorsLabelText = "Resource File Copy Errors: ";
    String diskFreeLabelText = "Total Disk Free: ";
    private JButton stopButton;
    private JButton startButton;
    private JTabbedPane detailsTabPane;
    private JTextArea taskOutput;
    private JTextArea xmlOutput;
    private JTextArea resourceCopyOutput;
    private boolean stopSearch = false;
    protected Vector<ArbilDataNode> selectedNodes;
    ArbilDataNode destinationNode = null;
    protected File exportDestinationDirectory = null;
    DownloadAbortFlag downloadAbortFlag = new DownloadAbortFlag();
    ShibbolethNegotiator shibbolethNegotiator = null;
    Vector<URI> validationErrors = new Vector();
    Vector<URI> metaDataCopyErrors = new Vector();
    Vector<URI> fileCopyErrors = new Vector();
    private static TreeHelper treeHelper;
    private static DataNodeLoader dataNodeLoader;
    private static SessionStorage sessionStorage;

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    private void setNodesPanel(ArbilDataNode selectedNode, JPanel nodePanel) {
        JLabel currentLabel = new JLabel(selectedNode.toString(), selectedNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setNodesPanel(Vector selectedNodes, JPanel nodePanel) {
        Enumeration selectedNodesEnum = selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            ArbilDataNode currentNode = (ArbilDataNode)selectedNodesEnum.nextElement();
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            nodePanel.add(currentLabel);
        }
    }

    private void setLocalCacheToNodesPanel(JPanel nodePanel) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalCorpusTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(rootArbilNode.toString(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setLocalFileToNodesPanel(JPanel nodePanel, File destinationDirectory) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalDirectoryTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(destinationDirectory.getPath(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    public void importArbilBranch() {
        File[] selectedFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Import", false, true, true);
        if (selectedFiles != null) {
            Vector<ArbilDataNode> importNodeVector = new Vector<ArbilDataNode>();
            for (File currentFile : selectedFiles) {
                ArbilDataNode nodeToImport = dataNodeLoader.getArbilDataNode(null, currentFile.toURI());
                importNodeVector.add(nodeToImport);
            }
            this.copyToCache(importNodeVector);
        }
    }

    public void selectExportDirectoryAndExport(ArbilDataNode[] localCorpusSelectedNodes) {
        this.searchDialog.setTitle("Export Branch");
        File destinationDirectory = ArbilWindowManager.getSingleInstance().showEmptyExportDirectoryDialogue(this.searchDialog.getTitle());
        if (destinationDirectory != null) {
            this.exportFromCache(new Vector<ArbilDataNode>(Arrays.asList(localCorpusSelectedNodes)), destinationDirectory);
        }
    }

    private void exportFromCache(Vector localSelectedNodes, File destinationDirectory) {
        this.selectedNodes = localSelectedNodes;
        if (!this.selectedNodesContainDataNode()) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No relevant nodes are selected", this.searchDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        this.setLocalFileToNodesPanel(this.outputNodePanel, destinationDirectory);
        this.exportDestinationDirectory = destinationDirectory;
        this.searchDialog.setVisible(true);
    }

    public void copyToCache(ArbilDataNode[] localSelectedNodes) {
        this.copyToCache(new Vector<ArbilDataNode>(Arrays.asList(localSelectedNodes)));
    }

    public void setDestinationNode(ArbilDataNode localDestinationNode) {
        this.destinationNode = localDestinationNode;
        this.setNodesPanel(this.destinationNode, this.outputNodePanel);
    }

    public void copyToCache(Vector localSelectedNodes) {
        this.selectedNodes = localSelectedNodes;
        this.searchDialog.setTitle("Import Branch");
        if (!this.selectedNodesContainDataNode()) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No relevant nodes are selected", this.searchDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        if (this.destinationNode == null) {
            this.setLocalCacheToNodesPanel(this.outputNodePanel);
        }
        this.searchDialog.setVisible(true);
    }

    private boolean selectedNodesContainDataNode() {
        Enumeration<ArbilDataNode> selectedNodesEnum = this.selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            if (!(selectedNodesEnum.nextElement() instanceof ArbilDataNode)) continue;
            return true;
        }
        return false;
    }

    private void showDetails(boolean showFlag) {
        if (!showFlag || this.detailsTabPane.isVisible() != showFlag) {
            this.detailsTabPane.setVisible(showFlag);
            this.bottomPanel.setVisible(showFlag);
            this.copyFilesCheckBox.setVisible(showFlag);
            this.renameFileToNodeName.setVisible(showFlag && this.exportDestinationDirectory != null);
            this.renameFileToLamusFriendlyName.setVisible(showFlag && this.exportDestinationDirectory != null);
            this.overwriteCheckBox.setVisible(showFlag && this.exportDestinationDirectory == null);
            this.shibbolethCheckBox.setVisible(showFlag && this.copyFilesCheckBox.isSelected());
            this.shibbolethPanel.setVisible(showFlag && this.copyFilesCheckBox.isSelected());
            this.outputNodePanel.setVisible(false);
            this.inputNodePanel.setVisible(false);
            this.outputNodePanel.setVisible(true);
            this.inputNodePanel.setVisible(true);
            System.out.println(this.searchDialog.getSize());
            if (showFlag) {
                this.searchDialog.setMinimumSize(new Dimension(467, 500));
            } else {
                this.searchDialog.setMinimumSize(new Dimension(316, 126));
                this.searchDialog.setSize(new Dimension(316, 126));
            }
            this.searchDialog.setResizable(showFlag);
        }
    }

    public ImportExportDialog(Component targetComponent) throws Exception {
        ArbilWindowManager.getSingleInstance().offerUserToSaveChanges();
        this.searchDialog = new JDialog(JOptionPane.getFrameForComponent(ArbilWindowManager.getSingleInstance().linorgFrame), true);
        this.searchDialog.addWindowStateListener(new WindowAdapter(){

            public void windowStateChanged(WindowEvent e) {
                if ((e.getNewState() & 6) == 6) {
                    ImportExportDialog.this.detailsCheckBox.setSelected(true);
                    ImportExportDialog.this.showDetails(true);
                } else {
                    ImportExportDialog.this.searchDialog.pack();
                }
            }
        });
        this.searchDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportExportDialog.this.stopSearch = true;
                ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
            }
        });
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchDialog.getContentPane().setLayout(new BorderLayout());
        this.searchDialog.add((Component)this.searchPanel, "Center");
        JPanel inOutNodePanel = new JPanel();
        inOutNodePanel.setLayout(new BoxLayout(inOutNodePanel, 3));
        JPanel inputNodeLabelPanel = new JPanel();
        inputNodeLabelPanel.setLayout(new BorderLayout());
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        inputNodeLabelPanel.add((Component)new JLabel("From: "), "Before");
        inputNodeLabelPanel.add((Component)this.inputNodePanel, "Center");
        inOutNodePanel.add(inputNodeLabelPanel);
        JPanel outputNodeLabelPanel = new JPanel();
        outputNodeLabelPanel.setLayout(new BorderLayout());
        this.outputNodePanel = new JPanel();
        this.outputNodePanel.setLayout(new GridLayout());
        outputNodeLabelPanel.add((Component)new JLabel("To: "), "Before");
        outputNodeLabelPanel.add((Component)this.outputNodePanel, "Center");
        inOutNodePanel.add(outputNodeLabelPanel);
        this.detailsCheckBox = new JCheckBox("Show Details and Options", false);
        this.detailsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.showDetails(ImportExportDialog.this.detailsCheckBox.isSelected());
                    ImportExportDialog.this.searchDialog.pack();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        JPanel detailsCheckBoxPanel = new JPanel();
        detailsCheckBoxPanel.setLayout(new GridLayout());
        detailsCheckBoxPanel.add(this.detailsCheckBox);
        inOutNodePanel.add(detailsCheckBoxPanel);
        this.searchPanel.add((Component)inOutNodePanel, "North");
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BorderLayout());
        this.copyFilesCheckBox = new JCheckBox("Copy Resource Files (if available)", false);
        this.renameFileToNodeName = new JCheckBox("Rename Metadata Files (to match local corpus tree names)", true);
        this.renameFileToLamusFriendlyName = new JCheckBox("Limit Characters in File Names (LAMUS friendly format)", true);
        this.overwriteCheckBox = new JCheckBox("Overwrite Local Changes", false);
        this.shibbolethCheckBox = new JCheckBox("Shibboleth authentication via the SURFnet method", false);
        this.shibbolethCheckBox.setEnabled(false);
        this.shibbolethPanel = new JPanel();
        this.shibbolethCheckBox.setVisible(false);
        this.shibbolethPanel.setVisible(false);
        this.shibbolethCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImportExportDialog.this.shibbolethCheckBox.isSelected()) {
                    if (ImportExportDialog.this.shibbolethNegotiator == null) {
                        ImportExportDialog.this.shibbolethNegotiator = new ShibbolethNegotiator();
                    }
                    ImportExportDialog.this.shibbolethPanel.add(ImportExportDialog.this.shibbolethNegotiator.getControlls());
                } else {
                    ImportExportDialog.this.shibbolethPanel.removeAll();
                    ImportExportDialog.this.shibbolethNegotiator = null;
                }
                ImportExportDialog.this.searchDialog.pack();
            }
        });
        this.copyFilesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.shibbolethCheckBox.setVisible(ImportExportDialog.this.copyFilesCheckBox.isSelected());
                ImportExportDialog.this.shibbolethPanel.setVisible(ImportExportDialog.this.copyFilesCheckBox.isSelected());
                ImportExportDialog.this.searchDialog.pack();
            }
        });
        JPanel detailsTopPanel = new JPanel();
        detailsTopPanel.setLayout(new BoxLayout(detailsTopPanel, 3));
        JPanel detailsTopCheckBoxPanel = new JPanel();
        detailsTopCheckBoxPanel.setLayout(new BoxLayout(detailsTopCheckBoxPanel, 3));
        detailsTopCheckBoxPanel.add(this.renameFileToNodeName);
        detailsTopCheckBoxPanel.add(this.renameFileToLamusFriendlyName);
        detailsTopCheckBoxPanel.add(this.overwriteCheckBox);
        detailsTopCheckBoxPanel.add(this.copyFilesCheckBox);
        detailsTopCheckBoxPanel.add(this.shibbolethCheckBox);
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BoxLayout(paddingPanel, 2));
        JPanel leftPadding = new JPanel();
        leftPadding.setMaximumSize(new Dimension(500, 100));
        paddingPanel.add(leftPadding);
        paddingPanel.add(detailsTopCheckBoxPanel);
        paddingPanel.add(new JPanel());
        detailsTopPanel.add(paddingPanel);
        detailsTopPanel.add(this.shibbolethPanel);
        this.detailsPanel.add((Component)detailsTopPanel, "North");
        this.detailsTabPane = new JTabbedPane();
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.detailsTabPane.add("Process Details", new JScrollPane(this.taskOutput));
        this.xmlOutput = new JTextArea(5, 20);
        this.xmlOutput.setMargin(new Insets(5, 5, 5, 5));
        this.xmlOutput.setEditable(false);
        this.detailsTabPane.add("Validation Errors", new JScrollPane(this.xmlOutput));
        this.resourceCopyOutput = new JTextArea(5, 20);
        this.resourceCopyOutput.setMargin(new Insets(5, 5, 5, 5));
        this.resourceCopyOutput.setEditable(false);
        this.detailsTabPane.add("Resource Copy Errors", new JScrollPane(this.resourceCopyOutput));
        this.detailsPanel.add((Component)this.detailsTabPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 3));
        this.progressFoundLabel = new JLabel(this.progressFoundLabelText);
        this.progressProcessedLabel = new JLabel(this.progressProcessedLabelText);
        this.progressAlreadyInCacheLabel = new JLabel(this.progressAlreadyInCacheLabelText);
        this.progressFailedLabel = new JLabel(this.progressFailedLabelText);
        this.progressXmlErrorsLabel = new JLabel(this.progressXmlErrorsLabelText);
        this.resourceCopyErrorsLabel = new JLabel(this.resourceCopyErrorsLabelText);
        this.showInTableButton = new JButton("Show errors in table");
        this.diskSpaceLabel = new JLabel(this.diskFreeLabelText);
        this.progressAlreadyInCacheLabel.setForeground(Color.darkGray);
        this.progressFailedLabel.setForeground(Color.red);
        this.progressXmlErrorsLabel.setForeground(Color.red);
        this.resourceCopyErrorsLabel.setForeground(Color.red);
        this.bottomPanel.add(new SaveCurrentSettingsPanel(this, null));
        this.bottomPanel.add(this.progressFoundLabel);
        this.bottomPanel.add(this.progressProcessedLabel);
        this.bottomPanel.add(this.progressAlreadyInCacheLabel);
        this.bottomPanel.add(this.progressFailedLabel);
        this.bottomPanel.add(this.progressXmlErrorsLabel);
        this.bottomPanel.add(this.resourceCopyErrorsLabel);
        this.bottomPanel.add(this.showInTableButton);
        this.bottomPanel.add(this.diskSpaceLabel);
        this.resourceProgressLabel = new JLabel(" ");
        this.bottomPanel.add(this.resourceProgressLabel);
        this.detailsPanel.add((Component)this.bottomPanel, "South");
        this.searchPanel.add((Component)this.detailsPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.stopButton = new JButton("Stop");
        this.startButton = new JButton("Start");
        this.stopButton.setEnabled(false);
        buttonsPanel.add(this.stopButton);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        buttonsPanel.add(this.progressBar);
        buttonsPanel.add(this.startButton);
        this.searchPanel.add((Component)buttonsPanel, "South");
        this.searchDialog.setLocationRelativeTo(targetComponent);
        this.showInTableButton.setEnabled(false);
        this.showInTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ImportExportDialog.this.metaDataCopyErrors.size() > 0) {
                        ArbilWindowManager.getSingleInstance().openFloatingTableOnce(ImportExportDialog.this.metaDataCopyErrors.toArray(new URI[0]), ImportExportDialog.this.progressFailedLabelText);
                    }
                    if (ImportExportDialog.this.validationErrors.size() > 0) {
                        ArbilWindowManager.getSingleInstance().openAllChildNodesInFloatingTableOnce(ImportExportDialog.this.validationErrors.toArray(new URI[0]), ImportExportDialog.this.progressXmlErrorsLabelText);
                    }
                    if (ImportExportDialog.this.fileCopyErrors.size() > 0) {
                        ArbilTableModel resourceFileErrorsTable = ArbilWindowManager.getSingleInstance().openFloatingTableOnceGetModel(ImportExportDialog.this.fileCopyErrors.toArray(new URI[0]), ImportExportDialog.this.resourceCopyErrorsLabelText);
                        resourceFileErrorsTable.addChildTypeToDisplay("MediaFiles");
                        resourceFileErrorsTable.addChildTypeToDisplay("WrittenResources");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.performCopy();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.stopSearch = true;
                    ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
                    ImportExportDialog.this.stopButton.setEnabled(false);
                    ImportExportDialog.this.startButton.setEnabled(false);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.taskOutput.append("The details of the import / export process will be displayed here.\n");
        this.xmlOutput.append("When the metadata files are imported or exported they will be validated (for XML schema conformance) and any errors will be reported here.\n");
        this.resourceCopyOutput.append("If copying of resource files is selected, any file copy errors will be reported here.\n");
        this.showDetails(this.detailsCheckBox.isSelected());
        this.searchDialog.pack();
    }

    private void appendToTaskOutput(String lineOfText) {
        this.taskOutput.append(lineOfText + "\n");
        this.taskOutput.setCaretPosition(this.taskOutput.getText().length());
    }

    private void setUItoRunningState() {
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.showInTableButton.setEnabled(false);
        this.taskOutput.setCursor(Cursor.getPredefinedCursor(3));
        this.searchDialog.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setUItoStoppedState() {
        Toolkit.getDefaultToolkit().beep();
        this.taskOutput.setCursor(null);
        this.searchDialog.setCursor(null);
        this.progressBar.setIndeterminate(false);
        this.resourceProgressLabel.setText(" ");
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(this.selectedNodes.size() > 0);
        this.showInTableButton.setEnabled(this.validationErrors.size() > 0 || this.metaDataCopyErrors.size() > 0 || this.fileCopyErrors.size() > 0);
        this.stopSearch = false;
        this.downloadAbortFlag.abortDownload = false;
    }

    private void waitTillVisible() {
        while (!this.searchDialog.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                GuiHelper.linorgBugCatcher.logError(ignore);
            }
        }
    }

    private void performCopy() {
        this.setUItoRunningState();
        this.createPerformCopyThread("performCopy").start();
    }

    private Thread createPerformCopyThread(String threadName) {
        return new Thread(threadName){
            int freeGbWarningPoint;
            int xsdErrors;
            int totalLoaded;
            int totalErrors;
            int totalExisting;
            int resourceCopyErrors;
            String finalMessageString;
            File directoryForSizeTest;
            boolean testFreeSpace;
            {
                this.freeGbWarningPoint = 3;
                this.xsdErrors = 0;
                this.totalLoaded = 0;
                this.totalErrors = 0;
                this.totalExisting = 0;
                this.resourceCopyErrors = 0;
                this.finalMessageString = "";
            }

            @Override
            public void run() {
                String javaVersionString = System.getProperty("java.version");
                this.testFreeSpace = !javaVersionString.startsWith("1.4.") && !javaVersionString.startsWith("1.5.");
                File file = this.directoryForSizeTest = ImportExportDialog.this.exportDestinationDirectory != null ? ImportExportDialog.this.exportDestinationDirectory : sessionStorage.getCacheDirectory();
                if (ImportExportDialog.this.copyFilesCheckBox.isSelected()) {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is selected: Resource files will be downloaded where appropriate permission are granted.\n");
                } else {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is not selected: No resource files will be downloaded, however they will be still accessible via the web server.\n");
                }
                try {
                    this.copyElements(ImportExportDialog.this.selectedNodes.elements());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                    this.finalMessageString = this.finalMessageString + "There was a critical error.";
                }
                ImportExportDialog.this.setUItoStoppedState();
                System.out.println("finalMessageString: " + this.finalMessageString);
                Object[] options = new Object[]{"Close", "Details"};
                int detailsOption = JOptionPane.showOptionDialog(ArbilWindowManager.getSingleInstance().linorgFrame, this.finalMessageString, ImportExportDialog.this.searchDialog.getTitle(), 0, -1, null, options, options[0]);
                if (detailsOption == 0) {
                    ImportExportDialog.this.searchDialog.setVisible(false);
                } else if (!ImportExportDialog.this.detailsCheckBox.isSelected()) {
                    ImportExportDialog.this.detailsCheckBox.setSelected(true);
                    ImportExportDialog.this.showDetails(true);
                    ImportExportDialog.this.searchDialog.pack();
                }
                if (ImportExportDialog.this.exportDestinationDirectory != null) {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(ImportExportDialog.this.exportDestinationDirectory.toURI());
                }
            }

            private void copyElements(Enumeration selectedNodesEnum) {
                XsdChecker xsdChecker = new XsdChecker();
                ImportExportDialog.this.waitTillVisible();
                ImportExportDialog.this.progressBar.setIndeterminate(true);
                ArrayList<ArbilDataNode> finishedTopNodes = new ArrayList<ArbilDataNode>();
                Hashtable<URI, RetrievableFile> seenFiles = new Hashtable<URI, RetrievableFile>();
                ArrayList<URI> getList = new ArrayList<URI>();
                ArrayList<URI> doneList = new ArrayList<URI>();
                while (selectedNodesEnum.hasMoreElements() && !ImportExportDialog.this.stopSearch) {
                    Object currentElement = selectedNodesEnum.nextElement();
                    if (!(currentElement instanceof ArbilDataNode)) continue;
                    this.copyElement(currentElement, getList, seenFiles, doneList, xsdChecker, finishedTopNodes);
                }
                this.finalMessageString = this.finalMessageString + "Processed " + this.totalLoaded + " Metadata Files.\n";
                if (ImportExportDialog.this.exportDestinationDirectory == null) {
                    if (!ImportExportDialog.this.stopSearch) {
                        for (ArbilDataNode currentFinishedNode : finishedTopNodes) {
                            if (ImportExportDialog.this.destinationNode != null) {
                                if (!ImportExportDialog.this.destinationNode.getURI().equals(currentFinishedNode.getURI())) {
                                    ImportExportDialog.this.destinationNode.addCorpusLink(currentFinishedNode);
                                }
                            } else if (!treeHelper.addLocation(currentFinishedNode.getURI())) {
                                this.finalMessageString = this.finalMessageString + "The location:\n" + currentFinishedNode + "\nalready exists and need not be added again\n";
                            }
                            currentFinishedNode.reloadNode();
                        }
                    }
                    if (ImportExportDialog.this.destinationNode == null) {
                        treeHelper.applyRootLocations();
                    } else {
                        ImportExportDialog.this.destinationNode.reloadNode();
                    }
                }
                ImportExportDialog.this.progressBar.setIndeterminate(false);
                if (this.totalErrors != 0) {
                    this.finalMessageString = this.finalMessageString + "There were " + this.totalErrors + " errors, some files may not have been copied.\n";
                }
                if (this.xsdErrors != 0) {
                    this.finalMessageString = this.finalMessageString + "There were " + this.xsdErrors + " files that failed to validate and have xml errors.\n";
                }
                if (ImportExportDialog.this.stopSearch) {
                    ImportExportDialog.this.appendToTaskOutput("copy canceled");
                    System.out.println("copy canceled");
                    this.finalMessageString = this.finalMessageString + "The process was canceled, some files may not have been copied.\n";
                } else {
                    ImportExportDialog.this.selectedNodes.removeAllElements();
                }
            }

            private void copyElement(Object currentElement, ArrayList<URI> getList, Hashtable<URI, RetrievableFile> seenFiles, ArrayList<URI> doneList, XsdChecker xsdChecker, ArrayList<ArbilDataNode> finishedTopNodes) {
                URI currentGettableUri = ((ArbilDataNode)currentElement).getParentDomNode().getURI();
                getList.add(currentGettableUri);
                if (!seenFiles.containsKey(currentGettableUri)) {
                    seenFiles.put(currentGettableUri, new RetrievableFile(((ArbilDataNode)currentElement).getParentDomNode().getURI(), ImportExportDialog.this.exportDestinationDirectory));
                }
                while (!ImportExportDialog.this.stopSearch && getList.size() > 0) {
                    RetrievableFile currentRetrievableFile = seenFiles.get(getList.remove(0));
                    this.copyFile(currentRetrievableFile, seenFiles, doneList, getList, xsdChecker);
                }
                if (ImportExportDialog.this.exportDestinationDirectory == null) {
                    File newNodeLocation = sessionStorage.getSaveLocation(((ArbilDataNode)currentElement).getParentDomNode().getUrlString());
                    finishedTopNodes.add(dataNodeLoader.getArbilDataNodeWithoutLoading(newNodeLocation.toURI()));
                }
            }

            private void copyFile(RetrievableFile currentRetrievableFile, Hashtable<URI, RetrievableFile> seenFiles, ArrayList<URI> doneList, ArrayList<URI> getList, XsdChecker xsdChecker) {
                try {
                    if (!doneList.contains(currentRetrievableFile.sourceURI)) {
                        boolean replacingExitingFile;
                        String journalActionString;
                        if (ImportExportDialog.this.exportDestinationDirectory == null) {
                            currentRetrievableFile.calculateUriFileName();
                            journalActionString = "import";
                        } else {
                            if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                                currentRetrievableFile.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected());
                            } else {
                                currentRetrievableFile.calculateUriFileName();
                            }
                            journalActionString = "export";
                        }
                        MetadataUtils currentMetdataUtil = ArbilDataNode.getMetadataUtils(currentRetrievableFile.sourceURI.toString());
                        if (currentMetdataUtil == null) {
                            throw new ArbilMetadataException("Metadata format could not be determined");
                        }
                        ArrayList<URI[]> uncopiedLinks = new ArrayList<URI[]>();
                        URI[] linksUriArray = currentMetdataUtil.getCorpusLinks(currentRetrievableFile.sourceURI);
                        if (linksUriArray != null) {
                            this.copyLinks(linksUriArray, seenFiles, currentRetrievableFile, getList, uncopiedLinks);
                        }
                        boolean bl = replacingExitingFile = currentRetrievableFile.destinationFile.exists() && ImportExportDialog.this.overwriteCheckBox.isSelected();
                        if (currentRetrievableFile.destinationFile.exists()) {
                            ++this.totalExisting;
                        }
                        if (currentRetrievableFile.destinationFile.exists() && !ImportExportDialog.this.overwriteCheckBox.isSelected()) {
                            ImportExportDialog.this.appendToTaskOutput(currentRetrievableFile.sourceURI.toString());
                            ImportExportDialog.this.appendToTaskOutput("Destination already exists, skipping file: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                        } else {
                            ArbilDataNode destinationNode;
                            if (replacingExitingFile) {
                                ImportExportDialog.this.appendToTaskOutput("Replaced: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                            }
                            if ((destinationNode = dataNodeLoader.getArbilDataNodeWithoutLoading(currentRetrievableFile.destinationFile.toURI())).getNeedsSaveToDisk(false)) {
                                destinationNode.saveChangesToCache(true);
                            }
                            if (destinationNode.hasHistory()) {
                                destinationNode.bumpHistory();
                            }
                            if (!currentRetrievableFile.destinationFile.getParentFile().exists() && !currentRetrievableFile.destinationFile.getParentFile().mkdir()) {
                                GuiHelper.linorgBugCatcher.logError(new IOException("Could not create missing parent directory for " + currentRetrievableFile.destinationFile));
                            }
                            currentMetdataUtil.copyMetadataFile(currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, (URI[][])uncopiedLinks.toArray((T[])new URI[0][]), true);
                            ArbilJournal.getSingleInstance().saveJournalEntry(currentRetrievableFile.destinationFile.getAbsolutePath(), "", currentRetrievableFile.sourceURI.toString(), "", journalActionString);
                            String checkerResult = xsdChecker.simpleCheck(currentRetrievableFile.destinationFile, currentRetrievableFile.sourceURI);
                            if (checkerResult != null) {
                                ImportExportDialog.this.xmlOutput.append(currentRetrievableFile.sourceURI.toString() + "\n");
                                ImportExportDialog.this.xmlOutput.append("destination path: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                                System.out.println("checkerResult: " + checkerResult);
                                ImportExportDialog.this.xmlOutput.append(checkerResult + "\n");
                                ImportExportDialog.this.xmlOutput.setCaretPosition(ImportExportDialog.this.xmlOutput.getText().length() - 1);
                                ImportExportDialog.this.validationErrors.add(currentRetrievableFile.sourceURI);
                                ++this.xsdErrors;
                            }
                            if (replacingExitingFile) {
                                dataNodeLoader.requestReloadOnlyIfLoaded(currentRetrievableFile.destinationFile.toURI());
                            }
                        }
                    }
                }
                catch (ArbilMetadataException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI + " (" + ex.getMessage() + ")");
                }
                catch (MalformedURLException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI);
                    System.out.println("Error getting links from: " + currentRetrievableFile.sourceURI);
                }
                catch (IOException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI);
                }
                ++this.totalLoaded;
                ImportExportDialog.this.progressFoundLabel.setText(ImportExportDialog.this.progressFoundLabelText + (getList.size() + this.totalLoaded));
                ImportExportDialog.this.progressProcessedLabel.setText(ImportExportDialog.this.progressProcessedLabelText + this.totalLoaded);
                ImportExportDialog.this.progressAlreadyInCacheLabel.setText(ImportExportDialog.this.progressAlreadyInCacheLabelText + this.totalExisting);
                ImportExportDialog.this.progressFailedLabel.setText(ImportExportDialog.this.progressFailedLabelText + this.totalErrors);
                ImportExportDialog.this.progressXmlErrorsLabel.setText(ImportExportDialog.this.progressXmlErrorsLabelText + this.xsdErrors);
                ImportExportDialog.this.resourceCopyErrorsLabel.setText(ImportExportDialog.this.resourceCopyErrorsLabelText + this.resourceCopyErrors);
                ImportExportDialog.this.progressBar.setString(this.totalLoaded + "/" + (getList.size() + this.totalLoaded) + " (" + (this.totalErrors + this.xsdErrors + this.resourceCopyErrors) + " errors)");
                if (this.testFreeSpace) {
                    this.testFreeSpace();
                }
            }

            private void copyLinks(URI[] linksUriArray, Hashtable<URI, RetrievableFile> seenFiles, RetrievableFile currentRetrievableFile, ArrayList<URI> getList, ArrayList<URI[]> uncopiedLinks) throws MalformedURLException {
                for (int linkCount = 0; linkCount < linksUriArray.length && !ImportExportDialog.this.stopSearch; ++linkCount) {
                    File downloadFileLocation;
                    System.out.println("Link: " + linksUriArray[linkCount].toString());
                    String currentLink = linksUriArray[linkCount].toString();
                    URI gettableLinkUri = linksUriArray[linkCount].normalize();
                    if (!seenFiles.containsKey(gettableLinkUri)) {
                        seenFiles.put(gettableLinkUri, new RetrievableFile(gettableLinkUri, currentRetrievableFile.childDestinationDirectory));
                    }
                    RetrievableFile retrievableLink = seenFiles.get(gettableLinkUri);
                    if (MetadataFormat.isPathMetadata(currentLink)) {
                        getList.add(gettableLinkUri);
                        if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                            retrievableLink.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected());
                        } else {
                            retrievableLink.calculateUriFileName();
                        }
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], retrievableLink.destinationFile.toURI()});
                        continue;
                    }
                    if (!ImportExportDialog.this.copyFilesCheckBox.isSelected()) {
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                        continue;
                    }
                    if (ImportExportDialog.this.exportDestinationDirectory == null) {
                        downloadFileLocation = sessionStorage.updateCache(currentLink, ImportExportDialog.this.shibbolethNegotiator, false, false, ImportExportDialog.this.downloadAbortFlag, ImportExportDialog.this.resourceProgressLabel);
                    } else {
                        if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                            retrievableLink.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected());
                        } else {
                            retrievableLink.calculateUriFileName();
                        }
                        if (!retrievableLink.destinationFile.getParentFile().exists() && !retrievableLink.destinationFile.getParentFile().mkdirs()) {
                            GuiHelper.linorgBugCatcher.logError(new IOException("Could not create missing parent directory for " + retrievableLink.destinationFile));
                        }
                        downloadFileLocation = retrievableLink.destinationFile;
                        ImportExportDialog.this.resourceProgressLabel.setText(" ");
                        sessionStorage.saveRemoteResource(new URL(currentLink), downloadFileLocation, ImportExportDialog.this.shibbolethNegotiator, true, false, ImportExportDialog.this.downloadAbortFlag, ImportExportDialog.this.resourceProgressLabel);
                        ImportExportDialog.this.resourceProgressLabel.setText(" ");
                    }
                    if (downloadFileLocation != null && downloadFileLocation.exists()) {
                        ImportExportDialog.this.appendToTaskOutput("Downloaded resource: " + downloadFileLocation.getAbsolutePath());
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], downloadFileLocation.toURI()});
                    } else {
                        ImportExportDialog.this.resourceCopyOutput.append("Download failed: " + currentLink + " \n");
                        ImportExportDialog.this.fileCopyErrors.add(currentRetrievableFile.sourceURI);
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                        ++this.resourceCopyErrors;
                    }
                    ImportExportDialog.this.resourceCopyOutput.setCaretPosition(ImportExportDialog.this.resourceCopyOutput.getText().length() - 1);
                }
            }

            private void testFreeSpace() {
                try {
                    int freeGBytes = (int)(this.directoryForSizeTest.getFreeSpace() / 0x40000000L);
                    ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + freeGBytes + "GB");
                    if (this.freeGbWarningPoint > freeGBytes) {
                        ImportExportDialog.this.progressBar.setIndeterminate(false);
                        if (0 == ArbilWindowManager.getSingleInstance().showDialogBox("There is only " + freeGBytes + "GB free space left on the disk.\nTo you still want to continue?", ImportExportDialog.this.searchDialog.getTitle(), 0, -1)) {
                            this.freeGbWarningPoint = freeGBytes - 1;
                        } else {
                            ImportExportDialog.this.stopSearch = true;
                        }
                        ImportExportDialog.this.progressBar.setIndeterminate(true);
                    }
                }
                catch (Exception ex) {
                    ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + "N/A");
                    this.testFreeSpace = false;
                }
            }
        };
    }

    private class RetrievableFile {
        URI sourceURI;
        File destinationDirectory;
        File childDestinationDirectory;
        File destinationFile;
        String fileSuffix;

        public RetrievableFile(URI sourceURILocal, File destinationDirectoryLocal) {
            this.sourceURI = sourceURILocal;
            this.destinationDirectory = destinationDirectoryLocal;
        }

        private String makeFileNameLamusFriendly(String fileNameString) {
            String friendlyFileName = fileNameString.replaceAll("[^A-Za-z0-9-]", "_");
            friendlyFileName = friendlyFileName.replaceAll("__+", "_");
            return friendlyFileName;
        }

        public void calculateUriFileName() {
            this.destinationFile = this.destinationDirectory != null ? sessionStorage.getExportPath(this.sourceURI.toString(), this.destinationDirectory.getPath()) : sessionStorage.getSaveLocation(this.sourceURI.toString());
            this.childDestinationDirectory = this.destinationDirectory;
        }

        public void calculateTreeFileName(boolean lamusFriendly) {
            String fileNameString;
            this.fileSuffix = this.sourceURI.toString().substring(this.sourceURI.toString().lastIndexOf("."));
            ArbilDataNode currentNode = dataNodeLoader.getArbilDataNode(null, this.sourceURI);
            currentNode.waitTillLoaded();
            if (currentNode.isMetaDataNode()) {
                fileNameString = currentNode.toString();
            } else {
                String urlString = this.sourceURI.toString();
                try {
                    urlString = URLDecoder.decode(urlString, "UTF-8");
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(urlString, ex);
                    ImportExportDialog.this.appendToTaskOutput("unable to decode the file name for: " + urlString);
                    System.out.println("unable to decode the file name for: " + urlString);
                }
                fileNameString = urlString.substring(urlString.lastIndexOf("/") + 1, urlString.lastIndexOf("."));
            }
            fileNameString = fileNameString.replace("\\", "_");
            fileNameString = fileNameString.replace("/", "_");
            if (lamusFriendly) {
                fileNameString = this.makeFileNameLamusFriendly(fileNameString);
            }
            if (fileNameString.length() < 1) {
                fileNameString = "unnamed";
            }
            this.destinationFile = new File(this.destinationDirectory, fileNameString + this.fileSuffix);
            this.childDestinationDirectory = new File(this.destinationDirectory, fileNameString);
            int fileCounter = 1;
            while (this.destinationFile.exists()) {
                if (lamusFriendly) {
                    this.destinationFile = new File(this.destinationDirectory, fileNameString + "_" + fileCounter + this.fileSuffix);
                    this.childDestinationDirectory = new File(this.destinationDirectory, fileNameString + "_" + fileCounter);
                } else {
                    this.destinationFile = new File(this.destinationDirectory, fileNameString + "(" + fileCounter + ")" + this.fileSuffix);
                    this.childDestinationDirectory = new File(this.destinationDirectory, fileNameString + "(" + fileCounter + ")");
                }
                ++fileCounter;
            }
        }
    }
}

