/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;

public class CsvImporter
extends EntityImporter
implements GenericImporter {
    public CsvImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal);
    }

    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".csv");
    }

    private String cleanCsvString(String valueString) {
        valueString = valueString.replaceAll("^\"", "");
        valueString = valueString.replaceAll("\"$", "");
        valueString = valueString.replaceAll("\"\"", "");
        return valueString;
    }

    public URI[] importFile(InputStreamReader inputStreamReader) {
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ImportTranslator importTranslator = new ImportTranslator(true);
        importTranslator.addTranslationEntry("Gender", "0", "Gender", "female");
        importTranslator.addTranslationEntry("Gender", "1", "Gender", "male");
        try {
            int maxImportCount = 10;
            String headingLine = bufferedReader.readLine();
            if (headingLine != null) {
                ArrayList<String> allHeadings = new ArrayList<String>();
                for (String headingString : headingLine.split(",")) {
                    String cleanHeading = this.cleanCsvString(headingString);
                    allHeadings.add(cleanHeading);
                }
                try {
                    String inputLine;
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        EntityDocument currentEntity = null;
                        EntityDocument relatedEntity = null;
                        String relatedEntityPrefix = null;
                        int valueCount = 0;
                        for (String entityLineString : inputLine.split(",")) {
                            String cleanValue = this.cleanCsvString(entityLineString);
                            String headingString = (String)allHeadings.get(valueCount);
                            if (currentEntity == null) {
                                currentEntity = this.getEntityDocument(createdNodes, "Entity", cleanValue, importTranslator);
                            } else if (cleanValue.length() > 0) {
                                if (headingString.matches("Spouses[\\d]*-ID")) {
                                    relatedEntity = this.getEntityDocument(createdNodes, "Entity", cleanValue, importTranslator);
                                    currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.union, DataTypes.RelationLineType.sanguineLine, null, null);
                                    relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                                } else if (headingString.matches("Parents[\\d]*-ID")) {
                                    relatedEntity = this.getEntityDocument(createdNodes, "Entity", cleanValue, importTranslator);
                                    currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.ancestor, DataTypes.RelationLineType.sanguineLine, null, null);
                                    relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                                } else if (headingString.matches("Children[\\d]*-ID")) {
                                    relatedEntity = this.getEntityDocument(createdNodes, "Entity", cleanValue, importTranslator);
                                    currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.descendant, DataTypes.RelationLineType.sanguineLine, null, null);
                                    relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                                } else if (relatedEntityPrefix != null && headingString.startsWith(relatedEntityPrefix)) {
                                    relatedEntity.insertValue(headingString.substring(relatedEntityPrefix.length()), cleanValue);
                                } else {
                                    currentEntity.insertValue(headingString, cleanValue);
                                }
                            }
                            ++valueCount;
                        }
                        super.incrementLineProgress();
                    }
                }
                catch (ImportException exception) {
                    this.appendToTaskOutput(exception.getMessage());
                }
            }
            this.saveAllDocuments();
        }
        catch (IOException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        return createdNodes.toArray(new URI[0]);
    }
}

