/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GedcomImporter
extends EntityImporter
implements GenericImporter {
    public GedcomImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal);
    }

    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".ged");
    }

    public URI[] importFile(InputStreamReader inputStreamReader) {
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        HashMap socialGroupRoleMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ImportTranslator importTranslator = new ImportTranslator(true);
        try {
            String strLine;
            int gedcomLevel = 0;
            ArrayList<String> gedcomLevelStrings = new ArrayList<String>();
            EntityDocument currentEntity = null;
            boolean skipFileEntity = false;
            while ((strLine = bufferedReader.readLine()) != null) {
                String lineContents;
                if (skipFileEntity) {
                    skipFileEntity = false;
                    while ((strLine = bufferedReader.readLine()) != null && !strLine.startsWith("0")) {
                    }
                }
                String[] lineParts = strLine.split(" ", 3);
                gedcomLevel = Integer.parseInt(lineParts[0]);
                while (gedcomLevelStrings.size() > gedcomLevel) {
                    gedcomLevelStrings.remove(gedcomLevelStrings.size() - 1);
                }
                gedcomLevelStrings.add(lineParts[1]);
                System.out.println(strLine);
                boolean lastFieldContinued = false;
                if (lineParts[1].equals("CONT")) {
                    lineContents = "";
                    if (lineParts.length > 2) {
                        lineContents = lineParts[2];
                    }
                    currentEntity.appendValueToLast("\n" + lineContents);
                    lastFieldContinued = true;
                } else if (lineParts[1].equals("CONC")) {
                    lineContents = "";
                    if (lineParts.length > 2) {
                        lineContents = lineParts[2];
                    }
                    currentEntity.appendValueToLast(lineContents);
                    lastFieldContinued = true;
                }
                if (!lastFieldContinued) {
                    if (gedcomLevel == 0) {
                        if (lineParts[1].equals("TRLR")) {
                            this.appendToTaskOutput("End of file found");
                        } else {
                            String typeString = lineParts.length > 2 ? lineParts[2] : lineParts[1];
                            currentEntity = this.getEntityDocument(createdNodes, typeString, lineParts[1], importTranslator);
                            if (lineParts[1].equals("HEAD")) {
                                this.appendToTaskOutput("Reading Gedcom Header");
                                currentEntity.appendValue(lineParts[1], null, gedcomLevel);
                            } else if (lineParts.length > 2) {
                                currentEntity.appendValue(lineParts[2], lineParts[1], gedcomLevel);
                            } else {
                                currentEntity.appendValue("gedcom-id", lineParts[1], gedcomLevel);
                            }
                        }
                    } else if (lineParts.length == 2) {
                        currentEntity.appendValue(lineParts[1], null, gedcomLevel);
                    } else if (lineParts.length > 2) {
                        currentEntity.appendValue(lineParts[1], lineParts[2], gedcomLevel);
                        if (gedcomLevelStrings.size() == 3 && ((String)gedcomLevelStrings.get(2)).equals("DATE") && (((String)gedcomLevelStrings.get(1)).equals("BIRT") || ((String)gedcomLevelStrings.get(1)).equals("DEAT"))) {
                            SimpleDateFormat formatter;
                            String dateText = lineParts[2].trim();
                            for (String prefixString : new String[]{"ABT", "BEF", "AFT"}) {
                                if (!dateText.startsWith(prefixString)) continue;
                                this.appendToTaskOutput("Unsupported Date Type: " + dateText);
                                dateText = dateText.substring(prefixString.length()).trim();
                            }
                            if (dateText.matches("[0-9]{1,4}")) {
                                while (dateText.length() < 4) {
                                    dateText = "0" + dateText;
                                }
                                formatter = new SimpleDateFormat("yyyy");
                            } else {
                                formatter = dateText.matches("[a-zA-Z]{3} [0-9]{4}") ? new SimpleDateFormat("MMM yyyy") : new SimpleDateFormat("dd MMM yyyy");
                            }
                            try {
                                if (((String)gedcomLevelStrings.get(1)).equals("BIRT")) {
                                    currentEntity.entityData.setDateOfBirth(formatter.parse(dateText));
                                } else {
                                    currentEntity.entityData.setDateOfDeath(formatter.parse(dateText));
                                }
                            }
                            catch (ParseException exception) {
                                System.out.println(exception.getMessage());
                                this.appendToTaskOutput("Failed to parse date of birth: " + strLine);
                            }
                        }
                        if (gedcomLevelStrings.size() == 2 && ((String)gedcomLevelStrings.get(1)).equals("SEX")) {
                            String genderString = lineParts[2];
                            if ("F".equals(genderString)) {
                                genderString = "female";
                            } else if ("M".equals(genderString)) {
                                genderString = "male";
                            } else {
                                this.appendToTaskOutput("Unknown gender type: " + genderString);
                            }
                            currentEntity.insertValue("Gender", genderString);
                        }
                        if (((String)gedcomLevelStrings.get(gedcomLevelStrings.size() - 1)).equals("FILE")) {
                            if (lineParts[2].toLowerCase().startsWith("mailto:")) {
                                currentEntity.insertValue("mailto", lineParts[2]);
                            } else {
                                currentEntity.entityData.addArchiveLink(this.inputFileUri.resolve(lineParts[2]));
                            }
                        }
                        if (lineParts[2].startsWith("@") && lineParts[2].endsWith("@")) {
                            DataTypes.RelationType targetRelation = DataTypes.RelationType.none;
                            if (lineParts[1].equals("FAMS") || lineParts[1].equals("FAMC") || lineParts[1].equals("HUSB") || lineParts[1].equals("WIFE") || lineParts[1].equals("CHIL")) {
                                EntityData socialGroupMember;
                                UniqueIdentifier socialGroupIdentifier;
                                if (lineParts[1].equals("FAMS") || lineParts[1].equals("FAMC")) {
                                    socialGroupIdentifier = this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData.getUniqueIdentifier();
                                    socialGroupMember = currentEntity.entityData;
                                } else {
                                    socialGroupIdentifier = currentEntity.entityData.getUniqueIdentifier();
                                    socialGroupMember = this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData;
                                }
                                if (!socialGroupRoleMap.containsKey(socialGroupIdentifier)) {
                                    socialGroupRoleMap.put(socialGroupIdentifier, new ArrayList());
                                }
                                ((ArrayList)socialGroupRoleMap.get(socialGroupIdentifier)).add(new SocialMemberElement(lineParts[1], socialGroupMember));
                                targetRelation = DataTypes.RelationType.affiliation;
                            } else if (lineParts[1].equals("SUBM")) {
                                targetRelation = DataTypes.RelationType.collector;
                            } else if (lineParts[1].equals("SUBN")) {
                                targetRelation = DataTypes.RelationType.metadata;
                            } else if (lineParts[1].equals("NOTE")) {
                                targetRelation = DataTypes.RelationType.metadata;
                            } else if (lineParts[1].equals("ALIA")) {
                                targetRelation = DataTypes.RelationType.metadata;
                            } else if (lineParts[1].equals("ASSO")) {
                                targetRelation = DataTypes.RelationType.affiliation;
                            } else if (lineParts[1].equals("ANCI")) {
                                targetRelation = DataTypes.RelationType.collector;
                            } else if (lineParts[1].equals("DESI")) {
                                targetRelation = DataTypes.RelationType.collector;
                            } else if (lineParts[1].equals("REPO")) {
                                targetRelation = DataTypes.RelationType.metadata;
                            } else if (lineParts[1].equals("OBJE")) {
                                targetRelation = DataTypes.RelationType.resource;
                            } else if (lineParts[1].equals("SOUR")) {
                                targetRelation = DataTypes.RelationType.metadata;
                            } else if (lineParts[1].equals("_HME")) {
                                targetRelation = DataTypes.RelationType.none;
                            } else {
                                this.appendToTaskOutput("Unknown relation type: " + lineParts[2]);
                                targetRelation = DataTypes.RelationType.metadata;
                            }
                            currentEntity.entityData.addRelatedNode(this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData, targetRelation, DataTypes.RelationLineType.none, null, null);
                        }
                    }
                }
                super.incrementLineProgress();
            }
            for (ArrayList currentSocialGroup : socialGroupRoleMap.values()) {
                for (SocialMemberElement outerMemberElement : currentSocialGroup) {
                    for (SocialMemberElement innerMemberElement : currentSocialGroup) {
                        if (innerMemberElement.memberEntity.equals(outerMemberElement.memberEntity)) continue;
                        if (innerMemberElement.typeString.equals("FAMC") || innerMemberElement.typeString.equals("CHIL")) {
                            if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                                innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.sibling, DataTypes.RelationLineType.sanguineLine, null, null);
                                continue;
                            }
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.ancestor, DataTypes.RelationLineType.sanguineLine, null, null);
                            continue;
                        }
                        if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.descendant, DataTypes.RelationLineType.sanguineLine, null, null);
                            continue;
                        }
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.union, DataTypes.RelationLineType.sanguineLine, null, null);
                    }
                }
            }
            this.saveAllDocuments();
            ArbilDataNodeLoader.getSingleInstance().saveNodesNeedingSave(true);
        }
        catch (IOException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        catch (ImportException exception) {
            new ArbilBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        return createdNodes.toArray(new URI[0]);
    }

    class SocialMemberElement {
        String typeString;
        EntityData memberEntity;

        public SocialMemberElement(String typeString, EntityData memberEntity) {
            this.typeString = typeString;
            this.memberEntity = memberEntity;
        }
    }
}

