/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.kintypestrings.LabelStringsParser;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTypeStringConverter
extends GraphSorter {
    DataStoreSvg dataStoreSvg;

    public KinTypeStringConverter(DataStoreSvg dataStoreSvg) {
        this.dataStoreSvg = dataStoreSvg;
    }

    public void setEgoKinTypeString(EntityData entityData) {
        for (KinType kinType : this.dataStoreSvg.getKinTypeDefinitions()) {
            if (!kinType.isEgoType() || !kinType.symbolType.name().equals(entityData.getSymbolType())) continue;
            entityData.addKinTypeString(kinType.codeString);
        }
    }

    public ArrayList<KinTypeElement> getKinTypeElements(String consumableString, ParserHighlight parserHighlight) {
        int initialLength = consumableString.length();
        if (consumableString.startsWith("[")) {
            consumableString = "x=" + consumableString;
        }
        ArrayList<KinTypeElement> kinTypeElementList = new ArrayList<KinTypeElement>();
        KinTypeElement previousElement = null;
        boolean foundKinType = true;
        String errorMessage = null;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                if (!consumableString.startsWith(currentReferenceKinType.codeString)) continue;
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, initialLength - consumableString.length(), currentReferenceKinType.displayString);
                KinTypeElement currentElement = new KinTypeElement();
                if (previousElement != null) {
                    previousElement.nextType = currentElement;
                    currentElement.prevType = previousElement;
                }
                previousElement = currentElement;
                currentElement.kinType = currentReferenceKinType;
                if ((consumableString = consumableString.substring(currentReferenceKinType.codeString.length())).startsWith("[")) {
                    int highlightPosition = initialLength - consumableString.length();
                    String highlightMessage = "Query: ";
                    while (consumableString.startsWith("[")) {
                        int queryStart = "[".length();
                        int queryEnd = consumableString.indexOf("]");
                        if (queryEnd == -1) {
                            errorMessage = highlightMessage = highlightMessage + "No closing bracket ']' found";
                            foundKinType = false;
                            break;
                        }
                        if (queryEnd - queryStart < 3) {
                            errorMessage = highlightMessage = highlightMessage + "Query must be over 2 chars long";
                            foundKinType = false;
                            break;
                        }
                        if (currentElement.queryTerms == null) {
                            currentElement.queryTerms = new ArrayList();
                        }
                        String queryText = consumableString.substring(queryStart, queryEnd);
                        consumableString = consumableString.substring(queryEnd + 1);
                        QueryType currentQueryType = null;
                        String[] queryTerm = queryText.split("==");
                        if (queryTerm.length > 1) {
                            currentQueryType = QueryType.Equals;
                        } else {
                            queryTerm = queryText.split("=");
                            if (queryTerm.length > 1) {
                                currentQueryType = QueryType.Contains;
                            } else {
                                queryTerm = queryText.split("\\>");
                                if (queryTerm.length > 1) {
                                    currentQueryType = QueryType.Greater;
                                } else {
                                    queryTerm = queryText.split("\\<");
                                    if (queryTerm.length > 1) {
                                        currentQueryType = QueryType.Less;
                                    }
                                }
                            }
                        }
                        if (currentQueryType == null) {
                            currentElement.queryTerms.add(new QueryTerm("*", QueryType.Contains, queryText));
                            highlightMessage = highlightMessage + "Any field containing '" + queryText + "'";
                            continue;
                        }
                        if (queryTerm[0].length() <= 2 || queryTerm[1].length() <= 2) continue;
                        currentElement.queryTerms.add(new QueryTerm("*:" + queryTerm[0].replaceAll("\\.", "/*:"), currentQueryType, queryTerm[1]));
                        highlightMessage = highlightMessage + "Only the field '" + queryTerm[0] + "' containing '" + queryTerm[1] + "'";
                    }
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, highlightPosition, highlightMessage);
                }
                kinTypeElementList.add(currentElement);
                foundKinType = true;
                continue block0;
            }
        }
        if (!foundKinType && !consumableString.startsWith("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), errorMessage);
        }
        if (consumableString.contains("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length() + consumableString.indexOf("#"), null);
        }
        return kinTypeElementList;
    }

    public ArrayList<KinType> getKinTypes(String consumableString) {
        ArrayList<KinType> kinTypeList = new ArrayList<KinType>();
        boolean foundKinType = true;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                if (!consumableString.startsWith(currentReferenceKinType.codeString)) continue;
                kinTypeList.add(currentReferenceKinType);
                consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                foundKinType = true;
                continue block0;
            }
        }
        return kinTypeList;
    }

    public void readKinTypes(String[] inputStringArray, KinTermGroup[] kinTermsArray, DataStoreSvg dataStoreSvg, ParserHighlight[] parserHighlightArray) {
        HashMap<UniqueIdentifier, EntityData> namedEntitiesMap = new HashMap<UniqueIdentifier, EntityData>();
        HashSet<EntityData> allEntitiesSet = new HashSet<EntityData>();
        ArrayList<String> inputStringList = new ArrayList<String>();
        inputStringList.addAll(Arrays.asList(inputStringArray));
        for (KinTermGroup kinTerms : kinTermsArray) {
            if (!kinTerms.graphGenerate) continue;
            for (KinTerm kinTerm : kinTerms.getKinTerms()) {
                String[] alterKinTypeStrings = kinTerm.alterKinTypeStrings.split("\\|");
                inputStringList.addAll(Arrays.asList(alterKinTypeStrings));
                if (kinTerm.propositusKinTypeStrings == null) continue;
                String[] propositusKinTypeStrings = kinTerm.propositusKinTypeStrings.split("\\|");
                inputStringList.addAll(Arrays.asList(propositusKinTypeStrings));
            }
        }
        ArrayList<EntityData> egoDataNodeList = new ArrayList<EntityData>();
        int lineCounter = -1;
        block2: for (String inputString : inputStringList) {
            ParserHighlight parserHighlight = new ParserHighlight();
            if (parserHighlightArray.length > ++lineCounter) {
                parserHighlightArray[lineCounter] = parserHighlight;
            }
            if (inputString == null || inputString.length() <= 0) continue;
            if (inputString.startsWith("#")) {
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, 0, null);
                continue;
            }
            int initialLength = inputString.length();
            String consumableString = inputString;
            EntityData parentDataNode = null;
            EntityData egoDataNode = null;
            String fullKinTypeString = "";
            while (consumableString.length() > 0) {
                int parserHighlightPosition = initialLength - consumableString.length();
                boolean kinTypeFound = false;
                for (KinType currentReferenceKinType : dataStoreSvg.getKinTypeDefinitions()) {
                    if (!consumableString.startsWith(currentReferenceKinType.codeString) || currentReferenceKinType.relationType == null || currentReferenceKinType.symbolType == null) continue;
                    String previousConsumableString = consumableString;
                    if (currentReferenceKinType.relationType.equals((Object)DataTypes.RelationType.none) && parentDataNode != null) break;
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, parserHighlightPosition, currentReferenceKinType.displayString);
                    String currentKinTypeString = consumableString;
                    consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                    consumableString = consumableString.replaceAll("^[-\\+\\d]*", "");
                    currentKinTypeString = currentKinTypeString.substring(0, currentKinTypeString.length() - consumableString.length());
                    String kinTypeModifier = currentKinTypeString.substring(currentReferenceKinType.codeString.length());
                    EntityData currentGraphDataNode = null;
                    fullKinTypeString = fullKinTypeString + previousConsumableString.substring(0, previousConsumableString.length() - consumableString.length());
                    LabelStringsParser labelStringsParser = new LabelStringsParser(consumableString, parentDataNode, currentKinTypeString);
                    if (labelStringsParser.userDefinedIdentifierFound) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - consumableString.length(), "Label text");
                        consumableString = labelStringsParser.remainingInputString;
                        currentGraphDataNode = (EntityData)namedEntitiesMap.get(labelStringsParser.uniqueIdentifier);
                    }
                    if (labelStringsParser.uidStartLocation > -1) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.uidStartLocation, "User defined identifier");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.uidEndLocation, "Label text");
                    }
                    if (labelStringsParser.dateLocation > -1) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.dateLocation, "Date of birth/death");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                    }
                    if (labelStringsParser.dateError) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - labelStringsParser.dateLocation, "Incorrect date format: Valid formats are yyyy, yyyy/mm, yyyy/mm/dd with the birth date followed by death date eg yyyy/mm/dd-yyyy/mm/dd");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                    }
                    if (currentGraphDataNode == null) {
                        if (parentDataNode != null && !labelStringsParser.userDefinedIdentifierFound) {
                            for (EntityRelation entityRelation : parentDataNode.getAllRelations()) {
                                if (!currentReferenceKinType.matchesRelation(entityRelation, kinTypeModifier)) continue;
                                currentGraphDataNode = entityRelation.getAlterNode();
                                currentGraphDataNode.addKinTypeString(fullKinTypeString);
                                break;
                            }
                        } else if (parentDataNode == null && !labelStringsParser.userDefinedIdentifierFound) {
                            for (EntityData egoEntity : egoDataNodeList) {
                                if (!currentReferenceKinType.matchesEgoEntity(egoEntity, kinTypeModifier)) continue;
                                currentGraphDataNode = egoEntity;
                                currentGraphDataNode.addKinTypeString(fullKinTypeString);
                                break;
                            }
                        }
                        if (currentGraphDataNode == null) {
                            currentGraphDataNode = new EntityData(labelStringsParser, fullKinTypeString, currentReferenceKinType.symbolType, currentReferenceKinType.isEgoType());
                            if (currentGraphDataNode.isEgo) {
                                egoDataNodeList.add(currentGraphDataNode);
                            }
                            if (labelStringsParser.userDefinedIdentifierFound) {
                                namedEntitiesMap.put(labelStringsParser.uniqueIdentifier, currentGraphDataNode);
                            }
                            allEntitiesSet.add(currentGraphDataNode);
                        }
                    }
                    if (currentGraphDataNode.isEgo) {
                        egoDataNode = currentGraphDataNode;
                    }
                    if (parentDataNode != null && !currentReferenceKinType.relationType.equals((Object)DataTypes.RelationType.none)) {
                        EntityRelation nodeRelation = parentDataNode.addRelatedNode(currentGraphDataNode, currentReferenceKinType.relationType, DataTypes.RelationLineType.sanguineLine, null, null);
                        if (kinTypeModifier != null && !kinTypeModifier.isEmpty()) {
                            if (kinTypeModifier.equals("-")) {
                                nodeRelation.setRelationOrder(-1);
                            } else if (kinTypeModifier.equals("+")) {
                                nodeRelation.setRelationOrder(1);
                            } else {
                                nodeRelation.setRelationOrder(Integer.parseInt(kinTypeModifier.replaceFirst("^\\+", "")));
                            }
                        }
                    }
                    currentGraphDataNode.isVisible = true;
                    for (KinTermGroup kinTerms : kinTermsArray) {
                        if (!kinTerms.graphShow || egoDataNode == null) continue;
                        for (String kinTermLabel : kinTerms.getTermLabel(fullKinTypeString)) {
                            currentGraphDataNode.addKinTermString(kinTermLabel, kinTerms.graphColour);
                            egoDataNode.addRelatedNode(currentGraphDataNode, DataTypes.RelationType.none, DataTypes.RelationLineType.kinTermLine, kinTerms.graphColour, kinTermLabel);
                        }
                    }
                    parentDataNode = currentGraphDataNode;
                    kinTypeFound = true;
                    break;
                }
                if (kinTypeFound) continue;
                if ((consumableString = consumableString.replaceAll("^[\\s]*", "")).startsWith("#")) {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                    continue block2;
                }
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax");
                int commentPosition = consumableString.indexOf("#");
                if (commentPosition <= 0) continue block2;
                consumableString = consumableString.substring(commentPosition);
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                continue block2;
            }
        }
        super.setEntitys(allEntitiesSet.toArray(new EntityData[0]));
    }

    public class KinTypeElement {
        public KinTypeElement prevType;
        public KinTypeElement nextType;
        public KinType kinType;
        public ArrayList<QueryTerm> queryTerms;
        public ArrayList<EntityData> entityData = new ArrayList();
        ParserHighlight[] highlightLocs;
    }

    public class QueryTerm {
        public String fieldXPath;
        public QueryType comparatorType;
        public String searchValue;

        public QueryTerm(String fieldXPath, QueryType comparatorType, String searchValue) {
            this.fieldXPath = fieldXPath;
            this.comparatorType = comparatorType;
            this.searchValue = searchValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        Contains,
        Greater,
        Less,
        Equals;

    }
}

