/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.geom.AffineTransform;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphLabel;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySvg {
    protected HashMap<UniqueIdentifier, float[]> entityPositions = new HashMap();
    private HashMap<UniqueIdentifier, HashSet<UniqueIdentifier>> parentIdentifiers = new HashMap();
    private int symbolSize = 15;
    protected static int strokeWidth = 2;

    public void readEntityPositions(Node entityGroup) {
        if (entityGroup != null) {
            for (Node entityNode = entityGroup.getFirstChild(); entityNode != null; entityNode = entityNode.getNextSibling()) {
                try {
                    NamedNodeMap nodeMap = entityNode.getAttributes();
                    if (nodeMap == null) continue;
                    Node idNode = nodeMap.getNamedItem("id");
                    Node transformNode = nodeMap.getNamedItem("transform");
                    if (idNode == null || transformNode == null) continue;
                    UniqueIdentifier entityId = new UniqueIdentifier(idNode.getNodeValue());
                    String transformString = transformNode.getNodeValue();
                    transformString = transformString.replaceAll("\\s", "");
                    transformString = transformString.replace("translate(", "");
                    transformString = transformString.replace(")", "");
                    String[] stringPos = transformString.split(",");
                    this.entityPositions.put(entityId, new float[]{Float.parseFloat(stringPos[0]), Float.parseFloat(stringPos[1])});
                    continue;
                }
                catch (IdentifierException exception) {
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to read an entity position, layout might not be preserved", "Restore Layout");
                }
            }
        }
    }

    public int insertSymbols(SVGDocument doc, String svgNameSpace) {
        Element svgRoot = doc.getDocumentElement();
        Element defsNode = doc.createElementNS(svgNameSpace, "defs");
        defsNode.setAttribute("id", "KinSymbols");
        Element circleGroup = doc.createElementNS(svgNameSpace, "g");
        circleGroup.setAttribute("id", "circle");
        Element circleNode = doc.createElementNS(svgNameSpace, "circle");
        circleNode.setAttribute("cx", Integer.toString(this.symbolSize / 2));
        circleNode.setAttribute("cy", Integer.toString(this.symbolSize / 2));
        circleNode.setAttribute("r", Integer.toString((this.symbolSize - strokeWidth) / 2));
        circleNode.setAttribute("stroke", "black");
        circleNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        circleGroup.appendChild(circleNode);
        defsNode.appendChild(circleGroup);
        Element squareGroup = doc.createElementNS(svgNameSpace, "g");
        squareGroup.setAttribute("id", "square");
        Element squareNode = doc.createElementNS(svgNameSpace, "rect");
        squareNode.setAttribute("x", Integer.toString(strokeWidth));
        squareNode.setAttribute("y", Integer.toString(strokeWidth));
        squareNode.setAttribute("width", Integer.toString(this.symbolSize - strokeWidth * 2));
        squareNode.setAttribute("height", Integer.toString(this.symbolSize - strokeWidth * 2));
        squareNode.setAttribute("stroke", "black");
        squareNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        squareGroup.appendChild(squareNode);
        defsNode.appendChild(squareGroup);
        svgRoot.appendChild(defsNode);
        Element squareGroup45 = doc.createElementNS(svgNameSpace, "g");
        squareGroup45.setAttribute("id", "square-45");
        Element squareNode45 = doc.createElementNS(svgNameSpace, "rect");
        squareNode45.setAttribute("transform", "rotate(-45 " + Integer.toString(this.symbolSize / 2) + " " + Integer.toString(this.symbolSize / 2) + ")");
        squareNode45.setAttribute("x", Integer.toString(strokeWidth));
        squareNode45.setAttribute("y", Integer.toString(strokeWidth));
        squareNode45.setAttribute("width", Integer.toString(this.symbolSize - strokeWidth * 2));
        squareNode45.setAttribute("height", Integer.toString(this.symbolSize - strokeWidth * 2));
        squareNode45.setAttribute("stroke", "black");
        squareNode45.setAttribute("stroke-width", Integer.toString(strokeWidth));
        squareGroup45.appendChild(squareNode45);
        defsNode.appendChild(squareGroup45);
        svgRoot.appendChild(defsNode);
        Element rhombusGroup = doc.createElementNS(svgNameSpace, "g");
        rhombusGroup.setAttribute("id", "rhombus");
        Element rhombusNode = doc.createElementNS(svgNameSpace, "rect");
        rhombusNode.setAttribute("transform", "scale(1,0.5), rotate(-45 " + Integer.toString(this.symbolSize / 2) + " " + Integer.toString(this.symbolSize / 2) + ")");
        rhombusNode.setAttribute("x", Integer.toString(strokeWidth));
        rhombusNode.setAttribute("y", Integer.toString(strokeWidth));
        rhombusNode.setAttribute("width", Integer.toString(this.symbolSize - strokeWidth * 2));
        rhombusNode.setAttribute("height", Integer.toString(this.symbolSize - strokeWidth * 2));
        rhombusNode.setAttribute("stroke", "black");
        rhombusNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        rhombusGroup.appendChild(rhombusNode);
        defsNode.appendChild(rhombusGroup);
        svgRoot.appendChild(defsNode);
        Element unionGroup = doc.createElementNS(svgNameSpace, "g");
        unionGroup.setAttribute("id", "union");
        Element upperNode = doc.createElementNS(svgNameSpace, "line");
        Element lowerNode = doc.createElementNS(svgNameSpace, "line");
        upperNode.setAttribute("x1", Integer.toString(0));
        upperNode.setAttribute("y1", Integer.toString(this.symbolSize / 6));
        upperNode.setAttribute("x2", Integer.toString(this.symbolSize));
        upperNode.setAttribute("y2", Integer.toString(this.symbolSize / 6));
        upperNode.setAttribute("stroke-width", Integer.toString(this.symbolSize / 3));
        upperNode.setAttribute("stroke", "black");
        lowerNode.setAttribute("x1", Integer.toString(0));
        lowerNode.setAttribute("y1", Integer.toString(this.symbolSize - this.symbolSize / 6));
        lowerNode.setAttribute("x2", Integer.toString(this.symbolSize));
        lowerNode.setAttribute("y2", Integer.toString(this.symbolSize - this.symbolSize / 6));
        lowerNode.setAttribute("stroke-width", Integer.toString(this.symbolSize / 3));
        lowerNode.setAttribute("stroke", "black");
        Element backgroundNode = doc.createElementNS(svgNameSpace, "rect");
        backgroundNode.setAttribute("x", "0");
        backgroundNode.setAttribute("y", "0");
        backgroundNode.setAttribute("width", Integer.toString(this.symbolSize));
        backgroundNode.setAttribute("height", Integer.toString(this.symbolSize));
        backgroundNode.setAttribute("stroke", "none");
        backgroundNode.setAttribute("fill", "white");
        unionGroup.appendChild(backgroundNode);
        unionGroup.appendChild(upperNode);
        unionGroup.appendChild(lowerNode);
        defsNode.appendChild(unionGroup);
        svgRoot.appendChild(defsNode);
        Element triangleGroup = doc.createElementNS(svgNameSpace, "g");
        triangleGroup.setAttribute("id", "triangle");
        Element triangleNode = doc.createElementNS(svgNameSpace, "polygon");
        int triangleSize = this.symbolSize - strokeWidth / 2;
        int triangleHeight = (int)(Math.sqrt(3.0) * (double)triangleSize / 2.0);
        triangleNode.setAttribute("points", this.symbolSize / 2 + "," + strokeWidth / 2 + " " + strokeWidth / 2 + "," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode.setAttribute("stroke", "black");
        triangleNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        triangleGroup.appendChild(triangleNode);
        defsNode.appendChild(triangleGroup);
        svgRoot.appendChild(defsNode);
        Element triangleGroup1 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup1.setAttribute("id", "triangle-270");
        Element triangleNode1 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode1.setAttribute("transform", "rotate(-90 " + Integer.toString(this.symbolSize / 2) + " " + Integer.toString(this.symbolSize / 2) + ")");
        triangleNode1.setAttribute("points", this.symbolSize / 2 + "," + strokeWidth / 2 + " " + strokeWidth / 2 + "," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode1.setAttribute("stroke", "black");
        triangleNode1.setAttribute("stroke-width", Integer.toString(strokeWidth));
        triangleGroup1.appendChild(triangleNode1);
        defsNode.appendChild(triangleGroup1);
        svgRoot.appendChild(defsNode);
        Element triangleGroup2 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup2.setAttribute("id", "triangle-180");
        triangleGroup2.setAttribute("transform", "rotate(180 " + Integer.toString(this.symbolSize / 2) + " " + Integer.toString(this.symbolSize / 2) + ")");
        Element triangleNode2 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode2.setAttribute("points", this.symbolSize / 2 + "," + strokeWidth / 2 + " " + strokeWidth / 2 + "," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode2.setAttribute("stroke", "black");
        triangleNode2.setAttribute("stroke-width", Integer.toString(strokeWidth));
        triangleGroup2.appendChild(triangleNode2);
        defsNode.appendChild(triangleGroup2);
        svgRoot.appendChild(defsNode);
        Element triangleGroup3 = doc.createElementNS(svgNameSpace, "g");
        triangleGroup3.setAttribute("id", "triangle-90");
        triangleGroup3.setAttribute("transform", "rotate(90 " + Integer.toString(this.symbolSize / 2) + " " + Integer.toString(this.symbolSize / 2) + ")");
        Element triangleNode3 = doc.createElementNS(svgNameSpace, "polygon");
        triangleNode3.setAttribute("points", this.symbolSize / 2 + "," + strokeWidth / 2 + " " + strokeWidth / 2 + "," + triangleHeight + " " + triangleSize + "," + triangleHeight);
        triangleNode3.setAttribute("stroke", "black");
        triangleNode3.setAttribute("stroke-width", Integer.toString(strokeWidth));
        triangleGroup3.appendChild(triangleNode3);
        defsNode.appendChild(triangleGroup3);
        svgRoot.appendChild(defsNode);
        Element crossGroup = doc.createElementNS(svgNameSpace, "g");
        crossGroup.setAttribute("id", "cross");
        Element crossNode = doc.createElementNS(svgNameSpace, "polyline");
        int posX = this.symbolSize / 2;
        int posY = this.symbolSize / 2;
        int offsetAmount = this.symbolSize / 2;
        crossNode.setAttribute("points", posX - offsetAmount + "," + (posY - offsetAmount) + " " + (posX + offsetAmount) + "," + (posY + offsetAmount) + " " + posX + "," + posY + " " + (posX - offsetAmount) + "," + (posY + offsetAmount) + " " + (posX + offsetAmount) + "," + (posY - offsetAmount));
        crossNode.setAttribute("fill", "none");
        crossNode.setAttribute("stroke", "black");
        crossNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        crossGroup.appendChild(crossNode);
        defsNode.appendChild(crossGroup);
        svgRoot.appendChild(defsNode);
        Element noneGroup = doc.createElementNS(svgNameSpace, "g");
        noneGroup.setAttribute("id", "error");
        Element noneNode = doc.createElementNS(svgNameSpace, "polyline");
        int posXnone = this.symbolSize / 2;
        int posYnone = this.symbolSize / 2;
        int offsetNoneAmount = this.symbolSize / 2;
        noneNode.setAttribute("points", posXnone - offsetNoneAmount + "," + (posYnone - offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + posXnone + "," + posYnone + " " + (posXnone - offsetNoneAmount) + "," + (posYnone + offsetNoneAmount) + " " + (posXnone + offsetNoneAmount) + "," + (posYnone - offsetNoneAmount));
        noneNode.setAttribute("fill", "none");
        noneNode.setAttribute("stroke", "red");
        noneNode.setAttribute("stroke-width", Integer.toString(strokeWidth));
        noneGroup.appendChild(noneNode);
        defsNode.appendChild(noneGroup);
        svgRoot.appendChild(defsNode);
        return this.symbolSize;
    }

    public String[] listSymbolNames(SVGDocument doc, String svgNameSpace) {
        ArrayList<String> symbolArray = new ArrayList<String>();
        Element kinSymbols = doc.getElementById("KinSymbols");
        if (kinSymbols == null) {
            this.insertSymbols(doc, svgNameSpace);
            kinSymbols = doc.getElementById("KinSymbols");
        }
        for (Node kinSymbolNode = kinSymbols.getFirstChild(); kinSymbolNode != null; kinSymbolNode = kinSymbolNode.getNextSibling()) {
            Node idNode;
            NamedNodeMap attributesMap = kinSymbolNode.getAttributes();
            if (attributesMap == null || (idNode = attributesMap.getNamedItem("id")) == null) continue;
            symbolArray.add(idNode.getNodeValue());
        }
        return symbolArray.toArray(new String[0]);
    }

    public void clearEntityLocations(UniqueIdentifier[] selectedIdentifiers) {
        for (UniqueIdentifier currentIdentifier : selectedIdentifiers) {
            this.entityPositions.remove(currentIdentifier);
        }
    }

    public UniqueIdentifier getClosestEntity(float[] locationArray, int maximumDistance, ArrayList<UniqueIdentifier> excludeIdentifiers) {
        double closestDistance = -1.0;
        UniqueIdentifier closestIdentifier = null;
        for (Map.Entry<UniqueIdentifier, float[]> currentEntry : this.entityPositions.entrySet()) {
            if (excludeIdentifiers.contains(currentEntry.getKey())) continue;
            float hDistance = locationArray[0] - currentEntry.getValue()[0];
            float vDistance = locationArray[1] - currentEntry.getValue()[1];
            double entityDistance = Math.sqrt(hDistance * hDistance + vDistance * vDistance);
            if (closestIdentifier == null) {
                closestDistance = entityDistance;
                closestIdentifier = currentEntry.getKey();
            }
            if (!(entityDistance < closestDistance)) continue;
            closestDistance = entityDistance;
            closestIdentifier = currentEntry.getKey();
        }
        if ((double)maximumDistance < closestDistance) {
            return null;
        }
        return closestIdentifier;
    }

    public float[] getEntityLocation(UniqueIdentifier entityId) {
        float[] returnLoc = this.entityPositions.get(entityId);
        float xPos = returnLoc[0] + (float)(this.symbolSize / 2);
        float yPos = returnLoc[1] + (float)(this.symbolSize / 2);
        return new float[]{xPos, yPos};
    }

    public float[] getAverageParentLocation(UniqueIdentifier entityId) {
        Float maxY = null;
        float averageX = 0.0f;
        int parentCount = 0;
        HashSet<UniqueIdentifier> parentIdSet = this.parentIdentifiers.get(entityId);
        if (parentIdSet != null) {
            for (UniqueIdentifier parentIdentifier : parentIdSet) {
                float[] parentLoc = this.getEntityLocation(parentIdentifier);
                maxY = maxY == null ? Float.valueOf(parentLoc[1]) : Float.valueOf(maxY.floatValue() >= parentLoc[1] ? maxY.floatValue() : parentLoc[1]);
                averageX += parentLoc[0];
                ++parentCount;
            }
        }
        averageX /= (float)parentCount;
        if (maxY == null) {
            return null;
        }
        return new float[]{averageX, maxY.floatValue()};
    }

    public float[] getAverageParentLocation(EntityData entityData) {
        HashSet<UniqueIdentifier> identifierSet = new HashSet<UniqueIdentifier>();
        for (EntityRelation entityRelation : entityData.getVisiblyRelateNodes()) {
            if (entityRelation.relationType != DataTypes.RelationType.ancestor) continue;
            identifierSet.add(entityRelation.alterUniqueIdentifier);
        }
        this.parentIdentifiers.put(entityData.getUniqueIdentifier(), identifierSet);
        return this.getAverageParentLocation(entityData.getUniqueIdentifier());
    }

    public float[] moveEntity(GraphPanel graphPanel, UniqueIdentifier entityId, float shiftXfloat, float shiftYfloat, boolean snapToGrid, boolean allRealtionsSelected) {
        Element entitySymbol = graphPanel.doc.getElementById(entityId.getAttributeIdentifier());
        Element highlightGroup = null;
        if (entityId.isGraphicsIdentifier()) {
            highlightGroup = graphPanel.doc.getElementById("highlight_" + entityId.getAttributeIdentifier());
        }
        float remainderAfterSnapX = 0.0f;
        float remainderAfterSnapY = 0.0f;
        double scaleFactor = 1.0;
        if (entitySymbol != null) {
            boolean allowYshift = entitySymbol.getLocalName().equals("text");
            if (allRealtionsSelected) {
                allowYshift = true;
            }
            allowYshift = true;
            AffineTransform affineTransform = graphPanel.svgCanvas.getRenderingTransform();
            scaleFactor = affineTransform.getScaleX();
            double shiftXscaled = (double)shiftXfloat / scaleFactor;
            double shiftYscaled = (double)shiftYfloat / scaleFactor;
            float[] entityPosition = this.entityPositions.get(entityId);
            float updatedPositionX = (float)((double)entityPosition[0] + shiftXscaled);
            float updatedPositionY = entityPosition[1];
            if (allowYshift) {
                updatedPositionY = (float)((double)updatedPositionY + shiftYscaled);
            }
            if (snapToGrid) {
                double updatedSnapPositionX = Math.round(updatedPositionX / 50.0f) * 50;
                updatedPositionX = (float)updatedSnapPositionX;
                if (allowYshift) {
                    float updatedSnapPositionY;
                    updatedPositionY = updatedSnapPositionY = (float)(Math.round(updatedPositionY / 50.0f) * 50);
                }
            } else {
                updatedPositionX = (int)updatedPositionX;
                if (allowYshift) {
                    updatedPositionY = (int)updatedPositionY;
                }
            }
            this.entityPositions.put(entityId, new float[]{updatedPositionX, updatedPositionY});
            String translateString = "translate(" + String.valueOf(updatedPositionX) + ", " + String.valueOf(updatedPositionY) + ")";
            entitySymbol.setAttribute("transform", translateString);
            if (highlightGroup != null) {
                highlightGroup.setAttribute("transform", translateString);
            }
            float distanceXmoved = (float)((double)(updatedPositionX - entityPosition[0]) * scaleFactor);
            float distanceYmoved = (float)((double)(updatedPositionY - entityPosition[1]) * scaleFactor);
            remainderAfterSnapX = shiftXfloat - distanceXmoved;
            remainderAfterSnapY = shiftYfloat - distanceYmoved;
        }
        return new float[]{remainderAfterSnapX, remainderAfterSnapY};
    }

    private int addTextLabel(GraphPanel graphPanel, Element groupNode, String currentTextLable, String textColour, int textSpanCounter) {
        int lineSpacing = 15;
        Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
        labelText.setAttribute("x", Double.toString((double)this.symbolSize * 1.5));
        labelText.setAttribute("y", Integer.toString(textSpanCounter));
        labelText.setAttribute("fill", textColour);
        labelText.setAttribute("stroke-width", "0");
        labelText.setAttribute("font-size", "14");
        Text textNode = graphPanel.doc.createTextNode(currentTextLable);
        labelText.appendChild(textNode);
        groupNode.appendChild(labelText);
        return textSpanCounter += lineSpacing;
    }

    protected Element createEntitySymbol(GraphPanel graphPanel, EntityData currentNode) {
        Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
        groupNode.setAttribute("id", currentNode.getUniqueIdentifier().getAttributeIdentifier());
        groupNode.setAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kin:path", currentNode.getEntityPath());
        groupNode.setAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kin:kintype", currentNode.getKinTypeString());
        String symbolType = currentNode.getSymbolType();
        if (symbolType == null || symbolType.length() == 0) {
            symbolType = "error";
        }
        Element symbolNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "use");
        symbolNode.setAttribute("id", currentNode.getUniqueIdentifier().getAttributeIdentifier() + ":symbol");
        symbolNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + symbolType);
        float[] storedPosition = this.entityPositions.get(currentNode.getUniqueIdentifier());
        if (storedPosition == null) {
            GuiHelper.linorgBugCatcher.logError(new Exception("No storedPosition found for: " + currentNode.getUniqueIdentifier().getAttributeIdentifier()));
            storedPosition = new float[]{0.0f, 0.0f};
            this.entityPositions.put(currentNode.getUniqueIdentifier(), storedPosition);
        }
        groupNode.setAttribute("transform", "translate(" + Float.toString(storedPosition[0]) + ", " + Float.toString(storedPosition[1]) + ")");
        if (currentNode.isEgo) {
            symbolNode.setAttribute("fill", "black");
        } else {
            symbolNode.setAttribute("fill", "white");
        }
        symbolNode.setAttribute("stroke", "black");
        symbolNode.setAttribute("stroke-width", "2");
        groupNode.appendChild(symbolNode);
        ArrayList<String> labelList = new ArrayList<String>();
        if (graphPanel.dataStoreSvg.showIdLabels && currentNode.customIdentifier != null) {
            labelList.add(currentNode.customIdentifier);
        }
        if (graphPanel.dataStoreSvg.showLabels) {
            labelList.addAll(Arrays.asList(currentNode.getLabel()));
        }
        if (graphPanel.dataStoreSvg.showKinTypeLabels) {
            labelList.addAll(Arrays.asList(currentNode.getKinTypeStringArray()));
        }
        int textSpanCounter = 0;
        if (currentNode.metadataRequiresSave) {
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, "modified", "red", textSpanCounter);
        }
        for (String currentTextLable : labelList) {
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, currentTextLable, "black", textSpanCounter);
        }
        for (GraphLabel currentTextLable : currentNode.getKinTermStrings()) {
            textSpanCounter = this.addTextLabel(graphPanel, groupNode, currentTextLable.getLabelString(), currentTextLable.getColourString(), textSpanCounter);
        }
        if (graphPanel.dataStoreSvg.showDateLabels) {
            String dateString = "";
            Date dob = currentNode.getDateOfBirth();
            Date dod = currentNode.getDateOfDeath();
            if (dob != null) {
                dateString = dateString + DateFormat.getDateInstance().format(dob);
            }
            if (dod != null) {
                dateString = dateString + " - " + DateFormat.getDateInstance().format(dod);
            }
            if (dateString.length() > 0) {
                textSpanCounter = this.addTextLabel(graphPanel, groupNode, dateString, "black", textSpanCounter);
            }
        }
        int linkCounter = 0;
        if (graphPanel.dataStoreSvg.showArchiveLinks && currentNode.archiveLinkArray != null) {
            Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
            labelText.setAttribute("x", Double.toString((double)this.symbolSize * 1.5));
            labelText.setAttribute("y", Integer.toString(textSpanCounter));
            labelText.setAttribute("fill", "black");
            labelText.setAttribute("stroke-width", "0");
            labelText.setAttribute("font-size", "14");
            Text textNode = graphPanel.doc.createTextNode("archive ref: ");
            labelText.appendChild(textNode);
            for (URI linkURI : currentNode.archiveLinkArray) {
                Element labelTagA = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "a");
                labelTagA.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", linkURI.toASCIIString());
                labelTagA.setAttribute("target", "_blank");
                if (++linkCounter == 1) {
                    labelTagA.appendChild(graphPanel.doc.createTextNode("" + linkCounter));
                } else {
                    labelTagA.appendChild(graphPanel.doc.createTextNode(", " + linkCounter));
                }
                labelText.appendChild(labelTagA);
            }
            groupNode.appendChild(labelText);
        }
        ((EventTarget)((Object)groupNode)).addEventListener("mousedown", graphPanel.mouseListenerSvg, false);
        return groupNode;
    }
}

