/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Point;
import java.util.ArrayList;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.LineLookUpTable;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationSvg {
    private boolean oldFormatWarningShown = false;

    private void addUseNode(SVGDocument doc, String svgNameSpace, Element targetGroup, String targetDefId) {
        String useNodeId = targetDefId + "use";
        Element useNodeOld = doc.getElementById(useNodeId);
        if (useNodeOld != null) {
            useNodeOld.getParentNode().removeChild(useNodeOld);
        }
        Element useNode = doc.createElementNS(svgNameSpace, "use");
        useNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + targetDefId);
        useNode.setAttribute("id", useNodeId);
        targetGroup.appendChild(useNode);
    }

    private void updateLabelNode(SVGDocument doc, String svgNameSpace, String lineIdString, String targetRelationId) {
        String labelNodeId = targetRelationId + "label";
        Element useNodeOld = doc.getElementById(labelNodeId);
        if (useNodeOld != null) {
            Node textParentNode = useNodeOld.getParentNode();
            String labelText = useNodeOld.getTextContent();
            useNodeOld.getParentNode().removeChild(useNodeOld);
            Element textPath = doc.createElementNS(svgNameSpace, "textPath");
            textPath.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + lineIdString);
            textPath.setAttribute("startOffset", "50%");
            textPath.setAttribute("id", labelNodeId);
            Text textNode = doc.createTextNode(labelText);
            textPath.appendChild(textNode);
            textParentNode.appendChild(textPath);
        }
    }

    protected void setPolylinePointsAttribute(LineLookUpTable lineLookUpTable, String lineIdString, Element targetNode, DataTypes.RelationType relationType, float vSpacing, float egoX, float egoY, float alterX, float alterY, float[] averageParentPassed) {
        float alterYmid;
        float egoYmid;
        ArrayList<Point> initialPointsList = new ArrayList<Point>();
        float[] averageParent = null;
        float midSpacing = vSpacing / 2.0f;
        float centerX = (egoX + alterX) / 2.0f;
        switch (relationType) {
            case ancestor: {
                averageParent = averageParentPassed == null ? new float[]{alterX, alterY} : averageParentPassed;
                egoYmid = egoY - midSpacing;
                alterYmid = averageParent[1] + 30.0f;
                centerX = egoYmid < alterYmid ? centerX : egoX;
                centerX = egoY < alterY && egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case descendant: {
                if (!this.oldFormatWarningShown) {
                    ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("This diagram needs to be updated, select recalculate diagram from the edit menu before continuing.", "Old or erroneous format detected");
                    this.oldFormatWarningShown = true;
                }
                return;
            }
            case sibling: {
                egoYmid = egoY - midSpacing;
                alterYmid = alterY - midSpacing;
                centerX = egoY < alterY ? alterX : egoX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            case union: {
                egoYmid = egoY + 30.0f;
                alterYmid = alterY + 30.0f;
                centerX = egoY < alterY ? egoX : alterX;
                centerX = egoX == alterX ? centerX - midSpacing : centerX;
                break;
            }
            default: {
                egoYmid = egoY;
                alterYmid = alterY;
            }
        }
        initialPointsList.add(new Point((int)egoX, (int)egoY));
        initialPointsList.add(new Point((int)egoX, (int)egoYmid));
        if (averageParent != null) {
            float averageParentX = averageParent[0];
            initialPointsList.add(new Point((int)averageParentX, (int)egoYmid));
            initialPointsList.add(new Point((int)averageParentX, (int)alterYmid));
        } else {
            initialPointsList.add(new Point((int)centerX, (int)egoYmid));
            initialPointsList.add(new Point((int)centerX, (int)alterYmid));
        }
        initialPointsList.add(new Point((int)alterX, (int)alterYmid));
        initialPointsList.add(new Point((int)alterX, (int)alterY));
        Point[] adjustedPointsList = lineLookUpTable != null ? lineLookUpTable.adjustLineToObstructions(lineIdString, initialPointsList) : initialPointsList.toArray(new Point[0]);
        StringBuilder stringBuilder = new StringBuilder();
        for (Point currentPoint : adjustedPointsList) {
            stringBuilder.append(currentPoint.x);
            stringBuilder.append(",");
            stringBuilder.append(currentPoint.y);
            stringBuilder.append(" ");
        }
        targetNode.setAttribute("points", stringBuilder.toString());
    }

    protected void setPathPointsAttribute(Element targetNode, DataTypes.RelationType relationType, DataTypes.RelationLineType relationLineType, float hSpacing, float vSpacing, float egoX, float egoY, float alterX, float alterY) {
        float toBezY;
        float toBezX;
        float fromBezY;
        float fromBezX;
        if (egoX > alterX && egoY < alterY || egoX > alterX && egoY > alterY) {
            float tempX = alterX;
            float tempY = alterY;
            alterX = egoX;
            alterY = egoY;
            egoX = tempX;
            egoY = tempY;
        }
        if (relationLineType == DataTypes.RelationLineType.verticalCurve) {
            fromBezX = egoX;
            fromBezY = alterY;
            toBezX = alterX;
            toBezY = egoY;
            if (1.0f / (egoY - alterY) < vSpacing) {
                fromBezX = egoX;
                fromBezY = alterY - vSpacing / 2.0f;
                toBezX = alterX;
                toBezY = egoY - vSpacing / 2.0f;
            }
        } else {
            fromBezX = alterX;
            fromBezY = egoY;
            toBezX = egoX;
            toBezY = alterY;
            if (egoX > alterX) {
                if (egoX - alterX < hSpacing / 4.0f) {
                    fromBezX = egoX - hSpacing / 4.0f;
                    toBezX = alterX - hSpacing / 4.0f;
                } else {
                    fromBezX = (egoX - alterX) / 2.0f + alterX;
                    toBezX = (egoX - alterX) / 2.0f + alterX;
                }
            } else if (alterX - egoX < hSpacing / 4.0f) {
                fromBezX = egoX + hSpacing / 4.0f;
                toBezX = alterX + hSpacing / 4.0f;
            } else {
                fromBezX = (alterX - egoX) / 2.0f + egoX;
                toBezX = (alterX - egoX) / 2.0f + egoX;
            }
        }
        targetNode.setAttribute("d", "M " + egoX + "," + egoY + " C " + fromBezX + "," + fromBezY + " " + toBezX + "," + toBezY + " " + alterX + "," + alterY);
    }

    public boolean hasCommonParent(EntityData currentNode, EntityRelation graphLinkNode) {
        if (graphLinkNode.relationType == DataTypes.RelationType.sibling) {
            for (EntityRelation altersRelation : graphLinkNode.getAlterNode().getDistinctRelateNodes()) {
                if (altersRelation.relationType != DataTypes.RelationType.ancestor) continue;
                for (EntityRelation egosRelation : currentNode.getDistinctRelateNodes()) {
                    if (egosRelation.relationType != DataTypes.RelationType.ancestor || !altersRelation.alterUniqueIdentifier.equals(egosRelation.alterUniqueIdentifier) || !altersRelation.getAlterNode().isVisible) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void insertRelation(GraphPanel graphPanel, Element relationGroupNode, EntityData leftEntity, EntityData rightEntity, DataTypes.RelationType directedRelation, DataTypes.RelationLineType relationLineType, String lineColour, String lineLabel, int hSpacing, int vSpacing) {
        float[] egoSymbolPoint = graphPanel.entitySvg.getEntityLocation(leftEntity.getUniqueIdentifier());
        float[] alterSymbolPoint = graphPanel.entitySvg.getEntityLocation(rightEntity.getUniqueIdentifier());
        float[] parentPoint = graphPanel.entitySvg.getAverageParentLocation(leftEntity);
        int relationLineIndex = relationGroupNode.getChildNodes().getLength();
        Element groupNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "g");
        groupNode.setAttribute("id", "relation" + relationLineIndex);
        Element defsNode = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "defs");
        String lineIdString = "relation" + relationLineIndex + "Line";
        new DataStoreSvg().storeRelationParameters(graphPanel.doc, groupNode, directedRelation, relationLineType, leftEntity.getUniqueIdentifier(), rightEntity.getUniqueIdentifier());
        float fromX = egoSymbolPoint[0];
        float fromY = egoSymbolPoint[1];
        float toX = alterSymbolPoint[0];
        float toY = alterSymbolPoint[1];
        boolean addedRelationLine = false;
        switch (relationLineType) {
            case kinTermLine: 
            case verticalCurve: {
                Element linkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "path");
                this.setPathPointsAttribute(linkLine, directedRelation, relationLineType, hSpacing, vSpacing, fromX, fromY, toX, toY);
                linkLine.setAttribute("fill", "none");
                if (lineColour != null) {
                    linkLine.setAttribute("stroke", lineColour);
                } else {
                    linkLine.setAttribute("stroke", "blue");
                }
                linkLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                linkLine.setAttribute("id", lineIdString);
                defsNode.appendChild(linkLine);
                addedRelationLine = true;
                break;
            }
            case sanguineLine: {
                Element squareLinkLine = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "polyline");
                this.setPolylinePointsAttribute(graphPanel.lineLookUpTable, lineIdString, squareLinkLine, directedRelation, vSpacing, fromX, fromY, toX, toY, parentPoint);
                squareLinkLine.setAttribute("fill", "none");
                squareLinkLine.setAttribute("stroke", "grey");
                squareLinkLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                squareLinkLine.setAttribute("id", lineIdString);
                defsNode.appendChild(squareLinkLine);
                addedRelationLine = true;
            }
        }
        groupNode.appendChild(defsNode);
        if (addedRelationLine) {
            this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, groupNode, lineIdString);
            if (lineLabel != null) {
                Element labelText = graphPanel.doc.createElementNS(graphPanel.svgNameSpace, "text");
                labelText.setAttribute("text-anchor", "middle");
                if (lineColour != null) {
                    labelText.setAttribute("fill", lineColour);
                } else {
                    labelText.setAttribute("fill", "blue");
                }
                labelText.setAttribute("stroke-width", "0");
                labelText.setAttribute("font-size", "14");
                groupNode.appendChild(labelText);
            }
        }
        relationGroupNode.appendChild(groupNode);
    }

    public void updateRelationLines(GraphPanel graphPanel, ArrayList<UniqueIdentifier> draggedNodeIds, int hSpacing, int vSpacing) {
        Element relationGroup = graphPanel.doc.getElementById("RelationGroup");
        for (Node currentChild = relationGroup.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!"g".equals(currentChild.getLocalName())) continue;
            Node idAttrubite = currentChild.getAttributes().getNamedItem("id");
            try {
                DataStoreSvg.GraphRelationData graphRelationData = new DataStoreSvg().getEntitiesForRelations(currentChild);
                if (graphRelationData == null) continue;
                String lineElementId = idAttrubite.getNodeValue() + "Line";
                Element relationLineElement = graphPanel.doc.getElementById(lineElementId);
                DataTypes.RelationType directedRelation = graphRelationData.relationType;
                float[] egoSymbolPoint = graphPanel.entitySvg.getEntityLocation(graphRelationData.egoNodeId);
                float[] alterSymbolPoint = graphPanel.entitySvg.getEntityLocation(graphRelationData.alterNodeId);
                float[] parentPoint = graphPanel.entitySvg.getAverageParentLocation(graphRelationData.egoNodeId);
                float egoX = egoSymbolPoint[0];
                float egoY = egoSymbolPoint[1];
                float alterX = alterSymbolPoint[0];
                float alterY = alterSymbolPoint[1];
                if ("polyline".equals(relationLineElement.getLocalName())) {
                    this.setPolylinePointsAttribute(graphPanel.lineLookUpTable, lineElementId, relationLineElement, directedRelation, vSpacing, egoX, egoY, alterX, alterY, parentPoint);
                }
                if ("path".equals(relationLineElement.getLocalName())) {
                    this.setPathPointsAttribute(relationLineElement, directedRelation, graphRelationData.relationLineType, hSpacing, vSpacing, egoX, egoY, alterX, alterY);
                }
                this.addUseNode(graphPanel.doc, graphPanel.svgNameSpace, (Element)currentChild, lineElementId);
                this.updateLabelNode(graphPanel.doc, graphPanel.svgNameSpace, lineElementId, idAttrubite.getNodeValue());
                continue;
            }
            catch (IdentifierException exception) {
                ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Failed to read related entities, sanguine lines might be incorrect", "Update Sanguine Lines");
            }
        }
    }
}

