/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;

public class HidePane
extends JPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private boolean hiddenState = true;
    private int lastSelectedTab = -1;
    private int defaultShownWidth = 300;
    private int shownWidth;
    private int hiddenWidth = 30;
    private HidePanePosition borderPosition;
    private boolean horizontalDivider;
    private int dragStartPosition = 0;
    private boolean lastWasDrag = false;
    private HashSet<VisiblePanelSetting> registeredPanelSettings;

    public HidePane(HidePanePosition borderPositionLocal, int startWidth) {
        this.setLayout(new BorderLayout());
        JPanel separatorBar = new JPanel();
        separatorBar.setPreferredSize(new Dimension(5, 5));
        separatorBar.setMaximumSize(new Dimension(5, 5));
        separatorBar.setMinimumSize(new Dimension(5, 5));
        this.registeredPanelSettings = new HashSet();
        this.shownWidth = startWidth;
        this.borderPosition = borderPositionLocal;
        this.horizontalDivider = !this.borderPosition.equals((Object)HidePanePosition.left) && !this.borderPosition.equals((Object)HidePanePosition.right);
        switch (this.borderPosition) {
            case left: {
                separatorBar.setCursor(Cursor.getPredefinedCursor(10));
                this.add((Component)separatorBar, "After");
                this.tabbedPane.setTabPlacement(1);
                break;
            }
            case right: {
                separatorBar.setCursor(Cursor.getPredefinedCursor(11));
                this.add((Component)separatorBar, "Before");
                this.tabbedPane.setTabPlacement(1);
                break;
            }
            case top: {
                separatorBar.setCursor(Cursor.getPredefinedCursor(8));
                this.add((Component)separatorBar, "Last");
                this.tabbedPane.setTabPlacement(1);
                break;
            }
            default: {
                separatorBar.setCursor(Cursor.getPredefinedCursor(9));
                this.add((Component)separatorBar, "First");
                this.tabbedPane.setTabPlacement(1);
            }
        }
        separatorBar.setBackground(Color.LIGHT_GRAY);
        this.add((Component)this.tabbedPane, "Center");
        separatorBar.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                HidePane.this.lastWasDrag = true;
                if (HidePane.this.hiddenState) {
                    HidePane.this.hiddenState = false;
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                }
                switch (HidePane.this.borderPosition) {
                    case left: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth - HidePane.this.dragStartPosition + e.getXOnScreen();
                        HidePane.this.dragStartPosition = e.getXOnScreen();
                        break;
                    }
                    case right: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth + HidePane.this.dragStartPosition - e.getXOnScreen();
                        HidePane.this.dragStartPosition = e.getXOnScreen();
                        break;
                    }
                    case top: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth - HidePane.this.dragStartPosition + e.getYOnScreen();
                        HidePane.this.dragStartPosition = e.getYOnScreen();
                        break;
                    }
                    case bottom: {
                        HidePane.this.shownWidth = HidePane.this.shownWidth + HidePane.this.dragStartPosition - e.getYOnScreen();
                        HidePane.this.dragStartPosition = e.getYOnScreen();
                    }
                }
                if (HidePane.this.shownWidth < HidePane.this.hiddenWidth) {
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                    HidePane.this.hiddenState = true;
                }
                if (HidePane.this.horizontalDivider) {
                    HidePane.this.setPreferredSize(new Dimension(HidePane.this.getPreferredSize().width, HidePane.this.shownWidth));
                } else {
                    HidePane.this.setPreferredSize(new Dimension(HidePane.this.shownWidth, HidePane.this.getPreferredSize().height));
                }
                HidePane.this.revalidate();
                HidePane.this.repaint();
            }
        });
        separatorBar.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (!HidePane.this.hiddenState && HidePane.this.lastSelectedTab != HidePane.this.tabbedPane.getSelectedIndex()) {
                    HidePane.this.lastSelectedTab = HidePane.this.tabbedPane.getSelectedIndex();
                    return;
                }
                HidePane.this.lastSelectedTab = HidePane.this.tabbedPane.getSelectedIndex();
                if (!HidePane.this.lastWasDrag) {
                    HidePane.this.toggleHiddenState();
                } else if (HidePane.this.shownWidth < HidePane.this.hiddenWidth * 2) {
                    HidePane.this.shownWidth = HidePane.this.hiddenWidth;
                    HidePane.this.hiddenState = true;
                    if (HidePane.this.horizontalDivider) {
                        HidePane.this.setPreferredSize(new Dimension(HidePane.this.getPreferredSize().width, HidePane.this.shownWidth));
                    } else {
                        HidePane.this.setPreferredSize(new Dimension(HidePane.this.shownWidth, HidePane.this.getPreferredSize().height));
                    }
                    HidePane.this.revalidate();
                    HidePane.this.repaint();
                }
                for (VisiblePanelSetting panelSetting : HidePane.this.registeredPanelSettings) {
                    panelSetting.setPanelWidth(HidePane.this.shownWidth);
                }
            }

            public void mousePressed(MouseEvent e) {
                HidePane.this.lastWasDrag = false;
                if (HidePane.this.horizontalDivider) {
                    HidePane.this.dragStartPosition = e.getYOnScreen();
                } else {
                    HidePane.this.dragStartPosition = e.getXOnScreen();
                }
                super.mousePressed(e);
            }
        });
        if (this.horizontalDivider) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.hiddenWidth));
        } else {
            this.setPreferredSize(new Dimension(this.hiddenWidth, this.getPreferredSize().height));
        }
    }

    public void addTab(String tabString, Component tabComponent) {
        int insertIndex = 0;
        for (int tabCounter = 0; tabCounter < this.tabbedPane.getTabCount() && tabString.compareToIgnoreCase(this.tabbedPane.getTitleAt(tabCounter)) >= 0; ++tabCounter) {
            ++insertIndex;
        }
        this.tabbedPane.insertTab(tabString, null, tabComponent, tabString, insertIndex);
    }

    public void addTab(VisiblePanelSetting panelSetting, String tabString, Component tabComponent) {
        this.addTab(tabString, tabComponent);
        this.shownWidth = panelSetting.getPanelWidth();
        this.hiddenState = false;
        if (this.horizontalDivider) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.shownWidth));
        } else {
            this.setPreferredSize(new Dimension(this.shownWidth, this.getPreferredSize().height));
        }
        this.setVisible(true);
        this.revalidate();
        this.repaint();
        this.registeredPanelSettings.add(panelSetting);
    }

    public Component[] getComponents() {
        return this.tabbedPane.getComponents();
    }

    public Component getSelectedComponent() {
        return this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedComponent(Component component) {
        this.tabbedPane.setSelectedComponent(component);
    }

    public void removeTab(Component comp) {
        this.tabbedPane.remove(comp);
    }

    public void remove(VisiblePanelSetting panelSetting) {
        for (Component currentPanel : panelSetting.getTargetPanels()) {
            this.tabbedPane.remove(currentPanel);
        }
        this.setVisible(this.tabbedPane.getComponentCount() > 0);
        this.registeredPanelSettings.remove(panelSetting);
    }

    public void setHiddeState() {
        boolean showEditor;
        boolean bl = showEditor = this.tabbedPane.getComponentCount() > 0;
        if (this.hiddenState == showEditor) {
            this.toggleHiddenState();
        }
        this.setVisible(showEditor);
    }

    private void toggleHiddenState() {
        if (!this.hiddenState) {
            if (this.horizontalDivider) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.hiddenWidth));
            } else {
                this.setPreferredSize(new Dimension(this.hiddenWidth, this.getPreferredSize().height));
            }
        } else {
            if (this.shownWidth < this.hiddenWidth * 2) {
                this.shownWidth = this.defaultShownWidth;
            }
            if (this.horizontalDivider) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.shownWidth));
            } else {
                this.setPreferredSize(new Dimension(this.shownWidth, this.getPreferredSize().height));
            }
        }
        this.hiddenState = !this.hiddenState;
        this.revalidate();
        this.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HidePanePosition {
        left,
        right,
        top,
        bottom;

    }
}

