/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.kinnate.entityindexer.IndexerParam;
import nl.mpi.kinnate.ui.FieldSelectionList;
import nl.mpi.kinnate.ui.KinTypeStringInput;

public class TableCellDragHandler
extends TransferHandler
implements Transferable {
    private ArbilField[] selectedFields = null;
    private DataFlavor dataFlavor = new DataFlavor(ArbilField[].class, "ArbilField");

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(DataFlavor.stringFlavor)) {
            String returnString = "";
            for (ArbilField imdiField : this.selectedFields) {
                returnString = returnString + this.convertToKinTypeStringQuery(imdiField.getFullXmlPath(), imdiField.getFieldValue());
            }
            return returnString;
        }
        throw new UnsupportedFlavorException(df);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canImport(TransferHandler.TransferSupport ts) {
        if (!ts.isDataFlavorSupported(this.dataFlavor)) {
            return false;
        }
        Component dropLocation = ts.getComponent();
        if (dropLocation instanceof FieldSelectionList) {
            return true;
        }
        return dropLocation instanceof KinTypeStringInput;
    }

    protected Transferable createTransferable(JComponent jc) {
        this.selectedFields = ((ArbilTable)jc).getSelectedFields();
        return this;
    }

    public int getSourceActions(JComponent jc) {
        return 1;
    }

    private String convertToKinTypeStringQuery(String fieldName, String fieldValue) {
        fieldName = fieldName.replace(".Kinnate.Metadata.", "");
        String queryString = "[" + fieldName + "=" + fieldValue + "]";
        return queryString;
    }

    private String convertToBooleanQuery(String fieldName, String fieldValue) {
        int lastIndexOf = fieldName.lastIndexOf(".");
        String queryNode = fieldName.substring(lastIndexOf + 1);
        String queryString = fieldName.substring(0, lastIndexOf);
        queryString = queryString.replace(".", "/*:");
        queryString = queryString.substring(1);
        queryString = queryString + "[*:" + queryNode + "='" + fieldValue + "']";
        return queryString;
    }

    private String convertToSelectQuery(String fieldName, String fieldValue) {
        String queryString = fieldName.replace(".", "/*:");
        queryString = queryString.substring(1);
        return queryString;
    }

    public boolean importData(TransferHandler.TransferSupport ts) {
        if (ts.getComponent() instanceof FieldSelectionList) {
            IndexerParam indexerParam = ((FieldSelectionList)ts.getComponent()).indexerParam;
            for (ArbilField imdiField : this.selectedFields) {
                String queryString;
                String paramValue = null;
                if (indexerParam.getAvailableValues() != null) {
                    queryString = this.convertToBooleanQuery(imdiField.getFullXmlPath(), imdiField.getFieldValue());
                    paramValue = "";
                } else {
                    queryString = this.convertToSelectQuery(imdiField.getFullXmlPath(), imdiField.getFieldValue());
                }
                indexerParam.setValue(queryString, paramValue);
            }
            ((FieldSelectionList)ts.getComponent()).updateUiList();
            return true;
        }
        if (ts.getComponent() instanceof KinTypeStringInput) {
            return false;
        }
        return false;
    }
}

