/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class WindowedDiagramManager
extends AbstractDiagramManager {
    private HashMap<JFrame, String> titleMap = new HashMap();
    private ArrayList<JFrame> diagramArray = new ArrayList();

    public WindowedDiagramManager(ApplicationVersionManager versionManager) {
        super(versionManager);
    }

    public void createApplicationWindow() {
    }

    protected void closeWindowAction(JFrame windowFrame) {
        if (this.diagramArray.size() == 1) {
            super.closeWindowAction(windowFrame);
        } else {
            int selectedIndex = this.diagramArray.indexOf(windowFrame);
            if (windowFrame instanceof SavePanel) {
                SavePanel savePanel = (SavePanel)((Object)windowFrame);
                String diagramTitle = this.getSavePanelTitle(selectedIndex);
                boolean userCanceled = this.offerUserToSave(savePanel, diagramTitle);
                if (!userCanceled) {
                    this.closeSavePanel(selectedIndex);
                }
            } else {
                this.closeSavePanel(selectedIndex);
            }
        }
    }

    public void createDiagramContainer(String diagramTitle, Component diagramComponent) {
        JFrame diagramWindow = super.createDiagramWindow(diagramTitle, diagramComponent);
        this.titleMap.put(diagramWindow, diagramTitle);
        this.diagramArray.add(diagramWindow);
    }

    public void createDiagramSubPanel(String diagramTitle, Component diagramComponent) {
        JTabbedPane tabbedPane;
        int currentDiagramIndex = this.getSavePanelIndex();
        JFrame diagramFame = (JFrame)this.getDiagramAt(currentDiagramIndex);
        Container currentComponent = diagramFame.getContentPane();
        if (!(currentComponent instanceof JTabbedPane)) {
            tabbedPane = new JTabbedPane();
            String savePanelTitle = this.getSavePanelTitle(currentDiagramIndex);
            tabbedPane.addTab(savePanelTitle, currentComponent);
            diagramFame.setContentPane(tabbedPane);
        } else {
            tabbedPane = (JTabbedPane)currentComponent;
        }
        tabbedPane.addTab(diagramTitle, diagramComponent);
    }

    Component getSelectedDiagram() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public void setSelectedDiagram(Component diagramComponent) {
        ((JFrame)diagramComponent).toFront();
    }

    public void setSelectedDiagram(int diagramIndex) {
        if (this.diagramArray.size() > diagramIndex) {
            this.setSelectedDiagram(this.diagramArray.get(diagramIndex));
        } else {
            this.setSelectedDiagram(null);
        }
    }

    public int getSavePanelIndex() {
        return this.diagramArray.indexOf(this.getSelectedDiagram());
    }

    public String getSavePanelTitle(int selectedIndex) {
        return this.titleMap.get(this.diagramArray.get(selectedIndex));
    }

    Component getDiagramAt(int diagramIndex) {
        return this.diagramArray.get(diagramIndex);
    }

    public void closeSavePanel(int selectedIndex) {
        JFrame diagramFrame = this.diagramArray.get(selectedIndex);
        this.titleMap.remove(this.diagramArray.get(selectedIndex));
        this.diagramArray.remove(selectedIndex);
        diagramFrame.dispose();
        while (this.diagramArray.size() <= selectedIndex && selectedIndex > 0) {
            --selectedIndex;
        }
        this.setSelectedDiagram(selectedIndex);
    }

    public void setDiagramTitle(int diagramIndex, String diagramTitle) {
        this.titleMap.put(this.diagramArray.get(diagramIndex), diagramTitle);
        this.setWindowTitle(this.diagramArray.get(diagramIndex), diagramTitle);
    }

    public Component[] getAllDiagrams() {
        return this.diagramArray.toArray(new Component[0]);
    }
}

