/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MimeHashQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilIcons {
    private static ApplicationVersionManager versionManager;
    public ImageIcon linorgIcon;
    public ImageIcon serverIcon;
    public ImageIcon directoryIcon;
    public ImageIcon computerIcon;
    public ImageIcon loadingIcon;
    private ImageIcon localicon;
    private ImageIcon remoteicon;
    private ImageIcon localWithArchiveHandle;
    private ImageIcon writtenresourceIcon;
    private ImageIcon videoIcon;
    private ImageIcon audioIcon;
    public ImageIcon corpusnodeColorIcon;
    private ImageIcon missingRedIcon;
    private ImageIcon picturesIcon;
    private ImageIcon questionRedIcon;
    public ImageIcon dataIcon;
    public ImageIcon fieldIcon;
    private ImageIcon dataemptyIcon;
    private ImageIcon dataContainerIcon;
    public ImageIcon sessionColorIcon;
    public ImageIcon clarinIcon;
    public ImageIcon kinOathIcon;
    public ImageIcon catalogueColorIcon;
    private ImageIcon exclamationBlueIcon;
    private ImageIcon exclamationRedIcon;
    public ImageIcon languageIcon;
    private ImageIcon tickBlueIcon;
    private ImageIcon fileIcon;
    private ImageIcon tickGreenIcon;
    private ImageIcon infofileIcon;
    public ImageIcon favouriteIcon;
    public ImageIcon lockedIcon;
    public ImageIcon unLockedIcon;
    public ImageIcon vocabularyOpenIcon;
    public ImageIcon vocabularyOpenListIcon;
    public ImageIcon vocabularyClosedIcon;
    public ImageIcon vocabularyClosedListIcon;
    public ImageIcon attributeIcon;
    public final ImageIcon orderAsc;
    public final ImageIcon orderDesc;
    private static BugCatcher bugCatcher;
    private static ArbilIcons singleInstance;

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static synchronized ArbilIcons getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilIcons();
        }
        return singleInstance;
    }

    private ArbilIcons() {
        this.linorgIcon = new ImageIcon(versionManager.getApplicationVersion().getClass().getResource(ArbilIcons.versionManager.getApplicationVersion().applicationIconName));
        this.serverIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/server16x16.png"));
        this.directoryIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/directory16x16.png"));
        this.computerIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/computer16x16.png"));
        this.loadingIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/loading01.png"));
        this.localicon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/local.png"));
        this.remoteicon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/remote.png"));
        this.localWithArchiveHandle = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/localarchivehandle.png"));
        this.writtenresourceIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/writtenresource.png"));
        this.videoIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/video.png"));
        this.audioIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/audio.png"));
        this.corpusnodeColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/corpusnode_color.png"));
        this.missingRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/notfound.png"));
        this.picturesIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/pictures.png"));
        this.questionRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/question-red.png"));
        this.dataIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/data.png"));
        this.fieldIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/field.png"));
        this.dataemptyIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/dataempty.png"));
        this.dataContainerIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/datacontainer.png"));
        this.sessionColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/session_color.png"));
        this.clarinIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/clarinE.png"));
        this.kinOathIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/KinOath-16.png"));
        this.catalogueColorIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/catalogue.png"));
        this.exclamationBlueIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-blue.png"));
        this.exclamationRedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-red.png"));
        this.languageIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/language.png"));
        this.tickBlueIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-blue.png"));
        this.fileIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/file.png"));
        this.tickGreenIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-green.png"));
        this.infofileIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/infofile.png"));
        this.favouriteIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/favourite.png"));
        this.lockedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/lock.png"));
        this.unLockedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/unlock.png"));
        this.vocabularyOpenIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_open.png"));
        this.vocabularyOpenListIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_open_list.png"));
        this.vocabularyClosedIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_closed.png"));
        this.vocabularyClosedListIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/vocabulary_closed_list.png"));
        this.attributeIcon = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/attribute.png"));
        this.orderAsc = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/order-asc.png"));
        this.orderDesc = new ImageIcon(ArbilIcons.class.getResource("/nl/mpi/arbil/resources/icons/order-desc.png"));
    }

    public ImageIcon getIconForNode(ArbilDataNode[] arbilNodeArray) {
        int currentIconXPosition = 0;
        int width = 0;
        int heightMax = 0;
        for (ArbilDataNode currentNode : arbilNodeArray) {
            width += currentNode.getIcon().getIconWidth();
            int height = currentNode.getIcon().getIconHeight();
            if (heightMax >= height) continue;
            heightMax = height;
        }
        BufferedImage bufferedImage = new BufferedImage(width, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (ArbilDataNode childNode : arbilNodeArray) {
            ImageIcon currentIcon = childNode.getIcon();
            currentIcon.paintIcon(null, g2d, currentIconXPosition, 0);
            currentIconXPosition += currentIcon.getIconWidth();
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon compositIcons(List<Icon> iconArray) {
        int widthTotal = 0;
        int heightMax = 0;
        for (Icon currentIcon : iconArray) {
            int width = currentIcon.getIconWidth();
            int height = currentIcon.getIconHeight();
            if (currentIcon != this.missingRedIcon) {
                widthTotal += width;
            }
            if (heightMax >= height) continue;
            heightMax = height;
        }
        int currentIconXPosition = 0;
        BufferedImage bufferedImage = new BufferedImage(widthTotal, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (Icon currentIcon : iconArray) {
            int yPos = (heightMax - currentIcon.getIconHeight()) / 2;
            if (currentIcon != this.missingRedIcon) {
                currentIcon.paintIcon(null, g2d, currentIconXPosition, yPos);
                currentIconXPosition += currentIcon.getIconWidth();
                continue;
            }
            currentIcon.paintIcon(null, g2d, currentIconXPosition - this.missingRedIcon.getIconWidth(), yPos);
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    public Icon getIconForVocabulary(ArbilField cellObject) {
        if (cellObject.hasVocabulary()) {
            if (cellObject.isVocabularyOpen()) {
                if (cellObject.isVocabularyList()) {
                    return this.vocabularyOpenListIcon;
                }
                return this.vocabularyOpenIcon;
            }
            if (cellObject.isVocabularyList()) {
                return this.vocabularyClosedListIcon;
            }
            return this.vocabularyClosedIcon;
        }
        return null;
    }

    public Icon getIconForField(ArbilField field) {
        LinkedList<Icon> iconsList = new LinkedList<Icon>();
        if (field.hasVocabulary()) {
            iconsList.add(this.getIconForVocabulary(field));
        }
        if (field.isAllowsLanguageId()) {
            iconsList.add(this.languageIcon);
        }
        if (field.hasEditableFieldAttributes()) {
            iconsList.add(this.attributeIcon);
        }
        switch (iconsList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Icon)iconsList.get(0);
            }
        }
        return this.compositIcons(iconsList);
    }

    public ImageIcon getIconForNode(ArbilDataNode arbilNode) {
        LinkedList<Icon> iconsList = new LinkedList<Icon>();
        if (arbilNode.isLoading() || arbilNode.getParentDomNode().isMetaDataNode() && !arbilNode.getParentDomNode().isDataLoaded()) {
            iconsList.add(this.loadingIcon);
        }
        if (arbilNode.isLocal()) {
            if (arbilNode.isMetaDataNode()) {
                if (arbilNode.matchesRemote == 0) {
                    if (arbilNode.archiveHandle == null) {
                        iconsList.add(this.localicon);
                    } else {
                        iconsList.add(this.localWithArchiveHandle);
                    }
                } else {
                    iconsList.add(this.remoteicon);
                }
            }
        } else {
            iconsList.add(this.remoteicon);
        }
        if (arbilNode.resourceFileServerResponse == 200) {
            iconsList.add(this.unLockedIcon);
        } else if (arbilNode.resourceFileServerResponse == 302) {
            iconsList.add(this.lockedIcon);
        }
        String mimeTypeForNode = arbilNode.getAnyMimeType();
        if (arbilNode.isMetaDataNode()) {
            if (arbilNode.isChildNode()) {
                if (arbilNode.isContainerNode()) {
                    iconsList.add(this.dataContainerIcon);
                } else if (arbilNode.isEmptyMetaNode()) {
                    iconsList.add(this.dataemptyIcon);
                } else {
                    iconsList.add(this.dataIcon);
                }
            } else if (arbilNode.isSession()) {
                iconsList.add(this.sessionColorIcon);
            } else if (arbilNode.isCatalogue()) {
                iconsList.add(this.catalogueColorIcon);
            } else if (arbilNode.isCorpus()) {
                iconsList.add(this.corpusnodeColorIcon);
            } else if (arbilNode.isCmdiMetaDataNode()) {
                iconsList.add(MetadataFormat.getFormatIcon(arbilNode.getURI().getPath()));
            } else if (arbilNode.isDataLoaded()) {
                iconsList.add(this.fileIcon);
            }
        } else if (mimeTypeForNode != null) {
            if ((mimeTypeForNode = mimeTypeForNode.toLowerCase()).contains("audio")) {
                iconsList.add(this.audioIcon);
            } else if (mimeTypeForNode.contains("video")) {
                iconsList.add(this.videoIcon);
            } else if (mimeTypeForNode.contains("image")) {
                iconsList.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("text")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("xml")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("chat")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("pdf")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("kml")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("manual/mediafile")) {
                iconsList.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("manual/writtenresource")) {
                iconsList.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("unspecified") || mimeTypeForNode.length() == 0) {
                iconsList.add(this.fileIcon);
            } else if (mimeTypeForNode.contains("unknown")) {
                iconsList.add(this.questionRedIcon);
            } else if (mimeTypeForNode.length() > 0) {
                iconsList.add(this.questionRedIcon);
                bugCatcher.logError(mimeTypeForNode, new Exception("Icon not found for file type: " + mimeTypeForNode));
            }
        } else if (arbilNode.isInfoLink) {
            iconsList.add(this.infofileIcon);
        } else if (arbilNode.hasResource()) {
            iconsList.add(this.fileIcon);
        } else if (arbilNode.isDirectory()) {
            iconsList.add(UIManager.getIcon("FileView.directoryIcon"));
        } else {
            iconsList.add(this.fileIcon);
            if (!arbilNode.getTypeCheckerState().equals((Object)MimeHashQueue.TypeCheckerState.CHECKED)) {
                iconsList.add(this.questionRedIcon);
            }
        }
        if (arbilNode.fileNotFound || arbilNode.resourceFileNotFound()) {
            if (arbilNode.isResourceSet()) {
                iconsList.add(this.missingRedIcon);
            } else {
                iconsList.add(this.questionRedIcon);
            }
        }
        if (!arbilNode.isMetaDataNode() && arbilNode.matchesInCache + arbilNode.matchesRemote > 0) {
            if (arbilNode.matchesRemote > 0) {
                iconsList.add(this.tickGreenIcon);
            } else {
                iconsList.add(this.tickBlueIcon);
            }
        }
        if (arbilNode.isFavorite()) {
            iconsList.add(this.favouriteIcon);
        }
        return this.compositIcons(iconsList);
    }

    static {
        singleInstance = null;
    }
}

