/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilFavouritesSorter;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilFieldComparator;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilNodeSorter;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.FieldUpdateRequest;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.CmdiUtils;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ArrayComparator;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNode
extends ArbilNode
implements Comparable {
    public MetadataUtils metadataUtils;
    public ArbilTemplate nodeTemplate;
    private Hashtable<String, ArbilField[]> fieldHashtable;
    private ArbilDataNode[] childArray = new ArbilDataNode[0];
    private boolean dataLoaded;
    public int resourceFileServerResponse = -1;
    public String hashString;
    public String mpiMimeType = null;
    public String typeCheckerMessage;
    private MimeHashQueue.TypeCheckerState typeCheckerState = MimeHashQueue.TypeCheckerState.UNCHECKED;
    public int matchesInCache;
    public int matchesRemote;
    public int matchesLocalFileSystem;
    public boolean fileNotFound;
    public boolean isInfoLink = false;
    private boolean singletonMetadataNode = false;
    private boolean nodeNeedsSaveToDisk;
    private String nodeText;
    private String lastNodeText = "loading node...";
    private URI nodeUri;
    private boolean containerNode = false;
    public ArbilField resourceUrlField;
    public CmdiComponentLinkReader cmdiComponentLinkReader = null;
    public boolean isDirectory;
    private ImageIcon icon;
    private boolean nodeEnabled;
    public boolean hasSchemaError = false;
    private String[][] childLinks = new String[0][0];
    private int isLoadingCount = 0;
    private final Object loadingCountLock = new Object();
    @Deprecated
    public boolean lockedByLoadingThread = false;
    public String archiveHandle = null;
    public boolean hasDomIdAttribute = false;
    public boolean scrollToRequested = false;
    private ArbilDataNode domParentNode = null;
    public File thumbnailFile = null;
    private final Object domLockObjectPrivate = new Object();
    private static final String NODE_LOADING_TEXT = "loading node...";
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static DataNodeLoader dataNodeLoader;
    private static MimeHashQueue mimeHashQueue;
    private Boolean isFavorite = null;
    private static ArbilNodeSorter dataNodeSorter;
    private static ArbilNodeSorter favouriteSorter;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setMimeHashQueue(MimeHashQueue mimeHashQueueInstance) {
        mimeHashQueue = mimeHashQueueInstance;
    }

    protected ArbilDataNode(URI localUri) {
        this.nodeUri = localUri;
        if (this.nodeUri != null) {
            this.metadataUtils = ArbilDataNode.getMetadataUtils(this.nodeUri.toString());
        }
        this.initNodeVariables();
    }

    public void setNodeText(String localNodeText) {
        if (this.nodeText == null) {
            this.nodeText = localNodeText;
        }
    }

    private static String urlEncodePath(String inputPath) {
        String encodedString = null;
        try {
            for (String inputStringPart : inputPath.split("/")) {
                encodedString = encodedString == null ? URLEncoder.encode(inputStringPart, "UTF-8") : encodedString + "/" + URLEncoder.encode(inputStringPart, "UTF-8");
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
        return encodedString;
    }

    public static URI conformStringToUrl(String inputUrlString) {
        try {
            if (!(inputUrlString.toLowerCase().startsWith("http") || inputUrlString.toLowerCase().startsWith("file:") || inputUrlString.toLowerCase().startsWith("."))) {
                return new File(inputUrlString).toURI();
            }
            int protocolEndIndex = inputUrlString.startsWith(".") ? 0 : inputUrlString.indexOf(":/");
            String protocolComponent = inputUrlString.substring(0, protocolEndIndex);
            String remainingComponents = inputUrlString.substring(protocolEndIndex + 1);
            String[] pathComponentArray = remainingComponents.split("#");
            String pathComponent = pathComponentArray[0];
            String fragmentComponent = null;
            if (pathComponentArray.length > 1) {
                fragmentComponent = pathComponentArray[1];
            }
            return new URI(protocolComponent, pathComponent, fragmentComponent);
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
            return null;
        }
    }

    public static URI normaliseURI(URI inputURI) {
        boolean isUncPath = inputURI.toString().toLowerCase().startsWith("file:////");
        URI returnURI = inputURI.normalize();
        if (isUncPath) {
            try {
                returnURI = new URI("file:////" + returnURI.toString().substring("file:/".length()));
            }
            catch (URISyntaxException urise) {
                bugCatcher.logError(urise);
            }
        }
        return returnURI;
    }

    public static boolean isArbilDataNode(Object unknownObj) {
        if (unknownObj == null) {
            return false;
        }
        return unknownObj instanceof ArbilDataNode;
    }

    public static boolean isStringLocal(String urlString) {
        return !urlString.startsWith("http");
    }

    public static boolean isPathHistoryFile(String urlString) {
        return MetadataFormat.isPathMetadata(urlString.replaceAll("mdi.[0-9]*$", "mdi"));
    }

    public static boolean isPathMetadata(String urlString) {
        return ArbilDataNode.isPathImdi(urlString) || ArbilDataNode.isPathCmdi(urlString);
    }

    public static boolean isPathImdi(String urlString) {
        return urlString.endsWith(".imdi");
    }

    public static boolean isPathCmdi(String urlString) {
        return urlString.endsWith(".cmdi");
    }

    public static boolean isStringChildNode(String urlString) {
        return urlString.contains("#.");
    }

    public static MetadataUtils getMetadataUtils(String urlString) {
        if (MetadataFormat.isPathCmdi(urlString)) {
            return new CmdiUtils();
        }
        if (MetadataFormat.isPathImdi(urlString)) {
            return new ImdiUtils();
        }
        return null;
    }

    public boolean getNeedsSaveToDisk(boolean onlyOfSubNode) {
        if (this.nodeNeedsSaveToDisk && !this.getParentDomNode().nodeNeedsSaveToDisk) {
            this.nodeNeedsSaveToDisk = false;
        }
        if (onlyOfSubNode) {
            return this.nodeNeedsSaveToDisk;
        }
        return this.getParentDomNode().nodeNeedsSaveToDisk;
    }

    public boolean hasChangedFields() {
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChangedFieldsInSubtree() {
        if (this.hasChangedFields()) {
            return true;
        }
        for (ArbilDataNode child : this.getChildArray()) {
            if (!child.hasChangedFieldsInSubtree()) continue;
            return true;
        }
        return false;
    }

    public void setDataNodeNeedsSaveToDisk(ArbilField originatingField, boolean updateUI) {
        boolean needsSaveToDisk;
        if (this.resourceUrlField != null && this.resourceUrlField.equals(originatingField)) {
            this.hashString = null;
            this.mpiMimeType = null;
            this.thumbnailFile = null;
            this.typeCheckerMessage = null;
            mimeHashQueue.addToQueue(this);
        }
        boolean bl = needsSaveToDisk = this.hasChangedFields() || this.hasDomIdAttribute;
        if (this.isMetaDataNode() && !this.isChildNode()) {
            if (!needsSaveToDisk) {
                for (ArbilDataNode childNode : this.getAllChildren()) {
                    if (!childNode.nodeNeedsSaveToDisk) continue;
                    needsSaveToDisk = true;
                }
            }
            if (this.nodeNeedsSaveToDisk != needsSaveToDisk) {
                if (needsSaveToDisk) {
                    dataNodeLoader.addNodeNeedingSave(this);
                } else {
                    dataNodeLoader.removeNodesNeedingSave(this);
                }
                this.nodeNeedsSaveToDisk = needsSaveToDisk;
            }
        } else {
            this.nodeNeedsSaveToDisk = needsSaveToDisk;
            this.getParentDomNode().setDataNodeNeedsSaveToDisk(null, updateUI);
        }
        if (updateUI) {
            this.clearIcon();
        }
    }

    public String getAnyMimeType() {
        ArbilField[] formatField;
        if (this.mpiMimeType == null && this.hasResource() && (formatField = this.fieldHashtable.get("Format")) != null && formatField.length > 0) {
            return formatField[0].getFieldValue();
        }
        return this.mpiMimeType;
    }

    public void setMimeType(String[] typeCheckerMessageArray) {
        this.mpiMimeType = typeCheckerMessageArray[0];
        this.typeCheckerMessage = typeCheckerMessageArray[1];
        if (!this.isMetaDataNode() && this.isLocal() && this.mpiMimeType != null) {
            ArbilField mimeTypeField = new ArbilField(this.fieldHashtable.size(), this, "Format", this.mpiMimeType, 0, false, null, null);
            this.addField(mimeTypeField);
        }
    }

    private String getNodeTypeNameFromUriFragment(String nodeFragmentName) {
        if (nodeFragmentName == null) {
            return null;
        }
        nodeFragmentName = nodeFragmentName.substring(nodeFragmentName.lastIndexOf(".") + 1);
        nodeFragmentName = nodeFragmentName.replaceAll("\\(\\d+\\)", "");
        return nodeFragmentName;
    }

    private void initNodeVariables() {
        if (this.childArray != null) {
            for (ArbilDataNode currentNode : this.childArray) {
                if (!currentNode.isChildNode()) continue;
                currentNode.initNodeVariables();
            }
        }
        this.fieldHashtable = new Hashtable();
        this.dataLoaded = false;
        this.hashString = null;
        this.matchesInCache = 0;
        this.matchesRemote = 0;
        this.matchesLocalFileSystem = 0;
        this.fileNotFound = false;
        this.nodeNeedsSaveToDisk = false;
        this.isDirectory = false;
        this.icon = null;
        this.nodeEnabled = true;
        this.singletonMetadataNode = false;
        this.containerNode = false;
        if (this.nodeUri != null) {
            File fileObject;
            if (!this.isMetaDataNode() && this.isLocal() && (fileObject = this.getFile()) != null) {
                this.nodeText = fileObject.getName();
                this.isDirectory = fileObject.isDirectory();
            }
            if (!this.isMetaDataNode() && this.nodeText == null) {
                this.nodeText = this.getUrlString();
            }
        }
    }

    public void reloadNode() {
        System.out.println("reloadNode: " + this.isLoading());
        this.getParentDomNode().nodeNeedsSaveToDisk = false;
        dataNodeLoader.requestReload(this.getParentDomNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArbilDom() {
        System.out.println("loadArbilDom: " + this.nodeUri.toString());
        if (this.getParentDomNode() != this) {
            this.getParentDomNode().loadArbilDom();
        } else {
            Object object = this.getParentDomLockObject();
            synchronized (object) {
                this.initNodeVariables();
                if (!this.isMetaDataNode() && !this.isDirectory() && this.isLocal()) {
                    mimeHashQueue.addToQueue(this);
                    this.dataLoaded = true;
                }
                if (this.isDirectory()) {
                    this.getDirectoryLinks();
                    this.dataLoaded = true;
                }
                if (this.isMetaDataNode()) {
                    this.loadMetadataDom();
                    this.dataLoaded = true;
                }
            }
        }
    }

    private void loadMetadataDom() {
        if (this.isLocal() && !this.getFile().exists() && new File(this.getFile().getAbsolutePath() + ".0").exists()) {
            this.copyLastHistoryToCurrent();
            messageDialogHandler.addMessageDialogToQueue("Missing file has been recovered from the last history item.", "Recover History");
        }
        try {
            this.nodeText = "unknown";
            this.initComponentLinkReader();
            this.updateMetadataChildNodes();
        }
        catch (Exception mue) {
            bugCatcher.logError(this.getUrlString(), mue);
            File nodeFile = this.getFile();
            if (nodeFile != null && nodeFile.exists()) {
                this.nodeText = "Could not load data";
            }
            this.nodeText = "File not found";
            this.fileNotFound = true;
        }
    }

    private void initComponentLinkReader() {
        if (this.isCmdiMetaDataNode()) {
            this.cmdiComponentLinkReader = new CmdiComponentLinkReader();
            this.cmdiComponentLinkReader.readLinks(this.getURI());
        } else {
            this.cmdiComponentLinkReader = null;
        }
    }

    private void updateMetadataChildNodes() throws ParserConfigurationException, SAXException, IOException, TransformerException, ArbilMetadataException {
        Document nodDom = ArbilComponentBuilder.getDocument(this.getURI());
        Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree = new Hashtable<ArbilDataNode, HashSet<ArbilDataNode>>();
        this.childLinks = this.loadMetadataChildNodes(nodDom, parentChildTree);
        this.checkRemovedChildNodes(parentChildTree);
    }

    private String[][] loadMetadataChildNodes(Document nodDom, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree) throws TransformerException, ArbilMetadataException {
        Vector<String[]> childLinks = new Vector<String[]>();
        Hashtable<String, Integer> siblingNodePathCounter = new Hashtable<String, Integer>();
        String fullNodePath = "";
        Node startNode = nodDom.getFirstChild();
        MetadataReader.getSingleInstance().iterateChildNodes(this, childLinks, startNode, fullNodePath, fullNodePath, parentChildTree, siblingNodePathCounter, 0);
        if (this.isCmdiMetaDataNode()) {
            MetadataReader.getSingleInstance().addUnreferencedResources(this, parentChildTree, childLinks);
        }
        return (String[][])childLinks.toArray((T[])new String[0][]);
    }

    private void checkRemovedChildNodes(Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree) {
        for (Map.Entry<ArbilDataNode, HashSet<ArbilDataNode>> entry : parentChildTree.entrySet()) {
            ArbilDataNode currentNode = entry.getKey();
            ArbilDataNode[] oldChildArray = currentNode.childArray;
            currentNode.childArray = parentChildTree.get(currentNode).toArray(new ArbilDataNode[0]);
            List<ArbilDataNode> currentChildList = Arrays.asList(currentNode.childArray);
            for (ArbilDataNode currentOldChild : oldChildArray) {
                if (currentChildList.indexOf(currentOldChild) != -1) continue;
                for (ArbilDataNodeContainer currentContainer : currentOldChild.getRegisteredContainers()) {
                    currentContainer.dataNodeRemoved(currentOldChild);
                }
            }
        }
    }

    private void getDirectoryLinks() {
        File[] dirLinkArray = null;
        File nodeFile = this.getFile();
        if (nodeFile != null && nodeFile.isDirectory()) {
            dirLinkArray = nodeFile.listFiles();
            Vector<ArbilDataNode> childLinksTemp = new Vector<ArbilDataNode>();
            for (int linkCount = 0; linkCount < dirLinkArray.length; ++linkCount) {
                try {
                    URI childURI = dirLinkArray[linkCount].toURI();
                    ArbilDataNode currentNode = dataNodeLoader.getArbilDataNodeWithoutLoading(childURI);
                    if (!treeHelper.isShowHiddenFilesInTree() && currentNode.getFile().isHidden()) continue;
                    childLinksTemp.add(currentNode);
                    continue;
                }
                catch (Exception ex) {
                    messageDialogHandler.addMessageDialogToQueue(dirLinkArray[linkCount] + " could not be loaded in\n" + this.nodeUri.toString(), "Load Directory");
                    bugCatcher.logError(ex);
                }
            }
            this.childArray = childLinksTemp.toArray(new ArbilDataNode[0]);
        }
    }

    @Override
    public int getChildCount() {
        return this.childArray.length;
    }

    @Override
    public ArbilDataNode[] getAllChildren() {
        Vector<ArbilDataNode> allChildren = new Vector<ArbilDataNode>();
        this.getAllChildren(allChildren);
        return allChildren.toArray(new ArbilDataNode[0]);
    }

    @Override
    public void getAllChildren(Vector<ArbilDataNode> allChildren) {
        System.out.println("getAllChildren: " + this.getUrlString());
        if (this.isSession() || this.isCatalogue() || this.isChildNode() || this.isCmdiMetaDataNode()) {
            for (ArbilDataNode currentChild : this.childArray) {
                if (currentChild == this) continue;
                currentChild.getAllChildren(allChildren);
                allChildren.add(currentChild);
            }
        }
    }

    public ArbilDataNode[] getChildArray() {
        return this.childArray;
    }

    public ArbilDataNode[] getChildNodesArray(String childType) {
        for (ArbilDataNode currentNode : this.childArray) {
            if (!currentNode.toString().equals(childType)) continue;
            return currentNode.getChildArray();
        }
        return null;
    }

    public ArbilDataNode getChildByPath(String path) {
        if (this.childArray != null && this.childArray.length > 0) {
            for (ArbilDataNode child : this.childArray) {
                if (child.getURI() != null && path.equals(child.getURI().getFragment())) {
                    return child;
                }
                ArbilDataNode childMatch = child.getChildByPath(path);
                if (childMatch == null) continue;
                return childMatch;
            }
        }
        return null;
    }

    public ArbilTemplate getNodeTemplate() {
        if (this.nodeTemplate != null && !this.isCorpus()) {
            return this.nodeTemplate;
        }
        if (this.isChildNode()) {
            return this.getParentDomNode().getNodeTemplate();
        }
        return ArbilTemplateManager.getSingleInstance().getDefaultTemplate();
    }

    public File getSubDirectory() {
        String currentFileName = this.getFile().getParent();
        if (MetadataFormat.isPathImdi(this.nodeUri.getPath()) || MetadataFormat.isPathCmdi(this.nodeUri.getPath())) {
            File destinationDir = new File(currentFileName = currentFileName + File.separatorChar + this.getFile().getName().substring(0, this.getFile().getName().length() - 5));
            if (!destinationDir.exists() && !destinationDir.mkdir()) {
                bugCatcher.logError(new Exception("Could not create directory " + destinationDir.getAbsolutePath()));
            }
            return destinationDir;
        }
        return new File(this.getFile().getParent());
    }

    public boolean containsFieldValue(String fieldName, String searchValue) {
        boolean findResult = false;
        ArbilField[] currentFieldArray = this.fieldHashtable.get(fieldName);
        if (currentFieldArray != null) {
            for (ArbilField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.getFieldValue() + ":" + searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean containsFieldValue(String searchValue) {
        boolean findResult = false;
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.getFieldValue() + ":" + searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean getNodeEnabled() {
        return this.nodeEnabled;
    }

    public boolean canHaveChildren() {
        return this.childArray.length > 0;
    }

    private void getAllFields(Vector<ArbilField[]> allFields) {
        System.out.println("getAllFields: " + this.toString());
        allFields.addAll(this.fieldHashtable.values());
        for (ArbilDataNode currentChild : this.childArray) {
            if (!currentChild.isChildNode()) continue;
            currentChild.getAllFields(allFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCorpusLink(ArbilDataNode[] targetImdiNodes) {
        if (this.nodeNeedsSaveToDisk) {
            this.saveChangesToCache(false);
        }
        try {
            this.bumpHistory();
            this.copyLastHistoryToCurrent();
            Object object = this.getParentDomLockObject();
            synchronized (object) {
                System.out.println("deleting by corpus link");
                URI[] copusUriList = new URI[targetImdiNodes.length];
                for (int nodeCounter = 0; nodeCounter < targetImdiNodes.length; ++nodeCounter) {
                    copusUriList[nodeCounter] = targetImdiNodes[nodeCounter].getURI();
                }
                this.metadataUtils.removeCorpusLink(this.getURI(), copusUriList);
                this.getParentDomNode().loadArbilDom();
            }
            for (ArbilDataNode removedChild : targetImdiNodes) {
                removedChild.removeFromAllContainers();
            }
        }
        catch (IOException ex) {
            bugCatcher.logError("I/O exception while deleting nodes from " + this.toString(), ex);
            messageDialogHandler.addMessageDialogToQueue("Could not delete nodes because an error occurred while saving history for node. See error log for details.", "Error while moving nodes");
        }
        this.getParentDomNode().clearIcon();
        this.getParentDomNode().clearChildIcons();
        this.clearIcon();
    }

    @Override
    public boolean hasCatalogue() {
        for (ArbilDataNode childNode : this.childArray) {
            if (!childNode.isCatalogue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCorpusLink(ArbilDataNode targetImdiNode) {
        boolean linkAlreadyExists = false;
        if (targetImdiNode.isCatalogue() && this.hasCatalogue()) {
            return false;
        }
        for (String[] currentLinkPair : this.childLinks) {
            String currentChildPath = currentLinkPair[0];
            if (!targetImdiNode.waitTillLoaded()) {
                messageDialogHandler.addMessageDialogToQueue("Error adding node, could not wait for file to load", "Loading Error");
                return false;
            }
            if (!currentChildPath.equals(targetImdiNode.getUrlString())) continue;
            linkAlreadyExists = true;
        }
        if (targetImdiNode.getUrlString().equals(this.getUrlString())) {
            messageDialogHandler.addMessageDialogToQueue("Cannot link or move a node into itself", null);
            return false;
        }
        if (linkAlreadyExists) {
            messageDialogHandler.addMessageDialogToQueue(targetImdiNode + " already exists in " + this + " and will not be added again", null);
            return false;
        }
        if (this.nodeNeedsSaveToDisk) {
            this.saveChangesToCache(true);
        }
        try {
            this.bumpHistory();
            this.copyLastHistoryToCurrent();
            Object object = this.getParentDomLockObject();
            synchronized (object) {
                return this.metadataUtils.addCorpusLink(this.getURI(), new URI[]{targetImdiNode.getURI()});
            }
        }
        catch (IOException iOException) {
            bugCatcher.logError("I/O exception while moving node " + targetImdiNode.toString() + " to " + this.toString(), iOException);
            messageDialogHandler.addMessageDialogToQueue("Could not move nodes because an error occurred while saving history for node. See error log for details.", "Error while moving nodes");
            return false;
        }
    }

    public void pasteIntoNode() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
                System.out.println("clipBoardString: " + clipBoardString);
                String[] elements = clipBoardString.contains("\n") ? clipBoardString.split("\n") : new String[]{clipBoardString};
                for (String element : elements) {
                }
                for (ArbilDataNode clipboardNode : this.pasteIntoNode(elements)) {
                    new MetadataBuilder().requestAddNode(this, "copy of " + clipboardNode, clipboardNode);
                }
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
    }

    private Collection<ArbilDataNode> pasteIntoNode(String[] clipBoardStrings) {
        ArrayList<ArbilDataNode> nodesToAdd = new ArrayList<ArbilDataNode>();
        boolean ignoreSaveChanges = false;
        for (String clipBoardString : clipBoardStrings) {
            if (this.isCorpus()) {
                if (MetadataFormat.isPathMetadata(clipBoardString) || ArbilDataNode.isStringChildNode(clipBoardString)) {
                    ArbilDataNode clipboardNode = dataNodeLoader.getArbilDataNode(null, ArbilDataNode.conformStringToUrl(clipBoardString));
                    if (sessionStorage.pathIsInsideCache(clipboardNode.getFile())) {
                        if (!ArbilDataNode.isStringChildNode(clipBoardString) || this.isSession() || this.isChildNode()) {
                            if (this.getFile().exists()) {
                                if (!ignoreSaveChanges && clipboardNode.getNeedsSaveToDisk(false)) {
                                    if (2 == messageDialogHandler.showDialogBox("Some of the nodes to be copied contain unsaved changes.\nUnless they are saved, these changes will not be present in the resulting nodes. Continue anyway?", "Copying with unsaved changes", 2, -1)) {
                                        return new ArrayList<ArbilDataNode>(0);
                                    }
                                    ignoreSaveChanges = true;
                                }
                                nodesToAdd.add(clipboardNode);
                                continue;
                            }
                            messageDialogHandler.addMessageDialogToQueue("The target node's file does not exist", null);
                            continue;
                        }
                        messageDialogHandler.addMessageDialogToQueue("Cannot paste session subnodes into a corpus", null);
                        continue;
                    }
                    messageDialogHandler.addMessageDialogToQueue("The target file is not in the cache", null);
                    continue;
                }
                messageDialogHandler.addMessageDialogToQueue("Pasted string is not and IMDI file", null);
                continue;
            }
            if (this.isMetaDataNode() || this.isSession()) {
                ArbilDataNode templateDataNode = dataNodeLoader.getArbilDataNode(null, ArbilDataNode.conformStringToUrl(clipBoardString));
                if (MetadataReader.getSingleInstance().nodeCanExistInNode(this, templateDataNode)) {
                    new MetadataBuilder().requestAddNode(this, templateDataNode.toString(), templateDataNode);
                    continue;
                }
                messageDialogHandler.addMessageDialogToQueue("Cannot copy '" + templateDataNode.toString() + "' to '" + this.toString() + "'", "Cannot copy");
                continue;
            }
            messageDialogHandler.addMessageDialogToQueue("Nodes of this type cannot be pasted into at this stage", null);
        }
        return nodesToAdd;
    }

    public synchronized void saveChangesToCache(boolean updateUI) {
        if (this != this.getParentDomNode()) {
            this.getParentDomNode().saveChangesToCache(updateUI);
            return;
        }
        System.out.println("saveChangesToCache");
        ArbilJournal.getSingleInstance().clearFieldChangeHistory();
        if (!this.isLocal()) {
            System.out.println("should not try to save remote files");
            return;
        }
        ArrayList<FieldUpdateRequest> fieldUpdateRequests = new ArrayList<FieldUpdateRequest>();
        Vector<ArbilField[]> allFields = new Vector<ArbilField[]>();
        this.getAllFields(allFields);
        Enumeration<ArbilField[]> fieldsEnum = allFields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ArbilField[] currentFieldArray = fieldsEnum.nextElement();
            for (int fieldCounter = 0; fieldCounter < currentFieldArray.length; ++fieldCounter) {
                ArbilField currentField = currentFieldArray[fieldCounter];
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                FieldUpdateRequest currentFieldUpdateRequest = new FieldUpdateRequest();
                currentFieldUpdateRequest.keyNameValue = currentField.getKeyName();
                currentFieldUpdateRequest.fieldOldValue = currentField.originalFieldValue;
                currentFieldUpdateRequest.fieldNewValue = currentField.getFieldValueForXml();
                currentFieldUpdateRequest.fieldPath = currentField.getFullXmlPath();
                currentFieldUpdateRequest.fieldLanguageId = currentField.getLanguageId();
                currentFieldUpdateRequest.attributeValuesMap = currentField.getAttributeValuesMap();
                fieldUpdateRequests.add(currentFieldUpdateRequest);
            }
        }
        ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
        boolean result = componentBuilder.setFieldValues(this, fieldUpdateRequests.toArray(new FieldUpdateRequest[0]));
        if (!result) {
            messageDialogHandler.addMessageDialogToQueue("Error saving changes to disk, check the log file via the help menu for more information.", "Save");
        } else {
            this.nodeNeedsSaveToDisk = false;
        }
    }

    public void addField(ArbilField fieldToAdd) {
        ArbilField[] currentFieldsArray = this.fieldHashtable.get(fieldToAdd.getTranslateFieldName());
        if (currentFieldsArray == null) {
            currentFieldsArray = new ArbilField[]{fieldToAdd};
        } else {
            ArbilField[] appendedFieldsArray = new ArbilField[currentFieldsArray.length + 1];
            System.arraycopy(currentFieldsArray, 0, appendedFieldsArray, 0, currentFieldsArray.length);
            appendedFieldsArray[appendedFieldsArray.length - 1] = fieldToAdd;
            currentFieldsArray = appendedFieldsArray;
        }
        this.fieldHashtable.put(fieldToAdd.getTranslateFieldName(), currentFieldsArray);
        if (fieldToAdd.xmlPath.endsWith(".ResourceLink") && fieldToAdd.getParentDataNode().isChildNode()) {
            this.resourceUrlField = fieldToAdd;
            mimeHashQueue.addToQueue(this);
        }
    }

    public Hashtable<String, ArbilField[]> getFields() {
        return this.fieldHashtable;
    }

    public List<ArbilField[]> getFieldsSorted() {
        ArrayList<ArbilField[]> fieldArrays = new ArrayList<ArbilField[]>(this.getFields().values());
        Collections.sort(fieldArrays, new ArrayComparator<ArbilField>(new ArbilFieldComparator(), 0));
        return fieldArrays;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this.isFavorite()) {
            return favouriteSorter.compare(this, o);
        }
        return dataNodeSorter.compare(this, o);
    }

    public synchronized void notifyLoaded() {
        this.getParentDomNode().notifyAll();
    }

    public synchronized boolean waitTillLoaded() {
        System.out.println("waitTillLoaded");
        if (this != this.getParentDomNode()) {
            return this.getParentDomNode().waitTillLoaded();
        }
        if (this.isLoading()) {
            System.out.println("isLoading");
            try {
                this.getParentDomNode().wait();
                System.out.println("wait");
                if (this.isLoading()) {
                    bugCatcher.logError(new Exception("waited till loaded but its still loading: " + this.getUrlString()));
                }
            }
            catch (Exception ex) {
                bugCatcher.logError(ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadingState(int countChange) {
        if (this != this.getParentDomNode()) {
            this.getParentDomNode().updateLoadingState(countChange);
        } else {
            Object object = this.loadingCountLock;
            synchronized (object) {
                this.isLoadingCount += countChange;
            }
            if (!this.isLoading()) {
                this.clearChildIcons();
                this.clearIcon();
            }
        }
    }

    @Override
    public synchronized boolean isLoading() {
        return this.getParentDomNode().isLoadingCount > 0;
    }

    public String toString() {
        if (this.lastNodeText != null) {
            return this.lastNodeText;
        }
        return "unknown";
    }

    public boolean isNodeTextDetermined() {
        return this.lastNodeText != null && !this.lastNodeText.equals(NODE_LOADING_TEXT);
    }

    public String refreshStringValue() {
        URI resourceUri;
        if (this.isLoading()) {
            return this.lastNodeText;
        }
        if (this.lastNodeText.equals(NODE_LOADING_TEXT) && this.getParentDomNode().dataLoaded) {
            this.lastNodeText = "                      ";
        }
        boolean foundPreferredNameField = false;
        boolean preferredNameFieldExists = false;
        block2: for (String currentPreferredName : this.getNodeTemplate().preferredNameFields) {
            for (ArbilField[] currentFieldArray : (ArbilField[][])this.fieldHashtable.values().toArray((T[])new ArbilField[0][])) {
                if (!currentFieldArray[0].getFullXmlPath().replaceAll("\\(\\d+\\)", "").equals(currentPreferredName)) continue;
                preferredNameFieldExists = true;
                for (ArbilField currentField : currentFieldArray) {
                    if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                    this.nodeText = currentField.toString();
                    foundPreferredNameField = true;
                    break block2;
                }
            }
            ArbilField[] currentFieldArray = this.fieldHashtable.get(currentPreferredName);
            if (currentFieldArray == null) continue;
            for (ArbilField currentField : currentFieldArray) {
                if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                this.nodeText = currentField.toString();
                foundPreferredNameField = true;
                break block2;
            }
        }
        if (!foundPreferredNameField && this.isCmdiMetaDataNode()) {
            String nodeFragmentName = this.getURI().getFragment();
            String unamedText = nodeFragmentName != null ? (nodeFragmentName = this.getNodeTypeNameFromUriFragment(nodeFragmentName)) : (this.nodeTemplate != null ? this.nodeTemplate.getTemplateName() : "");
            this.nodeText = preferredNameFieldExists ? unamedText + " (unnamed)" : unamedText;
        }
        if (this.hasResource() && (resourceUri = this.getFullResourceURI()) != null) {
            String resourcePathString = resourceUri.toString();
            int lastIndex = resourcePathString.lastIndexOf("/");
            resourcePathString = resourcePathString.substring(lastIndex + 1);
            try {
                resourcePathString = URLDecoder.decode(resourcePathString, "UTF-8");
            }
            catch (UnsupportedEncodingException encodingException) {
                bugCatcher.logError(encodingException);
            }
            this.nodeText = resourcePathString;
        }
        if (this.isInfoLink) {
            String infoTitle = this.fieldHashtable.values().iterator().next()[0].getFieldValue();
            if ((infoTitle = infoTitle.trim()).length() > 0) {
                this.nodeText = infoTitle;
            }
        }
        if (this.nodeText != null) {
            File nodeFile;
            if (this.isMetaDataNode() && (nodeFile = this.getFile()) != null && !this.isHeadRevision()) {
                this.nodeText = this.nodeText + " (rev:" + this.getHistoryLabelStringForFile(nodeFile) + ")";
            }
            this.lastNodeText = this.nodeText;
        }
        if (this.isContainerNode()) {
            this.lastNodeText = String.format("%1$s (%2$d)", this.lastNodeText, this.getChildCount());
        } else if (this.isSingletonMetadataNode()) {
            StringBuilder nodeTextSB = new StringBuilder(this.getNodeTypeNameFromUriFragment(this.getURI().getFragment()));
            if (this.nodeText != null && this.nodeText.length() > 0) {
                nodeTextSB.append(" (").append(this.nodeText).append(")");
            }
            this.lastNodeText = nodeTextSB.toString();
        }
        if (this.lastNodeText.length() == 0) {
            this.lastNodeText = "                      ";
        }
        return this.lastNodeText;
    }

    @Override
    public boolean isArchivableFile() {
        return this.mpiMimeType != null;
    }

    @Override
    public boolean hasResource() {
        return this.resourceUrlField != null;
    }

    public boolean canHaveResource() {
        ArbilTemplate template;
        if (this.hasResource()) {
            return true;
        }
        if (this.isCmdiMetaDataNode() && (template = this.getNodeTemplate()) != null) {
            return template.pathCanHaveResource(this.nodeUri.getFragment());
        }
        return false;
    }

    public void insertResourceLocation(URI location) throws ArbilMetadataException {
        if (this.isCmdiMetaDataNode()) {
            ArbilDataNode resourceNode = null;
            try {
                resourceNode = dataNodeLoader.getArbilDataNodeWithoutLoading(location);
            }
            catch (Exception ex) {
                throw new ArbilMetadataException("Error creating resource node for URI: " + location.toString(), ex);
            }
            if (resourceNode == null) {
                throw new ArbilMetadataException("Unknown error creating resource node for URI: " + location.toString());
            }
            new MetadataBuilder().requestAddNode(this, null, resourceNode);
        } else if (this.hasResource()) {
            this.resourceUrlField.setFieldValue(location.toString(), true, false);
        }
    }

    @Override
    public boolean hasLocalResource() {
        if (!this.hasResource()) {
            return false;
        }
        if (this.resourceUrlField.getFieldValue().toLowerCase().startsWith("http")) {
            return false;
        }
        return this.isLocal();
    }

    public boolean resourceFileNotFound() {
        if (this.hasLocalResource()) {
            if (this.resourceUrlField.getFieldValue().length() == 0) {
                return true;
            }
            try {
                return !new File(this.getFullResourceURI()).exists();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private String getResource() {
        return this.resourceUrlField.getFieldValue();
    }

    @Override
    public boolean hasHistory() {
        if (!this.isLocal()) {
            return false;
        }
        return !this.isChildNode() && new File(this.getFile().getAbsolutePath() + ".0").exists();
    }

    private String getHistoryLabelStringForFile(File historyFile) {
        Date mtime = new Date(historyFile.lastModified());
        String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
        return mTimeString;
    }

    private boolean isHeadRevision() {
        return !new File(this.getFile().getAbsolutePath() + ".x").exists();
    }

    public String[][] getHistoryList() {
        File currentHistoryFile;
        Vector<String[]> historyVector = new Vector<String[]>();
        int versionCounter = 0;
        if (!this.isHeadRevision()) {
            historyVector.add(new String[]{"Last Save", ".x"});
        }
        do {
            if ((currentHistoryFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter)).exists()) {
                String mTimeString = this.getHistoryLabelStringForFile(currentHistoryFile);
                historyVector.add(new String[]{mTimeString, "." + versionCounter});
            }
            ++versionCounter;
        } while (currentHistoryFile.exists());
        return (String[][])historyVector.toArray((T[])new String[][]{new String[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resurrectHistory(String historyVersion) {
        block42: {
            InputStream historyFile = null;
            OutputStream activeVersionFile = null;
            try {
                int len;
                if (historyVersion.equals(".x")) {
                    if (this.getFile().delete()) {
                        if (!new File(this.getFile().getAbsolutePath() + ".x").renameTo(this.getFile())) {
                            throw new IOException("Could not rename history file '" + this.getFile().getAbsolutePath() + ".x'");
                        }
                        break block42;
                    }
                    throw new IOException("Could not delete old history file: " + this.getFile().getAbsolutePath());
                }
                try {
                    messageDialogHandler.offerUserToSaveChanges();
                }
                catch (Exception e) {
                    boolean bl = false;
                    if (null != historyFile) {
                        try {
                            historyFile.close();
                        }
                        catch (IOException ex) {
                            bugCatcher.logError(ex);
                        }
                    }
                    if (null != activeVersionFile) {
                        try {
                            activeVersionFile.close();
                        }
                        catch (IOException ex) {
                            bugCatcher.logError(ex);
                        }
                    }
                    return bl;
                }
                if (!new File(this.getFile().getAbsolutePath() + ".x").exists()) {
                    if (!this.getFile().renameTo(new File(this.getFile().getAbsolutePath() + ".x"))) {
                        throw new IOException("Could not rename to history file: " + this.getFile().getAbsolutePath());
                    }
                } else if (!this.getFile().delete()) {
                    throw new IOException("Could not delete history file: " + this.getFile().getAbsolutePath());
                }
                historyFile = new FileInputStream(new File(this.getFile().getAbsolutePath() + historyVersion));
                activeVersionFile = new FileOutputStream(this.getFile(), true);
                byte[] copyBuffer = new byte[1024];
                while ((len = historyFile.read(copyBuffer)) > 0) {
                    activeVersionFile.write(copyBuffer, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                messageDialogHandler.addMessageDialogToQueue(e.getLocalizedMessage() + ". History may be broken for " + this.toString(), "File not found");
                bugCatcher.logError(e);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                messageDialogHandler.addMessageDialogToQueue(e.getLocalizedMessage() + ". History may be broken for " + this.toString(), "Error while reading or writing to disk");
                bugCatcher.logError(e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != historyFile) {
                    try {
                        historyFile.close();
                    }
                    catch (IOException ex) {
                        bugCatcher.logError(ex);
                    }
                }
                if (null != activeVersionFile) {
                    try {
                        activeVersionFile.close();
                    }
                    catch (IOException ex) {
                        bugCatcher.logError(ex);
                    }
                }
            }
        }
        dataNodeLoader.requestReload(this.getParentDomNode());
        return true;
    }

    public void bumpHistory() throws IOException {
        int versionCounter = 0;
        File headVersion = this.getFile();
        if (new File(this.getFile().getAbsolutePath() + ".x").exists()) {
            ++versionCounter;
            headVersion = new File(this.getFile().getAbsolutePath() + ".x");
        }
        while (new File(this.getFile().getAbsolutePath() + "." + versionCounter).exists()) {
            ++versionCounter;
        }
        while (versionCounter >= 0) {
            File lastFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter);
            File nextFile = new File(this.getFile().getAbsolutePath() + "." + --versionCounter);
            if (versionCounter >= 0) {
                System.out.println("renaming: " + nextFile + " : " + lastFile);
                if (nextFile.renameTo(lastFile)) continue;
                throw new IOException("Error while copying history files for metadata. Could not rename " + nextFile.toString() + " to " + lastFile.toString());
            }
            System.out.println("renaming: " + headVersion + " : " + lastFile);
            if (headVersion.renameTo(lastFile)) continue;
            throw new IOException("Error while copying history files for metadata. Could not rename " + nextFile.toString() + " to " + lastFile.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLastHistoryToCurrent() {
        FileOutputStream outFile = null;
        InputStream inputStream = null;
        try {
            outFile = new FileOutputStream(this.getFile());
            inputStream = new FileInputStream(new File(this.getFile().getAbsolutePath() + ".0"));
            int bufferLength = 4096;
            byte[] buffer = new byte[bufferLength];
            int bytesread = 0;
            while (bytesread >= 0) {
                bytesread = inputStream.read(buffer);
                if (bytesread == -1) {
                    break;
                }
                outFile.write(buffer, 0, bytesread);
            }
        }
        catch (IOException iOException) {
            messageDialogHandler.addMessageDialogToQueue("Could not copy file when recovering from the last history file.", "Recover History");
            bugCatcher.logError(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    bugCatcher.logError(ex);
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException ex) {
                    bugCatcher.logError(ex);
                }
            }
        }
    }

    public URI getFullResourceURI() {
        try {
            boolean isUncPath;
            URI targetUri;
            String targetUriString = this.resourceUrlField.getFieldValue();
            String[] uriParts = targetUriString.split(":/", 2);
            if (uriParts.length > 1) {
                String bracketEncodedPath = uriParts[1];
                targetUri = new URI(uriParts[0], "/" + bracketEncodedPath, null);
            } else {
                targetUri = new URI(null, targetUriString, null);
            }
            URI resourceUri = this.nodeUri.resolve(targetUri);
            if (!targetUri.equals(resourceUri) && (isUncPath = this.nodeUri.toString().toLowerCase().startsWith("file:////"))) {
                try {
                    resourceUri = new URI("file:////" + resourceUri.toString().substring("file:/".length()));
                }
                catch (URISyntaxException urise) {
                    bugCatcher.logError(urise);
                }
            }
            return resourceUri;
        }
        catch (Exception urise) {
            bugCatcher.logError(urise);
            System.out.println("URISyntaxException: " + urise.getMessage());
            return null;
        }
    }

    public String getUrlString() {
        return this.nodeUri.toString();
    }

    public Object getParentDomLockObject() {
        return this.getParentDomNode().domLockObjectPrivate;
    }

    public synchronized ArbilDataNode getParentDomNode() {
        if (this.domParentNode == null) {
            if (this.nodeUri.getFragment() != null) {
                try {
                    this.domParentNode = dataNodeLoader.getArbilDataNode(null, new URI(this.nodeUri.toString().split("#")[0]));
                }
                catch (URISyntaxException ex) {
                    bugCatcher.logError(ex);
                }
            } else {
                this.domParentNode = this;
            }
        }
        return this.domParentNode;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isChildNode()) {
                return true;
            }
            return MetadataFormat.isPathMetadata(this.nodeUri.getPath());
        }
        return false;
    }

    @Override
    public boolean isCmdiMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isChildNode()) {
                return this.getParentDomNode().isCmdiMetaDataNode();
            }
            return MetadataFormat.isPathCmdi(this.nodeUri.getPath());
        }
        return false;
    }

    @Override
    public boolean isChildNode() {
        return ArbilDataNode.isStringChildNode(this.getUrlString());
    }

    @Override
    public boolean isSession() {
        ArbilField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Session.Name");
        }
        return false;
    }

    @Override
    public boolean isEmptyMetaNode() {
        return this.getFields().isEmpty();
    }

    @Override
    public boolean isCatalogue() {
        ArbilField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Catalogue.Name");
        }
        return false;
    }

    @Override
    public boolean isCorpus() {
        if (this.isCmdiMetaDataNode()) {
            return false;
        }
        ArbilField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Corpus.Name");
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        if (this.nodeUri != null) {
            return ArbilDataNode.isStringLocal(this.nodeUri.getScheme());
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        if (this.isLocal()) {
            return sessionStorage.pathIsInsideCache(this.getFile()) || sessionStorage.pathIsInFavourites(this.getFile());
        }
        return false;
    }

    public URI getURI() {
        try {
            return this.nodeUri;
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
            return null;
        }
    }

    public File getFile() {
        if (this.nodeUri.getScheme().toLowerCase().equals("file")) {
            try {
                return new File(new URI(this.nodeUri.toString().split("#")[0]));
            }
            catch (Exception urise) {
                bugCatcher.logError(this.nodeUri.toString(), urise);
            }
        }
        return null;
    }

    public String getParentDirectory() {
        String parentPath = this.getUrlString().substring(0, this.getUrlString().lastIndexOf("/")) + "/";
        return parentPath;
    }

    @Override
    public void registerContainer(ArbilDataNodeContainer containerToAdd) {
        if (!this.getParentDomNode().dataLoaded && !this.isLoading()) {
            dataNodeLoader.requestReload(this.getParentDomNode());
        }
        super.registerContainer(containerToAdd);
    }

    public void clearChildIcons() {
        for (ArbilDataNode currentChild : this.childArray) {
            currentChild.clearChildIcons();
            currentChild.clearIcon();
        }
    }

    public void clearIcon() {
        this.refreshStringValue();
        this.icon = ArbilIcons.getSingleInstance().getIconForNode(this);
        Enumeration containersIterator = this.containersOfThisNode.elements();
        while (containersIterator.hasMoreElements()) {
            try {
                ArbilDataNodeContainer currentContainer = (ArbilDataNodeContainer)containersIterator.nextElement();
                currentContainer.dataNodeIconCleared(this);
            }
            catch (NoSuchElementException ex) {
                bugCatcher.logError(ex);
            }
        }
    }

    public synchronized void removeFromAllContainers() {
        for (ArbilDataNode currentChildNode : this.getAllChildren()) {
            currentChildNode.removeFromAllContainers();
        }
        for (ArbilDataNodeContainer currentContainer : this.containersOfThisNode.toArray(new ArbilDataNodeContainer[0])) {
            try {
                currentContainer.dataNodeRemoved(this);
            }
            catch (NoSuchElementException ex) {
                bugCatcher.logError(ex);
            }
        }
    }

    @Override
    public boolean isFavorite() {
        if (this.isFavorite == null) {
            if (!this.isLocal()) {
                return false;
            }
            this.isFavorite = sessionStorage.pathIsInFavourites(this.getFile());
        }
        return this.isFavorite;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.icon == null) {
            return ArbilIcons.getSingleInstance().loadingIcon;
        }
        return this.icon;
    }

    @Override
    public boolean isDataLoaded() {
        if (this.isChildNode()) {
            return this.getParentDomNode().dataLoaded;
        }
        return this.dataLoaded;
    }

    public void setDataLoaded(boolean dataLoaded) {
        this.dataLoaded = dataLoaded;
    }

    @Override
    public boolean isResourceSet() {
        return this.resourceUrlField != null && this.resourceUrlField.getFieldValue().length() > 0;
    }

    public void invalidateThumbnails() {
        this.thumbnailFile = null;
        for (ArbilDataNode node : this.getChildArray()) {
            node.invalidateThumbnails();
        }
    }

    public boolean isSingletonMetadataNode() {
        return this.singletonMetadataNode;
    }

    public void setSingletonMetadataNode(boolean singletonMetadataNodeName) {
        this.singletonMetadataNode = singletonMetadataNodeName;
    }

    public boolean isContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(boolean containerNode) {
        this.containerNode = containerNode;
    }

    public CmdiComponentLinkReader getCmdiComponentLinkReader() {
        return this.getParentDomNode().cmdiComponentLinkReader;
    }

    public MimeHashQueue.TypeCheckerState getTypeCheckerState() {
        return this.typeCheckerState;
    }

    public void setTypeCheckerState(MimeHashQueue.TypeCheckerState typeCheckerState) {
        this.typeCheckerState = typeCheckerState;
    }

    static {
        dataNodeSorter = new ArbilNodeSorter();
        favouriteSorter = new ArbilFavouritesSorter();
    }
}

